<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

/**
 * The "customers" collection of methods.
 * Typical usage is:
 *  <code>
 *   $androiddeviceprovisioningService = new Google_Service_AndroidProvisioningPartner(...);
 *   $customers = $androiddeviceprovisioningService->customers;
 *  </code>
 */
class Google_Service_AndroidProvisioningPartner_Resource_Customers extends Google_Service_Resource
{
  /**
   * Lists the user's customer accounts. (customers.listCustomers)
   *
   * @param array $optParams Optional parameters.
   *
   * @opt_param string pageToken A token specifying which result page to return.
   * @opt_param int pageSize The maximum number of customers to show in a page of
   * results. A number between 1 and 1000 (inclusive).
   * @return Google_Service_AndroidProvisioningPartner_CustomerListCustomersResponse
   */
  public function listCustomers($optParams = array())
  {
    $params = array();
    $params = array_merge($params, $optParams);
    return $this->call('list', array($params), "Google_Service_AndroidProvisioningPartner_CustomerListCustomersResponse");
  }
}
