<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\MigrationCenterAPI;

class GuestConfigDetails extends \Google\Model
{
  protected $fstabType = FstabEntryList::class;
  protected $fstabDataType = '';
  public $fstab;
  protected $hostsType = HostsEntryList::class;
  protected $hostsDataType = '';
  public $hosts;
  /**
   * @var string
   */
  public $issue;
  protected $nfsExportsType = NfsExportList::class;
  protected $nfsExportsDataType = '';
  public $nfsExports;
  protected $selinuxType = Selinux::class;
  protected $selinuxDataType = '';
  public $selinux;

  /**
   * @param FstabEntryList
   */
  public function setFstab(FstabEntryList $fstab)
  {
    $this->fstab = $fstab;
  }
  /**
   * @return FstabEntryList
   */
  public function getFstab()
  {
    return $this->fstab;
  }
  /**
   * @param HostsEntryList
   */
  public function setHosts(HostsEntryList $hosts)
  {
    $this->hosts = $hosts;
  }
  /**
   * @return HostsEntryList
   */
  public function getHosts()
  {
    return $this->hosts;
  }
  /**
   * @param string
   */
  public function setIssue($issue)
  {
    $this->issue = $issue;
  }
  /**
   * @return string
   */
  public function getIssue()
  {
    return $this->issue;
  }
  /**
   * @param NfsExportList
   */
  public function setNfsExports(NfsExportList $nfsExports)
  {
    $this->nfsExports = $nfsExports;
  }
  /**
   * @return NfsExportList
   */
  public function getNfsExports()
  {
    return $this->nfsExports;
  }
  /**
   * @param Selinux
   */
  public function setSelinux(Selinux $selinux)
  {
    $this->selinux = $selinux;
  }
  /**
   * @return Selinux
   */
  public function getSelinux()
  {
    return $this->selinux;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GuestConfigDetails::class, 'Google_Service_MigrationCenterAPI_GuestConfigDetails');
