<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\ThreatIntelligenceService;

class InbandVulnerability extends \Google\Collection
{
  protected $collection_key = 'referenceUrls';
  protected $affectedSoftwareType = AffectedSoftware::class;
  protected $affectedSoftwareDataType = 'array';
  /**
   * Optional. The authors of the vulnerability detection.
   *
   * @var string[]
   */
  public $authors;
  /**
   * Required. The CVE ID of the vulnerability.
   *
   * @var string
   */
  public $cveId;
  /**
   * Required. The CVSS V3.1 score (Base score)for the vulnerability. ( )
   *
   * @var float
   */
  public $cvssV31Score;
  /**
   * Optional. Temporal CVSS V3.1 score for the vulnerability.
   *
   * @var float
   */
  public $cvssV31ScoreTemporal;
  /**
   * Optional. The human readable description. This can be basic HTML formatted
   * text.
   *
   * @var string
   */
  public $description;
  /**
   * Optional. The date the vulnerability was first disclosed.
   *
   * @var string
   */
  public $disclosureTime;
  /**
   * Optional. Exploitation state of the vulnerability, for example "Available".
   *
   * @var string
   */
  public $exploitationState;
  /**
   * Required. The external ID of the vulnerability.
   *
   * @var string
   */
  public $externalVulnerabilityId;
  /**
   * Optional. Whether this is exploited in the wild.
   *
   * @var bool
   */
  public $isExploitedWild;
  /**
   * Optional. Reference URLs to the vulnerability.
   *
   * @var string[]
   */
  public $referenceUrls;
  /**
   * Optional. The human readable remediation recommendation. This can be basic
   * HTML formatted text.
   *
   * @var string
   */
  public $remediation;
  /**
   * Optional. Risk rating for the vulnerability, for example "High".
   *
   * @var string
   */
  public $riskRating;
  /**
   * Optional. Human readable name for the vulnerability.
   *
   * @var string
   */
  public $title;

  /**
   * Optional. The software that is affected by the vulnerability.
   *
   * @param AffectedSoftware[] $affectedSoftware
   */
  public function setAffectedSoftware($affectedSoftware)
  {
    $this->affectedSoftware = $affectedSoftware;
  }
  /**
   * @return AffectedSoftware[]
   */
  public function getAffectedSoftware()
  {
    return $this->affectedSoftware;
  }
  /**
   * Optional. The authors of the vulnerability detection.
   *
   * @param string[] $authors
   */
  public function setAuthors($authors)
  {
    $this->authors = $authors;
  }
  /**
   * @return string[]
   */
  public function getAuthors()
  {
    return $this->authors;
  }
  /**
   * Required. The CVE ID of the vulnerability.
   *
   * @param string $cveId
   */
  public function setCveId($cveId)
  {
    $this->cveId = $cveId;
  }
  /**
   * @return string
   */
  public function getCveId()
  {
    return $this->cveId;
  }
  /**
   * Required. The CVSS V3.1 score (Base score)for the vulnerability. ( )
   *
   * @param float $cvssV31Score
   */
  public function setCvssV31Score($cvssV31Score)
  {
    $this->cvssV31Score = $cvssV31Score;
  }
  /**
   * @return float
   */
  public function getCvssV31Score()
  {
    return $this->cvssV31Score;
  }
  /**
   * Optional. Temporal CVSS V3.1 score for the vulnerability.
   *
   * @param float $cvssV31ScoreTemporal
   */
  public function setCvssV31ScoreTemporal($cvssV31ScoreTemporal)
  {
    $this->cvssV31ScoreTemporal = $cvssV31ScoreTemporal;
  }
  /**
   * @return float
   */
  public function getCvssV31ScoreTemporal()
  {
    return $this->cvssV31ScoreTemporal;
  }
  /**
   * Optional. The human readable description. This can be basic HTML formatted
   * text.
   *
   * @param string $description
   */
  public function setDescription($description)
  {
    $this->description = $description;
  }
  /**
   * @return string
   */
  public function getDescription()
  {
    return $this->description;
  }
  /**
   * Optional. The date the vulnerability was first disclosed.
   *
   * @param string $disclosureTime
   */
  public function setDisclosureTime($disclosureTime)
  {
    $this->disclosureTime = $disclosureTime;
  }
  /**
   * @return string
   */
  public function getDisclosureTime()
  {
    return $this->disclosureTime;
  }
  /**
   * Optional. Exploitation state of the vulnerability, for example "Available".
   *
   * @param string $exploitationState
   */
  public function setExploitationState($exploitationState)
  {
    $this->exploitationState = $exploitationState;
  }
  /**
   * @return string
   */
  public function getExploitationState()
  {
    return $this->exploitationState;
  }
  /**
   * Required. The external ID of the vulnerability.
   *
   * @param string $externalVulnerabilityId
   */
  public function setExternalVulnerabilityId($externalVulnerabilityId)
  {
    $this->externalVulnerabilityId = $externalVulnerabilityId;
  }
  /**
   * @return string
   */
  public function getExternalVulnerabilityId()
  {
    return $this->externalVulnerabilityId;
  }
  /**
   * Optional. Whether this is exploited in the wild.
   *
   * @param bool $isExploitedWild
   */
  public function setIsExploitedWild($isExploitedWild)
  {
    $this->isExploitedWild = $isExploitedWild;
  }
  /**
   * @return bool
   */
  public function getIsExploitedWild()
  {
    return $this->isExploitedWild;
  }
  /**
   * Optional. Reference URLs to the vulnerability.
   *
   * @param string[] $referenceUrls
   */
  public function setReferenceUrls($referenceUrls)
  {
    $this->referenceUrls = $referenceUrls;
  }
  /**
   * @return string[]
   */
  public function getReferenceUrls()
  {
    return $this->referenceUrls;
  }
  /**
   * Optional. The human readable remediation recommendation. This can be basic
   * HTML formatted text.
   *
   * @param string $remediation
   */
  public function setRemediation($remediation)
  {
    $this->remediation = $remediation;
  }
  /**
   * @return string
   */
  public function getRemediation()
  {
    return $this->remediation;
  }
  /**
   * Optional. Risk rating for the vulnerability, for example "High".
   *
   * @param string $riskRating
   */
  public function setRiskRating($riskRating)
  {
    $this->riskRating = $riskRating;
  }
  /**
   * @return string
   */
  public function getRiskRating()
  {
    return $this->riskRating;
  }
  /**
   * Optional. Human readable name for the vulnerability.
   *
   * @param string $title
   */
  public function setTitle($title)
  {
    $this->title = $title;
  }
  /**
   * @return string
   */
  public function getTitle()
  {
    return $this->title;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(InbandVulnerability::class, 'Google_Service_ThreatIntelligenceService_InbandVulnerability');
