<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\ServiceUsage;

class Aspect extends \Google\Collection
{
  protected $collection_key = 'rules';
  /**
   * The type of this aspect configuration.
   *
   * @var string
   */
  public $kind;
  protected $rulesType = AspectRule::class;
  protected $rulesDataType = 'array';
  /**
   * Content of the configuration. The underlying schema should be defined by
   * Aspect owners as protobuf message under `google/api/configaspects/proto`.
   *
   * @var array[]
   */
  public $spec;

  /**
   * The type of this aspect configuration.
   *
   * @param string $kind
   */
  public function setKind($kind)
  {
    $this->kind = $kind;
  }
  /**
   * @return string
   */
  public function getKind()
  {
    return $this->kind;
  }
  /**
   * Optional. Rules of the Configuration.
   *
   * @param AspectRule[] $rules
   */
  public function setRules($rules)
  {
    $this->rules = $rules;
  }
  /**
   * @return AspectRule[]
   */
  public function getRules()
  {
    return $this->rules;
  }
  /**
   * Content of the configuration. The underlying schema should be defined by
   * Aspect owners as protobuf message under `google/api/configaspects/proto`.
   *
   * @param array[] $spec
   */
  public function setSpec($spec)
  {
    $this->spec = $spec;
  }
  /**
   * @return array[]
   */
  public function getSpec()
  {
    return $this->spec;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(Aspect::class, 'Google_Service_ServiceUsage_Aspect');
