<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Reports;

class UsageReports extends \Google\Collection
{
  protected $collection_key = 'warnings';
  /**
   * ETag of the resource.
   *
   * @var string
   */
  public $etag;
  /**
   * The type of API resource. For a usage report, the value is
   * `admin#reports#usageReports`.
   *
   * @var string
   */
  public $kind;
  /**
   * Token to specify next page. A report with multiple pages has a
   * `nextPageToken` property in the response. For your follow-on requests
   * getting all of the report's pages, enter the `nextPageToken` value in the
   * `pageToken` query string.
   *
   * @var string
   */
  public $nextPageToken;
  protected $usageReportsType = UsageReport::class;
  protected $usageReportsDataType = 'array';
  protected $warningsType = UsageReportsWarnings::class;
  protected $warningsDataType = 'array';

  /**
   * ETag of the resource.
   *
   * @param string $etag
   */
  public function setEtag($etag)
  {
    $this->etag = $etag;
  }
  /**
   * @return string
   */
  public function getEtag()
  {
    return $this->etag;
  }
  /**
   * The type of API resource. For a usage report, the value is
   * `admin#reports#usageReports`.
   *
   * @param string $kind
   */
  public function setKind($kind)
  {
    $this->kind = $kind;
  }
  /**
   * @return string
   */
  public function getKind()
  {
    return $this->kind;
  }
  /**
   * Token to specify next page. A report with multiple pages has a
   * `nextPageToken` property in the response. For your follow-on requests
   * getting all of the report's pages, enter the `nextPageToken` value in the
   * `pageToken` query string.
   *
   * @param string $nextPageToken
   */
  public function setNextPageToken($nextPageToken)
  {
    $this->nextPageToken = $nextPageToken;
  }
  /**
   * @return string
   */
  public function getNextPageToken()
  {
    return $this->nextPageToken;
  }
  /**
   * Various application parameter records.
   *
   * @param UsageReport[] $usageReports
   */
  public function setUsageReports($usageReports)
  {
    $this->usageReports = $usageReports;
  }
  /**
   * @return UsageReport[]
   */
  public function getUsageReports()
  {
    return $this->usageReports;
  }
  /**
   * Warnings, if any.
   *
   * @param UsageReportsWarnings[] $warnings
   */
  public function setWarnings($warnings)
  {
    $this->warnings = $warnings;
  }
  /**
   * @return UsageReportsWarnings[]
   */
  public function getWarnings()
  {
    return $this->warnings;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(UsageReports::class, 'Google_Service_Reports_UsageReports');
