<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Contactcenterinsights;

class GoogleCloudContactcenterinsightsV1alpha1ConversationCorrelationResultRuleCorrelationResult extends \Google\Model
{
  /**
   * The correlation ID generated by the join key expression.
   *
   * @var string
   */
  public $correlationId;
  protected $errorType = GoogleRpcStatus::class;
  protected $errorDataType = '';
  /**
   * The rule ID.
   *
   * @var string
   */
  public $ruleId;

  /**
   * The correlation ID generated by the join key expression.
   *
   * @param string $correlationId
   */
  public function setCorrelationId($correlationId)
  {
    $this->correlationId = $correlationId;
  }
  /**
   * @return string
   */
  public function getCorrelationId()
  {
    return $this->correlationId;
  }
  /**
   * The error status if the join key expression failed to evaluate.
   *
   * @param GoogleRpcStatus $error
   */
  public function setError(GoogleRpcStatus $error)
  {
    $this->error = $error;
  }
  /**
   * @return GoogleRpcStatus
   */
  public function getError()
  {
    return $this->error;
  }
  /**
   * The rule ID.
   *
   * @param string $ruleId
   */
  public function setRuleId($ruleId)
  {
    $this->ruleId = $ruleId;
  }
  /**
   * @return string
   */
  public function getRuleId()
  {
    return $this->ruleId;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoogleCloudContactcenterinsightsV1alpha1ConversationCorrelationResultRuleCorrelationResult::class, 'Google_Service_Contactcenterinsights_GoogleCloudContactcenterinsightsV1alpha1ConversationCorrelationResultRuleCorrelationResult');
