<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Classroom;

class ListStudentGroupsResponse extends \Google\Collection
{
  protected $collection_key = 'studentGroups';
  /**
   * Token identifying the next page of results to return. If empty, no further
   * results are available.
   *
   * @var string
   */
  public $nextPageToken;
  protected $studentGroupsType = StudentGroup::class;
  protected $studentGroupsDataType = 'array';

  /**
   * Token identifying the next page of results to return. If empty, no further
   * results are available.
   *
   * @param string $nextPageToken
   */
  public function setNextPageToken($nextPageToken)
  {
    $this->nextPageToken = $nextPageToken;
  }
  /**
   * @return string
   */
  public function getNextPageToken()
  {
    return $this->nextPageToken;
  }
  /**
   * The student groups.
   *
   * @param StudentGroup[] $studentGroups
   */
  public function setStudentGroups($studentGroups)
  {
    $this->studentGroups = $studentGroups;
  }
  /**
   * @return StudentGroup[]
   */
  public function getStudentGroups()
  {
    return $this->studentGroups;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(ListStudentGroupsResponse::class, 'Google_Service_Classroom_ListStudentGroupsResponse');
