<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\CertificateAuthorityService;

class SubjectDescription extends \Google\Model
{
  /**
   * @var string
   */
  public $hexSerialNumber;
  /**
   * @var string
   */
  public $lifetime;
  /**
   * @var string
   */
  public $notAfterTime;
  /**
   * @var string
   */
  public $notBeforeTime;
  /**
   * @var Subject
   */
  public $subject;
  protected $subjectType = Subject::class;
  protected $subjectDataType = '';
  /**
   * @var SubjectAltNames
   */
  public $subjectAltName;
  protected $subjectAltNameType = SubjectAltNames::class;
  protected $subjectAltNameDataType = '';

  /**
   * @param string
   */
  public function setHexSerialNumber($hexSerialNumber)
  {
    $this->hexSerialNumber = $hexSerialNumber;
  }
  /**
   * @return string
   */
  public function getHexSerialNumber()
  {
    return $this->hexSerialNumber;
  }
  /**
   * @param string
   */
  public function setLifetime($lifetime)
  {
    $this->lifetime = $lifetime;
  }
  /**
   * @return string
   */
  public function getLifetime()
  {
    return $this->lifetime;
  }
  /**
   * @param string
   */
  public function setNotAfterTime($notAfterTime)
  {
    $this->notAfterTime = $notAfterTime;
  }
  /**
   * @return string
   */
  public function getNotAfterTime()
  {
    return $this->notAfterTime;
  }
  /**
   * @param string
   */
  public function setNotBeforeTime($notBeforeTime)
  {
    $this->notBeforeTime = $notBeforeTime;
  }
  /**
   * @return string
   */
  public function getNotBeforeTime()
  {
    return $this->notBeforeTime;
  }
  /**
   * @param Subject
   */
  public function setSubject(Subject $subject)
  {
    $this->subject = $subject;
  }
  /**
   * @return Subject
   */
  public function getSubject()
  {
    return $this->subject;
  }
  /**
   * @param SubjectAltNames
   */
  public function setSubjectAltName(SubjectAltNames $subjectAltName)
  {
    $this->subjectAltName = $subjectAltName;
  }
  /**
   * @return SubjectAltNames
   */
  public function getSubjectAltName()
  {
    return $this->subjectAltName;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(SubjectDescription::class, 'Google_Service_CertificateAuthorityService_SubjectDescription');
