<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Cloudchannel;

class GoogleCloudChannelV1BillingAccountPurchaseInfo extends \Google\Model
{
  /**
   * @var GoogleCloudChannelV1BillingAccount
   */
  public $billingAccount;
  protected $billingAccountType = GoogleCloudChannelV1BillingAccount::class;
  protected $billingAccountDataType = '';

  /**
   * @param GoogleCloudChannelV1BillingAccount
   */
  public function setBillingAccount(GoogleCloudChannelV1BillingAccount $billingAccount)
  {
    $this->billingAccount = $billingAccount;
  }
  /**
   * @return GoogleCloudChannelV1BillingAccount
   */
  public function getBillingAccount()
  {
    return $this->billingAccount;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoogleCloudChannelV1BillingAccountPurchaseInfo::class, 'Google_Service_Cloudchannel_GoogleCloudChannelV1BillingAccountPurchaseInfo');
