<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\TrafficDirectorService;

class GenericXdsConfig extends \Google\Model
{
  /**
   * Resource status is not available/unknown.
   */
  public const CLIENT_STATUS_UNKNOWN = 'UNKNOWN';
  /**
   * Client requested this resource but hasn't received any update from
   * management server. The client will not fail requests, but will queue them
   * until update arrives or the client times out waiting for the resource.
   */
  public const CLIENT_STATUS_REQUESTED = 'REQUESTED';
  /**
   * This resource has been requested by the client but has either not been
   * delivered by the server or was previously delivered by the server and then
   * subsequently removed from resources provided by the server. For more
   * information, please refer to the :ref:`"Knowing When a Requested Resource
   * Does Not Exist" ` section.
   */
  public const CLIENT_STATUS_DOES_NOT_EXIST = 'DOES_NOT_EXIST';
  /**
   * Client received this resource and replied with ACK.
   */
  public const CLIENT_STATUS_ACKED = 'ACKED';
  /**
   * Client received this resource and replied with NACK.
   */
  public const CLIENT_STATUS_NACKED = 'NACKED';
  /**
   * Client received an error from the control plane. The attached config dump
   * is the most recent accepted one. If no config is accepted yet, the attached
   * config dump will be empty.
   */
  public const CLIENT_STATUS_RECEIVED_ERROR = 'RECEIVED_ERROR';
  /**
   * Client timed out waiting for the resource from the control plane.
   */
  public const CLIENT_STATUS_TIMEOUT = 'TIMEOUT';
  /**
   * Status info is not available/unknown.
   */
  public const CONFIG_STATUS_UNKNOWN = 'UNKNOWN';
  /**
   * Management server has sent the config to client and received ACK.
   */
  public const CONFIG_STATUS_SYNCED = 'SYNCED';
  /**
   * Config is not sent.
   */
  public const CONFIG_STATUS_NOT_SENT = 'NOT_SENT';
  /**
   * Management server has sent the config to client but hasn’t received
   * ACK/NACK.
   */
  public const CONFIG_STATUS_STALE = 'STALE';
  /**
   * Management server has sent the config to client but received NACK. The
   * attached config dump will be the latest config (the rejected one), since it
   * is the persisted version in the management server.
   */
  public const CONFIG_STATUS_ERROR = 'ERROR';
  /**
   * Per xDS resource status from the view of a xDS client
   *
   * @var string
   */
  public $clientStatus;
  /**
   * Per xDS resource config status. It is generated by management servers. It
   * will not be present if the CSDS server is an xDS client.
   *
   * @var string
   */
  public $configStatus;
  protected $errorStateType = UpdateFailureState::class;
  protected $errorStateDataType = '';
  /**
   * Is static resource is true if it is specified in the config supplied
   * through the file at the startup.
   *
   * @var bool
   */
  public $isStaticResource;
  /**
   * Timestamp when the xDS resource was last updated
   *
   * @var string
   */
  public $lastUpdated;
  /**
   * Name of the xDS resource
   *
   * @var string
   */
  public $name;
  /**
   * Type_url represents the fully qualified name of xDS resource type like
   * envoy.v3.Cluster, envoy.v3.ClusterLoadAssignment etc.
   *
   * @var string
   */
  public $typeUrl;
  /**
   * This is the :ref:`version_info ` in the last processed xDS discovery
   * response. If there are only static bootstrap listeners, this field will be
   * ""
   *
   * @var string
   */
  public $versionInfo;
  /**
   * The xDS resource config. Actual content depends on the type
   *
   * @var array[]
   */
  public $xdsConfig;

  /**
   * Per xDS resource status from the view of a xDS client
   *
   * Accepted values: UNKNOWN, REQUESTED, DOES_NOT_EXIST, ACKED, NACKED,
   * RECEIVED_ERROR, TIMEOUT
   *
   * @param self::CLIENT_STATUS_* $clientStatus
   */
  public function setClientStatus($clientStatus)
  {
    $this->clientStatus = $clientStatus;
  }
  /**
   * @return self::CLIENT_STATUS_*
   */
  public function getClientStatus()
  {
    return $this->clientStatus;
  }
  /**
   * Per xDS resource config status. It is generated by management servers. It
   * will not be present if the CSDS server is an xDS client.
   *
   * Accepted values: UNKNOWN, SYNCED, NOT_SENT, STALE, ERROR
   *
   * @param self::CONFIG_STATUS_* $configStatus
   */
  public function setConfigStatus($configStatus)
  {
    $this->configStatus = $configStatus;
  }
  /**
   * @return self::CONFIG_STATUS_*
   */
  public function getConfigStatus()
  {
    return $this->configStatus;
  }
  /**
   * Set if the last update failed, cleared after the next successful update.
   * The *error_state* field contains the rejected version of this particular
   * resource along with the reason and timestamp. For successfully updated or
   * acknowledged resource, this field should be empty. [#not-implemented-hide:]
   *
   * @param UpdateFailureState $errorState
   */
  public function setErrorState(UpdateFailureState $errorState)
  {
    $this->errorState = $errorState;
  }
  /**
   * @return UpdateFailureState
   */
  public function getErrorState()
  {
    return $this->errorState;
  }
  /**
   * Is static resource is true if it is specified in the config supplied
   * through the file at the startup.
   *
   * @param bool $isStaticResource
   */
  public function setIsStaticResource($isStaticResource)
  {
    $this->isStaticResource = $isStaticResource;
  }
  /**
   * @return bool
   */
  public function getIsStaticResource()
  {
    return $this->isStaticResource;
  }
  /**
   * Timestamp when the xDS resource was last updated
   *
   * @param string $lastUpdated
   */
  public function setLastUpdated($lastUpdated)
  {
    $this->lastUpdated = $lastUpdated;
  }
  /**
   * @return string
   */
  public function getLastUpdated()
  {
    return $this->lastUpdated;
  }
  /**
   * Name of the xDS resource
   *
   * @param string $name
   */
  public function setName($name)
  {
    $this->name = $name;
  }
  /**
   * @return string
   */
  public function getName()
  {
    return $this->name;
  }
  /**
   * Type_url represents the fully qualified name of xDS resource type like
   * envoy.v3.Cluster, envoy.v3.ClusterLoadAssignment etc.
   *
   * @param string $typeUrl
   */
  public function setTypeUrl($typeUrl)
  {
    $this->typeUrl = $typeUrl;
  }
  /**
   * @return string
   */
  public function getTypeUrl()
  {
    return $this->typeUrl;
  }
  /**
   * This is the :ref:`version_info ` in the last processed xDS discovery
   * response. If there are only static bootstrap listeners, this field will be
   * ""
   *
   * @param string $versionInfo
   */
  public function setVersionInfo($versionInfo)
  {
    $this->versionInfo = $versionInfo;
  }
  /**
   * @return string
   */
  public function getVersionInfo()
  {
    return $this->versionInfo;
  }
  /**
   * The xDS resource config. Actual content depends on the type
   *
   * @param array[] $xdsConfig
   */
  public function setXdsConfig($xdsConfig)
  {
    $this->xdsConfig = $xdsConfig;
  }
  /**
   * @return array[]
   */
  public function getXdsConfig()
  {
    return $this->xdsConfig;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GenericXdsConfig::class, 'Google_Service_TrafficDirectorService_GenericXdsConfig');
