<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\SQLAdmin;

class TruncateLogContext extends \Google\Model
{
  /**
   * This is always `sql#truncateLogContext`.
   *
   * @var string
   */
  public $kind;
  /**
   * The type of log to truncate. Valid values are `MYSQL_GENERAL_TABLE` and
   * `MYSQL_SLOW_TABLE`.
   *
   * @var string
   */
  public $logType;

  /**
   * This is always `sql#truncateLogContext`.
   *
   * @param string $kind
   */
  public function setKind($kind)
  {
    $this->kind = $kind;
  }
  /**
   * @return string
   */
  public function getKind()
  {
    return $this->kind;
  }
  /**
   * The type of log to truncate. Valid values are `MYSQL_GENERAL_TABLE` and
   * `MYSQL_SLOW_TABLE`.
   *
   * @param string $logType
   */
  public function setLogType($logType)
  {
    $this->logType = $logType;
  }
  /**
   * @return string
   */
  public function getLogType()
  {
    return $this->logType;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(TruncateLogContext::class, 'Google_Service_SQLAdmin_TruncateLogContext');
