<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\DatabaseMigrationService;

class ColumnEntity extends \Google\Collection
{
  protected $collection_key = 'setValues';
  /**
   * Is the column of array type.
   *
   * @var bool
   */
  public $array;
  /**
   * If the column is array, of which length.
   *
   * @var int
   */
  public $arrayLength;
  /**
   * Is the column auto-generated/identity.
   *
   * @var bool
   */
  public $autoGenerated;
  /**
   * Charset override - instead of table level charset.
   *
   * @var string
   */
  public $charset;
  /**
   * Collation override - instead of table level collation.
   *
   * @var string
   */
  public $collation;
  /**
   * Comment associated with the column.
   *
   * @var string
   */
  public $comment;
  /**
   * Is the column a computed column.
   *
   * @var bool
   */
  public $computed;
  /**
   * Custom engine specific features.
   *
   * @var array[]
   */
  public $customFeatures;
  /**
   * Column data type.
   *
   * @var string
   */
  public $dataType;
  /**
   * Default value of the column.
   *
   * @var string
   */
  public $defaultValue;
  /**
   * Column fractional second precision - used for timestamp based datatypes.
   *
   * @var int
   */
  public $fractionalSecondsPrecision;
  /**
   * Column length - e.g. varchar (50).
   *
   * @var string
   */
  public $length;
  /**
   * Column name.
   *
   * @var string
   */
  public $name;
  /**
   * Is the column nullable.
   *
   * @var bool
   */
  public $nullable;
  /**
   * Column order in the table.
   *
   * @var int
   */
  public $ordinalPosition;
  /**
   * Column precision - when relevant.
   *
   * @var int
   */
  public $precision;
  /**
   * Column scale - when relevant.
   *
   * @var int
   */
  public $scale;
  /**
   * Specifies the list of values allowed in the column. Only used for set data
   * type.
   *
   * @var string[]
   */
  public $setValues;
  /**
   * Is the column a UDT.
   *
   * @var bool
   */
  public $udt;

  /**
   * Is the column of array type.
   *
   * @param bool $array
   */
  public function setArray($array)
  {
    $this->array = $array;
  }
  /**
   * @return bool
   */
  public function getArray()
  {
    return $this->array;
  }
  /**
   * If the column is array, of which length.
   *
   * @param int $arrayLength
   */
  public function setArrayLength($arrayLength)
  {
    $this->arrayLength = $arrayLength;
  }
  /**
   * @return int
   */
  public function getArrayLength()
  {
    return $this->arrayLength;
  }
  /**
   * Is the column auto-generated/identity.
   *
   * @param bool $autoGenerated
   */
  public function setAutoGenerated($autoGenerated)
  {
    $this->autoGenerated = $autoGenerated;
  }
  /**
   * @return bool
   */
  public function getAutoGenerated()
  {
    return $this->autoGenerated;
  }
  /**
   * Charset override - instead of table level charset.
   *
   * @param string $charset
   */
  public function setCharset($charset)
  {
    $this->charset = $charset;
  }
  /**
   * @return string
   */
  public function getCharset()
  {
    return $this->charset;
  }
  /**
   * Collation override - instead of table level collation.
   *
   * @param string $collation
   */
  public function setCollation($collation)
  {
    $this->collation = $collation;
  }
  /**
   * @return string
   */
  public function getCollation()
  {
    return $this->collation;
  }
  /**
   * Comment associated with the column.
   *
   * @param string $comment
   */
  public function setComment($comment)
  {
    $this->comment = $comment;
  }
  /**
   * @return string
   */
  public function getComment()
  {
    return $this->comment;
  }
  /**
   * Is the column a computed column.
   *
   * @param bool $computed
   */
  public function setComputed($computed)
  {
    $this->computed = $computed;
  }
  /**
   * @return bool
   */
  public function getComputed()
  {
    return $this->computed;
  }
  /**
   * Custom engine specific features.
   *
   * @param array[] $customFeatures
   */
  public function setCustomFeatures($customFeatures)
  {
    $this->customFeatures = $customFeatures;
  }
  /**
   * @return array[]
   */
  public function getCustomFeatures()
  {
    return $this->customFeatures;
  }
  /**
   * Column data type.
   *
   * @param string $dataType
   */
  public function setDataType($dataType)
  {
    $this->dataType = $dataType;
  }
  /**
   * @return string
   */
  public function getDataType()
  {
    return $this->dataType;
  }
  /**
   * Default value of the column.
   *
   * @param string $defaultValue
   */
  public function setDefaultValue($defaultValue)
  {
    $this->defaultValue = $defaultValue;
  }
  /**
   * @return string
   */
  public function getDefaultValue()
  {
    return $this->defaultValue;
  }
  /**
   * Column fractional second precision - used for timestamp based datatypes.
   *
   * @param int $fractionalSecondsPrecision
   */
  public function setFractionalSecondsPrecision($fractionalSecondsPrecision)
  {
    $this->fractionalSecondsPrecision = $fractionalSecondsPrecision;
  }
  /**
   * @return int
   */
  public function getFractionalSecondsPrecision()
  {
    return $this->fractionalSecondsPrecision;
  }
  /**
   * Column length - e.g. varchar (50).
   *
   * @param string $length
   */
  public function setLength($length)
  {
    $this->length = $length;
  }
  /**
   * @return string
   */
  public function getLength()
  {
    return $this->length;
  }
  /**
   * Column name.
   *
   * @param string $name
   */
  public function setName($name)
  {
    $this->name = $name;
  }
  /**
   * @return string
   */
  public function getName()
  {
    return $this->name;
  }
  /**
   * Is the column nullable.
   *
   * @param bool $nullable
   */
  public function setNullable($nullable)
  {
    $this->nullable = $nullable;
  }
  /**
   * @return bool
   */
  public function getNullable()
  {
    return $this->nullable;
  }
  /**
   * Column order in the table.
   *
   * @param int $ordinalPosition
   */
  public function setOrdinalPosition($ordinalPosition)
  {
    $this->ordinalPosition = $ordinalPosition;
  }
  /**
   * @return int
   */
  public function getOrdinalPosition()
  {
    return $this->ordinalPosition;
  }
  /**
   * Column precision - when relevant.
   *
   * @param int $precision
   */
  public function setPrecision($precision)
  {
    $this->precision = $precision;
  }
  /**
   * @return int
   */
  public function getPrecision()
  {
    return $this->precision;
  }
  /**
   * Column scale - when relevant.
   *
   * @param int $scale
   */
  public function setScale($scale)
  {
    $this->scale = $scale;
  }
  /**
   * @return int
   */
  public function getScale()
  {
    return $this->scale;
  }
  /**
   * Specifies the list of values allowed in the column. Only used for set data
   * type.
   *
   * @param string[] $setValues
   */
  public function setSetValues($setValues)
  {
    $this->setValues = $setValues;
  }
  /**
   * @return string[]
   */
  public function getSetValues()
  {
    return $this->setValues;
  }
  /**
   * Is the column a UDT.
   *
   * @param bool $udt
   */
  public function setUdt($udt)
  {
    $this->udt = $udt;
  }
  /**
   * @return bool
   */
  public function getUdt()
  {
    return $this->udt;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(ColumnEntity::class, 'Google_Service_DatabaseMigrationService_ColumnEntity');
