<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\DataLabeling;

class GoogleCloudDatalabelingV1beta1ListFeedbackMessagesResponse extends \Google\Collection
{
  protected $collection_key = 'feedbackMessages';
  protected $feedbackMessagesType = GoogleCloudDatalabelingV1beta1FeedbackMessage::class;
  protected $feedbackMessagesDataType = 'array';
  /**
   * A token to retrieve next page of results.
   *
   * @var string
   */
  public $nextPageToken;

  /**
   * The list of feedback messages to return.
   *
   * @param GoogleCloudDatalabelingV1beta1FeedbackMessage[] $feedbackMessages
   */
  public function setFeedbackMessages($feedbackMessages)
  {
    $this->feedbackMessages = $feedbackMessages;
  }
  /**
   * @return GoogleCloudDatalabelingV1beta1FeedbackMessage[]
   */
  public function getFeedbackMessages()
  {
    return $this->feedbackMessages;
  }
  /**
   * A token to retrieve next page of results.
   *
   * @param string $nextPageToken
   */
  public function setNextPageToken($nextPageToken)
  {
    $this->nextPageToken = $nextPageToken;
  }
  /**
   * @return string
   */
  public function getNextPageToken()
  {
    return $this->nextPageToken;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoogleCloudDatalabelingV1beta1ListFeedbackMessagesResponse::class, 'Google_Service_DataLabeling_GoogleCloudDatalabelingV1beta1ListFeedbackMessagesResponse');
