<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Contentwarehouse;

class GoogleCloudDocumentaiV1DocumentRevision extends \Google\Collection
{
  protected $collection_key = 'parentIds';
  /**
   * If the change was made by a person specify the name or id of that person.
   *
   * @var string
   */
  public $agent;
  /**
   * The time that the revision was created, internally generated by doc proto
   * storage at the time of create.
   *
   * @var string
   */
  public $createTime;
  protected $humanReviewType = GoogleCloudDocumentaiV1DocumentRevisionHumanReview::class;
  protected $humanReviewDataType = '';
  /**
   * Id of the revision, internally generated by doc proto storage. Unique
   * within the context of the document.
   *
   * @var string
   */
  public $id;
  /**
   * The revisions that this revision is based on. This can include one or more
   * parent (when documents are merged.) This field represents the index into
   * the `revisions` field.
   *
   * @deprecated
   * @var int[]
   */
  public $parent;
  /**
   * The revisions that this revision is based on. Must include all the ids that
   * have anything to do with this revision - eg. there are
   * `provenance.parent.revision` fields that index into this field.
   *
   * @var string[]
   */
  public $parentIds;
  /**
   * If the annotation was made by processor identify the processor by its
   * resource name.
   *
   * @var string
   */
  public $processor;

  /**
   * If the change was made by a person specify the name or id of that person.
   *
   * @param string $agent
   */
  public function setAgent($agent)
  {
    $this->agent = $agent;
  }
  /**
   * @return string
   */
  public function getAgent()
  {
    return $this->agent;
  }
  /**
   * The time that the revision was created, internally generated by doc proto
   * storage at the time of create.
   *
   * @param string $createTime
   */
  public function setCreateTime($createTime)
  {
    $this->createTime = $createTime;
  }
  /**
   * @return string
   */
  public function getCreateTime()
  {
    return $this->createTime;
  }
  /**
   * Human Review information of this revision.
   *
   * @param GoogleCloudDocumentaiV1DocumentRevisionHumanReview $humanReview
   */
  public function setHumanReview(GoogleCloudDocumentaiV1DocumentRevisionHumanReview $humanReview)
  {
    $this->humanReview = $humanReview;
  }
  /**
   * @return GoogleCloudDocumentaiV1DocumentRevisionHumanReview
   */
  public function getHumanReview()
  {
    return $this->humanReview;
  }
  /**
   * Id of the revision, internally generated by doc proto storage. Unique
   * within the context of the document.
   *
   * @param string $id
   */
  public function setId($id)
  {
    $this->id = $id;
  }
  /**
   * @return string
   */
  public function getId()
  {
    return $this->id;
  }
  /**
   * The revisions that this revision is based on. This can include one or more
   * parent (when documents are merged.) This field represents the index into
   * the `revisions` field.
   *
   * @deprecated
   * @param int[] $parent
   */
  public function setParent($parent)
  {
    $this->parent = $parent;
  }
  /**
   * @deprecated
   * @return int[]
   */
  public function getParent()
  {
    return $this->parent;
  }
  /**
   * The revisions that this revision is based on. Must include all the ids that
   * have anything to do with this revision - eg. there are
   * `provenance.parent.revision` fields that index into this field.
   *
   * @param string[] $parentIds
   */
  public function setParentIds($parentIds)
  {
    $this->parentIds = $parentIds;
  }
  /**
   * @return string[]
   */
  public function getParentIds()
  {
    return $this->parentIds;
  }
  /**
   * If the annotation was made by processor identify the processor by its
   * resource name.
   *
   * @param string $processor
   */
  public function setProcessor($processor)
  {
    $this->processor = $processor;
  }
  /**
   * @return string
   */
  public function getProcessor()
  {
    return $this->processor;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoogleCloudDocumentaiV1DocumentRevision::class, 'Google_Service_Contentwarehouse_GoogleCloudDocumentaiV1DocumentRevision');
