<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\CloudAlloyDBAdmin;

class BackupDrEnabledWindow extends \Google\Model
{
  /**
   * Whether automated backup was previously enabled prior to enabling BackupDR
   * protection for this cluster.
   *
   * @var bool
   */
  public $automatedBackupPreviouslyEnabled;
  /**
   * The BackupPlanAssociation resource that was used to enable BackupDR
   * protection for this cluster.
   *
   * @var string
   */
  public $backupPlanAssociation;
  /**
   * The retention set for the continuous backup that was previously enabled
   * prior to enabling BackupDR protection for this cluster.
   *
   * @var int
   */
  public $continuousBackupPreviousRecoveryWindowDays;
  /**
   * Whether continuous backup was previously enabled prior to enabling BackupDR
   * protection for this cluster.
   *
   * @var bool
   */
  public $continuousBackupPreviouslyEnabled;
  /**
   * The time when continuous backup was previously enabled prior to enabling
   * BackupDR protection for this cluster.
   *
   * @var string
   */
  public $continuousBackupPreviouslyEnabledTime;
  /**
   * The DataSource resource that represents the cluster in BackupDR.
   *
   * @var string
   */
  public $dataSource;
  /**
   * Time when the BackupDR protection for this cluster was disabled. This field
   * will be empty if this BackupDR window is the `current_window`.
   *
   * @var string
   */
  public $disabledTime;
  /**
   * Time when the BackupDR protection for this cluster was enabled.
   *
   * @var string
   */
  public $enabledTime;
  /**
   * The retention period for logs generated by BackupDR for this cluster.
   *
   * @var string
   */
  public $logRetentionPeriod;

  /**
   * Whether automated backup was previously enabled prior to enabling BackupDR
   * protection for this cluster.
   *
   * @param bool $automatedBackupPreviouslyEnabled
   */
  public function setAutomatedBackupPreviouslyEnabled($automatedBackupPreviouslyEnabled)
  {
    $this->automatedBackupPreviouslyEnabled = $automatedBackupPreviouslyEnabled;
  }
  /**
   * @return bool
   */
  public function getAutomatedBackupPreviouslyEnabled()
  {
    return $this->automatedBackupPreviouslyEnabled;
  }
  /**
   * The BackupPlanAssociation resource that was used to enable BackupDR
   * protection for this cluster.
   *
   * @param string $backupPlanAssociation
   */
  public function setBackupPlanAssociation($backupPlanAssociation)
  {
    $this->backupPlanAssociation = $backupPlanAssociation;
  }
  /**
   * @return string
   */
  public function getBackupPlanAssociation()
  {
    return $this->backupPlanAssociation;
  }
  /**
   * The retention set for the continuous backup that was previously enabled
   * prior to enabling BackupDR protection for this cluster.
   *
   * @param int $continuousBackupPreviousRecoveryWindowDays
   */
  public function setContinuousBackupPreviousRecoveryWindowDays($continuousBackupPreviousRecoveryWindowDays)
  {
    $this->continuousBackupPreviousRecoveryWindowDays = $continuousBackupPreviousRecoveryWindowDays;
  }
  /**
   * @return int
   */
  public function getContinuousBackupPreviousRecoveryWindowDays()
  {
    return $this->continuousBackupPreviousRecoveryWindowDays;
  }
  /**
   * Whether continuous backup was previously enabled prior to enabling BackupDR
   * protection for this cluster.
   *
   * @param bool $continuousBackupPreviouslyEnabled
   */
  public function setContinuousBackupPreviouslyEnabled($continuousBackupPreviouslyEnabled)
  {
    $this->continuousBackupPreviouslyEnabled = $continuousBackupPreviouslyEnabled;
  }
  /**
   * @return bool
   */
  public function getContinuousBackupPreviouslyEnabled()
  {
    return $this->continuousBackupPreviouslyEnabled;
  }
  /**
   * The time when continuous backup was previously enabled prior to enabling
   * BackupDR protection for this cluster.
   *
   * @param string $continuousBackupPreviouslyEnabledTime
   */
  public function setContinuousBackupPreviouslyEnabledTime($continuousBackupPreviouslyEnabledTime)
  {
    $this->continuousBackupPreviouslyEnabledTime = $continuousBackupPreviouslyEnabledTime;
  }
  /**
   * @return string
   */
  public function getContinuousBackupPreviouslyEnabledTime()
  {
    return $this->continuousBackupPreviouslyEnabledTime;
  }
  /**
   * The DataSource resource that represents the cluster in BackupDR.
   *
   * @param string $dataSource
   */
  public function setDataSource($dataSource)
  {
    $this->dataSource = $dataSource;
  }
  /**
   * @return string
   */
  public function getDataSource()
  {
    return $this->dataSource;
  }
  /**
   * Time when the BackupDR protection for this cluster was disabled. This field
   * will be empty if this BackupDR window is the `current_window`.
   *
   * @param string $disabledTime
   */
  public function setDisabledTime($disabledTime)
  {
    $this->disabledTime = $disabledTime;
  }
  /**
   * @return string
   */
  public function getDisabledTime()
  {
    return $this->disabledTime;
  }
  /**
   * Time when the BackupDR protection for this cluster was enabled.
   *
   * @param string $enabledTime
   */
  public function setEnabledTime($enabledTime)
  {
    $this->enabledTime = $enabledTime;
  }
  /**
   * @return string
   */
  public function getEnabledTime()
  {
    return $this->enabledTime;
  }
  /**
   * The retention period for logs generated by BackupDR for this cluster.
   *
   * @param string $logRetentionPeriod
   */
  public function setLogRetentionPeriod($logRetentionPeriod)
  {
    $this->logRetentionPeriod = $logRetentionPeriod;
  }
  /**
   * @return string
   */
  public function getLogRetentionPeriod()
  {
    return $this->logRetentionPeriod;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(BackupDrEnabledWindow::class, 'Google_Service_CloudAlloyDBAdmin_BackupDrEnabledWindow');
