<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Baremetalsolution;

class LogicalNetworkInterface extends \Google\Model
{
  /**
   * Unspecified value.
   */
  public const NETWORK_TYPE_TYPE_UNSPECIFIED = 'TYPE_UNSPECIFIED';
  /**
   * Client network, a network peered to a Google Cloud VPC.
   */
  public const NETWORK_TYPE_CLIENT = 'CLIENT';
  /**
   * Private network, a network local to the Bare Metal Solution environment.
   */
  public const NETWORK_TYPE_PRIVATE = 'PRIVATE';
  /**
   * Whether this interface is the default gateway for the instance. Only one
   * interface can be the default gateway for the instance.
   *
   * @var bool
   */
  public $defaultGateway;
  /**
   * An identifier for the `Network`, generated by the backend.
   *
   * @var string
   */
  public $id;
  /**
   * IP address in the network
   *
   * @var string
   */
  public $ipAddress;
  /**
   * Name of the network
   *
   * @var string
   */
  public $network;
  /**
   * Type of network.
   *
   * @var string
   */
  public $networkType;

  /**
   * Whether this interface is the default gateway for the instance. Only one
   * interface can be the default gateway for the instance.
   *
   * @param bool $defaultGateway
   */
  public function setDefaultGateway($defaultGateway)
  {
    $this->defaultGateway = $defaultGateway;
  }
  /**
   * @return bool
   */
  public function getDefaultGateway()
  {
    return $this->defaultGateway;
  }
  /**
   * An identifier for the `Network`, generated by the backend.
   *
   * @param string $id
   */
  public function setId($id)
  {
    $this->id = $id;
  }
  /**
   * @return string
   */
  public function getId()
  {
    return $this->id;
  }
  /**
   * IP address in the network
   *
   * @param string $ipAddress
   */
  public function setIpAddress($ipAddress)
  {
    $this->ipAddress = $ipAddress;
  }
  /**
   * @return string
   */
  public function getIpAddress()
  {
    return $this->ipAddress;
  }
  /**
   * Name of the network
   *
   * @param string $network
   */
  public function setNetwork($network)
  {
    $this->network = $network;
  }
  /**
   * @return string
   */
  public function getNetwork()
  {
    return $this->network;
  }
  /**
   * Type of network.
   *
   * Accepted values: TYPE_UNSPECIFIED, CLIENT, PRIVATE
   *
   * @param self::NETWORK_TYPE_* $networkType
   */
  public function setNetworkType($networkType)
  {
    $this->networkType = $networkType;
  }
  /**
   * @return self::NETWORK_TYPE_*
   */
  public function getNetworkType()
  {
    return $this->networkType;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(LogicalNetworkInterface::class, 'Google_Service_Baremetalsolution_LogicalNetworkInterface');
