<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\AndroidPublisher;

class ApksAddExternallyHostedResponse extends \Google\Model
{
  protected $externallyHostedApkType = ExternallyHostedApk::class;
  protected $externallyHostedApkDataType = '';

  /**
   * The definition of the externally-hosted APK and where it is located.
   *
   * @param ExternallyHostedApk $externallyHostedApk
   */
  public function setExternallyHostedApk(ExternallyHostedApk $externallyHostedApk)
  {
    $this->externallyHostedApk = $externallyHostedApk;
  }
  /**
   * @return ExternallyHostedApk
   */
  public function getExternallyHostedApk()
  {
    return $this->externallyHostedApk;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(ApksAddExternallyHostedResponse::class, 'Google_Service_AndroidPublisher_ApksAddExternallyHostedResponse');
