<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Analytics;

class AccountPermissions extends \Google\Collection
{
  protected $collection_key = 'effective';
  /**
   * All the permissions that the user has for this account. These include any
   * implied permissions (e.g., EDIT implies VIEW).
   *
   * @var string[]
   */
  public $effective;

  /**
   * All the permissions that the user has for this account. These include any
   * implied permissions (e.g., EDIT implies VIEW).
   *
   * @param string[] $effective
   */
  public function setEffective($effective)
  {
    $this->effective = $effective;
  }
  /**
   * @return string[]
   */
  public function getEffective()
  {
    return $this->effective;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(AccountPermissions::class, 'Google_Service_Analytics_AccountPermissions');
