<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\HangoutsChat;

class DynamiteIntegrationLogEntry extends \Google\Model
{
  public $deployment;
  public $deploymentFunction;
  protected $errorType = Status::class;
  protected $errorDataType = '';

  public function setDeployment($deployment)
  {
    $this->deployment = $deployment;
  }
  public function getDeployment()
  {
    return $this->deployment;
  }
  public function setDeploymentFunction($deploymentFunction)
  {
    $this->deploymentFunction = $deploymentFunction;
  }
  public function getDeploymentFunction()
  {
    return $this->deploymentFunction;
  }
  /**
   * @param Status
   */
  public function setError(Status $error)
  {
    $this->error = $error;
  }
  /**
   * @return Status
   */
  public function getError()
  {
    return $this->error;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(DynamiteIntegrationLogEntry::class, 'Google_Service_HangoutsChat_DynamiteIntegrationLogEntry');
