<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Vault;

class OrgUnitInfo extends \Google\Model
{
  /**
   * The name of the organizational unit to search, as provided by the [Admin
   * SDK Directory API](https://developers.google.com/admin-sdk/directory/).
   *
   * @var string
   */
  public $orgUnitId;

  /**
   * The name of the organizational unit to search, as provided by the [Admin
   * SDK Directory API](https://developers.google.com/admin-sdk/directory/).
   *
   * @param string $orgUnitId
   */
  public function setOrgUnitId($orgUnitId)
  {
    $this->orgUnitId = $orgUnitId;
  }
  /**
   * @return string
   */
  public function getOrgUnitId()
  {
    return $this->orgUnitId;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(OrgUnitInfo::class, 'Google_Service_Vault_OrgUnitInfo');
