<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\ServiceControl;

class ServicecontrolResource extends \Google\Model
{
  /**
   * Annotations is an unstructured key-value map stored with a resource that
   * may be set by external tools to store and retrieve arbitrary metadata. They
   * are not queryable and should be preserved when modifying objects. More
   * info: https://kubernetes.io/docs/concepts/overview/working-with-
   * objects/annotations/
   *
   * @var string[]
   */
  public $annotations;
  /**
   * Output only. The timestamp when the resource was created. This may be
   * either the time creation was initiated or when it was completed.
   *
   * @var string
   */
  public $createTime;
  /**
   * Output only. The timestamp when the resource was deleted. If the resource
   * is not deleted, this must be empty.
   *
   * @var string
   */
  public $deleteTime;
  /**
   * Mutable. The display name set by clients. Must be <= 63 characters.
   *
   * @var string
   */
  public $displayName;
  /**
   * Output only. An opaque value that uniquely identifies a version or
   * generation of a resource. It can be used to confirm that the client and
   * server agree on the ordering of a resource being written.
   *
   * @var string
   */
  public $etag;
  /**
   * The labels or tags on the resource, such as AWS resource tags and
   * Kubernetes resource labels.
   *
   * @var string[]
   */
  public $labels;
  /**
   * Immutable. The location of the resource. The location encoding is specific
   * to the service provider, and new encoding may be introduced as the service
   * evolves. For Google Cloud products, the encoding is what is used by Google
   * Cloud APIs, such as `us-east1`, `aws-us-east-1`, and `azure-eastus2`. The
   * semantics of `location` is identical to the `cloud.googleapis.com/location`
   * label used by some Google Cloud APIs.
   *
   * @var string
   */
  public $location;
  /**
   * The stable identifier (name) of a resource on the `service`. A resource can
   * be logically identified as "//{resource.service}/{resource.name}". The
   * differences between a resource name and a URI are: * Resource name is a
   * logical identifier, independent of network protocol and API version. For
   * example, `//pubsub.googleapis.com/projects/123/topics/news-feed`. * URI
   * often includes protocol and version information, so it can be used directly
   * by applications. For example,
   * `https://pubsub.googleapis.com/v1/projects/123/topics/news-feed`. See
   * https://cloud.google.com/apis/design/resource_names for details.
   *
   * @var string
   */
  public $name;
  /**
   * The name of the service that this resource belongs to, such as
   * `pubsub.googleapis.com`. The service may be different from the DNS hostname
   * that actually serves the request.
   *
   * @var string
   */
  public $service;
  /**
   * The type of the resource. The syntax is platform-specific because different
   * platforms define their resources differently. For Google APIs, the type
   * format must be "{service}/{kind}", such as "pubsub.googleapis.com/Topic".
   *
   * @var string
   */
  public $type;
  /**
   * The unique identifier of the resource. UID is unique in the time and space
   * for this resource within the scope of the service. It is typically
   * generated by the server on successful creation of a resource and must not
   * be changed. UID is used to uniquely identify resources with resource name
   * reuses. This should be a UUID4.
   *
   * @var string
   */
  public $uid;
  /**
   * Output only. The timestamp when the resource was last updated. Any change
   * to the resource made by users must refresh this value. Changes to a
   * resource made by the service should refresh this value.
   *
   * @var string
   */
  public $updateTime;

  /**
   * Annotations is an unstructured key-value map stored with a resource that
   * may be set by external tools to store and retrieve arbitrary metadata. They
   * are not queryable and should be preserved when modifying objects. More
   * info: https://kubernetes.io/docs/concepts/overview/working-with-
   * objects/annotations/
   *
   * @param string[] $annotations
   */
  public function setAnnotations($annotations)
  {
    $this->annotations = $annotations;
  }
  /**
   * @return string[]
   */
  public function getAnnotations()
  {
    return $this->annotations;
  }
  /**
   * Output only. The timestamp when the resource was created. This may be
   * either the time creation was initiated or when it was completed.
   *
   * @param string $createTime
   */
  public function setCreateTime($createTime)
  {
    $this->createTime = $createTime;
  }
  /**
   * @return string
   */
  public function getCreateTime()
  {
    return $this->createTime;
  }
  /**
   * Output only. The timestamp when the resource was deleted. If the resource
   * is not deleted, this must be empty.
   *
   * @param string $deleteTime
   */
  public function setDeleteTime($deleteTime)
  {
    $this->deleteTime = $deleteTime;
  }
  /**
   * @return string
   */
  public function getDeleteTime()
  {
    return $this->deleteTime;
  }
  /**
   * Mutable. The display name set by clients. Must be <= 63 characters.
   *
   * @param string $displayName
   */
  public function setDisplayName($displayName)
  {
    $this->displayName = $displayName;
  }
  /**
   * @return string
   */
  public function getDisplayName()
  {
    return $this->displayName;
  }
  /**
   * Output only. An opaque value that uniquely identifies a version or
   * generation of a resource. It can be used to confirm that the client and
   * server agree on the ordering of a resource being written.
   *
   * @param string $etag
   */
  public function setEtag($etag)
  {
    $this->etag = $etag;
  }
  /**
   * @return string
   */
  public function getEtag()
  {
    return $this->etag;
  }
  /**
   * The labels or tags on the resource, such as AWS resource tags and
   * Kubernetes resource labels.
   *
   * @param string[] $labels
   */
  public function setLabels($labels)
  {
    $this->labels = $labels;
  }
  /**
   * @return string[]
   */
  public function getLabels()
  {
    return $this->labels;
  }
  /**
   * Immutable. The location of the resource. The location encoding is specific
   * to the service provider, and new encoding may be introduced as the service
   * evolves. For Google Cloud products, the encoding is what is used by Google
   * Cloud APIs, such as `us-east1`, `aws-us-east-1`, and `azure-eastus2`. The
   * semantics of `location` is identical to the `cloud.googleapis.com/location`
   * label used by some Google Cloud APIs.
   *
   * @param string $location
   */
  public function setLocation($location)
  {
    $this->location = $location;
  }
  /**
   * @return string
   */
  public function getLocation()
  {
    return $this->location;
  }
  /**
   * The stable identifier (name) of a resource on the `service`. A resource can
   * be logically identified as "//{resource.service}/{resource.name}". The
   * differences between a resource name and a URI are: * Resource name is a
   * logical identifier, independent of network protocol and API version. For
   * example, `//pubsub.googleapis.com/projects/123/topics/news-feed`. * URI
   * often includes protocol and version information, so it can be used directly
   * by applications. For example,
   * `https://pubsub.googleapis.com/v1/projects/123/topics/news-feed`. See
   * https://cloud.google.com/apis/design/resource_names for details.
   *
   * @param string $name
   */
  public function setName($name)
  {
    $this->name = $name;
  }
  /**
   * @return string
   */
  public function getName()
  {
    return $this->name;
  }
  /**
   * The name of the service that this resource belongs to, such as
   * `pubsub.googleapis.com`. The service may be different from the DNS hostname
   * that actually serves the request.
   *
   * @param string $service
   */
  public function setService($service)
  {
    $this->service = $service;
  }
  /**
   * @return string
   */
  public function getService()
  {
    return $this->service;
  }
  /**
   * The type of the resource. The syntax is platform-specific because different
   * platforms define their resources differently. For Google APIs, the type
   * format must be "{service}/{kind}", such as "pubsub.googleapis.com/Topic".
   *
   * @param string $type
   */
  public function setType($type)
  {
    $this->type = $type;
  }
  /**
   * @return string
   */
  public function getType()
  {
    return $this->type;
  }
  /**
   * The unique identifier of the resource. UID is unique in the time and space
   * for this resource within the scope of the service. It is typically
   * generated by the server on successful creation of a resource and must not
   * be changed. UID is used to uniquely identify resources with resource name
   * reuses. This should be a UUID4.
   *
   * @param string $uid
   */
  public function setUid($uid)
  {
    $this->uid = $uid;
  }
  /**
   * @return string
   */
  public function getUid()
  {
    return $this->uid;
  }
  /**
   * Output only. The timestamp when the resource was last updated. Any change
   * to the resource made by users must refresh this value. Changes to a
   * resource made by the service should refresh this value.
   *
   * @param string $updateTime
   */
  public function setUpdateTime($updateTime)
  {
    $this->updateTime = $updateTime;
  }
  /**
   * @return string
   */
  public function getUpdateTime()
  {
    return $this->updateTime;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(ServicecontrolResource::class, 'Google_Service_ServiceControl_ServicecontrolResource');
