<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Compute;

class TargetVpnGateway extends \Google\Collection
{
  public const STATUS_CREATING = 'CREATING';
  public const STATUS_DELETING = 'DELETING';
  public const STATUS_FAILED = 'FAILED';
  public const STATUS_READY = 'READY';
  protected $collection_key = 'tunnels';
  /**
   * [Output Only] Creation timestamp inRFC3339 text format.
   *
   * @var string
   */
  public $creationTimestamp;
  /**
   * An optional description of this resource. Provide this property when you
   * create the resource.
   *
   * @var string
   */
  public $description;
  /**
   * [Output Only] A list of URLs to the ForwardingRule resources.
   * ForwardingRules are created usingcompute.forwardingRules.insert and
   * associated with a VPN gateway.
   *
   * @var string[]
   */
  public $forwardingRules;
  /**
   * [Output Only] The unique identifier for the resource. This identifier is
   * defined by the server.
   *
   * @var string
   */
  public $id;
  /**
   * [Output Only] Type of resource. Alwayscompute#targetVpnGateway for target
   * VPN gateways.
   *
   * @var string
   */
  public $kind;
  /**
   * A fingerprint for the labels being applied to this TargetVpnGateway, which
   * is essentially a hash of the labels set used for optimistic locking. The
   * fingerprint is initially generated by Compute Engine and changes after
   * every request to modify or update labels. You must always provide an up-to-
   * date fingerprint hash in order to update or change labels, otherwise the
   * request will fail with error412 conditionNotMet.
   *
   * To see the latest fingerprint, make a get() request to retrieve a
   * TargetVpnGateway.
   *
   * @var string
   */
  public $labelFingerprint;
  /**
   * Labels for this resource. These can only be added or modified by
   * thesetLabels method. Each label key/value pair must comply withRFC1035.
   * Label values may be empty.
   *
   * @var string[]
   */
  public $labels;
  /**
   * Name of the resource. Provided by the client when the resource is created.
   * The name must be 1-63 characters long, and comply withRFC1035.
   * Specifically, the name must be 1-63 characters long and match the regular
   * expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character
   * must be a lowercase letter, and all following characters must be a dash,
   * lowercase letter, or digit, except the last character, which cannot be a
   * dash.
   *
   * @var string
   */
  public $name;
  /**
   * URL of the network to which this VPN gateway is attached. Provided by the
   * client when the VPN gateway is created.
   *
   * @var string
   */
  public $network;
  /**
   * [Output Only] URL of the region where the target VPN gateway resides. You
   * must specify this field as part of the HTTP request URL. It is not settable
   * as a field in the request body.
   *
   * @var string
   */
  public $region;
  /**
   * [Output Only] Server-defined URL for the resource.
   *
   * @var string
   */
  public $selfLink;
  /**
   * [Output Only] The status of the VPN gateway, which can be one of the
   * following: CREATING, READY, FAILED, or DELETING.
   *
   * @var string
   */
  public $status;
  /**
   * [Output Only] A list of URLs to VpnTunnel resources. VpnTunnels are created
   * using the compute.vpntunnels.insert method and associated with a VPN
   * gateway.
   *
   * @var string[]
   */
  public $tunnels;

  /**
   * [Output Only] Creation timestamp inRFC3339 text format.
   *
   * @param string $creationTimestamp
   */
  public function setCreationTimestamp($creationTimestamp)
  {
    $this->creationTimestamp = $creationTimestamp;
  }
  /**
   * @return string
   */
  public function getCreationTimestamp()
  {
    return $this->creationTimestamp;
  }
  /**
   * An optional description of this resource. Provide this property when you
   * create the resource.
   *
   * @param string $description
   */
  public function setDescription($description)
  {
    $this->description = $description;
  }
  /**
   * @return string
   */
  public function getDescription()
  {
    return $this->description;
  }
  /**
   * [Output Only] A list of URLs to the ForwardingRule resources.
   * ForwardingRules are created usingcompute.forwardingRules.insert and
   * associated with a VPN gateway.
   *
   * @param string[] $forwardingRules
   */
  public function setForwardingRules($forwardingRules)
  {
    $this->forwardingRules = $forwardingRules;
  }
  /**
   * @return string[]
   */
  public function getForwardingRules()
  {
    return $this->forwardingRules;
  }
  /**
   * [Output Only] The unique identifier for the resource. This identifier is
   * defined by the server.
   *
   * @param string $id
   */
  public function setId($id)
  {
    $this->id = $id;
  }
  /**
   * @return string
   */
  public function getId()
  {
    return $this->id;
  }
  /**
   * [Output Only] Type of resource. Alwayscompute#targetVpnGateway for target
   * VPN gateways.
   *
   * @param string $kind
   */
  public function setKind($kind)
  {
    $this->kind = $kind;
  }
  /**
   * @return string
   */
  public function getKind()
  {
    return $this->kind;
  }
  /**
   * A fingerprint for the labels being applied to this TargetVpnGateway, which
   * is essentially a hash of the labels set used for optimistic locking. The
   * fingerprint is initially generated by Compute Engine and changes after
   * every request to modify or update labels. You must always provide an up-to-
   * date fingerprint hash in order to update or change labels, otherwise the
   * request will fail with error412 conditionNotMet.
   *
   * To see the latest fingerprint, make a get() request to retrieve a
   * TargetVpnGateway.
   *
   * @param string $labelFingerprint
   */
  public function setLabelFingerprint($labelFingerprint)
  {
    $this->labelFingerprint = $labelFingerprint;
  }
  /**
   * @return string
   */
  public function getLabelFingerprint()
  {
    return $this->labelFingerprint;
  }
  /**
   * Labels for this resource. These can only be added or modified by
   * thesetLabels method. Each label key/value pair must comply withRFC1035.
   * Label values may be empty.
   *
   * @param string[] $labels
   */
  public function setLabels($labels)
  {
    $this->labels = $labels;
  }
  /**
   * @return string[]
   */
  public function getLabels()
  {
    return $this->labels;
  }
  /**
   * Name of the resource. Provided by the client when the resource is created.
   * The name must be 1-63 characters long, and comply withRFC1035.
   * Specifically, the name must be 1-63 characters long and match the regular
   * expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character
   * must be a lowercase letter, and all following characters must be a dash,
   * lowercase letter, or digit, except the last character, which cannot be a
   * dash.
   *
   * @param string $name
   */
  public function setName($name)
  {
    $this->name = $name;
  }
  /**
   * @return string
   */
  public function getName()
  {
    return $this->name;
  }
  /**
   * URL of the network to which this VPN gateway is attached. Provided by the
   * client when the VPN gateway is created.
   *
   * @param string $network
   */
  public function setNetwork($network)
  {
    $this->network = $network;
  }
  /**
   * @return string
   */
  public function getNetwork()
  {
    return $this->network;
  }
  /**
   * [Output Only] URL of the region where the target VPN gateway resides. You
   * must specify this field as part of the HTTP request URL. It is not settable
   * as a field in the request body.
   *
   * @param string $region
   */
  public function setRegion($region)
  {
    $this->region = $region;
  }
  /**
   * @return string
   */
  public function getRegion()
  {
    return $this->region;
  }
  /**
   * [Output Only] Server-defined URL for the resource.
   *
   * @param string $selfLink
   */
  public function setSelfLink($selfLink)
  {
    $this->selfLink = $selfLink;
  }
  /**
   * @return string
   */
  public function getSelfLink()
  {
    return $this->selfLink;
  }
  /**
   * [Output Only] The status of the VPN gateway, which can be one of the
   * following: CREATING, READY, FAILED, or DELETING.
   *
   * Accepted values: CREATING, DELETING, FAILED, READY
   *
   * @param self::STATUS_* $status
   */
  public function setStatus($status)
  {
    $this->status = $status;
  }
  /**
   * @return self::STATUS_*
   */
  public function getStatus()
  {
    return $this->status;
  }
  /**
   * [Output Only] A list of URLs to VpnTunnel resources. VpnTunnels are created
   * using the compute.vpntunnels.insert method and associated with a VPN
   * gateway.
   *
   * @param string[] $tunnels
   */
  public function setTunnels($tunnels)
  {
    $this->tunnels = $tunnels;
  }
  /**
   * @return string[]
   */
  public function getTunnels()
  {
    return $this->tunnels;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(TargetVpnGateway::class, 'Google_Service_Compute_TargetVpnGateway');
