<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Compute;

class FirewallPolicy extends \Google\Collection
{
  public const POLICY_TYPE_RDMA_ROCE_POLICY = 'RDMA_ROCE_POLICY';
  public const POLICY_TYPE_VPC_POLICY = 'VPC_POLICY';
  protected $collection_key = 'rules';
  protected $associationsType = FirewallPolicyAssociation::class;
  protected $associationsDataType = 'array';
  /**
   * [Output Only] Creation timestamp inRFC3339 text format.
   *
   * @var string
   */
  public $creationTimestamp;
  /**
   * An optional description of this resource. Provide this property when you
   * create the resource.
   *
   * @var string
   */
  public $description;
  /**
   * Deprecated, please use short name instead. User-provided name of the
   * Organization firewall policy. The name should be unique in the organization
   * in which the firewall policy is created. This field is not applicable to
   * network firewall policies. This name must be set on creation and cannot be
   * changed. The name must be 1-63 characters long, and comply with RFC1035.
   * Specifically, the name must be 1-63 characters long and match the regular
   * expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character
   * must be a lowercase letter, and all following characters must be a dash,
   * lowercase letter, or digit, except the last character, which cannot be a
   * dash.
   *
   * @deprecated
   * @var string
   */
  public $displayName;
  /**
   * Specifies a fingerprint for this resource, which is essentially a hash of
   * the metadata's contents and used for optimistic locking. The fingerprint is
   * initially generated by Compute Engine and changes after every request to
   * modify or update metadata. You must always provide an up-to-date
   * fingerprint hash in order to update or change metadata, otherwise the
   * request will fail with error412 conditionNotMet.
   *
   * To see the latest fingerprint, make get() request to the firewall policy.
   *
   * @var string
   */
  public $fingerprint;
  /**
   * [Output Only] The unique identifier for the resource. This identifier is
   * defined by the server.
   *
   * @var string
   */
  public $id;
  /**
   * [Output only] Type of the resource. Alwayscompute#firewallPolicyfor
   * firewall policies
   *
   * @var string
   */
  public $kind;
  /**
   * Name of the resource. For Organization Firewall Policies it's a [Output
   * Only] numeric ID allocated by Google Cloud which uniquely identifies the
   * Organization Firewall Policy.
   *
   * @var string
   */
  public $name;
  protected $packetMirroringRulesType = FirewallPolicyRule::class;
  protected $packetMirroringRulesDataType = 'array';
  /**
   * [Output Only] The parent of the firewall policy. This field is not
   * applicable to network firewall policies.
   *
   * @var string
   */
  public $parent;
  /**
   * The type of the firewall policy. This field can be eitherVPC_POLICY or
   * RDMA_ROCE_POLICY.
   *
   * Note: if not specified then VPC_POLICY will be used.
   *
   * @var string
   */
  public $policyType;
  /**
   * [Output Only] URL of the region where the regional firewall policy resides.
   * This field is not applicable to global firewall policies. You must specify
   * this field as part of the HTTP request URL. It is not settable as a field
   * in the request body.
   *
   * @var string
   */
  public $region;
  /**
   * [Output Only] Total count of all firewall policy rule tuples. A firewall
   * policy can not exceed a set number of tuples.
   *
   * @var int
   */
  public $ruleTupleCount;
  protected $rulesType = FirewallPolicyRule::class;
  protected $rulesDataType = 'array';
  /**
   * [Output Only] Server-defined URL for the resource.
   *
   * @var string
   */
  public $selfLink;
  /**
   * [Output Only] Server-defined URL for this resource with the resource id.
   *
   * @var string
   */
  public $selfLinkWithId;
  /**
   * User-provided name of the Organization firewall policy. The name should be
   * unique in the organization in which the firewall policy is created. This
   * field is not applicable to network firewall policies. This name must be set
   * on creation and cannot be changed. The name must be 1-63 characters long,
   * and comply with RFC1035. Specifically, the name must be 1-63 characters
   * long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which
   * means the first character must be a lowercase letter, and all following
   * characters must be a dash, lowercase letter, or digit, except the last
   * character, which cannot be a dash.
   *
   * @var string
   */
  public $shortName;

  /**
   * A list of associations that belong to this firewall policy.
   *
   * @param FirewallPolicyAssociation[] $associations
   */
  public function setAssociations($associations)
  {
    $this->associations = $associations;
  }
  /**
   * @return FirewallPolicyAssociation[]
   */
  public function getAssociations()
  {
    return $this->associations;
  }
  /**
   * [Output Only] Creation timestamp inRFC3339 text format.
   *
   * @param string $creationTimestamp
   */
  public function setCreationTimestamp($creationTimestamp)
  {
    $this->creationTimestamp = $creationTimestamp;
  }
  /**
   * @return string
   */
  public function getCreationTimestamp()
  {
    return $this->creationTimestamp;
  }
  /**
   * An optional description of this resource. Provide this property when you
   * create the resource.
   *
   * @param string $description
   */
  public function setDescription($description)
  {
    $this->description = $description;
  }
  /**
   * @return string
   */
  public function getDescription()
  {
    return $this->description;
  }
  /**
   * Deprecated, please use short name instead. User-provided name of the
   * Organization firewall policy. The name should be unique in the organization
   * in which the firewall policy is created. This field is not applicable to
   * network firewall policies. This name must be set on creation and cannot be
   * changed. The name must be 1-63 characters long, and comply with RFC1035.
   * Specifically, the name must be 1-63 characters long and match the regular
   * expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character
   * must be a lowercase letter, and all following characters must be a dash,
   * lowercase letter, or digit, except the last character, which cannot be a
   * dash.
   *
   * @deprecated
   * @param string $displayName
   */
  public function setDisplayName($displayName)
  {
    $this->displayName = $displayName;
  }
  /**
   * @deprecated
   * @return string
   */
  public function getDisplayName()
  {
    return $this->displayName;
  }
  /**
   * Specifies a fingerprint for this resource, which is essentially a hash of
   * the metadata's contents and used for optimistic locking. The fingerprint is
   * initially generated by Compute Engine and changes after every request to
   * modify or update metadata. You must always provide an up-to-date
   * fingerprint hash in order to update or change metadata, otherwise the
   * request will fail with error412 conditionNotMet.
   *
   * To see the latest fingerprint, make get() request to the firewall policy.
   *
   * @param string $fingerprint
   */
  public function setFingerprint($fingerprint)
  {
    $this->fingerprint = $fingerprint;
  }
  /**
   * @return string
   */
  public function getFingerprint()
  {
    return $this->fingerprint;
  }
  /**
   * [Output Only] The unique identifier for the resource. This identifier is
   * defined by the server.
   *
   * @param string $id
   */
  public function setId($id)
  {
    $this->id = $id;
  }
  /**
   * @return string
   */
  public function getId()
  {
    return $this->id;
  }
  /**
   * [Output only] Type of the resource. Alwayscompute#firewallPolicyfor
   * firewall policies
   *
   * @param string $kind
   */
  public function setKind($kind)
  {
    $this->kind = $kind;
  }
  /**
   * @return string
   */
  public function getKind()
  {
    return $this->kind;
  }
  /**
   * Name of the resource. For Organization Firewall Policies it's a [Output
   * Only] numeric ID allocated by Google Cloud which uniquely identifies the
   * Organization Firewall Policy.
   *
   * @param string $name
   */
  public function setName($name)
  {
    $this->name = $name;
  }
  /**
   * @return string
   */
  public function getName()
  {
    return $this->name;
  }
  /**
   * A list of packet mirroring rules that belong to this policy.
   *
   * @param FirewallPolicyRule[] $packetMirroringRules
   */
  public function setPacketMirroringRules($packetMirroringRules)
  {
    $this->packetMirroringRules = $packetMirroringRules;
  }
  /**
   * @return FirewallPolicyRule[]
   */
  public function getPacketMirroringRules()
  {
    return $this->packetMirroringRules;
  }
  /**
   * [Output Only] The parent of the firewall policy. This field is not
   * applicable to network firewall policies.
   *
   * @param string $parent
   */
  public function setParent($parent)
  {
    $this->parent = $parent;
  }
  /**
   * @return string
   */
  public function getParent()
  {
    return $this->parent;
  }
  /**
   * The type of the firewall policy. This field can be eitherVPC_POLICY or
   * RDMA_ROCE_POLICY.
   *
   * Note: if not specified then VPC_POLICY will be used.
   *
   * Accepted values: RDMA_ROCE_POLICY, VPC_POLICY
   *
   * @param self::POLICY_TYPE_* $policyType
   */
  public function setPolicyType($policyType)
  {
    $this->policyType = $policyType;
  }
  /**
   * @return self::POLICY_TYPE_*
   */
  public function getPolicyType()
  {
    return $this->policyType;
  }
  /**
   * [Output Only] URL of the region where the regional firewall policy resides.
   * This field is not applicable to global firewall policies. You must specify
   * this field as part of the HTTP request URL. It is not settable as a field
   * in the request body.
   *
   * @param string $region
   */
  public function setRegion($region)
  {
    $this->region = $region;
  }
  /**
   * @return string
   */
  public function getRegion()
  {
    return $this->region;
  }
  /**
   * [Output Only] Total count of all firewall policy rule tuples. A firewall
   * policy can not exceed a set number of tuples.
   *
   * @param int $ruleTupleCount
   */
  public function setRuleTupleCount($ruleTupleCount)
  {
    $this->ruleTupleCount = $ruleTupleCount;
  }
  /**
   * @return int
   */
  public function getRuleTupleCount()
  {
    return $this->ruleTupleCount;
  }
  /**
   * A list of rules that belong to this policy. There must always be a default
   * rule (rule with priority 2147483647 and match "*"). If no rules are
   * provided when creating a firewall policy, a default rule with action
   * "allow" will be added.
   *
   * @param FirewallPolicyRule[] $rules
   */
  public function setRules($rules)
  {
    $this->rules = $rules;
  }
  /**
   * @return FirewallPolicyRule[]
   */
  public function getRules()
  {
    return $this->rules;
  }
  /**
   * [Output Only] Server-defined URL for the resource.
   *
   * @param string $selfLink
   */
  public function setSelfLink($selfLink)
  {
    $this->selfLink = $selfLink;
  }
  /**
   * @return string
   */
  public function getSelfLink()
  {
    return $this->selfLink;
  }
  /**
   * [Output Only] Server-defined URL for this resource with the resource id.
   *
   * @param string $selfLinkWithId
   */
  public function setSelfLinkWithId($selfLinkWithId)
  {
    $this->selfLinkWithId = $selfLinkWithId;
  }
  /**
   * @return string
   */
  public function getSelfLinkWithId()
  {
    return $this->selfLinkWithId;
  }
  /**
   * User-provided name of the Organization firewall policy. The name should be
   * unique in the organization in which the firewall policy is created. This
   * field is not applicable to network firewall policies. This name must be set
   * on creation and cannot be changed. The name must be 1-63 characters long,
   * and comply with RFC1035. Specifically, the name must be 1-63 characters
   * long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which
   * means the first character must be a lowercase letter, and all following
   * characters must be a dash, lowercase letter, or digit, except the last
   * character, which cannot be a dash.
   *
   * @param string $shortName
   */
  public function setShortName($shortName)
  {
    $this->shortName = $shortName;
  }
  /**
   * @return string
   */
  public function getShortName()
  {
    return $this->shortName;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(FirewallPolicy::class, 'Google_Service_Compute_FirewallPolicy');
