<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Apigee;

class GoogleCloudApigeeV1SecurityProfile extends \Google\Collection
{
  protected $collection_key = 'scoringConfigs';
  /**
   * Description of the security profile.
   *
   * @var string
   */
  public $description;
  /**
   * DEPRECATED: DO NOT USE Display name of the security profile.
   *
   * @deprecated
   * @var string
   */
  public $displayName;
  protected $environmentsType = GoogleCloudApigeeV1SecurityProfileEnvironment::class;
  protected $environmentsDataType = 'array';
  /**
   * Output only. Maximum security score that can be generated by this profile.
   *
   * @var int
   */
  public $maxScore;
  /**
   * Output only. Minimum security score that can be generated by this profile.
   *
   * @var int
   */
  public $minScore;
  /**
   * Immutable. Name of the security profile resource. Format:
   * organizations/{org}/securityProfiles/{profile}
   *
   * @var string
   */
  public $name;
  protected $profileConfigType = GoogleCloudApigeeV1ProfileConfig::class;
  protected $profileConfigDataType = '';
  /**
   * Output only. The time when revision was created.
   *
   * @var string
   */
  public $revisionCreateTime;
  /**
   * Output only. Revision ID of the security profile.
   *
   * @var string
   */
  public $revisionId;
  /**
   * Output only. DEPRECATED: DO NOT USE The time when revision was published.
   * Once published, the security profile revision cannot be updated further and
   * can be attached to environments.
   *
   * @deprecated
   * @var string
   */
  public $revisionPublishTime;
  /**
   * Output only. The time when revision was updated.
   *
   * @var string
   */
  public $revisionUpdateTime;
  protected $scoringConfigsType = GoogleCloudApigeeV1SecurityProfileScoringConfig::class;
  protected $scoringConfigsDataType = 'array';

  /**
   * Description of the security profile.
   *
   * @param string $description
   */
  public function setDescription($description)
  {
    $this->description = $description;
  }
  /**
   * @return string
   */
  public function getDescription()
  {
    return $this->description;
  }
  /**
   * DEPRECATED: DO NOT USE Display name of the security profile.
   *
   * @deprecated
   * @param string $displayName
   */
  public function setDisplayName($displayName)
  {
    $this->displayName = $displayName;
  }
  /**
   * @deprecated
   * @return string
   */
  public function getDisplayName()
  {
    return $this->displayName;
  }
  /**
   * List of environments attached to security profile.
   *
   * @param GoogleCloudApigeeV1SecurityProfileEnvironment[] $environments
   */
  public function setEnvironments($environments)
  {
    $this->environments = $environments;
  }
  /**
   * @return GoogleCloudApigeeV1SecurityProfileEnvironment[]
   */
  public function getEnvironments()
  {
    return $this->environments;
  }
  /**
   * Output only. Maximum security score that can be generated by this profile.
   *
   * @param int $maxScore
   */
  public function setMaxScore($maxScore)
  {
    $this->maxScore = $maxScore;
  }
  /**
   * @return int
   */
  public function getMaxScore()
  {
    return $this->maxScore;
  }
  /**
   * Output only. Minimum security score that can be generated by this profile.
   *
   * @param int $minScore
   */
  public function setMinScore($minScore)
  {
    $this->minScore = $minScore;
  }
  /**
   * @return int
   */
  public function getMinScore()
  {
    return $this->minScore;
  }
  /**
   * Immutable. Name of the security profile resource. Format:
   * organizations/{org}/securityProfiles/{profile}
   *
   * @param string $name
   */
  public function setName($name)
  {
    $this->name = $name;
  }
  /**
   * @return string
   */
  public function getName()
  {
    return $this->name;
  }
  /**
   * Required. Customized profile configuration that computes the security
   * score.
   *
   * @param GoogleCloudApigeeV1ProfileConfig $profileConfig
   */
  public function setProfileConfig(GoogleCloudApigeeV1ProfileConfig $profileConfig)
  {
    $this->profileConfig = $profileConfig;
  }
  /**
   * @return GoogleCloudApigeeV1ProfileConfig
   */
  public function getProfileConfig()
  {
    return $this->profileConfig;
  }
  /**
   * Output only. The time when revision was created.
   *
   * @param string $revisionCreateTime
   */
  public function setRevisionCreateTime($revisionCreateTime)
  {
    $this->revisionCreateTime = $revisionCreateTime;
  }
  /**
   * @return string
   */
  public function getRevisionCreateTime()
  {
    return $this->revisionCreateTime;
  }
  /**
   * Output only. Revision ID of the security profile.
   *
   * @param string $revisionId
   */
  public function setRevisionId($revisionId)
  {
    $this->revisionId = $revisionId;
  }
  /**
   * @return string
   */
  public function getRevisionId()
  {
    return $this->revisionId;
  }
  /**
   * Output only. DEPRECATED: DO NOT USE The time when revision was published.
   * Once published, the security profile revision cannot be updated further and
   * can be attached to environments.
   *
   * @deprecated
   * @param string $revisionPublishTime
   */
  public function setRevisionPublishTime($revisionPublishTime)
  {
    $this->revisionPublishTime = $revisionPublishTime;
  }
  /**
   * @deprecated
   * @return string
   */
  public function getRevisionPublishTime()
  {
    return $this->revisionPublishTime;
  }
  /**
   * Output only. The time when revision was updated.
   *
   * @param string $revisionUpdateTime
   */
  public function setRevisionUpdateTime($revisionUpdateTime)
  {
    $this->revisionUpdateTime = $revisionUpdateTime;
  }
  /**
   * @return string
   */
  public function getRevisionUpdateTime()
  {
    return $this->revisionUpdateTime;
  }
  /**
   * List of profile scoring configs in this revision.
   *
   * @param GoogleCloudApigeeV1SecurityProfileScoringConfig[] $scoringConfigs
   */
  public function setScoringConfigs($scoringConfigs)
  {
    $this->scoringConfigs = $scoringConfigs;
  }
  /**
   * @return GoogleCloudApigeeV1SecurityProfileScoringConfig[]
   */
  public function getScoringConfigs()
  {
    return $this->scoringConfigs;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoogleCloudApigeeV1SecurityProfile::class, 'Google_Service_Apigee_GoogleCloudApigeeV1SecurityProfile');
