<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Analytics;

class AccountRef extends \Google\Model
{
  /**
   * Link for this account.
   *
   * @var string
   */
  public $href;
  /**
   * Account ID.
   *
   * @var string
   */
  public $id;
  /**
   * Analytics account reference.
   *
   * @var string
   */
  public $kind;
  /**
   * Account name.
   *
   * @var string
   */
  public $name;

  /**
   * Link for this account.
   *
   * @param string $href
   */
  public function setHref($href)
  {
    $this->href = $href;
  }
  /**
   * @return string
   */
  public function getHref()
  {
    return $this->href;
  }
  /**
   * Account ID.
   *
   * @param string $id
   */
  public function setId($id)
  {
    $this->id = $id;
  }
  /**
   * @return string
   */
  public function getId()
  {
    return $this->id;
  }
  /**
   * Analytics account reference.
   *
   * @param string $kind
   */
  public function setKind($kind)
  {
    $this->kind = $kind;
  }
  /**
   * @return string
   */
  public function getKind()
  {
    return $this->kind;
  }
  /**
   * Account name.
   *
   * @param string $name
   */
  public function setName($name)
  {
    $this->name = $name;
  }
  /**
   * @return string
   */
  public function getName()
  {
    return $this->name;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(AccountRef::class, 'Google_Service_Analytics_AccountRef');
