<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\AccessContextManager;

class AccessLevel extends \Google\Model
{
  protected $basicType = BasicLevel::class;
  protected $basicDataType = '';
  protected $customType = CustomLevel::class;
  protected $customDataType = '';
  /**
   * Description of the `AccessLevel` and its use. Does not affect behavior.
   *
   * @var string
   */
  public $description;
  /**
   * Identifier. Resource name for the `AccessLevel`. Format:
   * `accessPolicies/{access_policy}/accessLevels/{access_level}`. The
   * `access_level` component must begin with a letter, followed by alphanumeric
   * characters or `_`. Its maximum length is 50 characters. After you create an
   * `AccessLevel`, you cannot change its `name`.
   *
   * @var string
   */
  public $name;
  /**
   * Human readable title. Must be unique within the Policy.
   *
   * @var string
   */
  public $title;

  /**
   * A `BasicLevel` composed of `Conditions`.
   *
   * @param BasicLevel $basic
   */
  public function setBasic(BasicLevel $basic)
  {
    $this->basic = $basic;
  }
  /**
   * @return BasicLevel
   */
  public function getBasic()
  {
    return $this->basic;
  }
  /**
   * A `CustomLevel` written in the Common Expression Language.
   *
   * @param CustomLevel $custom
   */
  public function setCustom(CustomLevel $custom)
  {
    $this->custom = $custom;
  }
  /**
   * @return CustomLevel
   */
  public function getCustom()
  {
    return $this->custom;
  }
  /**
   * Description of the `AccessLevel` and its use. Does not affect behavior.
   *
   * @param string $description
   */
  public function setDescription($description)
  {
    $this->description = $description;
  }
  /**
   * @return string
   */
  public function getDescription()
  {
    return $this->description;
  }
  /**
   * Identifier. Resource name for the `AccessLevel`. Format:
   * `accessPolicies/{access_policy}/accessLevels/{access_level}`. The
   * `access_level` component must begin with a letter, followed by alphanumeric
   * characters or `_`. Its maximum length is 50 characters. After you create an
   * `AccessLevel`, you cannot change its `name`.
   *
   * @param string $name
   */
  public function setName($name)
  {
    $this->name = $name;
  }
  /**
   * @return string
   */
  public function getName()
  {
    return $this->name;
  }
  /**
   * Human readable title. Must be unique within the Policy.
   *
   * @param string $title
   */
  public function setTitle($title)
  {
    $this->title = $title;
  }
  /**
   * @return string
   */
  public function getTitle()
  {
    return $this->title;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(AccessLevel::class, 'Google_Service_AccessContextManager_AccessLevel');
