<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\DiscoveryEngine;

class GoogleCloudDiscoveryengineV1StreamAssistResponse extends \Google\Model
{
  protected $answerType = GoogleCloudDiscoveryengineV1AssistAnswer::class;
  protected $answerDataType = '';
  /**
   * @var string
   */
  public $assistToken;
  protected $sessionInfoType = GoogleCloudDiscoveryengineV1StreamAssistResponseSessionInfo::class;
  protected $sessionInfoDataType = '';

  /**
   * @param GoogleCloudDiscoveryengineV1AssistAnswer
   */
  public function setAnswer(GoogleCloudDiscoveryengineV1AssistAnswer $answer)
  {
    $this->answer = $answer;
  }
  /**
   * @return GoogleCloudDiscoveryengineV1AssistAnswer
   */
  public function getAnswer()
  {
    return $this->answer;
  }
  /**
   * @param string
   */
  public function setAssistToken($assistToken)
  {
    $this->assistToken = $assistToken;
  }
  /**
   * @return string
   */
  public function getAssistToken()
  {
    return $this->assistToken;
  }
  /**
   * @param GoogleCloudDiscoveryengineV1StreamAssistResponseSessionInfo
   */
  public function setSessionInfo(GoogleCloudDiscoveryengineV1StreamAssistResponseSessionInfo $sessionInfo)
  {
    $this->sessionInfo = $sessionInfo;
  }
  /**
   * @return GoogleCloudDiscoveryengineV1StreamAssistResponseSessionInfo
   */
  public function getSessionInfo()
  {
    return $this->sessionInfo;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoogleCloudDiscoveryengineV1StreamAssistResponse::class, 'Google_Service_DiscoveryEngine_GoogleCloudDiscoveryengineV1StreamAssistResponse');
