<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\AppHub;

class WorkloadProperties extends \Google\Model
{
  protected $functionalTypeType = FunctionalType::class;
  protected $functionalTypeDataType = '';
  /**
   * @var string
   */
  public $gcpProject;
  /**
   * @var string
   */
  public $location;
  /**
   * @var string
   */
  public $zone;

  /**
   * @param FunctionalType
   */
  public function setFunctionalType(FunctionalType $functionalType)
  {
    $this->functionalType = $functionalType;
  }
  /**
   * @return FunctionalType
   */
  public function getFunctionalType()
  {
    return $this->functionalType;
  }
  /**
   * @param string
   */
  public function setGcpProject($gcpProject)
  {
    $this->gcpProject = $gcpProject;
  }
  /**
   * @return string
   */
  public function getGcpProject()
  {
    return $this->gcpProject;
  }
  /**
   * @param string
   */
  public function setLocation($location)
  {
    $this->location = $location;
  }
  /**
   * @return string
   */
  public function getLocation()
  {
    return $this->location;
  }
  /**
   * @param string
   */
  public function setZone($zone)
  {
    $this->zone = $zone;
  }
  /**
   * @return string
   */
  public function getZone()
  {
    return $this->zone;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(WorkloadProperties::class, 'Google_Service_AppHub_WorkloadProperties');
