<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\CloudIdentity;

class GoogleAppsCloudidentityDevicesV1ApproveDeviceUserResponse extends \Google\Model
{
  /**
   * @var GoogleAppsCloudidentityDevicesV1DeviceUser
   */
  public $deviceUser;
  protected $deviceUserType = GoogleAppsCloudidentityDevicesV1DeviceUser::class;
  protected $deviceUserDataType = '';

  /**
   * @param GoogleAppsCloudidentityDevicesV1DeviceUser
   */
  public function setDeviceUser(GoogleAppsCloudidentityDevicesV1DeviceUser $deviceUser)
  {
    $this->deviceUser = $deviceUser;
  }
  /**
   * @return GoogleAppsCloudidentityDevicesV1DeviceUser
   */
  public function getDeviceUser()
  {
    return $this->deviceUser;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoogleAppsCloudidentityDevicesV1ApproveDeviceUserResponse::class, 'Google_Service_CloudIdentity_GoogleAppsCloudidentityDevicesV1ApproveDeviceUserResponse');
