<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\AndroidPublisher;

class UpdateBasePlanStateRequest extends \Google\Model
{
  /**
   * @var ActivateBasePlanRequest
   */
  public $activateBasePlanRequest;
  protected $activateBasePlanRequestType = ActivateBasePlanRequest::class;
  protected $activateBasePlanRequestDataType = '';
  /**
   * @var DeactivateBasePlanRequest
   */
  public $deactivateBasePlanRequest;
  protected $deactivateBasePlanRequestType = DeactivateBasePlanRequest::class;
  protected $deactivateBasePlanRequestDataType = '';

  /**
   * @param ActivateBasePlanRequest
   */
  public function setActivateBasePlanRequest(ActivateBasePlanRequest $activateBasePlanRequest)
  {
    $this->activateBasePlanRequest = $activateBasePlanRequest;
  }
  /**
   * @return ActivateBasePlanRequest
   */
  public function getActivateBasePlanRequest()
  {
    return $this->activateBasePlanRequest;
  }
  /**
   * @param DeactivateBasePlanRequest
   */
  public function setDeactivateBasePlanRequest(DeactivateBasePlanRequest $deactivateBasePlanRequest)
  {
    $this->deactivateBasePlanRequest = $deactivateBasePlanRequest;
  }
  /**
   * @return DeactivateBasePlanRequest
   */
  public function getDeactivateBasePlanRequest()
  {
    return $this->deactivateBasePlanRequest;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(UpdateBasePlanStateRequest::class, 'Google_Service_AndroidPublisher_UpdateBasePlanStateRequest');
