<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Vault;

class Matter extends \Google\Collection
{
  /**
   * The region is unspecified. Defaults to ANY.
   */
  public const MATTER_REGION_MATTER_REGION_UNSPECIFIED = 'MATTER_REGION_UNSPECIFIED';
  /**
   * Any region.
   */
  public const MATTER_REGION_ANY = 'ANY';
  /**
   * United States region.
   */
  public const MATTER_REGION_US = 'US';
  /**
   * Europe region.
   */
  public const MATTER_REGION_EUROPE = 'EUROPE';
  /**
   * The matter has no specified state.
   */
  public const STATE_STATE_UNSPECIFIED = 'STATE_UNSPECIFIED';
  /**
   * The matter is open.
   */
  public const STATE_OPEN = 'OPEN';
  /**
   * The matter is closed.
   */
  public const STATE_CLOSED = 'CLOSED';
  /**
   * The matter is deleted.
   */
  public const STATE_DELETED = 'DELETED';
  protected $collection_key = 'matterPermissions';
  /**
   * An optional description for the matter.
   *
   * @var string
   */
  public $description;
  /**
   * The matter ID, which is generated by the server. Leave blank when creating
   * a matter.
   *
   * @var string
   */
  public $matterId;
  protected $matterPermissionsType = MatterPermission::class;
  protected $matterPermissionsDataType = 'array';
  /**
   * Optional. The requested data region for the matter.
   *
   * @var string
   */
  public $matterRegion;
  /**
   * The name of the matter.
   *
   * @var string
   */
  public $name;
  /**
   * The state of the matter.
   *
   * @var string
   */
  public $state;

  /**
   * An optional description for the matter.
   *
   * @param string $description
   */
  public function setDescription($description)
  {
    $this->description = $description;
  }
  /**
   * @return string
   */
  public function getDescription()
  {
    return $this->description;
  }
  /**
   * The matter ID, which is generated by the server. Leave blank when creating
   * a matter.
   *
   * @param string $matterId
   */
  public function setMatterId($matterId)
  {
    $this->matterId = $matterId;
  }
  /**
   * @return string
   */
  public function getMatterId()
  {
    return $this->matterId;
  }
  /**
   * Lists the users and their permission for the matter. Currently there is no
   * programmer defined limit on the number of permissions a matter can have.
   *
   * @param MatterPermission[] $matterPermissions
   */
  public function setMatterPermissions($matterPermissions)
  {
    $this->matterPermissions = $matterPermissions;
  }
  /**
   * @return MatterPermission[]
   */
  public function getMatterPermissions()
  {
    return $this->matterPermissions;
  }
  /**
   * Optional. The requested data region for the matter.
   *
   * Accepted values: MATTER_REGION_UNSPECIFIED, ANY, US, EUROPE
   *
   * @param self::MATTER_REGION_* $matterRegion
   */
  public function setMatterRegion($matterRegion)
  {
    $this->matterRegion = $matterRegion;
  }
  /**
   * @return self::MATTER_REGION_*
   */
  public function getMatterRegion()
  {
    return $this->matterRegion;
  }
  /**
   * The name of the matter.
   *
   * @param string $name
   */
  public function setName($name)
  {
    $this->name = $name;
  }
  /**
   * @return string
   */
  public function getName()
  {
    return $this->name;
  }
  /**
   * The state of the matter.
   *
   * Accepted values: STATE_UNSPECIFIED, OPEN, CLOSED, DELETED
   *
   * @param self::STATE_* $state
   */
  public function setState($state)
  {
    $this->state = $state;
  }
  /**
   * @return self::STATE_*
   */
  public function getState()
  {
    return $this->state;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(Matter::class, 'Google_Service_Vault_Matter');
