<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\FirebaseAppDistribution;

class GoogleFirebaseAppdistroV1BatchJoinGroupRequest extends \Google\Collection
{
  protected $collection_key = 'emails';
  /**
   * @var bool
   */
  public $createMissingTesters;
  /**
   * @var string[]
   */
  public $emails;

  /**
   * @param bool
   */
  public function setCreateMissingTesters($createMissingTesters)
  {
    $this->createMissingTesters = $createMissingTesters;
  }
  /**
   * @return bool
   */
  public function getCreateMissingTesters()
  {
    return $this->createMissingTesters;
  }
  /**
   * @param string[]
   */
  public function setEmails($emails)
  {
    $this->emails = $emails;
  }
  /**
   * @return string[]
   */
  public function getEmails()
  {
    return $this->emails;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoogleFirebaseAppdistroV1BatchJoinGroupRequest::class, 'Google_Service_FirebaseAppDistribution_GoogleFirebaseAppdistroV1BatchJoinGroupRequest');
