<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\AndroidPublisher;

class TargetingUpdate extends \Google\Model
{
  /**
   * @var AllUsers
   */
  public $allUsers;
  protected $allUsersType = AllUsers::class;
  protected $allUsersDataType = '';
  /**
   * @var AndroidSdks
   */
  public $androidSdks;
  protected $androidSdksType = AndroidSdks::class;
  protected $androidSdksDataType = '';
  /**
   * @var Regions
   */
  public $regions;
  protected $regionsType = Regions::class;
  protected $regionsDataType = '';

  /**
   * @param AllUsers
   */
  public function setAllUsers(AllUsers $allUsers)
  {
    $this->allUsers = $allUsers;
  }
  /**
   * @return AllUsers
   */
  public function getAllUsers()
  {
    return $this->allUsers;
  }
  /**
   * @param AndroidSdks
   */
  public function setAndroidSdks(AndroidSdks $androidSdks)
  {
    $this->androidSdks = $androidSdks;
  }
  /**
   * @return AndroidSdks
   */
  public function getAndroidSdks()
  {
    return $this->androidSdks;
  }
  /**
   * @param Regions
   */
  public function setRegions(Regions $regions)
  {
    $this->regions = $regions;
  }
  /**
   * @return Regions
   */
  public function getRegions()
  {
    return $this->regions;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(TargetingUpdate::class, 'Google_Service_AndroidPublisher_TargetingUpdate');
