CHANGELOG for PHP CS Fixer
==========================

This file contains changelogs for stable releases only.

Changelog for v2.7.3
--------------------

* bug #3114 SelfAccessorFixer - Fix type declarations replacement (julienfalque)

Changelog for v2.7.2
--------------------

* bug #3062 BraceClassInstantiationTransformer - Fix instantiation inside method call braces case (julienfalque, keradus)
* bug #3083 SingleBlankLineBeforeNamespaceFixer - Fix handling namespace right after opening tag (mlocati)
* bug #3109 SwitchCaseSemicolonToColonFixer - Fix bug with nested constructs (SpacePossum)
* bug #3117 Multibyte character in array key makes alignment incorect (kubawerlos)
* bug #3123 Cache - File permissions (SpacePossum)
* bug #3138 NoHomoglyphNamesFixer - fix crash on non-ascii but not mapped either (SpacePossum)
* bug #3172 IndentationTypeFixer - do not touch whitespace that is not indentation (SpacePossum)
* bug #3176 NoMultilineWhitespaceBeforeSemicolonsFixer - SpaceAfterSemicolonFixer - priority fix (SpacePossum)
* bug #3193 TokensAnalyzer::getClassyElements - sort result before returning (SpacePossum)
* bug #3196 SelfUpdateCommand - fix exit status when can't determine newest version (julienfalque)
* minor #3107 ConfigurationResolver - improve error message when rule is not found (SpacePossum)
* minor #3113 Add WordMatcher (keradus)
* minor #3128 README: remove deprecated rule from CLI examples (chteuchteu)
* minor #3133 Unify Reporter tests (keradus)
* minor #3134 Allow Symfony 4 (keradus, garak)
* minor #3136 PHPUnit - call hooks from parent class as well (keradus)
* minor #3141 Unify description of deprecated fixer (kubawerlos)
* minor #3144 PhpUnitDedicateAssertFixer - Sort map and array by function name (localheinz)
* minor #3145 misc - Typo (localheinz)
* minor #3150 Fix CircleCI (julienfalque)
* minor #3151 Update gitattributes to ignore next file (keradus)
* minor #3156 Update php-coveralls (keradus)
* minor #3166 README - add link to new gitter channel. (SpacePossum)
* minor #3174 Update UPGRADE.md (vitek-rostislav)
* minor #3180 Fix usage of static variables (kubawerlos)
* minor #3182 Add support for PHPUnit 6, drop PHPUnit 4 (keradus)
* minor #3184 Code grooming - sort content of arrays (keradus)
* minor #3191 Travis - add nightly build to allow_failures due to Travis issues (keradus)
* minor #3197 DX groom CS (keradus)

Changelog for v2.7.1
--------------------

* bug #3115 NoUnneededFinalMethodFixer - fix edge case (Slamdunk)

Changelog for v2.7.0
--------------------

* feature #2573 BinaryOperatorSpaces reworked (SpacePossum, keradus)
* feature #3073 SpaceAfterSemicolonFixer - Add option to remove space in empty for expressions (julienfalque)
* feature #3089 NoAliasFunctionsFixer - add imap aliases (Slamdunk)
* feature #3093 NoUnneededFinalMethodFixer - Remove final keyword from private methods (localheinz, keradus)
* minor #3068 Symfony:risky ruleset - add no_homoglyph_names (keradus)
* minor #3074 [IO] Replace Diff with fork version (SpacePossum)

Changelog for v2.6.1
--------------------

* bug #3052 Fix false positive warning about paths overridden by provided as command arguments (kubawerlos)
* bug #3053 CombineConsecutiveIssetsFixer - fix priority (SpacePossum)
* bug #3058 IsNullFixer - fix whitespace handling (roukmoute)
* bug #3069 MethodArgumentSpaceFixer - new test case (keradus)
* bug #3072 IsNullFixer - fix non_yoda_style edge case (keradus)
* bug #3088 Drop dedicated Phar stub (keradus)
* bug #3100 NativeFunctionInvocationFixer - Fix test if previous token is already namespace separator (SpacePossum)
* bug #3104 DoctrineAnnotationIndentationFixer - Fix str_repeat() error (julienfalque)
* minor #3038 Support PHP 7.2 (SpacePossum, keradus)
* minor #3064 Fix couple of typos (KKSzymanowski)
* minor #3070 YodaStyleFixer - Clarify configuration parameters (SteveJobzniak)
* minor #3078 ConfigurationResolver - hide context while including config file (keradus)
* minor #3080 Direct function call instead of by string (kubawerlos)
* minor #3085 CiIntegrationTest - skip when no git is available (keradus)
* minor #3087 phar-stub.php - allow PHP 7.2 (keradus)
* minor #3092 .travis.yml - fix matrix for PHP 7.1 (keradus)
* minor #3094 NoUnneededFinalMethodFixer - Add test cases (julienfalque)
* minor #3111 DoctrineAnnotationIndentationFixer - Restore test case (julienfalque)

Changelog for v2.6.0
--------------------

* bug #3039 YodaStyleFixer - Fix echo case (SpacePossum, keradus)
* feature #2446 Add YodaStyleFixer (SpacePossum)
* feature #2940 Add NoHomoglyphNamesFixer (mcfedr, keradus)
* feature #3012 Add CombineConsecutiveIssetsFixer (SpacePossum)
* minor #3037 Update SF rule set (SpacePossum)

Changelog for v2.5.1
--------------------

* bug #3002 Bugfix braces (mnabialek)
* bug #3010 Fix handling of Github releases (julienfalque, keradus)
* bug #3015 Fix exception arguments (julienfalque)
* bug #3016 Verify phar file (keradus)
* bug #3021 Risky rules cleanup (kubawerlos)
* bug #3023 RandomApiMigrationFixer - "rand();" to "random_int(0, getrandmax());" fixing (SpacePossum)
* bug #3024 ConfigurationResolver - Handle empty "rules" value (SpacePossum, keradus)
* bug #3031 IndentationTypeFixer - fix handling tabs in indented comments (keradus)
* minor #2999 Notice when paths from config file are overridden by command arguments (julienfalque, keradus)
* minor #3007 Add PHP 7.2 to Travis build matrix (Jean85)
* minor #3009 CiIntegrationTest - run local (SpacePossum)
* minor #3013 Adjust phpunit configuration (localheinz)
* minor #3017 Fix: Risky tests (localheinz)
* minor #3018 Fix: Make sure that data providers are named correctly (localheinz, keradus)
* minor #3032 .php_cs.dist - handling UnexpectedValueException (keradus)
* minor #3033 Use ::class (keradus)
* minor #3034 Follow newest CS (keradus)
* minor #3036 Drop not existing Standalone group from PHPUnit configuration and duplicated internal tags (keradus)
* minor #3042 Update gitter address (keradus)

Changelog for v2.5.0
--------------------

* feature #2770 DoctrineAnnotationSpaces - split assignments options (julienfalque)
* feature #2843 Add estimating-max progress output type (julienfalque)
* feature #2885 Add NoSuperfluousElseifFixer (julienfalque)
* feature #2929 Add NoUnneededCurlyBracesFixer (SpacePossum)
* feature #2944 FunctionToConstantFixer - handle get_class() -> __CLASS__ as well (SpacePossum)
* feature #2953 BlankLineBeforeStatementFixer - Add more statements (localheinz, keradus)
* feature #2972 Add NoUnneededFinalMethodFixer (Slamdunk, keradus)
* feature #2992 Add Doctrine Annotation ruleset (julienfalque)
* minor #2926 Token::getNameForId (SpacePossum)

Changelog for v2.4.2
--------------------

* bug #3002 Bugfix braces (mnabialek)
* bug #3010 Fix handling of Github releases (julienfalque, keradus)
* bug #3015 Fix exception arguments (julienfalque)
* bug #3016 Verify phar file (keradus)
* bug #3021 Risky rules cleanup (kubawerlos)
* bug #3023 RandomApiMigrationFixer - "rand();" to "random_int(0, getrandmax());" fixing (SpacePossum)
* bug #3024 ConfigurationResolver - Handle empty "rules" value (SpacePossum, keradus)
* bug #3031 IndentationTypeFixer - fix handling tabs in indented comments (keradus)
* minor #2999 Notice when paths from config file are overridden by command arguments (julienfalque, keradus)
* minor #3007 Add PHP 7.2 to Travis build matrix (Jean85)
* minor #3009 CiIntegrationTest - run local (SpacePossum)
* minor #3013 Adjust phpunit configuration (localheinz)
* minor #3017 Fix: Risky tests (localheinz)
* minor #3018 Fix: Make sure that data providers are named correctly (localheinz, keradus)
* minor #3032 .php_cs.dist - handling UnexpectedValueException (keradus)
* minor #3033 Use ::class (keradus)
* minor #3034 Follow newest CS (keradus)
* minor #3036 Drop not existing Standalone group from PHPUnit configuration and duplicated internal tags (keradus)
* minor #3042 Update gitter address (keradus)

Changelog for v2.4.1
--------------------

* bug #2925 Improve CI integration suggestion (julienfalque)
* bug #2928 TokensAnalyzer::getClassyElements - Anonymous class support (SpacePossum)
* bug #2931 Psr0Fixer, Psr4Fixer - ignore "new class" syntax (dg, keradus)
* bug #2934 Config - fix handling rule without value (keradus, SpacePossum)
* bug #2939 NoUnusedImportsFixer - Fix extra blank line (julienfalque)
* bug #2941 PHP 7.2 - Group imports with trailing comma support (SpacePossum, julienfalque)
* bug #2954 NoBreakCommentFixer - Disable case sensitivity (julienfalque)
* bug #2959 MethodArgumentSpaceFixer - Skip body of fixed function (greg0ire)
* bug #2984 AlignMultilineCommentFixer - handle uni code (SpacePossum)
* bug #2987 Fix incorrect indentation of comments in `braces` fixer (rob006)
* minor #2924 Add missing Token deprecations (julienfalque)
* minor #2927 WhiteSpaceConfig - update message copy and more strict tests (SpacePossum, keradus)
* minor #2930 Trigger website build (keradus)
* minor #2932 Integrate CircleCI (keradus, aidantwoods)
* minor #2933 ProcessLinterTest - Ensure Windows test only runs on Windows, add a Mac test execution (aidantwoods)
* minor #2935 special handling of fabbot.io service if it's using too old PHP CS Fixer version (keradus)
* minor #2937 Travis: execute 5.3 job on precise (keradus)
* minor #2938 Tests fix configuration of project (SpacePossum, keradus)
* minor #2943 FunctionToConstantFixer - test with diff. arguments than fixable (SpacePossum)
* minor #2945 BlankLineBeforeStatementFixerTest - Fix covered class (julienfalque)
* minor #2946 Detect extra old installations (keradus)
* minor #2947 Test suggested CI integration (keradus)
* minor #2951 AccessibleObject - remove most of usage (keradus)
* minor #2952 BlankLineBeforeStatementFixer - Reference fixer instead of test class (localheinz)
* minor #2955 Travis - stop using old TASK_SCA residue (keradus)
* minor #2968 AssertTokensTrait - don't use AccessibleObject (keradus)
* minor #2969 Shrink down AccessibleObject usage (keradus)
* minor #2982 TrailingCommaInMultilineArrayFixer - simplify isMultilineArray condition (TomasVotruba)
* minor #2989 CiIntegrationTest - fix min supported PHP versions (keradus)

Changelog for v2.4.0
--------------------

* bug #2880 NoBreakCommentFixer - fix edge case (julienfalque)
* bug #2900 VoidReturnFixer - handle functions containing anonymous functions/classes (bendavies, keradus)
* bug #2902 Fix test classes constructor (julienfalque)
* feature #2384 Add BlankLineBeforeStatementFixer (localheinz, keradus, SpacePossum)
* feature #2440 MethodArgumentSpaceFixer - add ensure_fully_multiline option (greg0ire)
* feature #2649 PhpdocAlignFixer - make fixer configurable (ntzm)
* feature #2664 Add DoctrineAnnotationArrayAssignmentFixer (julienfalque)
* feature #2667 Add NoBreakCommentFixer (julienfalque)
* feature #2684 BracesFixer - new options for braces position after control structures and anonymous constructs (aidantwoods, keradus)
* feature #2701 NoExtraConsecutiveBlankLinesFixer - Add more configuration options related to switch statements (SpacePossum)
* feature #2740 Add VoidReturnFixer (mrmark)
* feature #2765 DoctrineAnnotationIndentationFixer - add option to indent mixed lines (julienfalque)
* feature #2815 NonPrintableCharacterFixer - Add option to replace with escape sequences (julienfalque, keradus)
* feature #2822 Add NoNullPropertyInitializationFixer (ntzm, julienfalque, SpacePossum)
* feature #2825 Add PhpdocTypesOrderFixer (julienfalque, keradus)
* feature #2856 CastSpacesFixer - add space option (kubawerlos, keradus)
* feature #2857 Add AlignMultilineCommentFixer (Slamdunk, keradus)
* feature #2866 Add SingleLineCommentStyleFixer, deprecate HashToSlashCommentFixer (Slamdunk, keradus)
* minor #2773 Travis - use stages (keradus)
* minor #2794 Drop HHVM support (keradus, julienfalque)
* minor #2801 ProjectCodeTest - Fix typo in deprecation message (SpacePossum)
* minor #2818 Token become immutable, performance optimizations (keradus)
* minor #2877 Fix PHPMD report (julienfalque)
* minor #2894 NonPrintableCharacterFixer - fix handling required PHP version on PHPUnit 4.x (keradus)
* minor #2921 InvalidForEnvFixerConfigurationException - fix handling in tests on 2.4 line (keradus)

Changelog for v2.3.3
--------------------

* bug #2807 NoUselessElseFixer - Fix detection of conditional block (SpacePossum)
* bug #2809 Phar release - fix readme generation (SpacePossum, keradus)
* bug #2827 MethodArgumentSpaceFixer - Always remove trailing spaces (julienfalque)
* bug #2835 SelfAcessorFixer - class property fix (mnabialek)
* bug #2848 PhpdocIndentFixer - fix edge case with inline phpdoc (keradus)
* bug #2849 BracesFixer - Fix indentation issues with comments (julienfalque)
* bug #2851 Tokens - ensureWhitespaceAtIndex (GrahamCampbell, SpacePossum)
* bug #2854 NoLeadingImportSlashFixer - Removing leading slash from import even when in global space (kubawerlos)
* bug #2858 Support generic types (keradus)
* bug #2869 Fix handling required configuration (keradus)
* bug #2881 NoUnusedImportsFixer - Bug when trying to insert empty token (GrahamCampbell, keradus)
* bug #2882 DocBlock\Annotation - Fix parsing of collections with multiple key types (julienfalque)
* bug #2886 NoSpacesInsideParenthesisFixer - Do not remove whitespace if next token is comment (SpacePossum)
* bug #2888 SingleImportPerStatementFixer - Add support for function and const (SpacePossum)
* bug #2901 Add missing files to archive files (keradus)
* bug #2914 HeredocToNowdocFixer - works with CRLF line ending (dg)
* bug #2920 RuleSet - Update deprecated configuration of fixers (SpacePossum, keradus)
* minor #1531 Update docs for few generic types (keradus)
* minor #2793 COOKBOOK-FIXERS.md - update to current version, fix links (keradus)
* minor #2812 ProcessLinter - compatibility with Symfony 3.3 (keradus)
* minor #2816 Tokenizer - better docs and validation (keradus)
* minor #2817 Tokenizer - use future-compatible interface (keradus)
* minor #2819 Fix benchmark (keradus)
* minor #2820 MagicConstantCasingFixer - Remove defined check (SpacePossum)
* minor #2823 Tokenizer - use future-compatible interface (keradus)
* minor #2824 code grooming (keradus)
* minor #2826 Exceptions - provide utests (localheinz)
* minor #2828 Enhancement: Reference phpunit.xsd from phpunit.xml.dist (localheinz)
* minor #2830 Differs - add tests (localheinz)
* minor #2832 Fix: Use all the columns (localheinz)
* minor #2833 Doctrine\Annotation\Token - provide utests (localheinz)
* minor #2839 Use PHP 7.2 polyfill instead of xml one (keradus)
* minor #2842 Move null to first position in PHPDoc types (julienfalque)
* minor #2850 ReadmeCommandTest - Prevent diff output (julienfalque)
* minor #2859 Fixed typo and dead code removal (GrahamCampbell)
* minor #2863 FileSpecificCodeSample - add tests (localheinz)
* minor #2864 WhitespacesAwareFixerInterface clean up (Slamdunk)
* minor #2865 AutoReview\FixerTest - test configuration samples (SpacePossum, keradus)
* minor #2867 VersionSpecification - Fix copy-paste typo (SpacePossum)
* minor #2870 Tokens - ensureWhitespaceAtIndex - Clear tokens before compare. (SpacePossum)
* minor #2874 LineTest - fix typo (keradus)
* minor #2875 HelpCommand - recursive layout fix (SpacePossum)
* minor #2883 DescribeCommand - Show which sample uses the default configuration  (SpacePossum)
* minor #2887 Housekeeping - Strict whitespace checks (SpacePossum)
* minor #2895 ProjectCodeTest - check that classes in no-tests exception exist (keradus)
* minor #2896 Move testing related classes from src to tests (keradus)
* minor #2904 Reapply CS (keradus)
* minor #2910 PhpdocAnnotationWithoutDotFixer - Restrict lowercasing (oschwald)
* minor #2913 Tests - tweaks (SpacePossum, keradus)
* minor #2916 FixerFactory - drop return in sortFixers(), never used (TomasVotruba)

Changelog for v2.3.2
--------------------

* bug #2682 DoctrineAnnotationIndentationFixer - fix handling nested annotations (edhgoose, julienfalque)
* bug #2700 Fix Doctrine Annotation end detection (julienfalque)
* bug #2715 OrderedImportsFixer - handle indented groups (pilgerone)
* bug #2732 HeaderCommentFixer - fix handling blank lines (s7b4)
* bug #2745 Fix Doctrine Annotation newlines (julienfalque)
* bug #2752 FixCommand - fix typo in warning message (mnapoli)
* bug #2757 GeckoPHPUnit is not dev dependency (keradus)
* bug #2759 Update gitattributes (SpacePossum)
* bug #2763 Fix describe command with PSR-0 fixer (julienfalque)
* bug #2768 Tokens::ensureWhitespaceAtIndex - clean up comment check, add check for T_OPEN (SpacePossum)
* bug #2783 Tokens::ensureWhitespaceAtIndex - Fix handling line endings (SpacePossum)
* minor #2304 DX: use PHPMD (keradus)
* minor #2663 Use colors for keywords in commands output (julienfalque, keradus)
* minor #2706 Update README (SpacePossum)
* minor #2714 README.rst - fix wrong value in example (mleko)
* minor #2718 Remove old Symfony exception message expectation (julienfalque)
* minor #2721 Update phpstorm article link to a fresh blog post (valeryan)
* minor #2725 Use method chaining for configuration definitions (julienfalque)
* minor #2727 PHPUnit - use speedtrap (keradus)
* minor #2728 SelfUpdateCommand - verify that it's possible to replace current file (keradus)
* minor #2729 DescribeCommand - add decorated output test (julienfalque)
* minor #2731 BracesFixer - properly pass config in utest dataProvider (keradus)
* minor #2738 Upgrade tests to use new, namespaced PHPUnit TestCase class (keradus)
* minor #2742 Code cleanup (GrahamCampbell, keradus)
* minor #2743 Fixing example and description for GeneralPhpdocAnnotationRemoveFixer (kubawerlos)
* minor #2744 AbstractDoctrineAnnotationFixerTestCase - split fixers test cases (julienfalque)
* minor #2755 Fix compatibility with PHPUnit 5.4.x (keradus)
* minor #2758 Readme - improve CI integration guidelines (keradus)
* minor #2769 Psr0Fixer - remove duplicated example (julienfalque)
* minor #2774 AssertTokens Trait (keradus)
* minor #2775 NoExtraConsecutiveBlankLinesFixer - remove duplicate code sample. (SpacePossum)
* minor #2778 AutoReview - watch that code samples are unique (keradus)
* minor #2787 Add warnings about missing dom ext and require json ext (keradus)
* minor #2792 Use composer-require-checker (keradus)
* minor #2796 Update .gitattributes (SpacePossum)
* minor #2797 Update .gitattributes (SpacePossum)
* minor #2800 PhpdocTypesFixerTest - Fix typo in covers annotation (SpacePossum)

Changelog for v2.3.1
--------------------

Port of v2.2.3.

* bug #2724 Revert #2554 Add short diff. output format (keradus)

Changelog for v2.3.0
--------------------

* feature #2450 Add ListSyntaxFixer (SpacePossum)
* feature #2708 Add PhpUnitTestClassRequiresCoversFixer (keradus)
* minor #2568 Require PHP 5.6+ (keradus)
* minor #2672 Bump symfony/* deps (keradus)

Changelog for v2.2.9
--------------------

* bug #3062 BraceClassInstantiationTransformer - Fix instantiation inside method call braces case (julienfalque, keradus)
* bug #3083 SingleBlankLineBeforeNamespaceFixer - Fix handling namespace right after opening tag (mlocati)
* bug #3109 SwitchCaseSemicolonToColonFixer - Fix bug with nested constructs (SpacePossum)
* bug #3123 Cache - File permissions (SpacePossum)
* bug #3172 IndentationTypeFixer - do not touch whitespace that is not indentation (SpacePossum)
* bug #3176 NoMultilineWhitespaceBeforeSemicolonsFixer - SpaceAfterSemicolonFixer - priority fix (SpacePossum)
* bug #3193 TokensAnalyzer::getClassyElements - sort result before returning (SpacePossum)
* bug #3196 SelfUpdateCommand - fix exit status when can't determine newest version (julienfalque)
* minor #3107 ConfigurationResolver - improve error message when rule is not found (SpacePossum)
* minor #3113 Add WordMatcher (keradus)
* minor #3133 Unify Reporter tests (keradus)
* minor #3134 Allow Symfony 4 (keradus, garak)
* minor #3136 PHPUnit - call hooks from parent class as well (keradus)
* minor #3145 misc - Typo (localheinz)
* minor #3150 Fix CircleCI (julienfalque)
* minor #3151 Update gitattributes to ignore next file (keradus)
* minor #3156 Update php-coveralls (keradus)
* minor #3166 README - add link to new gitter channel. (SpacePossum)
* minor #3174 Update UPGRADE.md (vitek-rostislav)
* minor #3180 Fix usage of static variables (kubawerlos)
* minor #3184 Code grooming - sort content of arrays (keradus)
* minor #3191 Travis - add nightly build to allow_failures due to Travis issues (keradus)
* minor #3197 DX groom CS (keradus)

Changelog for v2.2.8
--------------------

* bug #3052 Fix false positive warning about paths overridden by provided as command arguments (kubawerlos)
* bug #3058 IsNullFixer - fix whitespace handling (roukmoute)
* bug #3072 IsNullFixer - fix non_yoda_style edge case (keradus)
* bug #3088 Drop dedicated Phar stub (keradus)
* bug #3100 NativeFunctionInvocationFixer - Fix test if previous token is already namespace separator (SpacePossum)
* bug #3104 DoctrineAnnotationIndentationFixer - Fix str_repeat() error (julienfalque)
* minor #3038 Support PHP 7.2 (SpacePossum, keradus)
* minor #3064 Fix couple of typos (KKSzymanowski)
* minor #3078 ConfigurationResolver - hide context while including config file (keradus)
* minor #3080 Direct function call instead of by string (kubawerlos)
* minor #3085 CiIntegrationTest - skip when no git is available (keradus)
* minor #3087 phar-stub.php - allow PHP 7.2 (keradus)

Changelog for v2.2.7
--------------------

* bug #3002 Bugfix braces (mnabialek)
* bug #3010 Fix handling of Github releases (julienfalque, keradus)
* bug #3015 Fix exception arguments (julienfalque)
* bug #3016 Verify phar file (keradus)
* bug #3021 Risky rules cleanup (kubawerlos)
* bug #3023 RandomApiMigrationFixer - "rand();" to "random_int(0, getrandmax());" fixing (SpacePossum)
* bug #3024 ConfigurationResolver - Handle empty "rules" value (SpacePossum, keradus)
* bug #3031 IndentationTypeFixer - fix handling tabs in indented comments (keradus)
* minor #2999 Notice when paths from config file are overridden by command arguments (julienfalque, keradus)
* minor #3007 Add PHP 7.2 to Travis build matrix (Jean85)
* minor #3009 CiIntegrationTest - run local (SpacePossum)
* minor #3013 Adjust phpunit configuration (localheinz)
* minor #3017 Fix: Risky tests (localheinz)
* minor #3018 Fix: Make sure that data providers are named correctly (localheinz, keradus)
* minor #3032 .php_cs.dist - handling UnexpectedValueException (keradus)
* minor #3034 Follow newest CS (keradus)
* minor #3036 Drop not existing Standalone group from PHPUnit configuration and duplicated internal tags (keradus)
* minor #3042 Update gitter address (keradus)

Changelog for v2.2.6
--------------------

* bug #2925 Improve CI integration suggestion (julienfalque)
* bug #2928 TokensAnalyzer::getClassyElements - Anonymous class support (SpacePossum)
* bug #2931 Psr0Fixer, Psr4Fixer - ignore "new class" syntax (dg, keradus)
* bug #2934 Config - fix handling rule without value (keradus, SpacePossum)
* bug #2939 NoUnusedImportsFixer - Fix extra blank line (julienfalque)
* bug #2941 PHP 7.2 - Group imports with trailing comma support (SpacePossum, julienfalque)
* bug #2987 Fix incorrect indentation of comments in `braces` fixer (rob006)
* minor #2927 WhiteSpaceConfig - update message copy and more strict tests (SpacePossum, keradus)
* minor #2930 Trigger website build (keradus)
* minor #2932 Integrate CircleCI (keradus, aidantwoods)
* minor #2933 ProcessLinterTest - Ensure Windows test only runs on Windows, add a Mac test execution (aidantwoods)
* minor #2935 special handling of fabbot.io service if it's using too old PHP CS Fixer version (keradus)
* minor #2937 Travis: execute 5.3 job on precise (keradus)
* minor #2938 Tests fix configuration of project (SpacePossum, keradus)
* minor #2943 FunctionToConstantFixer - test with diff. arguments than fixable (SpacePossum)
* minor #2946 Detect extra old installations (keradus)
* minor #2947 Test suggested CI integration (keradus)
* minor #2951 AccessibleObject - remove most of usage (keradus)
* minor #2969 Shrink down AccessibleObject usage (keradus)
* minor #2982 TrailingCommaInMultilineArrayFixer - simplify isMultilineArray condition (TomasVotruba)

Changelog for v2.2.5
--------------------

* bug #2807 NoUselessElseFixer - Fix detection of conditional block (SpacePossum)
* bug #2809 Phar release - fix readme generation (SpacePossum, keradus)
* bug #2827 MethodArgumentSpaceFixer - Always remove trailing spaces (julienfalque)
* bug #2835 SelfAcessorFixer - class property fix (mnabialek)
* bug #2848 PhpdocIndentFixer - fix edge case with inline phpdoc (keradus)
* bug #2849 BracesFixer - Fix indentation issues with comments (julienfalque)
* bug #2851 Tokens - ensureWhitespaceAtIndex (GrahamCampbell, SpacePossum)
* bug #2854 NoLeadingImportSlashFixer - Removing leading slash from import even when in global space (kubawerlos)
* bug #2858 Support generic types (keradus)
* bug #2869 Fix handling required configuration (keradus)
* bug #2881 NoUnusedImportsFixer - Bug when trying to insert empty token (GrahamCampbell, keradus)
* bug #2882 DocBlock\Annotation - Fix parsing of collections with multiple key types (julienfalque)
* bug #2886 NoSpacesInsideParenthesisFixer - Do not remove whitespace if next token is comment (SpacePossum)
* bug #2888 SingleImportPerStatementFixer - Add support for function and const (SpacePossum)
* bug #2901 Add missing files to archive files (keradus)
* bug #2914 HeredocToNowdocFixer - works with CRLF line ending (dg)
* bug #2920 RuleSet - Update deprecated configuration of fixers (SpacePossum, keradus)
* minor #1531 Update docs for few generic types (keradus)
* minor #2793 COOKBOOK-FIXERS.md - update to current version, fix links (keradus)
* minor #2812 ProcessLinter - compatibility with Symfony 3.3 (keradus)
* minor #2816 Tokenizer - better docs and validation (keradus)
* minor #2817 Tokenizer - use future-compatible interface (keradus)
* minor #2819 Fix benchmark (keradus)
* minor #2824 code grooming (keradus)
* minor #2826 Exceptions - provide utests (localheinz)
* minor #2828 Enhancement: Reference phpunit.xsd from phpunit.xml.dist (localheinz)
* minor #2830 Differs - add tests (localheinz)
* minor #2832 Fix: Use all the columns (localheinz)
* minor #2833 Doctrine\Annotation\Token - provide utests (localheinz)
* minor #2839 Use PHP 7.2 polyfill instead of xml one (keradus)
* minor #2842 Move null to first position in PHPDoc types (julienfalque)
* minor #2850 ReadmeCommandTest - Prevent diff output (julienfalque)
* minor #2859 Fixed typo and dead code removal (GrahamCampbell)
* minor #2863 FileSpecificCodeSample - add tests (localheinz)
* minor #2864 WhitespacesAwareFixerInterface clean up (Slamdunk)
* minor #2865 AutoReview\FixerTest - test configuration samples (SpacePossum, keradus)
* minor #2867 VersionSpecification - Fix copy-paste typo (SpacePossum)
* minor #2874 LineTest - fix typo (keradus)
* minor #2875 HelpCommand - recursive layout fix (SpacePossum)
* minor #2883 DescribeCommand - Show which sample uses the default configuration  (SpacePossum)
* minor #2887 Housekeeping - Strict whitespace checks (SpacePossum)
* minor #2895 ProjectCodeTest - check that classes in no-tests exception exist (keradus)
* minor #2896 Move testing related classes from src to tests (keradus)
* minor #2904 Reapply CS (keradus)
* minor #2910 PhpdocAnnotationWithoutDotFixer - Restrict lowercasing (oschwald)
* minor #2913 Tests - tweaks (SpacePossum, keradus)
* minor #2916 FixerFactory - drop return in sortFixers(), never used (TomasVotruba)

Changelog for v2.2.4
--------------------

* bug #2682 DoctrineAnnotationIndentationFixer - fix handling nested annotations (edhgoose, julienfalque)
* bug #2700 Fix Doctrine Annotation end detection (julienfalque)
* bug #2715 OrderedImportsFixer - handle indented groups (pilgerone)
* bug #2732 HeaderCommentFixer - fix handling blank lines (s7b4)
* bug #2745 Fix Doctrine Annotation newlines (julienfalque)
* bug #2752 FixCommand - fix typo in warning message (mnapoli)
* bug #2757 GeckoPHPUnit is not dev dependency (keradus)
* bug #2759 Update gitattributes (SpacePossum)
* bug #2763 Fix describe command with PSR-0 fixer (julienfalque)
* bug #2768 Tokens::ensureWhitespaceAtIndex - clean up comment check, add check for T_OPEN (SpacePossum)
* bug #2783 Tokens::ensureWhitespaceAtIndex - Fix handling line endings (SpacePossum)
* minor #2663 Use colors for keywords in commands output (julienfalque, keradus)
* minor #2706 Update README (SpacePossum)
* minor #2714 README.rst - fix wrong value in example (mleko)
* minor #2721 Update phpstorm article link to a fresh blog post (valeryan)
* minor #2727 PHPUnit - use speedtrap (keradus)
* minor #2728 SelfUpdateCommand - verify that it's possible to replace current file (keradus)
* minor #2729 DescribeCommand - add decorated output test (julienfalque)
* minor #2731 BracesFixer - properly pass config in utest dataProvider (keradus)
* minor #2738 Upgrade tests to use new, namespaced PHPUnit TestCase class (keradus)
* minor #2743 Fixing example and description for GeneralPhpdocAnnotationRemoveFixer (kubawerlos)
* minor #2744 AbstractDoctrineAnnotationFixerTestCase - split fixers test cases (julienfalque)
* minor #2755 Fix compatibility with PHPUnit 5.4.x (keradus)
* minor #2758 Readme - improve CI integration guidelines (keradus)
* minor #2769 Psr0Fixer - remove duplicated example (julienfalque)
* minor #2775 NoExtraConsecutiveBlankLinesFixer - remove duplicate code sample. (SpacePossum)
* minor #2778 AutoReview - watch that code samples are unique (keradus)
* minor #2787 Add warnings about missing dom ext and require json ext (keradus)
* minor #2792 Use composer-require-checker (keradus)
* minor #2796 Update .gitattributes (SpacePossum)
* minor #2800 PhpdocTypesFixerTest - Fix typo in covers annotation (SpacePossum)

Changelog for v2.2.3
--------------------

* bug #2724 Revert #2554 Add short diff. output format (keradus)

Changelog for v2.2.2
--------------------

Warning, this release breaks BC due to introduction of:
* minor #2554 Add short diff. output format (SpacePossum, keradus)
That PR was reverted in v2.2.3, which should be used instead of v2.2.2.

* bug #2545 RuleSet - change resolvement (SpacePossum)
* bug #2686 Commands readme and describe - fix rare casing when not displaying some possible options of configuration (keradus)
* bug #2711 FixCommand - fix diff optional value handling (keradus)
* minor #2688 AppVeyor - Remove github oauth (keradus)
* minor #2703 Clean ups - No mixed annotations (SpacePossum)
* minor #2704 Create PHP70Migration:risky ruleset (keradus)
* minor #2707 Deprecate other than "yes" or "no" for input options (SpacePossum)
* minor #2709 code grooming (keradus)
* minor #2710 Travis - run more rules on TASK_SCA (keradus)

Changelog for v2.2.1
--------------------

* bug #2621 Tokenizer - fix edge cases with empty code, registered found tokens and code hash (SpacePossum, keradus)
* bug #2674 SemicolonAfterInstructionFixer - Fix case where block ends with an opening curly brace (ntzm)
* bug #2675 ProcessOutputTest - update tests to pass on newest Symfony components under Windows (keradus)
* minor #2651 Fix UPGRADE.md table syntax so it works in GitHub (ntzm, keradus)
* minor #2665 Travis - Improve trailing spaces detection (julienfalque)
* minor #2666 TransformersTest - move test to auto-review group (keradus)
* minor #2668 add covers annotation (keradus)
* minor #2669 TokensTest - grooming (SpacePossum)
* minor #2670 AbstractFixer: use applyFix instead of fix (Slamdunk)
* minor #2677 README: Correct progressbar option support (Laurens St�tzel)

Changelog for v2.2.0
--------------------

* bug #2640 NoExtraConsecutiveBlankLinesFixer - Fix single indent characters not working (ntzm)
* feature #2220 Doctrine annotation fixers (julienfalque)
* feature #2431 MethodArgumentSpaceFixer: allow to retain multiple spaces after comma (Slamdunk)
* feature #2459 BracesFixer - Add option for keeping opening brackets on the same line (jtojnar, SpacePossum)
* feature #2486 Add FunctionToConstantFixer (SpacePossum, keradus)
* feature #2505 FunctionDeclarationFixer - Make space after anonymous function configurable (jtojnar, keradus)
* feature #2509 FullOpeningTagFixer - Ensure opening PHP tag is lowercase (jtojnar)
* feature #2532 FixCommand - add stop-on-violation option (keradus)
* feature #2591 Improve process output (julienfalque)
* feature #2603 Add InvisibleSymbols Fixer (ivan1986, keradus)
* feature #2642 Add MagicConstantCasingFixer (ntzm)
* feature #2657 PhpdocToCommentFixer - Allow phpdoc for language constructs (ceeram, SpacePossum)
* minor #2500 Configuration resolver (julienfalque, SpacePossum, keradus)
* minor #2566 Show more details on errors and exceptions. (SpacePossum, julienfalque)
* minor #2597 HHVM - bump required version to 3.18 (keradus)
* minor #2606 FixCommand - fix missing comment close tag (keradus)
* minor #2623 OrderedClassElementsFixer - remove dead code (SpacePossum)
* minor #2625 Update Symfony and Symfony:risky rulesets (keradus)
* minor #2626 TernaryToNullCoalescingFixer - adjust ruleset membership and description (keradus)
* minor #2635 ProjectCodeTest - watch that all classes have dedicated tests (keradus)
* minor #2647 DescribeCommandTest - remove deprecated code usage (julienfalque)
* minor #2648 Move non-code covering tests to AutoReview subnamespace (keradus)
* minor #2652 NoSpacesAroundOffsetFixerTest - fix deprecation (keradus)
* minor #2656 Code grooming (keradus)
* minor #2659 Travis - speed up preparation for phar building (keradus)
* minor #2660 Fixed typo in suggest for ext-mbstring (pascal-hofmann)
* minor #2661 NonPrintableCharacterFixer - include into Symfony:risky ruleset (keradus)

Changelog for v2.1.3
--------------------

* bug #2358 Cache - Deal with signature encoding (keradus, GrahamCampbell)
* bug #2475 Add shorthand array destructing support (SpacePossum, keradus)
* bug #2595 NoUnusedImportsFixer - Fix import usage detection with properties (julienfalque)
* bug #2605 PhpdocAddMissingParamAnnotationFixer, PhpdocOrderFixer - fix priority issue (SpacePossum)
* bug #2607 Fixers - better comments handling (SpacePossum)
* bug #2612 BracesFixer - Fix early bracket close for do-while loop inside an if without brackets (felixgomez)
* bug #2614 Ensure that '*Fixer::fix()' won't crash when running on non-candidate collection (keradus)
* bug #2630 HeaderCommentFixer - Fix trailing whitespace not removed after <?php (julienfalque)
* bug #2637 ToolInfo - use static dir check for composer discovery (Slamdunk)
* bug #2639 SemicolonAfterInstructionFixer - Handle alternative syntax (SpacePossum)
* bug #2645 HHVM: handle T_HH_ERROR (keradus)
* bug #2653 IsNullFixer - fix edge case (localheinz, kalessil)
* bug #2654 PhpdocAddMissingParamAnnotationFixer - handle one-line docblocks (keradus)
* minor #2594 Travis - generate coverage report at 7.1 and clean up build matrix (keradus)
* minor #2613 HeaderCommentFixer - add missing case for exception raising (keradus)
* minor #2615 Add DescribeCommand test (julienfalque)
* minor #2616 Exclude more tests in phar version (keradus)
* minor #2618 Update README.rst (mhitza)
* minor #2620 Finder - Remove `*.twig` as default (SpacePossum)
* minor #2641 Cookbook - remove information about levels (keradus)
* minor #2644 DescribeCommandTest - fix test execution on decorated console (keradus)
* minor #2655 AppVeyor - Cache Composer Installation (julienfalque)

Changelog for v2.1.2
--------------------

* bug #2580 NoSpacesAfterFunctionNameFixer - Fix after dynamic call (SpacePossum, keradus)
* bug #2586 NoUnusedImportsFixerTest - handle FQCN import (keradus)
* bug #2587 NoClosingTagFixerTest - handle file without operations (keradus, SpacePossum)
* minor #2552 Initial compatibility with PHP 7.2-DEV (keradus)
* minor #2582 Improve AppVeyor and Travis CI build time (julienfalque)
* minor #2584 NoUnreachableDefaultArgumentValueFixer - fix typo (chadburrus)
* minor #2593 PhpUnitFqcnAnnotationFixer - move test to proper namespace (keradus)
* minor #2596 AppVeyor - update PHP versions (keradus)

Changelog for v2.1.1
--------------------

* bug #2547 NoUnneededControlParenthesesFixer - Handle T_COALESCE in clone (keksa)
* bug #2557 BracesFixer - Better comments handling (SpacePossum)
* bug #2558 require symfony/polyfill-xml (SpacePossum)
* bug #2560 PhpdocNoAliasTagFixer - Fix circular replacements detection (julienfalque)
* bug #2567 Filename with spaces usage (jaymecd)
* bug #2572 NoUnreachableDefaultArgumentValueFixer - Mark as risky (SpacePossum)
* minor #2533 AppVeyor - adjust phpunit version (keradus)
* minor #2535 Make .gitignore entries more specific (julienfalque)
* minor #2541 README.rst - provide download link for latest version (keradus)
* minor #2562 Add schema.json (keradus)
* minor #2563 Add deprecation notices tests (julienfalque)
* minor #2564 Add rules configuration by passing json encode config by CLI (SpacePossum)
* minor #2569 Make symfony/phpunit-bridge a dev dependency only (julienfalque)
* minor #2574 Add xml.xsd (keradus)

Changelog for v2.1.0
--------------------

* feature #2124 Add TernaryToNullCoalescingFixer (Slamdunk, SpacePossum)
* feature #2280 Configurable OrderedImportsFixer (DarkaOnLine)
* feature #2351 Enhancement: Allow to configure return_type_declaration rule (localheinz)
* feature #2359 Add PhpdocNoUselessInheritdocFixer (SpacePossum, keradus)
* feature #2414 Add PhpdocReturnSelfReferenceFixer (SpacePossum)
* feature #2415 Add IsNullFixer (kalessil, keradus)
* feature #2421 BracesFixer - Add allow_single_line_closure configuration (keradus)
* feature #2461 PhpdocNoUselessInheritdocFixer - support multiline docblock (keradus)
* feature #2462 Add NativeFunctionInvocationFixer (localheinz, keradus, Slamdunk)
* feature #2478 DeclareEqualNormalizeFixer - Add config option (SpacePossum)
* feature #2494 FixCommand - Support rules with params (ptcong, keradus)
* minor #2452 Provide rules definitions (keradus)
* minor #2460 RuleSet - extend Symfony (keradus)
* minor #2483 DX: AbstractIntegrationTestCase does not use IntegrationCase::shouldCheckPriority, logic is now automated and method is now deprecated (keradus)
* minor #2488 IsNullFixer - Fix bug when calling without params (SpacePossum)
* minor #2519 remove trailing whitespace (keradus)

Changelog for v2.0.1
--------------------

* bug #2357 Better handling of file name that is the same in multiple finder paths (keradus)
* bug #2373 FunctionDeclarationFixer - Fix static anonymous functions (SpacePossum)
* bug #2377 PhpdocSeparationFixer - Ignore incorrect PHPDoc (SpacePossum, keradus)
* bug #2388 PhpdocAlignFixer - unicode characters support (SpacePossum)
* bug #2399 HashToSlashCommentFixer - Fix edge cases (SpacePossum)
* bug #2403 ClassDefinitionFixer - Anonymous classes format by PSR12 (SpacePossum)
* bug #2408 SingleClassElementPerStatementFixer, PhpdocSeparationFixer - add missing WhitespacesAwareFixerInterface interface (keradus)
* bug #2425 ClassKeywordRemoveFixer - Fix handling leading backslash and comments (SpacePossum)
* bug #2430 PhpdocAlignFixer - Fix alignment of variadic params. (SpacePossum)
* bug #2437 NoWhitespaceInBlankLineFixer - Fix more cases (SpacePossum)
* bug #2444 MbStrFunctionsFixer - handle return reference in method declaration (SpacePossum)
* bug #2449 PhpdocAlignFixer - don't crash poorly formatted phpdoc (GrahamCampbell)
* bug #2477 BracesFixer - Do not remove white space inside declare statement (SpacePossum)
* bug #2481 Fix priorities between declare_strict_types and blank_line_after_opening_tag (juliendufresne, keradus)
* bug #2507 NoClosingTagFixer - Do not insert semicolon in comment (SpacePossum)
* minor #2347 UPGRADE.md - Fix multi-row description (drAlberT, keradus)
* minor #2352 Corrected method visibility (GrahamCampbell)
* minor #2353 Fix: Typos (localheinz)
* minor #2354 Enhancement: Allow to specify minimum and maximum PHP versions for code samples (localheinz)
* minor #2356 Fixed spelling on "blank line" (GrahamCampbell)
* minor #2361 ConfigurationResolver - Reject unknown rules (localheinz)
* minor #2368 clean ups (SpacePossum, localheinz)
* minor #2380 DescribeCommand - filter code samples and output note when none can be demonstrated (localheinz)
* minor #2381 Tests - Do not use annotations for asserting exceptions (localheinz, keradus)
* minor #2382 Consistently provide a default configuration field (localheinz)
* minor #2383 update .php_cs.dist configuration (keradus)
* minor #2386 PHP7.1 Integration test - Add features added in PHP7.1. (SpacePossum)
* minor #2392 FixCommandHelp - fix typo (keradus)
* minor #2393 Remove overcomplete tests (SpacePossum)
* minor #2394 Update .gitattributes (SpacePossum)
* minor #2395 NoEmptyCommentFixer - Fix typo (fritz-c)
* minor #2396 MethodArgumentSpaceFixer - scope down endpoint (SpacePossum)
* minor #2397 RuleSet - Check risky (SpacePossum, keradus)
* minor #2400 Add Fixer descriptions (SpacePossum)
* minor #2401 Fix UPGRADE.md (issei-m)
* minor #2405 Transformers - Must be final (SpacePossum)
* minor #2406 ProtectedToPrivateFixer - Use backticks for visibility in description (localheinz)
* minor #2407 Add tests for not abusing interfaces (keradus)
* minor #2410 DX: Keep packages sorted (localheinz)
* minor #2412 Enhancement: Add more descriptions (localheinz)
* minor #2413 Update Symfony ruleset (fabpot)
* minor #2419 README.rst - use double backticks for code pieces in rule descriptions (keradus)
* minor #2422 BracesFixer - cleanup code after introducing CT::T_FUNCTION_IMPORT (keradus)
* minor #2426 .php_cs.dist - update local CS config (keradus)
* minor #2428 SCA with Php Inspections (EA Extended) (kalessil)
* minor #2433 AbstractFixerTestCase - give all the details available during catch (Slamdunk)
* minor #2434 COOKBOOK-FIXERS.md - Replace reference to outdated class with current (greg0ire)
* minor #2436 MethodArgumentSpaceFixer - Remove duplicate class name (greg0ire)
* minor #2441 IndentationTypeFixer - Fix description and upgrade guide (SpacePossum)
* minor #2443 AppVeyor - update configuration (keradus)
* minor #2447 .php_cs.dist - update local CS config (keradus)
* minor #2452 Provide rules definitions (keradus)
* minor #2455 NoMultilineWhitespaceAroundDoubleArrowFixer - Add missing priority test (SpacePossum)
* minor #2466 Provide rules definitions (keradus)
* minor #2470 README.rst - explain the usage of "--path-mode" parameter (kalimatas)
* minor #2474 Housekeeping (SpacePossum)
* minor #2487 UPGRADE.md - Fix typo (SpacePossum)
* minor #2493 FixCommand - Output warning message when both config and rules options are passed (SpacePossum)
* minor #2496 DX: Travis - check for trailing spaces (keradus)
* minor #2499 FileSpecificCodeSample - Specify class name relative to root namespace (localheinz, keradus)
* minor #2506 SCA (SpacePossum)
* minor #2515 Fix code indentation (keradus)
* minor #2521 SCA trailing spces check - ouput lines with trailing white space (SpacePossum)
* minor #2522 Fix docs and small code issues (keradus)

Changelog for v2.0.0
--------------------

* bug #1001 MethodArgumentSpaceFixer - no need for multiple executions (keradus)
* bug #1006 NewWithBracesFixer - fix by adding BraceClassInstantiationTransformer (sstok)
* bug #1077 ConfigInterface - add missing methods (localheinz)
* bug #1103 added missing keyword token (gharlan)
* bug #1107 Added ImportTransformer (gharlan)
* bug #1157 Prevent token collection corruption by fixers (keradus, stof)
* bug #1256 Do not write the fixed output twice (SpacePossum)
* bug #1405 Linter - fix ignoring input parameter for constructor (keradus)
* bug #1414 Linter - fix escaping the php binary (GrahamCampbell, keradus)
* bug #1606 Fixer - remove duplicate file_get_contents call (gharlan)
* bug #1629 Fix linting test cases (gharlan)
* bug #1800 ConfigurationResolver - Fix resolving intersection path (keradus)
* bug #1809 NoMultilineWhitespaceBeforeSemicolonsFixer - Semicolon should not be moved into comment (SpacePossum)
* bug #1838 BracesFixer - Removes line break (SpacePossum)
* bug #1847 Runner - always cache files, not only when something is changed (gharlan)
* bug #1852 ConfigurationResolver - disallow empty rule name (keradus)
* bug #1855 FixCommand - fix passing NullLinter to Runner (keradus)
* bug #1926 NoUselessElseFixer - fix wrong if handling (SpacePossum)
* bug #1946 NoEmptyCommentFixer - Only remove complete empty comment blocks (SpacePossum)
* bug #1965 AbstractPsrAutoloadingFixer - fix edge case of halting compiler for PHP 5.3 (keradus)
* bug #1974 composer.json - fix dependencies for PHP 5.3.6 (keradus)
* bug #2025 NoShortEchoTagFixer - adjust isCandidate check for hhvm (keradus)
* bug #2039 NoExtraConsecutiveBlankLinesFixer - Fix curly brace open false positive (SpacePossum)
* bug #2044 SingleClassElementPerStatementFixer - fix array handling (keradus)
* bug #2063 ConfigurationResolver - passing non-existing path is ignored (keradus)
* bug #2236 .gitattributes - fix ignoring tests during export (keradus)
* bug #2241 XmlReporter - fix used getter (keradus)
* bug #2283 FixCommand - Fix resolving format option (SpacePossum, keradus)
* bug #2287 NoExtraConsecutiveBlankLinesFixer - fix bug that removes empty line already after scope end (keradus)
* bug #2290 FixCommand - fix progress (keradus)
* bug #2292 GeneralPhpdocAnnotation*Fixer::configure - add missing return (keradus)
* bug #2305 ProcessLinter - fix running under phpdbg (keradus)
* feature #1076 Enhancement: Allow to specify cache file (localheinz, keradus)
* feature #1088 JoinFunctionFixer -> AliasFunctionsFixer (kalessil)
* feature #1275 Added PhpdocInlineTagFixer (SpacePossum, keradus)
* feature #1292 Added MethodSeparationFixer (SpacePossum)
* feature #1383 Introduce rules and sets (keradus)
* feature #1416 Mark fixers as risky (keradus)
* feature #1440 Made AbstractFixerTestCase and AbstractIntegrationTestCase public (keradus)
* feature #1489 Added Psr4Fixer (GrahamCampbell)
* feature #1497 ExtraEmptyLinesFixer - allow to remove empty blank lines after configured tags (SpacePossum)
* feature #1529 Added PhpdocPropertyFixer, refactored Tag and Annotation (GrahamCampbell)
* feature #1628 Added OrderedClassElementsFixer (gharlan)
* feature #1742 path argument is used to create an intersection with existing finder (keradus, gharlan)
* feature #1779 Added GeneralPhpdocAnnotationRemoveFixer, GeneralPhpdocAnnotationRenameFixer (keradus)
* feature #1811 Added NoSpacesInsideOfssetFixer (phansys)
* feature #1819 Added DirConstantFixer, ModernizeTypesCastingFixer, RandomApiMigrationFixer (kalessil, SpacePossum, keradus)
* feature #1825 Added junit format (ekho)
* feature #1862 FixerFactory - Do not allow conflicting fixers (SpacePossum)
* feature #1888 Cache refactoring, better cache handling in dry-run mode (localheinz)
* feature #1889 Added SingleClassElementPerStatementFixer (phansys, SpacePossum)
* feature #1903 FixCommand - allow to pass multiple path argument (keradus)
* feature #1913 Introduce path-mode CLI option (keradus)
* feature #1949 Added DeclareStrictTypesFixer, introduce options for HeaderCommentFixer (Seldaek, SpacePossum, keradus)
* feature #1955 Introduce CT_ARRAY_INDEX_CURLY_BRACE_OPEN and CT_ARRAY_INDEX_CURLY_BRACE_CLOSE (keradus)
* feature #1958 Added NormalizeIndexBraceFixer (keradus)
* feature #2069 Add semicolon after instruction fixer (SpacePossum)
* feature #2089 Add `no_spaces_around_offset` fixer (phansys)
* feature #2179 BinaryOperatorSpacesFixer - add (un)align configuration options (SpacePossum)
* feature #2192 Add PowToExponentiationFixer (SpacePossum, keradus)
* feature #2207 Added ReturnTypeDeclarationFixer (keradus)
* feature #2213 VisibilityRequiredFixer - Add support for class const visibility added in PHP7.1. (SpacePossum)
* feature #2221 Add support for user-defined whitespaces (keradus)
* feature #2244 Config cleanup (keradus, SpacePossum)
* feature #2247 PhpdocAnnotationWithoutDotFixer - support more cases (keradus)
* feature #2289 Add PhpdocAddMissingParamAnnotationFixer (keradus)
* feature #2331 Add DescribeCommand (keradus, SpacePossum)
* feature #2332 New colours of diff on console (keradus)
* feature #829 add support for .php_cs.dist file (keradus)
* feature #998 MethodArgumentSpaceFixer - enhance, now only one space after comma (trilopin, keradus)
* minor #1007 Simplify Transformers (keradus)
* minor #1050 Make Config's setDir() fluent like the rest of methods (gonzaloserrano)
* minor #1062 Added NamespaceOperatorTransformer (gharlan)
* minor #1078 Exit status should be 0 if there are no errors (gharlan)
* minor #1101 CS: fix project itself (localheinz)
* minor #1102 Enhancement: List errors occurred before, during and after fixing (localheinz)
* minor #1105 Token::isStructureAlternativeEnd - remove unused method (keradus)
* minor #1106 readme grooming (SpacePossum, keradus)
* minor #1115 Fixer - simplify flow (keradus)
* minor #1118 Process output refactor (SpacePossum)
* minor #1132 Linter - public methods should be first (keradus)
* minor #1134 Token::isWhitespace - simplify interface (keradus)
* minor #1140 FixerInterface - check if fixer should be applied by isCandidate method (keradus)
* minor #1146 Linter - detect executable (keradus)
* minor #1156 deleted old ConfigurationResolver class (keradus)
* minor #1160 Grammar fix to README (Falkirks)
* minor #1174 DefaultFinder - boost performance by not filtering when files array is empty (keradus)
* minor #1179 Exit with non-zero if invalid files were detected prior to fixing (localheinz)
* minor #1186 Finder - do not search for .xml and .yml files (keradus)
* minor #1206 BracesFixer::getClassyTokens - remove duplicated method (keradus)
* minor #1222 Made fixers final (GrahamCampbell)
* minor #1229 Tokens - Fix PHPDoc (SpacePossum)
* minor #1241 More details on exceptions. (SpacePossum)
* minor #1263 Made internal classes final (GrahamCampbell)
* minor #1272 Readme - Add spaces around PHP-CS-Fixer headers (Soullivaneuh)
* minor #1283 Error - Fixed type phpdoc (GrahamCampbell)
* minor #1284 Token - Fix PHPDoc (SpacePossum)
* minor #1314 Added missing internal annotations (keradus)
* minor #1329 Psr0Fixer - move to contrib level (gharlan)
* minor #1340 Clean ups (SpacePossum)
* minor #1341 Linter - throw exception when write fails (SpacePossum)
* minor #1348 Linter - Prefer error output when throwing a linting exception (GrahamCampbell)
* minor #1350 Add "phpt" as a valid extension (henriquemoody)
* minor #1376 Add time and memory to XML report (junichi11)
* minor #1387 Made all test classes final (keradus)
* minor #1388 Made all tests internal (keradus)
* minor #1390 Added ProjectCodeTest that tests if all classes inside tests are internal and final or abstract (keradus)
* minor #1391 Fixer::getLevelAsString is no longer static (keradus)
* minor #1392 Add report to XML report as the root node (junichi11)
* minor #1394 Stop mixing level from config file and fixers from CLI arg when one of fixers has dash (keradus)
* minor #1426 MethodSeparationFixer - Fix spacing around comments (SpacePossum, keradus)
* minor #1432 Fixer check on factory (Soullivaneuh)
* minor #1434 Add Test\AccessibleObject class (keradus)
* minor #1442 FixerFactory - disallow to register multiple fixers with same name (keradus)
* minor #1477 rename PhpdocShortDescriptionFixer into PhpdocSummaryFixer (keradus)
* minor #1481 Fix running the tests (keradus)
* minor #1482 move AbstractTransformerTestBase class outside Tests dir (keradus)
* minor #1530 Added missing internal annotation (GrahamCampbell)
* minor #1534 Clean ups (SpacePossum)
* minor #1536 Typo fix (fabpot)
* minor #1555 Fixed indentation in composer.json (GrahamCampbell)
* minor #1558 [2.0] Cleanup the tags property in the abstract phpdoc types fixer (GrahamCampbell)
* minor #1567 PrintToEchoFixer - add to symfony rule set (gharlan)
* minor #1607 performance improvement (gharlan)
* minor #1621 Switch to PSR-4 (keradus)
* minor #1631 Configuration exceptions exception cases on master. (SpacePossum)
* minor #1646 Remove non-default Config/Finder classes (keradus)
* minor #1648 Fixer - avoid extra calls to getFileRelativePathname (GrahamCampbell)
* minor #1649 Consider the php version when caching (GrahamCampbell)
* minor #1652 Rename namespace "Symfony\CS" to "PhpCsFixer" (gharlan)
* minor #1666 new Runner, ProcessOutputInterface, DifferInterface and ResultInterface (keradus)
* minor #1674 Config - add addCustomFixers method (PedroTroller)
* minor #1677 Enhance tests (keradus)
* minor #1695 Rename Fixers (keradus)
* minor #1702 Upgrade guide (keradus)
* minor #1707 ExtraEmptyLinesFixer - fix configure docs (keradus)
* minor #1712 NoExtraConsecutiveBlankLinesFixer - Remove blankline after curly brace open (SpacePossum)
* minor #1718 CLI: rename --config-file argument (keradus)
* minor #1722 Renamed not_operators_with_space to not_operator_with_space (GrahamCampbell)
* minor #1728 PhpdocNoSimplifiedNullReturnFixer - rename back to PhpdocNoEmptyReturnFixer (keradus)
* minor #1729 Renamed whitespacy_lines to no_whitespace_in_blank_lines (GrahamCampbell)
* minor #1731 FixCommand - value for config option is required (keradus)
* minor #1732 move fixer classes from level subdirs to thematic subdirs (gharlan, keradus)
* minor #1733 ConfigurationResolver - look for .php_cs file in cwd as well (keradus)
* minor #1737 RuleSet/FixerFactory - sort arrays content (keradus)
* minor #1751 FixerInterface::configure - method should always override configuration, not patch it (keradus)
* minor #1752 Remove unused code (keradus)
* minor #1756 Finder - clean up code (keradus)
* minor #1757 Psr0Fixer - change way of configuring the fixer (keradus)
* minor #1762 Remove ConfigInterface::getDir, ConfigInterface::setDir, Finder::setDir and whole FinderInterface (keradus)
* minor #1764 Remove ConfigAwareInterface (keradus)
* minor #1780 AbstractFixer - throw error on configuring non-configurable Fixer (keradus)
* minor #1782 rename fixers (gharlan)
* minor #1815 NoSpacesInsideParenthesisFixer - simplify implementation (keradus)
* minor #1821 Ensure that PhpUnitDedicateAssertFixer runs after NoAliasFunctionsFixer, clean up NoEmptyCommentFixer (SpacePossum)
* minor #1824 Reporting extracted to separate classes (ekho, keradus, SpacePossum)
* minor #1826 Fixer - remove measuring fixing time per file (keradus)
* minor #1843 FileFilterIterator - add missing import (GrahamCampbell)
* minor #1845 FileCacheManager - Allow linting to determine the cache state too (GrahamCampbell)
* minor #1846 FileFilterIterator - Corrected an iterator typehint (GrahamCampbell)
* minor #1848 DocBlock - Remove some old unused phpdoc tags (GrahamCampbell)
* minor #1856 NoDuplicateSemicolonsFixer - Remove overcomplete fixer (SpacePossum)
* minor #1861 Fix: Ofsset should be Offset (localheinz)
* minor #1867 Print non-report output to stdErr (SpacePossum, keradus)
* minor #1873 Enhancement: Show path to cache file if it exists (localheinz)
* minor #1875 renamed Composer package (fabpot)
* minor #1882 Runner - Handle throwables too (GrahamCampbell)
* minor #1886 PhpdocScalarFixer - Fix lowercase str to string too (GrahamCampbell)
* minor #1940 README.rst - update CI example (keradus)
* minor #1947 SCA, CS, add more tests (SpacePossum, keradus)
* minor #1954 tests - stop using deprecated method (sebastianbergmann)
* minor #1962 TextDiffTest - tests should not produce cache file (keradus)
* minor #1973 Introduce fast PHP7 based linter (keradus)
* minor #1999 Runner - No need to determine relative file name twice (localheinz)
* minor #2002 FileCacheManagerTest - Adjust name of test and variable (localheinz)
* minor #2010 NoExtraConsecutiveBlankLinesFixer - SF rule set, add 'extra' (SpacePossum)
* minor #2013 no_whitespace_in_blank_lines -> no_whitespace_in_blank_line (SpacePossum)
* minor #2024 AbstractFixerTestCase - check if there is no duplicated Token instance inside Tokens collection (keradus)
* minor #2031 COOKBOOK-FIXERS.md - update calling doTest method (keradus)
* minor #2032 code grooming (keradus)
* minor #2068 Code grooming (keradus)
* minor #2073 DeclareStrictTypesFixer - Remove fix CS fix logic from fixer. (SpacePossum)
* minor #2088 TokenizerLintingResult - expose line number of parsing error (keradus)
* minor #2093 Tokens - add block type BLOCK_TYPE_ARRAY_INDEX_CURLY_BRACE (SpacePossum)
* minor #2095 Transformers - add required PHP version (keradus)
* minor #2096 Introduce CT for PHP7 (keradus)
* minor #2119 Create @Symfony:risky ruleset (keradus)
* minor #2163 ClassKeywordRemoveFixerTest - Fix tests (SpacePossum)
* minor #2180 FixCommand - don't refer to renamed rules (keradus)
* minor #2181 Disallow to disable linter (keradus)
* minor #2194 semicolon_after_instruction,no_unneeded_control_parentheses prio issue (SpacePossum)
* minor #2199 make fixers less risky (SpacePossum)
* minor #2206 Add PHP70Migration ruleset (keradus)
* minor #2217 SelfUpdateCommand - Print version of update fixer (SpacePossum)
* minor #2223 update integration test format (keradus)
* minor #2227 Stop polluting global namespace with CT (keradus)
* minor #2237 DX: extend integration tests for PSR2 and Symfony rulesets (keradus)
* minor #2240 Make some objects immutable (keradus)
* minor #2251 ProtectedToPrivateFixer - fix priority, fix comments with new fixer names (SpacePossum)
* minor #2252 ClassDefinitionFixer - Set configuration of the fixer in the RuleSet of SF. (SpacePossum)
* minor #2257 extend Symfony_whitespaces itest (keradus)
* minor #2258 README.rst - indicate configurable rules (keradus)
* minor #2267 RuleSet - validate set (keradus)
* minor #2268 Use strict parameters for PHP functions (keradus)
* minor #2273 fixed typo (fabpot)
* minor #2274 ShortArraySyntaxFixer/LongArraySyntaxFixer - Merge conflicting fixers (SpacePossum)
* minor #2275 Clean ups (SpacePossum)
* minor #2278 Concat*Fixer - unify concat fixers (SpacePossum, keradus)
* minor #2279 Use Prophecy (keradus)
* minor #2284 Code grooming (SpacePossum)
* minor #2285 IntegrationCase is now aware about RuleSet but not Fixers (keradus, SpacePossum)
* minor #2286 Phpdoc*Fixer - unify rename fixers (SpacePossum, keradus)
* minor #2288 FixerInterface::configure(null) reset fixer to use default configuration (keradus)
* minor #2291 Make fixers ready to use directly after creation (keradus)
* minor #2295 Code grooming (keradus)
* minor #2296 ProjectCodeTest - make test part of regular testsuite, not standalone one (keradus)
* minor #2298 ConfigurationResolver - grooming (SpacePossum)
* minor #2300 Simplify rule set (SpacePossum, keradus)
* minor #2306 DeclareStrictTypesFixer - do not move tokens (SpacePossum)
* minor #2312 RuleSet - sort rules (localheinz)
* minor #2313 DX: provide doctyping for tests (keradus)
* minor #2317 Add utests (keradus)
* minor #2318 *TestCase - Reduce visibility of setUp() (localheinz)
* minor #2319 Code grooming (keradus)
* minor #2322 DX: use whitemessy aware assertion (keradus)
* minor #2324 Echo|Print*Fixer - unify printing fixers (SpacePossum, keradus)
* minor #2337 Normalize rule naming (keradus)
* minor #2338 Drop hacks for unsupported HHVM (keradus)
* minor #2339 Add some Fixer descriptions (SpacePossum, keradus)
* minor #2343 PowToExponentiationFixer - allow to run on 5.6.0 as well (keradus)
* minor #767 Add @internal tag (keradus)
* minor #807 Tokens::isMethodNameIsMagic - remove unused method (keradus)
* minor #809 Split Tokens into Tokens and TokensAnalyzer (keradus)
* minor #844 Renamed phpdoc_params to phpdoc_align (GrahamCampbell)
* minor #854 Change default level to PSR2 (keradus)
* minor #873 Config - using cache by default (keradus)
* minor #902 change FixerInterface (keradus)
* minor #911 remove Token::$line (keradus)
* minor #914 All Transformer classes should be named with Transformer as suffix (keradus)
* minor #915 add UseTransformer (keradus)
* minor #916 add ArraySquareBraceTransformer (keradus)
* minor #917 clean up Transformer tests (keradus)
* minor #919 CurlyBraceTransformer - one transformer to handle all curly braces transformations (keradus)
* minor #928 remove Token::getLine (keradus)
* minor #929 add WhitespacyCommentTransformer (keradus)
* minor #937 fix docs/typehinting in few classes (keradus)
* minor #958 FileCacheManager - remove code for BC support (keradus)
* minor #979 Improve Tokens::clearEmptyTokens performance (keradus)
* minor #981 Tokens - code grooming (keradus)
* minor #988 Fixers - no need to search for tokens of given kind in extra loop (keradus)
* minor #989 No need for loop in Token::equals (keradus)

Changelog for v1.13.3
---------------------

* minor #3042 Update gitter address (keradus)

Changelog for v1.13.2
---------------------

* minor #2946 Detect extra old installations (keradus)

Changelog for v1.13.1
---------------------

* minor #2342 Application - adjust test to not depend on symfony/console version (keradus)
* minor #2344 AppVeyor: enforce PHP version (keradus)

Changelog for v1.13.0
---------------------

* bug #2303 ClassDefinitionFixer - Anonymous classes fixing (SpacePossum)
* feature #2208 Added fixer for PHPUnit's @expectedException annotation (ro0NL)
* feature #2249 Added ProtectedToPrivateFixer (Slamdunk, SpacePossum)
* feature #2264 SelfUpdateCommand - Do not update to next major version by default (SpacePossum)
* feature #2328 ClassDefinitionFixer - Anonymous classes format by PSR12 (SpacePossum)
* feature #2333 PhpUnitFqcnAnnotationFixer - support more annotations (keradus)
* minor #2256 EmptyReturnFixer - it's now risky fixer due to null vs void (keradus)
* minor #2281 Add issue template (SpacePossum)
* minor #2307 Update .editorconfig (SpacePossum)
* minor #2310 CI: update AppVeyor to use newest PHP, silence the composer (keradus)
* minor #2315 Token - Deprecate getLine() (SpacePossum)
* minor #2320 Clear up status code on 1.x (SpacePossum)

Changelog for v1.12.4
---------------------

* bug #2235 OrderedImportsFixer - PHP 7 group imports support (SpacePossum)
* minor #2276 Tokens cleanup (keradus)
* minor #2277 Remove trailing spaces (keradus)
* minor #2294 Improve Travis configuration (keradus)
* minor #2297 Use phpdbg instead of xdebug (keradus)
* minor #2299 Travis: proper xdebug disabling (keradus)
* minor #2301 Travis: update platform adjusting (keradus)

Changelog for v1.12.3
---------------------

* bug #2155 ClassDefinitionFixer - overhaul (SpacePossum)
* bug #2187 MultipleUseFixer - Fix handling comments (SpacePossum)
* bug #2209 LinefeedFixer - Fix in a safe way (SpacePossum)
* bug #2228 NoEmptyLinesAfterPhpdocs, SingleBlankLineBeforeNamespace - Fix priority (SpacePossum)
* bug #2230 FunctionDeclarationFixer - Fix T_USE case (SpacePossum)
* bug #2232 Add a test for style of varaible decalration : var (daiglej)
* bug #2246 Fix itest requirements (keradus)
* minor #2238 .gitattributes - specified line endings (keradus)
* minor #2239 IntegrationCase - no longer internal (keradus)

Changelog for v1.12.2
---------------------

* bug #2191 PhpdocToCommentFixer - fix false positive for docblock of variable (keradus)
* bug #2193 UnneededControlParenthesesFixer - Fix more return cases. (SpacePossum)
* bug #2198 FileCacheManager - fix exception message and undefined property (j0k3r)
* minor #2170 Add dollar sign prefix for consistency (bcremer)
* minor #2190 .travis.yml - improve Travis speed for tags (keradus)
* minor #2196 PhpdocTypesFixer - support iterable type (GrahamCampbell)
* minor #2197 Update cookbook and readme (g105b, SpacePossum)
* minor #2203 README.rst - change formatting (ro0NL)
* minor #2204 FixCommand - clean unused var (keradus)
* minor #2205 Add integration test for iterable type (keradus)

Changelog for v1.12.1
---------------------

* bug #2144 Remove temporary files not deleted by destructor on failure (adawolfa)
* bug #2150 SelfUpdateCommand: resolve symlink (julienfalque)
* bug #2162 Fix issue where an exception is thrown if the cache file exists but is empty. (ikari7789)
* bug #2164 OperatorsSpacesFixer - Do not unalign double arrow and equals operators (SpacePossum)
* bug #2167 Rewrite file removal (keradus)
* minor #2152 Code cleanup (keradus)
* minor #2154 ShutdownFileRemoval - Fixed file header (GrahamCampbell)

Changelog for v1.12.0
---------------------

* feature #1493 Added MethodArgumentDefaultValueFixer (lmanzke)
* feature #1495 BracesFixer - added support for declare (EspadaV8)
* feature #1518 Added ClassDefinitionFixer (SpacePossum)
* feature #1543 [PSR-2] Switch case space fixer (Soullivaneuh)
* feature #1577 Added SpacesAfterSemicolonFixer (SpacePossum)
* feature #1580 Added HeredocToNowdocFixer (gharlan)
* feature #1581 UnneededControlParenthesesFixer - add "break" and "continue" support (gharlan)
* feature #1610 HashToSlashCommentFixer - Add (SpacePossum)
* feature #1613 ScalarCastFixer - LowerCaseCastFixer - Add (SpacePossum)
* feature #1659 NativeFunctionCasingFixer - Add (SpacePossum)
* feature #1661 SwitchCaseSemicolonToColonFixer - Add (SpacePossum)
* feature #1662 Added CombineConsecutiveUnsetsFixer (SpacePossum)
* feature #1671 Added NoEmptyStatementFixer (SpacePossum)
* feature #1705 Added NoUselessReturnFixer (SpacePossum, keradus)
* feature #1735 Added NoTrailingWhitespaceInCommentFixer (keradus)
* feature #1750 Add PhpdocSingleLineVarSpacingFixer (SpacePossum)
* feature #1765 Added NoEmptyPhpdocFixer (SpacePossum)
* feature #1773 Add NoUselessElseFixer (gharlan, SpacePossum)
* feature #1786 Added NoEmptyCommentFixer (SpacePossum)
* feature #1792 Add PhpUnitDedicateAssertFixer. (SpacePossum)
* feature #1894 BracesFixer - correctly fix indents of anonymous functions/classes (gharlan)
* feature #1985 Added ClassKeywordRemoveFixer (Soullivaneuh)
* feature #2020 Added PhpdocAnnotationWithoutDotFixer (keradus)
* feature #2067 Added DeclareEqualNormalizeFixer (keradus)
* feature #2078 Added SilencedDeprecationErrorFixer (HeahDude)
* feature #2082 Added MbStrFunctionsFixer (Slamdunk)
* bug #1657 SwitchCaseSpaceFixer - Fix spacing between 'case' and semicolon (SpacePossum)
* bug #1684 SpacesAfterSemicolonFixer - fix loops handling (SpacePossum, keradus)
* bug #1700 Fixer - resolve import conflict (keradus)
* bug #1836 NoUselessReturnFixer - Do not remove return if last statement in short if statement (SpacePossum)
* bug #1879 HeredocToNowdocFixer - Handle space in heredoc token (SpacePossum)
* bug #1896 FixCommand - Fix escaping of diff output (SpacePossum)
* bug #2034 IncludeFixer - fix support for close tag (SpacePossum)
* bug #2040 PhpdocAnnotationWithoutDotFixer - fix crash on odd character (keradus)
* bug #2041 DefaultFinder should implement FinderInterface (keradus)
* bug #2050 PhpdocAnnotationWithoutDotFixer - handle ellipsis (keradus)
* bug #2051 NativeFunctionCasingFixer - call to constructor with default NS of class with name matching native function name fix (SpacePossum)
* minor #1538 Added possibility to lint tests (gharlan)
* minor #1569 Add sample to get a specific version of the fixer (Soullivaneuh)
* minor #1571 Enhance integration tests (keradus)
* minor #1578 Code grooming (keradus)
* minor #1583 Travis - update matrix (keradus)
* minor #1585 Code grooming - Improve utests code coverage (SpacePossum)
* minor #1586 Add configuration exception classes and exit codes (SpacePossum)
* minor #1594 Fix invalid PHP code samples in utests  (SpacePossum)
* minor #1597 MethodArgumentDefaultValueFixer - refactoring and fix closures with "use" clause (gharlan)
* minor #1600 Added more integration tests (SpacePossum, keradus)
* minor #1605 integration tests - swap EXPECT and INPUT (optional INPUT) (gharlan)
* minor #1608 Travis - change matrix order for faster results (gharlan)
* minor #1609 CONTRIBUTING.md - Don't rebase always on master (SpacePossum)
* minor #1616 IncludeFixer - fix and test more cases (SpacePossum)
* minor #1622 AbstractIntegratationTest - fix linting test cases (gharlan)
* minor #1624 fix invalid code in test cases (gharlan)
* minor #1625 Travis - switch to trusty (keradus)
* minor #1627 FixCommand - fix output (keradus)
* minor #1630 Pass along the exception code. (SpacePossum)
* minor #1632 Php Inspections (EA Extended): SCA for 1.12 (kalessil)
* minor #1633 Fix CS for project itself (keradus)
* minor #1634 Backport some minor changes from 2.x line (keradus)
* minor #1637 update PHP Coveralls (keradus)
* minor #1639 Revert "Travis - set dist to trusty" (keradus)
* minor #1641 AppVeyor/Travis - use GITHUB_OAUTH_TOKEN (keradus)
* minor #1642 AppVeyor - install dev deps as well (keradus)
* minor #1647 Deprecate non-default Configs and Finders (keradus)
* minor #1654 Split output to stderr and stdout (SpacePossum)
* minor #1660 update phpunit version (gharlan)
* minor #1663 DuplicateSemicolonFixer - Remove duplicate semicolons even if there are comments between those (SpacePossum)
* minor #1664 IncludeFixer - Add missing test case (SpacePossum)
* minor #1668 Code grooming (keradus)
* minor #1669 NativeFunctionCasingFixer - move to Symfony level (keradus)
* minor #1670 Backport Finder and Config classes from 2.x line (keradus)
* minor #1682 ElseifFixer - handle comments (SpacePossum)
* minor #1689 AbstractIntegrationTest - no need for single-char group and docs grooming (keradus)
* minor #1690 Integration tests - allow to not check priority, introduce IntegrationCase (keradus)
* minor #1701 Fixer - Renamed import alias (GrahamCampbell)
* minor #1708 Update composer.json requirements (keradus)
* minor #1734 Travis: Turn on linting (keradus)
* minor #1736 Integration tests - don't check priority for tests using short_tag fixer (keradus)
* minor #1739 NoTrailingWhitespaceInCommentFixer - move to PSR2 level (keradus)
* minor #1763 Deprecate ConfigInterface::getDir, ConfigInterface::setDir, Finder::setDir (keradus)
* minor #1777 NoTrailingWhitespaceInCommentFixer - fix parent class (keradus)
* minor #1816 PhpUnitDedicateAssertFixer - configuration is not required anymore (keradus)
* minor #1849 DocBlock - The category tag should be together with package (GrahamCampbell)
* minor #1870 Update README.rst (glensc)
* minor #1880 FixCommand - fix stdErr detection (SpacePossum)
* minor #1881 NoEmptyStatementFixer - handle anonymous classes correctly (gharlan)
* minor #1906 .php_cs - use no_useless_else rule (keradus)
* minor #1915 NoEmptyComment - move to Symfony level (SpacePossum)
* minor #1917 BracesFixer - fixed comment handling (gharlan)
* minor #1919 EmptyReturnFixer - move fixer outside of Symfony level (keradus)
* minor #2036 OrderedUseFixer - adjust tests (keradus)
* minor #2056 Travis - run nightly PHP (keradus)
* minor #2061 UnusedUseFixer and LineAfterNamespace - add new integration test (keradus)
* minor #2097 Add lambda tests for 7.0 and 7.1 (SpacePossum)
* minor #2111 .travis.yml - rename PHP 7.1 env (keradus)
* minor #2112 Fix 1.12 line (keradus)
* minor #2118 SilencedDeprecationErrorFixer - adjust level (keradus)
* minor #2132 composer.json - rename package name (keradus)
* minor #2133 Apply ordered_class_elements rule (keradus)
* minor #2138 composer.json - disallow to run on PHP 7.2+ (keradus)

Changelog for v1.11.8
---------------------

* bug #2143 ReadmeCommand - fix running command on phar file (keradus)
* minor #2129 Add .gitattributes to remove unneeded files (Slamdunk)
* minor #2141 Move phar building to PHP 5.6 job as newest box.phar is no longer working on 5.3 (keradus)

Changelog for v1.11.7
---------------------

* bug #2108 ShortArraySyntaxFixer, TernarySpacesFixer, UnalignEqualsFixer - fix priority bug (SpacePossum)
* bug #2092 ConcatWithoutSpacesFixer, OperatorsSpacesFixer - fix too many spaces, fix incorrect fixing of lines with comments (SpacePossum)

Changelog for v1.11.6
---------------------

* bug #2086 Braces - fix bug with comment in method prototype (keradus)
* bug #2077 SingleLineAfterImportsFixer - Do not remove lines between use cases (SpacePossum)
* bug #2079 TernarySpacesFixer - Remove multiple spaces (SpacePossum)
* bug #2087 Fixer - handle PHP7 Errors as well (keradus)
* bug #2072 LowercaseKeywordsFixer - handle CT_CLASS_CONSTANT (tgabi333)
* bug #2066 LineAfterNamespaceFixer - Handle close tag (SpacePossum)
* bug #2057 LineAfterNamespaceFixer - adding too much extra lines where namespace is last statement (keradus)
* bug #2059 OperatorsSpacesFixer - handle declare statement (keradus)
* bug #2060 UnusedUseFixer - fix handling whitespaces around removed import (keradus)
* minor #2071 ShortEchoTagFixer - allow to run tests on PHP 5.3 (keradus)

Changelog for v1.11.5
---------------------

* bug #2012 Properly build phar file for lowest supported PHP version (keradus)
* bug #2037 BracesFixer - add support for anonymous classes (keradus)
* bug #1989 Add support for PHP 7 namespaces (SpacePossum)
* bug #2019 Fixing newlines added after curly brace string index access (jaydiablo)
* bug #1840 [Bug] BracesFixer - Do add a line before close tag (SpacePossum)
* bug #1994 EchoToPrintFixer - Fix T_OPEN_TAG_WITH_ECHO on hhvm (keradus)
* bug #1970 Tokens - handle semi-reserved PHP 7 keywords (keradus)
* minor #2017 PHP7 integration tests (keradus)
* minor #1465 Bump supported HHVM version, improve ShortEchoTagFixer on HHVM (keradus)
* minor #1995 Rely on own phpunit, not one from CI service (keradus)

Changelog for v1.11.4
---------------------

* bug #1956 SelfUpdateCommand - don't update to non-stable version (keradus)
* bug #1963 Fix not wanted unneeded_control_parentheses fixer for clone (Soullivaneuh)
* bug #1960 Fix invalid test cases (keradus)
* bug #1939 BracesFixer - fix handling comment around control token (keradus)
* minor #1927 NewWithBracesFixer - remove invalid testcase (keradus)

Changelog for v1.11.3
---------------------

* bug #1868 NewWithBracesFixer - fix handling more neighbor tokens (keradus)
* bug #1893 BracesFixer - handle comments inside lambda function prototype (keradus)
* bug #1806 SelfAccessorFixer - skip anonymous classes (gharlan)
* bug #1813 BlanklineAfterOpenTagFixer, NoBlankLinesBeforeNamespaceFixer - fix priority (SpacePossum)
* minor #1807 Tokens - simplify isLambda() (gharlan)

Changelog for v1.11.2
---------------------

* bug #1776 EofEndingFixer - new line on end line comment is allowed (Slamdunk)
* bug #1775 FileCacheManager - ignore corrupted serialized data (keradus)
* bug #1769 FunctionDeclarationFixer - fix more cases (keradus)
* bug #1747 Fixer - Fix ordering of fixer when both level and custom fixers are used (SpacePossum)
* bug #1744 Fixer - fix rare situation when file was visited twice (keradus)
* bug #1710 LowercaseConstantFixer - Fix comment cases. (SpacePossum)
* bug #1711 FunctioncallSpaceFixer - do not touch function declarations. (SpacePossum)
* minor #1798 LintManager - meaningful tempnam (Slamdunk)
* minor #1759 UniqueFileIterator - performance improvement (GrahamCampbell)
* minor #1745 appveyor - fix build (keradus)

Changelog for v1.11.1
---------------------

* bug #1680 NewWithBracesFixer - End tags  (SpacePossum)
* bug #1685 EmptyReturnFixer - Make independent of LowercaseConstantsFixer (SpacePossum)
* bug #1640 IntegrationTest - fix directory separator (keradus)
* bug #1595 ShortTagFixer - fix priority (keradus)
* bug #1576 SpacesBeforeSemicolonFixer - do not remove space before semicolon if that space is after a semicolon (SpacePossum)
* bug #1570 UnneededControlParenthesesFixer - fix test samples (keradus)
* minor #1653 Update license year (gharlan)

Changelog for v1.11
-------------------

* feature #1550 Added UnneededControlParenthesesFixer (Soullivaneuh, keradus)
* feature #1532 Added ShortBoolCastFixer (SpacePossum)
* feature #1523 Added EchoToPrintFixer and PrintToEchoFixer (Soullivaneuh)
* feature #1552 Warn when running with xdebug extension (SpacePossum)
* feature #1484 Added ArrayElementNoSpaceBeforeCommaFixer and ArrayElementWhiteSpaceAfterCommaFixer (amarczuk)
* feature #1449 PhpUnitConstructFixer - Fix more use cases (SpacePossum)
* feature #1382 Added PhpdocTypesFixer (GrahamCampbell)
* feature #1384 Add intergration tests (SpacePossum)
* feature #1349 Added FunctionTypehintSpaceFixer (keradus)
* minor #1562 Fix invalid PHP code samples in utests (SpacePossum)
* minor #1560 Fixed project name in xdebug warning (gharlan)
* minor #1545 Fix invalid PHP code samples in utests (SpacePossum)
* minor #1554 Alphabetically sort entries in .gitignore (GrahamCampbell)
* minor #1527 Refactor the way types work on annotations (GrahamCampbell)
* minor #1546 Update coding guide in cookbook (keradus)
* minor #1526 Support more annotations when fixing types in phpdoc (GrahamCampbell)
* minor #1535 clean ups (SpacePossum)
* minor #1510 Added Symfony 3.0 support (Ener-Getick)
* minor #1520 Code grooming (keradus)
* minor #1515 Support property, property-read and property-write tags (GrahamCampbell)
* minor #1488 Added more inline phpdoc tests (GrahamCampbell)
* minor #1496 Add docblock to AbstractFixerTestBase::makeTest (lmanzke)
* minor #1467 PhpdocShortDescriptionFixer - add support for Japanese sentence-ending characters (fritz-c)
* minor #1453 remove calling array_keys in foreach loops (keradus)
* minor #1448 Code grooming (keradus)
* minor #1437 Added import fixers integration test (GrahamCampbell)
* minor #1433 phpunit.xml.dist - disable gc (keradus)
* minor #1427 Change arounded to surrounded in README.rst (36degrees)
* minor #1420 AlignDoubleArrowFixer, AlignEqualsFixer - add integration tests (keradus)
* minor #1423 appveyor.yml - do not cache C:\tools, its internal forAppVeyor (keradus)
* minor #1400 appveyor.yml - add file (keradus)
* minor #1396 AbstractPhpdocTypesFixer - instance method should be called on instance (keradus)
* minor #1395 code grooming (keradus)
* minor #1393 boost .travis.yml file (keradus)
* minor #1372 Don't allow PHP 7 to fail (GrahamCampbell)
* minor #1332 PhpUnitConstructFixer - fix more functions (keradus)
* minor #1339 CONTRIBUTING.md - add link to PSR-5 (keradus)
* minor #1346 Core grooming (SpacePossum)
* minor #1328 Tokens: added typehint for Iterator elements (gharlan)

Changelog for v1.10.3
---------------------

* bug #1559 WhitespacyLinesFixer - fix bug cases (SpacePossum, keradus)
* bug #1541 Psr0Fixer - Ignore filenames that are a reserved keyword or predefined constant (SpacePossum)
* bug #1537 Psr0Fixer - ignore file without name or with name started by digit (keradus)
* bug #1516 FixCommand - fix wrong message for dry-run (SpacePossum)
* bug #1486 ExtraEmptyLinesFixer - Remove extra lines after comment lines too (SpacePossum)
* bug #1503 Psr0Fixer - fix case with comments lying around (GrahamCampbell)
* bug #1474 PhpdocToCommentFixer - fix not properly fixing for block right after namespace (GrahamCampbell)
* bug #1478 BracesFixer - do not remove empty lines after class opening (keradus)
* bug #1468 Add missing ConfigInterface::getHideProgress() (Eugene Leonovich, rybakit)
* bug #1466 Fix bad indent on align double arrow fixer (Soullivaneuh, keradus)
* bug #1479 Tokens - fix detection of short array (keradus)

Changelog for v1.10.2
---------------------

* bug #1461 PhpUnitConstructFixer - fix case when first argument is an expression (keradus)
* bug #1460 AlignDoubleArrowFixer - fix handling of nested arrays (Soullivaneuh, keradus)

Changelog for v1.10.1
---------------------

* bug #1424 Fixed the import fixer priorities (GrahamCampbell)
* bug #1444 OrderedUseFixer - fix next case (keradus)
* bug #1441 BracesFixer - fix next case (keradus)
* bug #1422 AlignDoubleArrowFixer - fix handling of nested array (SpacePossum)
* bug #1425 PhpdocInlineTagFixerTest - fix case when met inalid PHPDoc (keradus)
* bug #1419 AlignDoubleArrowFixer, AlignEqualsFixer - fix priorities (keradus)
* bug #1415 BlanklineAfterOpenTagFixer - Do not add a line break if there is one already. (SpacePossum)
* bug #1410 PhpdocIndentFixer - Fix for open tag (SpacePossum)
* bug #1401 PhpdocVarWithoutNameFixer - Fixed the var without name fixer for inline docs (keradus, GrahamCampbell)
* bug #1369 Fix not well-formed XML output (junichi11)
* bug #1356 Psr0Fixer - disallow run on StdinFileInfo (keradus)

Changelog for v1.10
-------------------

* feature #1306 Added LogicalNotOperatorsWithSuccessorSpaceFixer (phansys)
* feature #1286 Added PhpUnitConstructFixer (keradus)
* feature #1316 Added PhpdocInlineTagFixer (SpacePossum, keradus)
* feature #1303 Added LogicalNotOperatorsWithSpacesFixer (phansys)
* feature #1279 Added PhpUnitStrictFixer (keradus)
* feature #1267 SingleQuoteFixer fix more use cases (SpacePossum)
* minor #1319 PhpUnitConstructFixer - fix performance and add to local .php_cs (keradus)
* minor #1280 Fix non-utf characters in docs (keradus)
* minor #1274 Cookbook - No change auto-test note (Soullivaneuh)

Changelog for v1.9.3
--------------------

* bug #1327 DocBlock\Tag - keep the case of tags (GrahamCampbell)

Changelog for v1.9.2
--------------------

* bug #1313 AlignDoubleArrowFixer - fix aligning after UTF8 chars (keradus)
* bug #1296 PhpdocScalarFixer - fix property annotation too (GrahamCampbell)
* bug #1299 WhitespacyLinesFixer - spaces on next valid line must not be fixed (Slamdunk)

Changelog for v1.9.1
--------------------

* bug #1288 TrimArraySpacesFixer - fix moving first comment (keradus)
* bug #1287 PhpdocParamsFixer - now works on any indentation level (keradus)
* bug #1278 Travis - fix PHP7 build (keradus)
* bug #1277 WhitespacyLinesFixer - stop changing non-whitespacy tokens (SpacePossum, SamBurns-awin, keradus)
* bug #1224 TrailingSpacesFixer - stop changing non-whitespacy tokens (SpacePossum, SamBurns-awin, keradus)
* bug #1266 FunctionCallSpaceFixer - better detection of function call (funivan)
* bug #1255 make sure some phpdoc fixers are run in right order (SpacePossum)

Changelog for v1.9
------------------

* feature #1097 Added ShortEchoTagFixer (vinkla)
* minor #1238 Fixed error handler to respect current error_reporting (JanJakes)
* minor #1234 Add class to exception message, use sprintf for exceptions (SpacePossum)
* minor #1210 set custom error handler for application run (keradus)
* minor #1214 Tokens::isMonolithicPhp - enhance performance (keradus)
* minor #1207 Update code documentation (keradus)
* minor #1202 Update IDE tool urls (keradus)
* minor #1195 PreIncrementFixer - move to Symfony level (gharlan)

Changelog for v1.8.1
--------------------

* bug #1193 EofEndingFixer - do not add an empty line at EOF if the PHP tags have been closed (SpacePossum)
* bug #1209 PhpdocParamsFixer - fix corrupting following custom annotation (keradus)
* bug #1205 BracesFixer - fix missing indentation fixes for class level (keradus)
* bug #1204 Tag - fix treating complex tag as simple PhpDoc tag (keradus)
* bug #1198 Tokens - fixed unary/binary operator check for type-hinted reference arguments (gharlan)
* bug #1201 Php4ConstructorFixer - fix invalid handling of subnamespaces (gharlan)
* minor #1221 Add more tests (SpacePossum)
* minor #1216 Tokens - Add unit test for array detection (SpacePossum)

Changelog for v1.8
------------------

* feature #1168 Added UnalignEqualsFixer (keradus)
* feature #1167 Added UnalignDoubleArrowFixer (keradus)
* bug #1169 ToolInfo - Fix way to find script dir (sp-ian-monge)
* minor #1181 composer.json - Update description (SpacePossum)
* minor #1180 create Tokens::overrideAt method (keradus)

Changelog for v1.7.1
--------------------

* bug #1165 BracesFixer - fix bug when comment is a first statement in control structure without braces (keradus)

Changelog for v1.7
------------------

* feature #1113 Added PreIncrementFixer (gharlan)
* feature #1144 Added PhpdocNoAccessFixer (GrahamCampbell)
* feature #1116 Added SelfAccessorFixer (gharlan)
* feature #1064 OperatorsSpacesFixer enhancements (gharlan)
* bug #1151 Prevent token collection corruption by fixers (stof, keradus)
* bug #1152 LintManager - fix handling of temporary file (keradus)
* bug #1139 NamespaceNoLeadingWhitespaceFixer - remove need for ctype extension (keradus)
* bug #1117 Tokens - fix iterator used with foreach by reference (keradus)
* minor #1148 code grooming (keradus)
* minor #1142 We are actually PSR-4, not PSR-0 (GrahamCampbell)
* minor #1131 Phpdocs and typos (SpacePossum)
* minor #1069 state min HHVM version (keradus)
* minor #1129 [DX] Help developers choose the right branch (SpacePossum)
* minor #1138 PhpClosingTagFixer - simplify flow, no need for loop (keradus)
* minor #1123 Reference mismatches fixed, SCA (kalessil)
* minor #1109 SingleQuoteFixer - made fixer more accurate (gharlan)
* minor #1110 code grooming (kalessil)

Changelog for v1.6.2
--------------------

* bug #1149 UnusedUseFixer - must be run before LineAfterNamespaceFixer, fix token collection corruption (keradus)
* minor #1145 AbstractLinesBeforeNamespaceFixer - fix docs for fixLinesBeforeNamespace (GrahamCampbell)

Changelog for v1.6.1
--------------------

* bug #1108 UnusedUseFixer - fix false positive when name is used as part of another namespace (gharlan)
* bug #1114 Fixed PhpdocParamsFixer with malformed doc block (gharlan)
* minor #1135 PhpdocTrimFixer - fix doc typo (localheinz)
* minor #1093 Travis - test lowest dependencies (boekkooi)

Changelog for v1.6
------------------

* feature #1089 Added NewlineAfterOpenTagFixer and BlanklineAfterOpenTagFixer (ceeram, keradus)
* feature #1090 Added TrimArraySpacesFixer (jaredh159, keradus)
* feature #1058 Added SingleQuoteFixer (gharlan)
* feature #1059 Added LongArraySyntaxFixer (gharlan)
* feature #1037 Added PhpdocScalarFixer (GrahamCampbell, keradus)
* feature #1028 Add ListCommasFixer (keradus)
* bug #1047 Utils::camelCaseToUnderscore - fix regexp (odin-delrio)
* minor #1073 ShortTagFixer enhancement (gharlan)
* minor #1079 Use LongArraySyntaxFixer for this repo (gharlan)
* minor #1070 Tokens::isMonolithicPhp - remove unused T_CLOSE_TAG search (keradus)
* minor #1049 OrderedUseFixer - grooming (keradus)

Changelog for v1.5.2
--------------------

* bug #1025 Fixer - ignore symlinks (kix)
* bug #1071 Psr0Fixer - fix bug for fixing file with long extension like .class.php (keradus)
* bug #1080 ShortTagFixer - fix false positive (gharlan)
* bug #1066 Php4ConstructorFixer - fix causing infinite recursion (mbeccati)
* bug #1056 VisibilityFixer - fix T_VAR with multiple props (localheinz, keradus)
* bug #1065 Php4ConstructorFixer - fix detection of a PHP4 parent constructor variant (mbeccati)
* bug #1060 Tokens::isShortArray: tests and bugfixes (gharlan)
* bug #1057 unused_use: fix false positive when name is only used as variable name (gharlan)

Changelog for v1.5.1
--------------------

* bug #1054 VisibilityFixer - fix var with array value assigned (localheinz, keradus)
* bug #1048 MultilineArrayTrailingCommaFixer, SingleArrayNoTrailingCommaFixer - using heredoc inside array not cousing to treat it as multiline array (keradus)
* bug #1043 PhpdocToCommentFixer - also check other control structures, besides foreach (ceeram)
* bug #1045 OrderedUseFixer - fix namespace order for trailing digits (rusitschka)
* bug #1035 PhpdocToCommentFixer - Add static as valid keyword for structural element (ceeram)
* bug #1020 BracesFixer - fix missing braces for nested if elseif else (malengrin)
* minor #1036 Added php7 to travis build (fonsecas72)
* minor #1026 Fix typo in ShortArraySyntaxFixer (tommygnr)
* minor #1024 code grooming (keradus)

Changelog for v1.5
------------------

* feature #887 Added More Phpdoc Fixers (GrahamCampbell, keradus)
* feature #1002 Add HeaderCommentFixer (ajgarlag)
* feature #974 Add EregToPregFixer (mbeccati)
* feature #970 Added Php4ConstructorFixer (mbeccati)
* feature #997 Add PhpdocToCommentFixer (ceeram, keradus)
* feature #932 Add NoBlankLinesAfterClassOpeningFixer (ceeram)
* feature #879 Add SingleBlankLineBeforeNamespaceFixer and NoBlankLinesBeforeNamespaceFixer (GrahamCampbell)
* feature #860 Add single_line_after_imports fixer (ceeram)
* minor #1014 Fixed a few file headers (GrahamCampbell)
* minor #1011 Fix HHVM as it works different than PHP (keradus)
* minor #1010 Fix invalid UTF-8 char in docs (ajgarlag)
* minor #1003 Fix header comment in php files (ajgarlag)
* minor #1005 Add Utils::calculateBitmask method (keradus)
* minor #973 Add Tokens::findSequence (mbeccati)
* minor #991 Longer explanation of how to use blacklist (bmitch, networkscraper)
* minor #972 Add case sensitive option to the tokenizer (mbeccati)
* minor #986 Add benchmark script (dericofilho)
* minor #985 Fix typo in COOKBOOK-FIXERS.md (mattleff)
* minor #978 Token - fix docs (keradus)
* minor #957 Fix Fixers methods order (GrahamCampbell)
* minor #944 Enable caching of composer downloads on Travis (stof)
* minor #941 EncodingFixer - enhance tests (keradus)
* minor #938 Psr0Fixer - remove unneded assignment (keradus)
* minor #936 FixerTest - test description consistency (keradus)
* minor #933 NoEmptyLinesAfterPhpdocsFixer - remove unneeded code, clarify description (ceeram)
* minor #934 StdinFileInfo::getFilename - Replace phpdoc with normal comment and add back empty line before return (ceeram)
* minor #927 Exclude the resources folder from coverage reports (GrahamCampbell)
* minor #926 Update Token::isGivenKind phpdoc (GrahamCampbell)
* minor #925 Improved AbstractFixerTestBase (GrahamCampbell)
* minor #922 AbstractFixerTestBase::makeTest - test if input is different than expected (keradus)
* minor #904 Refactoring Utils (GrahamCampbell)
* minor #901 Improved Readme Formatting (GrahamCampbell)
* minor #898 Tokens::getImportUseIndexes - simplify function (keradus)
* minor #897 phpunit.xml.dist - split testsuite (keradus)

Changelog for v1.4.2
--------------------

* bug #994 Fix detecting of short arrays (keradus)
* bug #995 DuplicateSemicolonFixer - ignore duplicated semicolons inside T_FOR (keradus)

Changelog for v1.4.1
--------------------

* bug #990 MultilineArrayTrailingCommaFixer - fix case with short array on return (keradus)
* bug #975 NoEmptyLinesAfterPhpdocsFixer - fix only when documentation documents sth (keradus)
* bug #976 PhpdocIndentFixer - fix error when there is a comment between docblock and next meaningful token (keradus, ceeram)

Changelog for v1.4
------------------

* feature #841 PhpdocParamsFixer: added aligning var/type annotations (GrahamCampbell)
* bug #965 Fix detection of lambda function that returns a reference (keradus)
* bug #962 PhpdocIndentFixer - fix bug when documentation is on the end of braces block (keradus)
* bug #961 Fixer - fix handling of empty file (keradus)
* bug #960 IncludeFixer - fix bug when include is part of condition statement (keradus)
* bug #954 AlignDoubleArrowFixer - fix new buggy case (keradus)
* bug #955 ParenthesisFixer - fix case with list call with trailing comma (keradus)
* bug #950 Tokens::isLambda - fix detection near comments (keradus)
* bug #951 Tokens::getImportUseIndexes - fix detection near comments (keradus)
* bug #949 Tokens::isShortArray - fix detection near comments (keradus)
* bug #948 NewWithBracesFixer - fix case with multidimensional array (keradus)
* bug #945 Skip files containing __halt_compiler() on PHP 5.3 (stof)
* bug #946 BracesFixer - fix typo in exception name (keradus)
* bug #940 Tokens::setCode - apply missing transformation (keradus)
* bug #908 BracesFixer - fix invalide inserting brace for control structure without brace and lambda inside of it (keradus)
* bug #903 NoEmptyLinesAfterPhpdocsFixer - fix bug with Windows style lines (GrahamCampbell)
* bug #895 [PSR-2] Preserve blank line after control structure opening brace (marcaube)
* bug #892 Fixed the double arrow multiline whitespace fixer (GrahamCampbell)
* bug #874 BracesFixer - fix bug of removing empty lines after class' opening { (ceeram)
* bug #868 BracesFixer - fix missing braces when statement is not followed by ; (keradus)
* bug #861 Updated PhpdocParamsFixer not to change line endings (keradus, GrahamCampbell)
* bug #837 FixCommand - stop corrupting xml/json format (keradus)
* bug #846 Made phpdoc_params run after phpdoc_indent (GrahamCampbell)
* bug #834 Correctly handle tab indentation (ceeram)
* bug #822 PhpdocIndentFixer - Ignore inline docblocks (ceeram)
* bug #813 MultilineArrayTrailingCommaFixer - do not move array end to new line (keradus)
* bug #817 LowercaseConstantsFixer - ignore class' constants TRUE/FALSE/NULL (keradus)
* bug #821 JoinFunctionFixer - stop changing declaration method name (ceeram)
* minor #963 State the minimum version of PHPUnit in CONTRIBUTING.md (SpacePossum)
* minor #943 Improve the cookbook to use relative links (stof)
* minor #921 Add changelog file (keradus)
* minor #909 BracesFixerTest - no \n line in \r\n test (keradus)
* minor #864 Added NoEmptyLinesAfterPhpdocsFixer (GrahamCampbell)
* minor #871 Added missing author (GrahamCampbell)
* minor #852 Fixed the coveralls version constraint (GrahamCampbell)
* minor #863 Tweaked testRetainsNewLineCharacters (GrahamCampbell)
* minor #849 Removed old alias (GrahamCampbell)
* minor #843 integer should be int (GrahamCampbell)
* minor #830 Remove whitespace before opening tag (ceeram)
* minor #835 code grooming (keradus)
* minor #828 PhpdocIndentFixerTest - code grooming (keradus)
* minor #827 UnusedUseFixer - code grooming (keradus)
* minor #825 improve code coverage (keradus)
* minor #810 improve code coverage (keradus)
* minor #811 ShortArraySyntaxFixer - remove not needed if statement (keradus)

Changelog for v1.3
------------------

* feature #790 Add docblock indent fixer (ceeram)
* feature #771 Add JoinFunctionFixer (keradus)
* bug #798 Add DynamicVarBrace Transformer for properly handling ${$foo} syntax (keradus)
* bug #796 LowercaseConstantsFixer - rewrite to handle new test cases (keradus)
* bug #789 T_CASE is not succeeded by parentheses (dericofilho)
* minor #814 Minor improvements to the phpdoc_params fixer (GrahamCampbell)
* minor #815 Minor fixes (GrahamCampbell)
* minor #782 Cookbook on how to make a new fixer (dericofilho)
* minor #806 Fix Tokens::detectBlockType call (keradus)
* minor #758 travis - disable sudo (keradus)
* minor #808 Tokens - remove commented code (keradus)
* minor #802 Address Sensiolabs Insight's warning of code cloning. (dericofilho)
* minor #803 README.rst - fix \` into \`\` (keradus)

Changelog for v1.2
------------------

* feature #706 Remove lead slash (dericofilho)
* feature #740 Add EmptyReturnFixer (GrahamCampbell)
* bug #775 PhpClosingTagFixer - fix case with T_OPEN_TAG_WITH_ECHO (keradus)
* bug #756 Fix broken cases for AlignDoubleArrowFixer (dericofilho)
* bug #763 MethodArgumentSpaceFixer - fix receiving data in list context with omitted values (keradus)
* bug #759 Fix Tokens::isArrayMultiLine (stof, keradus)
* bug #754 LowercaseKeywordsFixer - __HALT_COMPILER must not be lowercased (keradus)
* bug #753 Fix for double arrow misalignment in deeply nested arrays. (dericofilho)
* bug #752 OrderedUseFixer should be case-insensitive (rusitschka)
* minor #779 Fixed a docblock type (GrahamCampbell)
* minor #765 Typehinting in FileCacheManager, remove unused variable in Tokens (keradus)
* minor #764 SelfUpdateCommand - get local version only if remote version was successfully obtained (keradus)
* minor #761 aling => (keradus)
* minor #757 Some minor code simplify and extra test (keradus)
* minor #713 Download php-cs-fixer.phar without sudo (michaelsauter)
* minor #742 Various Minor Improvements (GrahamCampbell)

Changelog for v1.1
------------------

* feature #749 remove the --no-progress option (replaced by the standard -v) (fabpot, keradus)
* feature #728 AlignDoubleArrowFixer - standardize whitespace after => (keradus)
* feature #647 Add DoubleArrowMultilineWhitespacesFixer (dericofilho, keradus)
* bug #746 SpacesBeforeSemicolonFixerTest - fix bug with semicolon after comment (keradus)
* bug #741 Fix caching when composer is installed in custom path (cmodijk)
* bug #725 DuplicateSemicolonFixer - fix clearing whitespace after duplicated semicolon (keradus)
* bug #730 Cache busting when fixers list changes (Seldaek)
* bug #722 Fix lint for STDIN-files (ossinkine)
* bug #715 TrailingSpacesFixer - fix bug with french UTF-8 chars (keradus)
* bug #718 Fix package name for composer cache (Seldaek)
* bug #711 correct vendor name (keradus)
* minor #745 Show progress by default and allow to disable it (keradus)
* minor #731 Add a way to disable all default filters and really provide a whitelist (Seldaek)
* minor #737 Extract tool info into new class, self-update command works now only for PHAR version (keradus)
* minor #739 fix fabbot issues (keradus)
* minor #726 update CONTRIBUTING.md for installing dependencies (keradus)
* minor #736 Fix fabbot issues (GrahamCampbell)
* minor #727 Fixed typos (pborreli)
* minor #719 Add update instructions for composer and caching docs (Seldaek)

Changelog for v1.0
------------------

First stable release.
