<?php

namespace Faker\Provider\ru_RU;

class Text extends \Faker\Provider\Text
{
    public function realText($maxNbChars = 200, $indexSize = 2)
    {
        $realText = parent::realText($maxNbChars, $indexSize);

        return iconv('UTF-8', 'UTF-8//IGNORE', $realText);
    }

    /**
     * From ru.wikisource.org
     *
     * Текст доступен по лицензии Creative Commons Attribution-ShareAlike,
     * в отдельных случаях могут действовать дополнительные условия.
     * Подробнее см. Условия использования.
     *
     *
     * Title: Мертвые души
     *
     * Author: Гоголь Николай
     *
     * Posting Date: May 20, 2008
     * [Last updated: August 2, 2012]
     *
     * Language: Russian
     *
     * @see     https://wikimediafoundation.org/wiki/Terms_of_Use/
     * @link    http://ru.wikisource.org/wiki/%D0%9C%D1%91%D1%80%D1%82%D0%B2%D1%8B%D0%B5_%D0%B4%D1%83%D1%88%D0%B8_(%D0%93%D0%BE%D0%B3%D0%BE%D0%BB%D1%8C)/%D0%A2%D0%BE%D0%BC_I/%D0%93%D0%BB%D0%B0%D0%B2%D0%B0_I
     * @var string
     */
    protected static $baseText = <<<'EOT'

Глава первая

В ворота гостиницы губернского города NN въехала довольно красивая
рессорная небольшая бричка, в какой ездят холостяки: отставные
подполковники, штабс-капитаны, помещики, имеющие около сотни душ
крестьян, — словом, все те, которых называют господами средней руки. В
бричке сидел господин, не красавец, но и не дурной наружности, ни
слишком толст, ни слишком тонок; нельзя сказать, чтобы стар, однако ж
и не так, чтобы слишком молод. Въезд его не произвел в городе
совершенно никакого шума и не был сопровожден ничем особенным; только
два русские мужика, стоявшие у дверей кабака против гостиницы, сделали
кое-какие замечания, относившиеся, впрочем, более к экипажу, чем к
сидевшему в нем. «Вишь ты, — сказал один другому, — вон какое колесо!
что ты думаешь, доедет то колесо, если б случилось, в Москву или не
доедет?» — «Доедет», — отвечал другой. «А в Казань-то, я думаю, не
доедет?» — «В Казань не доедет», — отвечал другой. Этим разговор и
кончился. Да еще, когда бричка подъехала к гостинице, встретился
молодой человек в белых канифасовых панталонах, весьма узких и
коротких, во фраке с покушеньями на моду, из-под которого видна была
манишка, застегнутая тульскою булавкою с бронзовым пистолетом. Молодой
человек оборотился назад, посмотрел экипаж, придержал рукою картуз,
чуть не слетевший от ветра, и пошел своей дорогой.

Когда экипаж въехал на двор, господин был встречен трактирным слугою,
или половым, как их называют в русских трактирах, живым и вертлявым до
такой степени, что даже нельзя было рассмотреть, какое у него было
лицо. Он выбежал проворно, с салфеткой в руке, — весь длинный и в
длинном демикотонном сюртуке со спинкою чуть не на самом затылке,
встряхнул волосами и повел проворно господина вверх по всей деревянной
галерее показывать ниспосланный ему богом покой. Покой был известного
рода, ибо гостиница была тоже известного рода, то есть именно такая,
как бывают гостиницы в губернских городах, где за два рубля в сутки
проезжающие получают покойную комнату с тараканами, выглядывающими,
как чернослив, из всех углов, и дверью в соседнее помещение, всегда
заставленною комодом, где устроивается сосед, молчаливый и спокойный
человек, но чрезвычайно любопытный, интересующийся знать о всех
подробностях проезжающего. Наружный фасад гостиницы отвечал ее
внутренности: она была очень длинна, в два этажа; нижний не был
выщекатурен и оставался в темно-красных кирпичиках, еще более
потемневших от лихих погодных перемен и грязноватых уже самих по себе;
верхний был выкрашен вечною желтою краскою; внизу были лавочки с
хомутами, веревками и баранками. В угольной из этих лавочек, или,
лучше, в окне, помещался сбитенщик с самоваром из красной меди и лицом
так же красным, как самовар, так что издали можно бы подумать, что на
окне стояло два самовара, если б один самовар не был с черною как
смоль бородою.

Пока приезжий господин осматривал свою комнату, внесены были его
пожитки: прежде всего чемодан из белой кожи, несколько поистасканный,
показывавший, что был не в первый раз в дороге. Чемодан внесли кучер
Селифан, низенький человек в тулупчике, и лакей Петрушка, малый лет
тридцати, в просторном подержанном сюртуке, как видно с барского
плеча, малый немного суровый на взгляд, с очень крупными губами и
носом. Вслед за чемоданом внесен был небольшой ларчик красного дерева
с штучными выкладками из карельской березы, сапожные колодки и
завернутая в синюю бумагу жареная курица. Когда все это было внесено,
кучер Селифан отправился на конюшню возиться около лошадей, а лакей
Петрушка стал устроиваться в маленькой передней, очень темной конурке,
куда уже успел притащить свою шинель и вместе с нею какой-то свой
собственный запах, который был сообщен и принесенному вслед за тем
мешку с разным лакейским туалетом. В этой конурке он приладил к стене
узенькую трехногую кровать, накрыв ее небольшим подобием тюфяка,
убитым и плоским, как блин, и, может быть, так же замаслившимся, как
блин, который удалось ему вытребовать у хозяина гостиницы.

Покамест слуги управлялись и возились, господин отправился в общую
залу. Какие бывают эти общие залы — всякий проезжающий знает очень
хорошо: те же стены, выкрашенные масляной краской, потемневшие вверху
от трубочного дыма и залосненные снизу спинами разных проезжающих, а
еще более туземными купеческими, ибо купцы по торговым дням приходили
сюда сам-шест и сам-сём испивать свою известную пару чаю; тот же
закопченный потолок; та же копченая люстра со множеством висящих
стеклышек, которые прыгали и звенели всякий раз, когда половой бегал
по истертым клеенкам, помахивая бойко подносом, на котором сидела
такая же бездна чайных чашек, как птиц на морском берегу; те же
картины во всю стену, писанные масляными красками, — словом, все то
же, что и везде; только и разницы, что на одной картине изображена
была нимфа с такими огромными грудями, какие читатель, верно, никогда
не видывал. Подобная игра природы, впрочем, случается на разных
исторических картинах, неизвестно в какое время, откуда и кем
привезенных к нам в Россию, иной раз даже нашими вельможами,
любителями искусств, накупившими их в Италии по совету везших их
курьеров. Господин скинул с себя картуз и размотал с шеи шерстяную,
радужных цветов косынку, какую женатым приготовляет своими руками
супруга, снабжая приличными наставлениями, как закутываться, а
холостым — наверное не могу сказать, кто делает, бог их знает, я
никогда не носил таких косынок. Размотавши косынку, господин велел
подать себе обед. Покамест ему подавались разные обычные в трактирах
блюда, как-то: щи с слоеным пирожком, нарочно сберегаемым для
проезжающих в течение нескольких неделей, мозги с горошком, сосиски с
капустой, пулярка жареная, огурец соленый и вечный слоеный сладкий
пирожок, всегда готовый к услугам; покамест ему все это подавалось и
разогретое, и просто холодное, он заставил слугу, или полового,
рассказывать всякий вздор — о том, кто содержал прежде трактир и кто
теперь, и много ли дает дохода, и большой ли подлец их хозяин; на что
половой, по обыкновению, отвечал: «О, большой, сударь, мошенник». Как
в просвещенной Европе, так и в просвещенной России есть теперь весьма
много почтенных людей, которые без того не могут покушать в трактире,
чтоб не поговорить с слугою, а иногда даже забавно пошутить над ним.
Впрочем, приезжий делал не всё пустые вопросы; он с чрезвычайною
точностию расспросил, кто в городе губернатор, кто председатель
палаты, кто прокурор, — словом, не пропустил ни одного значительного
чиновника; но еще с большею точностию, если даже не с участием,
расспросил обо всех значительных помещиках: сколько кто имеет душ
крестьян, как далеко живет от города, какого даже характера и как
часто приезжает в город; расспросил внимательно о состоянии края: не
было ли каких болезней в их губернии — повальных горячек, убийственных
какие-либо лихорадок, оспы и тому подобного, и все так обстоятельно и
с такою точностию, которая показывала более, чем одно простое
любопытство. В приемах своих господин имел что-то солидное и
высмаркивался чрезвычайно громко. Неизвестно, как он это делал, но
только нос его звучал, как труба. Это, по-моему, совершенно невинное
достоинство приобрело, однако ж, ему много уважения со стороны
трактирного слуги, так что он всякий раз, когда слышал этот звук,
встряхивал волосами, выпрямливался почтительнее и, нагнувши с вышины
свою голову, спрашивал: не нужно ли чего? После обеда господин выкушал
чашку кофею и сел на диван, подложивши себе за спину подушку, которую
в русских трактирах вместо эластической шерсти набивают чем-то
чрезвычайно похожим на кирпич и булыжник. Тут начал он зевать и
приказал отвести себя в свой нумер, где, прилегши, заснул два часа.
Отдохнувши, он написал на лоскутке бумажки, по просьбе трактирного
слуги, чин, имя и фамилию для сообщения куда следует, в полицию. На
бумажке половой, спускаясь с лестницы, прочитал по складам следующее:
«Коллежский советник Павел Иванович Чичиков, помещик, по своим
надобностям». Когда половой все еще разбирал по складам записку, сам
Павел Иванович Чичиков отправился посмотреть город, которым был, как
казалось, удовлетворен, ибо нашел, что город никак не уступал другим
губернским городам: сильно била в глаза желтая краска на каменных
домах и скромно темнела серая на деревянных. Домы были в один, два и
полтора этажа, с вечным мезонином, очень красивым, по мнению
губернских архитекторов. Местами эти дома казались затерянными среди
широкой, как поле, улицы и нескончаемых деревянных заборов; местами
сбивались в кучу, и здесь было заметно более движения народа и
живости. Попадались почти смытые дождем вывески с кренделями и
сапогами, кое-где с нарисованными синими брюками и подписью какого-то
Аршавского портного; где магазин с картузами, фуражками и надписью:
«Иностранец Василий Федоров»; где нарисован был бильярд с двумя
игроками во фраках, в какие одеваются у нас на театрах гости, входящие
в последнем акте на сцену. Игроки были изображены с прицелившимися
киями, несколько вывороченными назад руками и косыми ногами, только
что сделавшими на воздухе антраша. Под всем этим было написано: «И вот
заведение». Кое-где просто на улице стояли столы с орехами, мылом и
пряниками, похожими на мыло; где харчевня с нарисованною толстою рыбою
и воткнутою в нее вилкою. Чаще же всего заметно было потемневших
двуглавых государственных орлов, которые теперь уже заменены
лаконическою надписью: «Питейный дом». Мостовая везде была плоховата.
Он заглянул и в городской сад, который состоял из тоненьких дерев,
дурно принявшихся, с подпорками внизу, в виде треугольников, очень
красиво выкрашенных зеленою масляною краскою. Впрочем, хотя эти
деревца были не выше тростника, о них было сказано в газетах при
описании иллюминации, что «город наш украсился, благодаря попечению
гражданского правителя, садом, состоящим из тенистых, широковетвистых
дерев, дающих прохладу в знойный день», и что при этом «было очень
умилительно глядеть, как сердца граждан трепетали в избытке
благодарности и струили потоки слез в знак признательности к господину
градоначальнику». Расспросивши подробно будочника, куда можно пройти
ближе, если понадобится, к собору, к присутственным местам, к
губернатору, он отправился взглянуть на реку, протекавшую посредине
города, дорогою оторвал прибитую к столбу афишу, с тем чтобы, пришедши
домой, прочитать ее хорошенько, посмотрел пристально на проходившую по
деревянному тротуару даму недурной наружности, за которой следовал
мальчик в военной ливрее, с узелком в руке, и, еще раз окинувши все
глазами, как бы с тем, чтобы хорошо припомнить положение места,
отправился домой прямо в свой нумер, поддерживаемый слегка на лестнице
трактирным слугою. Накушавшись чаю, он уселся перед столом, велел
подать себе свечу, вынул из кармана афишу, поднес ее к свече и стал
читать, прищуря немного правый глаз. Впрочем, замечательного немного
было в афишке: давалась драма г. Коцебу, в которой Ролла играл г.
Попльвин, Кору — девица Зяблова, прочие лица были и того менее
замечательны; однако же он прочел их всех, добрался даже до цены
партера и узнал, что афиша была напечатана в типографии губернского
правления, потом переворотил на другую сторону: узнать, нет ли и там
чего-нибудь, но, не нашедши ничего, протер глаза, свернул опрятно и
положил в свой ларчик, куда имел обыкновение складывать все, что ни
попадалось. День, кажется, был заключен порцией холодной телятины,
бутылкою кислых щей и крепким сном во всю насосную завертку, как
выражаются в иных местах обширного русского государства.

Весь следующий день посвящен был визитам; приезжий отправился делать
визиты всем городским сановникам. Был с почтением у губернатора,
который, как оказалось, подобно Чичикову был ни толст, ни тонок собой,
имел на шее Анну, и поговаривали даже, что был представлен к звезде;
впрочем, был большой добряк и даже сам вышивал иногда по тюлю. Потом
отправился к вице-губернатору, потом был у прокурора, у председателя
палаты, у полицеймейстера, у откупщика, у начальника над казенными
фабриками… жаль, что несколько трудно упомнить всех сильных мира сего;
но довольно сказать, что приезжий оказал необыкновенную деятельность
насчет визитов: он явился даже засвидетельствовать почтение инспектору
врачебной управы и городскому архитектору. И потом еще долго сидел в
бричке, придумывая, кому бы еще отдать визит, да уж больше в городе не
нашлось чиновников. В разговорах с сими властителями он очень искусно
умел польстить каждому. Губернатору намекнул как-то вскользь, что в
его губернию въезжаешь, как в рай, дороги везде бархатные, и что те
правительства, которые назначают мудрых сановников, достойны большой
похвалы. Полицеймейстеру сказал что-то очень лестное насчет городских
будочников; а в разговорах с вице-губернатором и председателем палаты,
которые были еще только статские советники, сказал даже ошибкою два
раза: «ваше превосходительство», что очень им понравилось. Следствием
этого было то, что губернатор сделал ему приглашение пожаловать к нему
того же дня на домашнюю вечеринку, прочие чиновники тоже, с своей
стороны, кто на обед, кто на бостончик, кто на чашку чаю.

О себе приезжий, как казалось, избегал много говорить; если же
говорил, то какими-то общими местами, с заметною скромностию, и
разговор его в таких случаях принимал несколько книжные обороты: что
он незначащий червь мира сего и не достоин того, чтобы много о нем
заботились, что испытал много на веку своем, претерпел на службе за
правду, имел много неприятелей, покушавшихся даже на жизнь его, и что
теперь, желая успокоиться, ищет избрать наконец место для жительства,
и что, прибывши в этот город, почел за непременный долг
засвидетельствовать свое почтение первым его сановникам. Вот все, что
узнали в городе об этом новом лице, которое очень скоро не преминуло
показать себя на губернаторской вечеринке. Приготовление к этой
вечеринке заняло с лишком два часа времени, и здесь в приезжем
оказалась такая внимательность к туалету, какой даже не везде
видывано. После небольшого послеобеденного сна он приказал подать
умыться и чрезвычайно долго тер мылом обе щеки, подперши их извнутри
языком; потом, взявши с плеча трактирного слуги полотенце, вытер им со
всех сторон полное свое лицо, начав из-за ушей и фыркнув прежде раза
два в самое лицо трактирного слуги. Потом надел перед зеркалом
манишку, выщипнул вылезшие из носу два волоска и непосредственно за
тем очутился во фраке брусничного цвета с искрой. Таким образом
одевшись, покатился он в собственном экипаже по бесконечно широким
улицам, озаренным тощим освещением из кое-где мелькавших океан.
Впрочем, губернаторский дом был так освещен, хоть бы и для бала;
коляска с фонарями, перед подъездом два жандарма, форейторские крики
вдали — словом, всё как нужно. Вошедши в зал, Чичиков должен был на
минуту зажмурить глаза, потому что блеск от свечей, ламп и дамских
платьев был страшный. Все было залито светом. Черные фраки мелькали и
носились врознь и кучами там и там, как носятся мухи на белом сияющем
рафинаде в пору жаркого июльского лета, когда старая ключница рубит и
делит его на сверкающие обломки перед открытым окном; дети все глядят,
собравшись вокруг, следя любопытно за движениями жестких рук ее,
подымающих молот, а воздушные эскадроны мух, поднятые легким воздухом,
влетают смело, как полные хозяева, и, пользуясь подслеповатостию
старухи и солнцем, беспокоящим глаза ее, обсыпают лакомые куски где
вразбитную, где густыми кучами Насыщенные богатым летом, и без того на
всяком шагу расставляющим лакомые блюда, они влетели вовсе не с тем,
чтобы есть, но чтобы только показать себя, пройтись взад и вперед по
сахарной куче, потереть одна о другую задние или передние ножки, или
почесать ими у себя под крылышками, или, протянувши обе передние
лапки, потереть ими у себя над головою, повернуться и опять улететь, и
опять прилететь с новыми докучными эскадронами. Не успел Чичиков
осмотреться, как уже был схвачен под руку губернатором, который
представил его тут же губернаторше. Приезжий гость и тут не уронил
себя: он сказал какой-то комплимент, весьма приличный для человека
средних лет, имеющего чин не слишком большой и не слишком малый. Когда
установившиеся пары танцующих притиснули всех к стене, он, заложивши
руки назад, глядел на них минуты две очень внимательно. Многие дамы
были хорошо одеты и по моде, другие оделись во что бог послал в
губернский город. Мужчины здесь, как и везде, были двух родов: одни
тоненькие, которые всё увивались около дам; некоторые из них были
такого рода, что с трудом можно было отличить их от петербургских,
имели так же весьма обдуманно и со вкусом зачесанные бакенбарды или
просто благовидные, весьма гладко выбритые овалы лиц, так же небрежно
подседали к дамам, так же говорили по-французски и смешили дам так же,
как и в Петербурге. Другой род мужчин составляли толстые или такие же,
как Чичиков, то есть не так чтобы слишком толстые, однако ж и не
тонкие. Эти, напротив того, косились и пятились от дам и посматривали
только по сторонам, не расставлял ли где губернаторский слуга зеленого
стола для виста. Лица у них были полные и круглые, на иных даже были
бородавки, кое-кто был и рябоват, волос они на голове не носили ни
хохлами, ни буклями, ни на манер «черт меня побери», как говорят
французы, — волосы у них были или низко подстрижены, или прилизаны, а
черты лица больше закругленные и крепкие. Это были почетные чиновники
в городе. Увы! толстые умеют лучше на этом свете обделывать дела свои,
нежели тоненькие. Тоненькие служат больше по особенным поручениям или
только числятся и виляют туда и сюда; их существование как-то слишком
легко, воздушно и совсем ненадежно. Толстые же никогда не занимают
косвенных мест, а все прямые, и уж если сядут где, то сядут надежно и
крепко, так что скорей место затрещит и угнется под ними, а уж они не
слетят. Наружного блеска они не любят; на них фрак не так ловко
скроен, как у тоненьких, зато в шкатулках благодать божия. У
тоненького в три года не остается ни одной души, не заложенной в
ломбард; у толстого спокойно, глядь — и явился где-нибудь в конце
города дом, купленный на имя жены, потом в другом конце другой дом,
потом близ города деревенька, потом и село со всеми угодьями. Наконец
толстый, послуживши богу и государю, заслуживши всеобщее уважение,
оставляет службу, перебирается и делается помещиком, славным русским
барином, хлебосолом, и живет, и хорошо живет. А после него опять
тоненькие наследники спускают, по русскому обычаю, на курьерских все
отцовское добро. Нельзя утаить, что почти такого рода размышления
занимали Чичикова в то время, когда он рассматривал общество, и
следствием этого было то, что он наконец присоединился к толстым, где
встретил почти все знакомые лица: прокурора с весьма черными густыми
бровями и несколько подмигивавшим левым глазом так, как будто бы
говорил: «Пойдем, брат, в другую комнату, там я тебе что-то скажу», —
человека, впрочем, серьезного и молчаливого; почтмейстера, низенького
человека, но остряка и философа; председателя палаты, весьма
рассудительного и любезного человека, — которые все приветствовали
его, как старинного знакомого, на что Чичиков раскланивался несколько
набок, впрочем, не без приятности. Тут же познакомился он с весьма
обходительным и учтивым помещиком Маниловым и несколько неуклюжим на
взгляд Собакевичем, который с первого раза ему наступил на ногу,
сказавши: «Прошу прощения». Тут же ему всунули карту на вист, которую
он принял с таким же вежливым поклоном. Они сели за зеленый стол и не
вставали уже до ужина. Все разговоры совершенно прекратились, как
случается всегда, когда наконец предаются занятию дельному. Хотя
почтмейстер был очень речист, но и тот, взявши в руки карты, тот же
час выразил на лице своем мыслящую физиономию, покрыл нижнею губою
верхнюю и сохранил такое положение во все время игры. Выходя с фигуры,
он ударял по столу крепко рукою, приговаривая, если была дама: «Пошла,
старая попадья!», если же король: «Пошел, тамбовский мужик!» А
председатель приговаривал: «А я его по усам! А я ее по усам!» Иногда
при ударе карт по столу вырывались выражения: «А! была не была, не с
чего, так с бубен!» Или же просто восклицания: «черви! червоточина!
пикенция!» или: «пикендрас! пичурущух! пичура!» и даже просто:
«пичук!» — названия, которыми перекрестили они масти в своем обществе.
По окончании игры спорили, как водится, довольно громко. Приезжий наш
гость также спорил, но как-то чрезвычайно искусно, так что все видели,
что он спорил, а между тем приятно спорил. Никогда он не говорил: «вы
пошли», но: «вы изволили пойти», «я имел честь покрыть вашу двойку» и
тому подобное. Чтобы еще более согласить в чем-нибудь своих
противников, он всякий раз подносил им всем свою серебряную с финифтью
табакерку, на дне которой заметили две фиалки, положенные туда для
запаха. Внимание приезжего особенно заняли помещики Манилов и
Собакевич, о которых было упомянуто выше. Он тотчас же осведомился о
них, отозвавши тут же несколько в сторону председателя и почтмейстера.
Несколько вопросов, им сделанных, показали в госте не только
любознательность, но и основательность; ибо прежде всего расспросил
он, сколько у каждого из них душ крестьян и в каком положении
находятся их имения, а потом уже осведомился, как имя и отчество. В
немного времени он совершенно успел очаровать их. Помещик Манилов, еще
вовсе человек не пожилой, имевший глаза сладкие, как сахар, и щуривший
их всякий раз, когда смеялся, был от него без памяти. Он очень долго
жал ему руку и просил убедительно сделать ему честь своим приездом в
деревню, к которой, по его словам, было только пятнадцать верст от
городской заставы. На что Чичиков с весьма вежливым наклонением головы
и искренним пожатием руки отвечал, что он не только с большою охотою
готов это исполнить, но даже почтет за священнейший долг. Собакевич
тоже сказал несколько лаконически: «И ко мне прошу», — шаркнувши
ногою, обутою в сапог такого исполинского размера, которому вряд ли
где можно найти отвечающую ногу, особливо в нынешнее время, когда и на
Руси начинают выводиться богатыри.

На другой день Чичиков отправился на обед и вечер к полицеймейстеру,
где с трех часов после обеда засели в вист и играли до двух часов
ночи. Там, между прочим, он познакомился с помещиком Ноздревым,
человеком лет тридцати, разбитным малым, который ему после трех-
четырех слов начал говорить «ты». С полицеймейстером и прокурором
Ноздрев тоже был на «ты» и обращался по-дружески; но, когда сели
играть в большую игру, полицеймейстер и прокурор чрезвычайно
внимательно рассматривали его взятки и следили почти за всякою картою,
с которой он ходил. На другой день Чичиков провел вечер у председателя
палаты, который принимал гостей своих в халате, несколько замасленном,
и в том числе двух каких-то дам. Потом был на вечере у вице-
губернатора, на большом обеде у откупщика, на небольшом обеде у
прокурора, который, впрочем, стоил большого; на закуске после обедни,
данной городским главою, которая тоже стоила обеда. Словом, ни одного
часа не приходилось ему оставаться дома, и в гостиницу приезжал он с
тем только, чтобы заснуть. Приезжий во всем как-то умел найтиться и
показал в себе опытного светского человека. О чем бы разговор ни был,
он всегда умел поддержать его: шла ли речь о лошадином заводе, он
говорил и о лошадином заводе; говорили ли о хороших собаках, и здесь
он сообщал очень дельные замечания; трактовали ли касательно
следствия, произведенного казенною палатою, — он показал, что ему
небезызвестны и судейские проделки; было ли рассуждение о бильярдной
игре — и в бильярдной игре не давал он промаха; говорили ли о
добродетели, и о добродетели рассуждал он очень хорошо, даже со
слезами на глазах; об выделке горячего вина, и в горячем вине знал он
прок; о таможенных надсмотрщиках и чиновниках, и о них он судил так,
как будто бы сам был и чиновником и надсмотрщиком. Но замечательно,
что он все это умел облекать какою-то степенностью, умел хорошо
держать себя. Говорил ни громко, ни тихо, а совершенно так, как
следует. Словом, куда ни повороти, был очень порядочный человек. Все
чиновники были довольны приездом нового лица. Губернатор об нем
изъяснился, что он благонамеренный человек; прокурор — что он дельный
человек; жандармский полковник говорил, что он ученый человек;
председатель палаты — что он знающий и почтенный человек;
полицеймейстер — что он почтенный и любезный человек; жена
полицеймейстера — что он любезнейший и обходительнейший человек. Даже
сам Собакевич, который редко отзывался о ком-нибудь с хорошей стороны,
приехавши довольно поздно из города и уже совершенно раздевшись и
легши на кровать возле худощавой жены своей, сказал ей: «Я, душенька,
был у губернатора на вечере, и у полицеймейстера обедал, и
познакомился с коллежским советником Павлом Ивановичем Чичиковым:
преприятный человек!» На что супруга отвечала: «Гм!»— и толкнула его
ногою.

Такое мнение, весьма лестное для гостя, составилось о нем в городе, и
оно держалось до тех пор, покамест одно странное свойство гостя и
предприятие, или, как говорят в провинциях, пассаж, о котором читатель
скоро узнает, не привело в совершенное недоумение почти всего города.






Глава вторая


Уже более недели приезжий господин жил в городе, разъезжая по
вечеринкам и обедам и таким образом проводя, как говорится, очень
приятно время. Наконец он решился перенести свои визиты за город и
навестить помещиков Манилова и Собакевича, которым дал слово. Может
быть, к сему побудила его другая, более существенная причина, дело
более серьезное, близшее к сердцу… Но обо всем этом читатель узнает
постепенно и в свое время, если только будет иметь терпение прочесть
предлагаемую повесть, очень длинную, имеющую после раздвинуться шире и
просторнее по мере приближения к концу, венчающему дело. Кучеру
Селифану отдано было приказание рано поутру заложить лошадей в
известную бричку; Петрушке приказано было оставаться дома, смотреть за
комнатой и чемоданом. Для читателя будет не лишним познакомиться с
сими двумя крепостными людьми нашего героя. Хотя, конечно, они лица не
так заметные, и то, что называют второстепенные или даже
третьестепенные, хотя главные ходы и пружины поэмы не на них
утверждены и разве кое-где касаются и легко зацепляют их, — но автор
любит чрезвычайно быть обстоятельным во всем и с этой стороны,
несмотря на то что сам человек русский, хочет быть аккуратен, как
немец. Это займет, впрочем, не много времени и места, потому что не
много нужно прибавить к тому, что уже читатель знает, то есть что
Петрушка ходил в несколько широком коричневом сюртуке с барского плеча
и имел по обычаю людей своего звания, крупный нос и губы. Характера он
был больше молчаливого, чем разговорчивого; имел даже благородное
побуждение к просвещению, то есть чтению книг, содержанием которых не
затруднялся: ему было совершенно все равно, похождение ли влюбленного
героя, просто букварь или молитвенник, — он всё читал с равным
вниманием; если бы ему подвернули химию, он и от нее бы не отказался.
Ему нравилось не то, о чем читал он, но больше самое чтение, или,
лучше сказать, процесс самого чтения, что вот-де из букв вечно выходит
какое-нибудь слово, которое иной раз черт знает что и значит. Это
чтение совершалось более в лежачем положении в передней, на кровати и
на тюфяке, сделавшемся от такого обстоятельства убитым и тоненьким,
как лепешка. Кроме страсти к чтению, он имел еще два обыкновения,
составлявшие две другие его характерические черты: спать не
раздеваясь, так, как есть, в том же сюртуке, и носить всегда с собою
какой-то свой особенный воздух, своего собственного запаха,
отзывавшийся несколько жилым покоем, так что достаточно было ему
только пристроить где-нибудь свою кровать, хоть даже в необитаемой
дотоле комнате, да перетащить туда шинель и пожитки, и уже казалось,
что в этой комнате лет десять жили люди. Чичиков, будучи человек
весьма щекотливый и даже в некоторых случаях привередливый, потянувши
к себе воздух на свежий нос поутру, только помарщивался да встряхивал
головою, приговаривая: «Ты, брат, черт тебя знает, потеешь, что ли.
Сходил бы ты хоть в баню». На что Петрушка ничего не отвечал и
старался тут же заняться какие-нибудь делом; или подходил с плеткой к
висевшему барскому фраку, или просто прибирал что-нибудь. Что думал он
в то время, когда молчал, — может быть, он говорил про себя: «И ты,
однако ж, хорош, не надоело тебе сорок раз повторять одно и то же», —
бог ведает, трудно знать, что думает дворовый крепостной человек в то
время, как барин ему дает наставление. Итак, вот что на первый раз
можно сказать о Петрушке. Кучер Селифан был совершенно другой человек…
Но автор весьма совестится занимать так долго читателей людьми низкого
класса, зная по опыту, как неохотно они знакомятся с низкими
сословиями. Таков уже русский человек: страсть сильная зазнаться с
тем, который бы хотя одним чином был его повыше, и шапочное знакомство
с графом или князем для него лучше всяких тесных дружеских отношений.
Автор даже опасается за своего героя, который только коллежский
советник. Надворные советники, может быть, и познакомятся с ним, но
те, которые подобрались уже к чинам генеральским, те, бог весть, может
быть, даже бросят один из тех презрительных взглядов, которые
бросаются гордо человеком на все, что ни пресмыкается у ног его, или,
что еще хуже, может быть, пройдут убийственным для автора невниманием.
Но как ни прискорбно то и другое, а все, однако ж, нужно возвратиться
к герою. Итак, отдавши нужные приказания еще с вечера, проснувшись
поутру очень рано, вымывшись, вытершись с ног до головы мокрою губкой,
что делалось только по воскресным дням, — а в тот день случись
воскресенье, — выбрившись таким образом, что щеки сделались настоящий
атлас в рассуждении гладкости и лоска, надевши фрак брусничного цвета
с искрой и потом шинель на больших медведях, он сошел с лестницы,
поддерживаемый под руку то с одной, то с другой стороны трактирным
слугою, и сел в бричку. С громом выехала бричка из-под ворот гостиницы
на улицу. Проходивший поп снял шляпу, несколько мальчишек в замаранных
рубашках протянули руки, приговаривая: «Барин, подай сиротиньке!»
Кучер, заметивши, что один из них был большой охотник становиться на
запятки, хлыснул его кнутом, и бричка пошла прыгать по камням. Не без
радости был вдали узрет полосатый шлагбаум, дававший знать, что
мостовой, как и всякой другой муке, будет скоро конец; и еще несколько
раз ударившись довольно крепко головою в кузов, Чичиков понесся
наконец по мягкой земле. Едва только ушел назад город, как уже пошли
писать, по нашему обычаю, чушь и дичь по обеим сторонам дороги: кочки,
ельник, низенькие жидкие кусты молодых сосен, обгорелые стволы старых,
дикий вереск и тому подобный вздор. Попадались вытянутые по шнурку
деревни, постройкою похожие на старые складенные дрова, покрытые
серыми крышами с резными деревянными под ними украшениями в виде
висячих шитых узорами утиральников. Несколько мужиков, по обыкновению,
зевали, сидя на лавках перед воротами в своих овчинных тулупах. Бабы с
толстыми лицами и перевязанными грудями смотрели из верхних окон; из
нижних глядел теленок или высовывала слепую морду свою свинья. Словом,
виды известные. Проехавши пятнадцатую версту, он вспомнил, что здесь,
по словам Манилова, должна быть его деревня, но и шестнадцатая верста
пролетела мимо, а деревни все не было видно, и если бы не два мужика.
попавшиеся навстречу, то вряд ли бы довелось им потрафить на лад. На
вопрос, далеко ли деревня Заманиловка, мужики сняли шляпы, и один из
них, бывший поумнее и носивший бороду клином, отвечал:

— Маниловка, может быть, а не Заманиловка?

— Ну да, Маниловка.

— Маниловка! а как проедешь еще одну версту, так вот тебе, то есть,
— так прямо направо.

— Направо? — отозвался кучер.

— Направо, — сказал мужик. — Это будет тебе дорога в Маниловку; а
— Заманиловки никакой нет. Она зовется так, то есть ее прозвание
— Маниловка, а Заманиловки тут вовсе нет. Там прямо на горе увидишь
— дом, каменный, в два этажа, господский дом, в котором, то есть,
— живет сам господин. Вот это тебе и есть Маниловка, а Заманиловки
— совсем нет никакой здесь и не было.

Поехали отыскивать Маниловку. Проехавши две версты, встретили поворот
на проселочную дорогу, но уже и две, и три, и четыре версты, кажется,
сделали, а каменного дома в два этажа все еще не было видно. Тут
Чичиков вспомнил, что если приятель приглашает к себе в деревню за
пятнадцать верст, то значит, что к ней есть верных тридцать. Деревня
Маниловка немногих могла заманить своим местоположением. Дом
господский стоял одиночкой на юру, то есть на возвышении, открытом
всем ветрам, какие только вздумается подуть; покатость горы, на
которой он стоял, была одета подстриженным дерном. На ней были
разбросаны по-английски две-три клумбы с кустами сиреней и желтых
акаций; пять-шесть берез небольшими купами кое-где возносили свои
мелколистные жиденькие вершины. Под двумя из них видна была беседка с
плоским зеленым куполом, деревянными голубыми колоннами и надписью:
«Храм уединенного размышления»; пониже пруд, покрытый зеленью, что,
впрочем, не в диковинку в аглицких садах русских помещиков. У подошвы
этого возвышения, и частию по самому скату, темнели вдоль и поперек
серенькие бревенчатые избы, которые герой наш, неизвестно по каким
причинам, в ту ж минуту принялся считать и насчитал более двухсот;
нигде между ними растущего деревца или какой-нибудь зелени; везде
глядело только одно бревно. Вид оживляли две бабы, которые, картинно
подобравши платья и подтыкавшись со всех сторон, брели по колени в
пруде, влача за два деревянные кляча изорванный бредень, где видны
были два запутавшиеся рака и блестела попавшаяся плотва; бабы,
казались, были между собою в ссоре и за что-то перебранивались.
Поодаль в стороне темнел каким-то скучно-синеватым цветом сосновый
лес. Даже самая погода весьма кстати прислужилась: день был не то
ясный, не то мрачный, а какого-то светло-серого цвета, какой бывает
только на старых мундирах гарнизонных солдат, этого, впрочем, мирного
войска, но отчасти нетрезвого по воскресным дням. Для пополнения
картины не было недостатка в петухе, предвозвестнике переменчивой
погоды, который, несмотря на то что голова продолблена была до самого
мозгу носами других петухов по известным делам волокитства, горланил
очень громко и даже похлопывал крыльями, обдерганными, как старые
рогожки. Подъезжая ко двору, Чичиков заметил на крыльце самого
хозяина, который стоял в зеленом шалоновом сюртуке, приставив руку ко
лбу в виде зонтика над глазами, чтобы рассмотреть получше подъезжавший
экипаж. По мере того как бричка близилась к крыльцу, глаза его
делались веселее и улыбка раздвигалась более и более.

— Павел Иванович! — вскричал он наконец, когда Чичиков вылезал из
— брички. — Насилу вы таки нас вспомнили!

Оба приятеля очень крепко поцеловались, и Манилов увел своего гостя в
комнату. Хотя время, в продолжение которого они будут проходить сени,
переднюю и столовую, несколько коротковато, но попробуем, не успеем ли
как-нибудь им воспользоваться и сказать кое-что о хозяине дома. Но тут
автор должен признаться, что подобное предприятие очень трудно.
Гораздо легче изображать характеры большого размера: там просто бросай
краски со всей руки на полотно, черные палящие глаза нависшие брови,
перерезанный морщиною лоб, перекинутый через плечо черный или алый,
как огонь, плащ — и портрет готов; но вот эти все господа, которых
много на свете, которые с вида очень похожи между собою, а между тем
как приглядишься, увидишь много самых неуловимых особенностей, — эти
господа страшно трудны для портретов. Тут придется сильно напрягать
внимание, пока заставишь перед собою выступить все тонкие, почти
невидимые черты, и вообще далеко придется углублять уже изощренный в
науке выпытывания взгляд.

Один бог разве мог сказать, какой был характер Манилова. Есть род
людей, известных под именем: люди так себе, ни то ни се, ни в городе
Богдан ни в селе Селифан, по словам пословицы. Может быть, к ним
следует примкнуть и Манилова. На взгляд он был человек видный; черты
лица его были не лишены приятности, но в эту приятность, казалось,
чересчур было передано сахару; в приемах и оборотах его было что-то
заискивающее расположения и знакомства. Он улыбался заманчиво, был
белокур, с голубыми глазами. В первую минуту разговора с ним не можешь
не сказать: «Какой приятный и добрый человек!» В следующую за тем
минуту ничего не скажешь, а в третью скажешь: «Черт знает что такое!»
— и отойдешь подальше; если ж не отойдешь, почувствуешь скуку
смертельную. От него не дождешься никакого живого или хоть даже
заносчивого слова, какое можешь услышать почти от всякого, если
коснешься задирающего его предмета. У всякого есть свой задор: у
одного задор обратился на борзых собак; другому кажется, что он
сильный любитель музыки и удивительно чувствует все глубокие места в
ней; третий мастер лихо пообедать; четвертый сыграть роль хоть одним
вершком повыше той, которая ему назначена; пятый, с желанием более
ограниченным, спит и грезит о том, как бы пройтиться на гулянье с
флигель-адъютантом, напоказ своим приятелям, знакомым и даже
незнакомым; шестой уже одарен такою рукою, которая чувствует желание
сверхъестественное заломить угол какому-нибудь бубновому тузу или
двойке, тогда как рука седьмого так и лезет произвести где-нибудь
порядок, подобраться поближе к личности станционного смотрителя или
ямщиков, — словом, у всякого есть свое, но у Манилова ничего не было.
Дома он говорил очень мало и большею частию размышлял и думал, но о
чем он думал, тоже разве богу было известно. Хозяйством нельзя сказать
чтобы он занимался, он даже никогда не ездил на поля, хозяйство шло
как-то само собою. Когда приказчик говорил: «Хорошо бы, барин, то и то
сделать», — «Да, недурно, — отвечал он обыкновенно, куря трубку,
которую курить сделал привычку, когда еще служил в армии, где считался
скромнейшим, деликатнейшим и образованнейшим офицером. „Да, именно
недурно“, — повторял он. Когда приходил к нему мужик и, почесавши
рукою затылок, говорил: „Барин, позволь отлучиться на работу, по'дать
заработать“, — „Ступай“, — говорил он, куря трубку, и ему даже в
голову не приходило, что мужик шел пьянствовать. Иногда, глядя с
крыльца на двор и на пруд, говорил он о том, как бы хорошо было, если
бы вдруг от дома провести подземный ход или чрез пруд выстроить
каменный мост, на котором бы были по обеим сторонам лавки, и чтобы в
них сидели купцы и продавали разные мелкие товары, нужные для
крестьян. При этом глаза его делались чрезвычайно сладкими и лицо
принимало самое довольное выражение; впрочем, все эти прожекты так и
оканчивались только одними словами. В его кабинете всегда лежала
какая-то книжка, заложенная закладкою на четырнадцатой странице,
которую он постоянно читал уже два года. В доме его чего-нибудь вечно
недоставало: в гостиной стояла прекрасная мебель, обтянутая щегольской
шелковой материей, которая, верно, стоила весьма недешево; но на два
кресла ее недостало, и кресла стояли обтянуты просто рогожею; впрочем,
хозяин в продолжение нескольких лет всякий раз предостерегал своего
гостя словами: „Не садитесь на эти кресла, они еще не готовы“. В иной
комнате и вовсе не было мебели, хотя и было говорено в первые дни
после женитьбы: „Душенька, нужно будет завтра похлопотать, чтобы в эту
комнату хоть на время поставить мебель“. Ввечеру подавался на стол
очень щегольской подсвечник из темной бронзы с тремя античными
грациями, с перламутным щегольским щитом, и рядом с ним ставился
какой-то просто медный инвалид, хромой, свернувшийся на сторону и весь
в сале, хотя этого не замечал ни хозяин, ни хозяйка, ни слуги. Жена
его… впрочем, они были совершенно довольны друг другом. Несмотря на то
что минуло более восьми лет их супружеству, из них все еще каждый
приносил другому или кусочек яблочка, или конфетку, или орешек и
говорил трогательно-нежным голосом, выражавшим совершенную любовь:
„Разинь, душенька, свой ротик, я тебе положу этот кусочек“. Само собою
разумеется, что ротик раскрывался при этом случае очень грациозно. Ко
дню рождения приготовляемы были сюрпризы: какой-нибудь бисерный
чехольчик на зубочистку. И весьма часто, сидя на диване, вдруг,
совершенно неизвестно из каких причин, один, оставивши свою трубку, а
другая работу, если только она держалась на ту пору в руках, они
напечатлевали друг другу такой томный и длинный поцелуй, что в
продолжение его можно бы легко выкурить маленькую соломенную сигарку.
Словом, они были, то что говорится, счастливы. Конечно, можно бы
заметить, что в доме есть много других занятий, кроме продолжительных
поцелуев и сюрпризов, и много бы можно сделать разных запросов. Зачем,
например, глупо и без толку готовится на кухне? зачем довольно пусто в
кладовой? зачем воровка ключница? зачем нечистоплотны и пьяницы слуги?
зачем вся дворня спит немилосердым образом и повесничает все остальное
время? Но все это предметы низкие, а Манилова воспитана хорошо. А
хорошее воспитание, как известно, получается в пансионах. А в
пансионах, как известно, три главные предмета составляют основу
человеческих добродетелей: французский язык, необходимый для счастия
семейственной жизни, фортепьяно, для составления приятных минут
супругу, и, наконец, собственно хозяйственная часть: вязание кошельков
и других сюрпризов. Впрочем, бывают разные усовершенствования и
изменения в мето'дах, особенно в нынешнее время; все это более зависит
от благоразумия и способностей самих содержательниц пансиона. В других
пансионах бывает таким образом, что прежде фортепьяно, потом
французский язык, а там уже хозяйственная часть. А иногда бывает и
так, что прежде хозяйственная часть, то есть вязание сюрпризов, потом
французский язык, а там уже фортепьяно. Разные бывают мето'ды. Не
мешает сделать еще замечание, что Манилова… но, признаюсь, о дамах я
очень боюсь говорить, да притом мне пора возвратиться к нашим героям,
которые стояли уже несколько минут перед дверями гостиной, взаимно
упрашивая друг друга пройти вперед.

— Сделайте милость, не беспокойтесь так для меня, я пройду после, —
— говорил Чичиков.

— Нет, Павел Иванович, нет, вы гость, — говорил Манилов, показывая ему
— рукою на дверь.

— Не затрудняйтесь, пожалуйста, не затрудняйтесь. Пожалуйста,
— проходите, — говорил Чичиков.

— Нет уж извините, не допущу пройти позади такому приятному,
— образованному гостю.

— Почему ж образованному?.. Пожалуйста, проходите.

— Ну да уж извольте проходить вы.

— Да отчего ж?

— Ну да уж оттого! — сказал с приятною улыбкою Манилов.

Наконец оба приятеля вошли в дверь боком и несколько притиснули друг
друга.

— Позвольте мне вам представить жену мою, — сказал Манилов. —
— Душенька! Павел Иванович!

Чичиков, точно, увидел даму, которую он совершенно было не приметил,
раскланиваясь в дверях с Маниловым. Она была недурна, одета к лицу. На
ней хорошо сидел матерчатый шелковый капот бледного цвета; тонкая
небольшая кисть руки ее что-то бросила поспешно на стол и сжала
батистовый платок с вышитыми уголками. Она поднялась с дивана, на
котором сидела; Чичиков не без удовольствия подошел к ее ручке.
Манилова проговорила, несколько даже картавя, что он очень обрадовал
их своим приездом и что муж ее не проходило дня, чтобы не вспоминал о
нем.

— Да, — примолвил Манилов, — уж она, бывало, все спрашивает меня: «Да
— что же твой приятель не едет?» — «Погоди, душенька, приедет». А вот
— вы наконец и удостоили нас своим посещением. Уж такое, право,
— доставили наслаждение… майский день… именины сердца…

Чичиков, услышавши, что дело уже дошло до именин сердца, несколько
даже смутился и отвечал скромно, что ни громкого имени не имеет, ни
даже ранга заметного.

— Вы всё имеете, — прервал Манилов с такою же приятною улыбкою, — всё
— имеете, даже еще более.

— Как вам показался наш город? — примолвила Манилова. — Приятно ли
— провели там время?

— Очень хороший город, прекрасный город, — отвечал Чичиков, — и время
— провел очень приятно: общество самое обходительное.

— А как вы нашли нашего губернатора? — сказала Манилова.

— Не правда ли, что препочтеннейший и прелюбезнейший человек? —
— прибавил Манилов.

— Совершенная правда, — сказал Чичиков, — препочтеннейший человек. И
— как он вошел в свою должность, как понимает ее! Нужно желать
— побольше таких людей.

— Как он может этак, знаете, принять всякого, блюсти деликатность в
— своих поступках, — присовокупил Манилов с улыбкою и от удовольствия
— почти совсем зажмурил глаза, как кот, у которого слегка пощекотали
— за ушами пальцем.

— Очень обходительный и приятный человек, — продолжал Чичиков, — и
— какой искусник! я даже никак не мог предполагать этого. Как хорошо
— вышивает разные домашние узоры! Он мне показывал своей работы
— кошелек: редкая дама может так искусно вышить.

— А вице-губернатор, не правда ли, какой милый человек? — сказал
— Манилов, опять несколько прищурив глаза.

— Очень, очень достойный человек, — отвечал Чичиков.

— Ну, позвольте, а как вам показался полицеймейстер? Не правда ли, что
— очень приятный человек?

— Чрезвычайно приятный, и какой умный, какой начитанный человек! Мы у
— него проиграли в вист вместе с прокурором и председателем палаты до
— самых поздних петухов; очень, очень достойный человек.

— Ну, а какого вы мнения о жене полицеймейстера? — прибавила Манилова.
— — Не правда ли, прелюбезная женщина?

— О, это одна из достойнейших женщин, каких только я знаю, — отвечал
— Чичиков

Засим не пропустили председателя палаты, почтмейстера и таким образом
перебрали почти всех чиновников города, которые все оказались самыми
достойными людьми.

— Вы всегда в деревне проводите время? — сделал наконец, в свою
— очередь, вопрос Чичиков.

— Больше в деревне, — отвечал Манилов. — впрочем, приезжаем в город
— для того только, чтобы увидеться с образованными людьми. Одичаешь,
— знаете, будешь все время жить взаперти.

— Правда, правда, — сказал Чичиков.

— Конечно, — продолжал Манилов, — другое дело, если бы соседство было
— хорошее, если бы, например, такой человек, с которым бы в некотором
— роде можно было поговорить о любезности, о хорошем обращении,
— следить какую-нибудь этакую науку, чтобы этак расшевелило душу, дало
— бы, так сказать, паренье этакое… — Здесь он еще что-то хотел
— выразить, но, заметивши, что несколько зарапортовался, ковырнул
— только рукою в воздухе и продолжал: — Тогда, конечно, деревня и
— уединение имели бы очень много приятностей. Но решительно нет
— никого… Вот только иногда почитаешь «Сын отечества».

Чичиков согласился с этим совершенно, прибавивши, что ничего не может
быть приятнее, как жить в уединенье, наслаждаться зрелищем природы и
почитать иногда какую-нибудь книгу…

— Но знаете ли, — прибавил Манилов, — все если нет друга, с которым бы
— можно поделиться…

— О, это справедливо, это совершенно справедливо! — прервал Чичиков. —
— Что все сокровища тогда в мире! «Не имей денег, имей хороших людей
— для обращения», сказал один мудрец.

— И знаете, Павел Иванович! — сказал Манилов, явя в лице своем
— выражение не только сладкое, но даже приторное, подобное той
— микстуре, которую ловкий светский доктор засластил немилосердно,
— воображая ею обрадовать пациента. — Тогда чувствуешь какое-то, в
— некотором роде, духовное наслаждение… Вот как, например, теперь,
— когда случай мне доставил счастие, можно сказать образцовое,
— говорить с вами и наслаждаться приятным вашим разговоров…

— Помилуйте, что ж за приятный разговор?.. Ничтожный человек, и больше
— ничего, — отвечал Чичиков.

— О! Павел Иванович, позвольте мне быть откровенным: я бы с радостию
— отдал половину всего моего состояния, чтобы иметь часть тех
— достоинств, которые имеете вы!..

— Напротив, я бы почел с своей стороны за величайшее…

Неизвестно, до чего бы дошло взаимное излияние чувств обоих приятелей,
если бы вошедший слуга не доложил, что кушанье готово.

— Прошу покорнейше, — сказал Манилов. — Вы извините, если у нас нет
— такого обеда, какой на паркетах и в столицах, у нас просто, по
— русскому обычаю, щи, но от чистого сердца. Покорнейше прошу.

Тут они еще несколько времени поспорили о том, кому первому войти, и
наконец Чичиков вошел боком в столовую.

В столовой уже стояли два мальчика, сыновья Манилова, которые были в
тех летах, когда сажают уже детей за стол, но еще на высоких стульях.
При них стоял учитель, поклонившийся вежливо и с улыбкою. Хозяйка села
за свою суповую чашку; гость был посажен между хозяином и хозяйкою,
слуга завязал детям на шею салфетки.

— Какие миленькие дети, — сказал Чичиков, посмотрев на них, — а
— который год?

— Старшему осьмой, а меньшему вчера только минуло шесть, — сказала
— Манилова.

— Фемистоклюс! — сказал Манилов, обратившись к старшему, который
— старался освободить свой подбородок, завязанный лакеем в салфетку.

Чичиков поднял несколько бровь, услышав такое отчасти греческое имя,
которому, неизвестно почему, Манилов дал окончание на «юс», но
постарался тот же час привесть лицо в обыкновенное положение.

— Фемистоклюс, скажи мне, какой лучший город во Франции?

Здесь учитель обратил все внимание на Фемистоклюса и казалось, хотел
ему вскочить в глаза, но наконец совершенно успокоился и кивнул
головою, когда Фемистоклюс сказал: «Париж».

— А у нас какой лучший город? — спросил опять Манилов.

Учитель опять настроил внимание.

— Петербург, — отвечал Фемистоклюс.

— А еще какой?

— Москва, — отвечал Фемистоклюс.

— Умница, душенька! — сказал на это Чичиков. — Скажите, однако ж… —
— продолжал он, обратившись тут же с некоторым видом изумления к
— Маниловым, — в такие лета и уже такие сведения! Я должен вам
— сказать, что в этом ребенке будут большие способности.

— О, вы еще не знаете его, — отвечал Манилов, — у него чрезвычайно
— много остроумия. Вот меньшой, Алкид, тот не так быстр, а этот
— сейчас, если что-нибудь встретит, букашку, козявку, так уж у него
— вдруг глазенки и забегают; побежит за ней следом и тотчас обратит
— внимание. Я его прочу по дипломатической части. Фемистоклюс, —
— продолжал он, снова обратясь к нему, — хочешь быть посланником?

— Хочу, — отвечал Фемистоклюс, жуя хлеб и болтая головой направо и
— налево.

В это время стоявший позади лакей утер посланнику нос, и очень хорошо
сделал, иначе бы канула в суп препорядочная посторонняя капля.
Разговор начался за столом об удовольствии спокойной жизни,
прерываемый замечаниями хозяйки о городском театре и об актерах.
Учитель очень внимательно глядел на разговаривающих и, как только
замечал, что они были готовы усмехнуться, в ту же минуту открывал рот
и смеялся с усердием. Вероятно, он был человек признательный и хотел
заплатить этим хозяину за хорошее обращение. Один раз, впрочем, лицо
его приняло суровый вид, и он строго застучал по столу, устремив глаза
на сидевших насупротив его детей. Это было у места, потому что
Фемистоклюс укусил за ухо Алкида, и Алкид, зажмурив глаза и открыв
рот, готов был зарыдать самым жалким образом, но, почувствовав, что за
это легко можно было лишиться блюда, привел рот в прежнее положение и
начал со слезами грызть баранью кость, от которой у него обе щеки
лоснились жиром. Хозяйка очень часто обращалась к Чичикову с словами:
«Вы ничего не кушаете, вы очень мало взяли». На что Чичиков отвечал
всякий раз: «Покорнейше благодарю, я сыт, приятный разговор лучше
всякого блюда».

Уже встали из-за стола. Манилов был доволен чрезвычайно и, поддерживая
рукою спину своего гостя, готовился таким образом препроводить его в
гостиную, как вдруг гость объявил с весьма значительным видом, что он
намерен с ним поговорить об одном очень нужном деле.

— В таком случае позвольте мне вас попросить в мой кабинет, — сказал
— Манилов и повел в небольшую комнату, обращенную окном на синевший
— лес. — Вот мой уголок, — сказал Манилов.

— Приятная комнатка, — сказал Чичиков, окинувши ее глазами.

Комната была, точно, не без приятности: стены были выкрашены какой-то
голубенькой краской вроде серенькой, четыре стула, одно кресло, стол,
на котором лежала книжка с заложенною закладкою, о которой мы уже
имели случай упомянуть, несколько исписанных бумаг, но больше всего
было табаку. Он был в разных видах: в картузах и в табачнице, и,
наконец, насыпан был просто кучею на столе. На своих окнах тоже
помещены были горки выбитой из трубки золы, расставленные не без
старания очень красивыми рядками. Заметно было, что это иногда
доставляло хозяину препровождение времени.

— Позвольте вас попросить расположиться в этих креслах, — сказал
— Манилов. — Здесь вам будет попокойнее.

— Позвольте, я сяду на стуле.

— Позвольте вам этого не позволить, — сказал Манилов с улыбкою. — Это
— кресло у меня уж ассигновано для гостя: ради или не ради, но должны
— сесть.

Чичиков сел.

— Позвольте мне вас попотчевать трубочкою.

— Нет, не курю, — отвечал Чичиков ласково и как бы с видом сожаления.

— Отчего? — сказал Манилов тоже ласково и с видом сожаления.

— Не сделал привычки, боюсь; говорят, трубка сушит.

— Позвольте мне вам заметить, что это предубеждение. Я полагаю даже,
— что курить трубку гораздо здоровее, нежели нюхать табак. В нашем
— полку был поручик, прекраснейший и образованнейший человек, который
— не выпускал изо рта трубки не только за столом, но даже, с
— позволения сказать, во всех прочих местах. И вот ему теперь уже
— сорок с лишком лет, но, благодари бога, до сих пор так здоров, как
— нельзя лучше.

Чичиков заметил, что это, точно, случается и что натуре находится
много вещей, неизъяснимых даже для обширного ума.

— Но позвольте прежде одну просьбу… — проговорил он голосом, в котором
— отдалось какое-то странное или почти странное выражение, и вслед за
— тем неизвестно чего оглянулся назад. — Как давно вы изволили
— подавать ревизскую сказку?

— Да уж давно; а лучше сказать не припомню.

— Как с того времени много у вас умерло крестьян?

— А не могу знать; об этом, я полагаю, нужно спросить приказчика. Эй,
— человек! позови приказчика, он должен быть сегодня здесь.

Приказчик явился. Это был человек лет под сорок, бривший бороду,
ходивший в сюртуке и, по-видимому, проводивший очень покойную жизнь,
потому что лицо его глядело какою-то пухлою полнотою, а желтоватый
цвет кожи и маленькие глаза показывали, что он знал слишком хорошо,
что такое пуховики и перины. Можно было видеть тотчас, что он совершил
свое поприще, как совершают его все господские приказчики: был прежде
просто грамотным мальчишкой в доме, потом женился на какой-нибудь
Агашке-ключнице, барыниной фаворитке, сделался сам ключником, а там и
приказчиком. А сделавшись приказчиком, поступал, разумеется, как все
приказчики: водился и кумился с теми, которые на деревне были
побогаче, подбавлял на тягла победнее, проснувшись в девятом часу
утра, поджидал самовара и пил чай.

— Послушай, любезный! сколько у нас умерло крестьян с тех пор, как
— подавали ревизию?

— Да как сколько? Многие умирали с тех пор, — сказал приказчик и при
— этом икнул, заслонив рот слегка рукою, наподобие щитка.

— Да, признаюсь, а сам так думал, — подхватил Манилов, — именно, очень
— многие умирали! — Тут он оборотился к Чичикову и прибавил еще: —
— Точно, очень многие.

— А как, например, числом? — спросил Чичиков.

— Да, сколько числом? — подхватил Манилов.

— Да как сказать числом? Ведь неизвестно, сколько умирало, их никто не
— считал.

— Да, именно, — сказал Манилов, обратясь к Чичикову, — я тоже
— предполагал, большая смертность; совсем неизвестно, сколько умерло.

— Ты, пожалуйста, их перечти, — сказал Чичиков, — и сделай подробный
— реестрик всех поименно.

— Да, всех поименно, — сказал Манилов.

Приказчик сказал: «Слушаю!» — и ушел.

— А для какие причин вам это нужно? — спросил по уходе приказчика
— Манилов.

Этот вопрос, казалось, затруднил гостя, в лице его показалось какое-то
напряженное выражение, от которого он даже покраснел, — напряжение
что-то выразить, не совсем покорное словам. И в самом деле, Манилов
наконец услышал такие странные и необыкновенные вещи, какие еще
никогда не слыхали человеческие уши.

— Вы спрашиваете, для каких причин? причины вот какие: я хотел бы
— купить крестьян… — сказал Чичиков, заикнулся и не кончил речи.

— Но позвольте спросить вас, — сказал Манилов, — как желаете вы купить
— крестьян: с землею или просто на вывод, то есть без земли?

— Нет, я не то чтобы совершенно крестьян, — сказал Чичиков, — я желаю
— иметь мертвых…

— Как-с? извините… я несколько туг на ухо, мне послышалось престранное
— слово…

— Я полагаю приобресть мертвых, которые, впрочем, значились бы по
— ревизии как живые, — сказал Чичиков.

Манилов выронил тут же чубук с трубкою на пол и как разинул рот, так и
остался с разинутым ртом в продолжение нескольких минут. Оба приятеля,
рассуждавшие о приятностях дружеской жизни, остались недвижимы, вперя
друг в друга глаза, как те портреты, которые вешались в старину один
против другого по обеим сторонам зеркала. Наконец Манилов поднял
трубку с чубуком и поглядел снизу ему в лицо, стараясь высмотреть, не
видно ли какой усмешки на губах его, не пошутил ли он; но ничего не
было видно такого, напротив, лицо даже казалось степеннее
обыкновенного; потом подумал, не спятил ли гость как-нибудь невзначай
с ума, и со страхом посмотрел на него пристально; но глаза гостя были
совершенно ясны, не было в них дикого, беспокойного огня, какой бегает
в глазах сумасшедшего человека, все было прилично и в порядке. Как ни
придумывал Манилов, как ему быть и что ему сделать, но ничего другого
не мог придумать, как только выпустить изо рта оставшийся дым очень
тонкой струею.

— Итак, я бы желал знать, можете ли вы мне таковых, не живых в
— действительности, но живых относительно законной формы, передать,
— уступить или как вам заблагорассудится лучше?

Но Манилов так сконфузился и смешался, что только смотрел на него

— Мне кажется, вы затрудняетесь?.. — заметил Чичиков.

— Я?.. нет, я не то, — сказал Манилов, — но я не могу постичь…
— извините… я, конечно, не мог получить такого блестящего образования,
— какое, так сказать, видно во всяком вашем движении; не имею высокого
— искусства выражаться… Может быть, здесь… в этом, вами сейчас
— выраженном изъяснении… скрыто другое… Может быть, вы изволили
— выразиться так для красоты слога?

— Нет, — подхватил Чичиков, — нет, я разумею предмет таков как есть,
— то есть те души, которые, точно, уже умерли.

Манилов совершенно растерялся. Он чувствовал, что ему нужно что-то
сделать, предложить вопрос, а какой вопрос — черт его знает. Кончил он
наконец тем, что выпустил опять дым, но только уже не ртом, а чрез
носовые ноздри.

— Итак, если нет препятствий, то с богом можно бы приступить к
— совершению купчей крепости, — сказал Чичиков.

— Как, на мертвые души купчую?

— А, нет! — сказал Чичиков. — Мы напишем, что они живы, так, как стоит
— действительно в ревизской сказке. Я привык ни в чем не отступать от
— гражданских законов, хотя за это и потерпел на службе, но уж
— извините: обязанность для меня дело священное, закон — я немею пред
— законом.

Последние слова понравились Манилову, но в толк самого дела он все-
таки никак не вник и вместо ответа принялся насасывать свой чубук так
сильно, что тот начал наконец хрипеть, как фагот. Казалось, как будто
он хотел вытянуть из него мнение относительно такого неслыханного
обстоятельства; но чубук хрипел и больше ничего.

— Может быть, вы имеете какие-нибудь сомнения?

— О! помилуйте, ничуть. Я не насчет того говорю, чтобы имел какое-
— нибудь, то есть, критическое предосуждение о вас. Но позвольте
— доложить, не будет ли это предприятие или, чтоб еще более, так
— сказать, выразиться, негоция, — так не будет ли эта негоция
— несоответствующею гражданским постановлениям и дальнейшим видам
— России?

Здесь Манилов, сделавши некоторое движение головою, посмотрел очень
значительно в лицо Чичикова, показав во всех чертах лица своего и
сжатых губах такое глубокое выражение, какого, может быть, и не видано
было на человеческом лице, разве только у какого-нибудь слишком умного
министра, да и то в минуту самого головоломного дела.

Но Чичиков сказал просто, что подобное предприятие, или негоция, никак
не будет несоответствующею гражданским постановлениям и дальнейшим
видам России, а чрез минуту потом прибавил, что казна получит даже
выгоды, ибо получит законные пошлины.

— Так вы полагаете?..

— Я полагаю, что это будет хорошо.

— А, если хорошо, это другое дело: я против этого ничего, — сказал
— Манилов и совершенно успокоился.

— Теперь остается условиться в цене.

— Как в цене? — сказал опять Манилов и остановился. — Неужели вы
— полагаете, что я стану брать деньги за души, которые в некотором
— роде окончили свое существование? Если уж вам пришло этакое, так
— сказать, фантастическое желание, то с своей стороны я передаю их вам
— безынтересно и купчую беру на себя.

Великий упрек был бы историку предлагаемых событий, если бы он упустил
сказать, что удовольствие одолело гостя после таких слов,
произнесенных Маниловым. Как он ни был степенен и рассудителен, но тут
чуть не произвел даже скачок по образцу козла, что, как известно,
производится только в самых сильных порывах радости. Он поворотился
так сильно в креслах, что лопнула шерстяная материя, обтягивавшая
подушку; сам Манилов посмотрел на него в некотором недоумении.
Побужденный признательностию, он наговорил тут же столько
благодарностей, что тот смешался, весь покраснел, производил головою
отрицательный жест и наконец уже выразился, что это сущее ничего, что
он, точно, хотел бы доказать чем-нибудь сердечное влечение, магнетизм
души, а умершие души в некотором роде совершенная дрянь.

— Очень не дрянь, — сказал Чичиков, пожав ему руку. Здесь был испущен
— очень глубокий вздох. Казалось, он был настроен к сердечным
— излияниям; не без чувства и выражения произнес он наконец следующие
— слова: — Если б вы знали, какую услугу оказали сей, по-видимому,
— дрянью человеку без племени и роду! Да и действительно, чего не
— потерпел я? как барка какая-нибудь среди свирепых волн… Каких
— гонений, каких преследований не испытал, какого горя не вкусил, а за
— что? за то, что соблюдал правду, что был чист на своей совести, что
— подавал руку и вдовице беспомощной, и сироте-горемыке!.. — Тут даже
— он отер платком выкатившуюся слезу.

Манилов был совершенно растроган. Оба приятеля долго жали друг другу
руку и долго смотрели молча один другому в глаза, в которых видны были
навернувшиеся слезы. Манилов никак не хотел выпустить руки нашего
героя и продолжал жать ее так горячо, что тот уже не знал, как ее
выручить. Наконец, выдернувши ее потихоньку, он сказал, что не худо бы
купчую совершить поскорее и хорошо бы, если бы он сам понаведался в
город. Потом взял шляпу и стал откланиваться.

— Как? вы уж хотите ехать? — сказал Манилов, вдруг очнувшись и почти
— испугавшись.

В это время вошла в кабинет Манилова.

— Лизанька, — сказал Манилов с несколько жалостливым видом, — Павел
— Иванович оставляет нас!

— Потому что мы надоели Павлу Ивановичу, — отвечала Манилова.

— Сударыня! здесь, — сказал Чичиков, — здесь, вот где, — тут он
— положил руку на сердце, — да, здесь пребудет приятность времени,
— проведенного с вами! и поверьте, не было бы для меня большего
— блаженства, как жить с вами если не в одном доме, то по крайней мере
— в самом ближайшем соседстве.

— А знаете, Павел Иванович, — сказал Манилов, которому очень
— понравилась такая мысль, — как было бы в самом деле хорошо, если бы
— жить этак вместе, под одною кровлею, или под тенью какого-нибудь
— вяза пофилософствовать о чем-нибудь, углубиться!..

— О! это была бы райская жизнь! — сказал Чичиков, вздохнувши. —
— Прощайте, сударыня! — продолжал он, подходя к ручке Маниловой. —
— Прощайте, почтеннейший друг! Не позабудьте просьбы!

— О, будьте уверены! — отвечал Манилов. — Я с вами расстаюсь не долее
— как на два дни.

Все вышли в столовую.

— Прощайте, миленькие малютки! — сказал Чичиков, увидевши Алкида и
— Фемистоклюса, которые занимались каким-то деревянным гусаром, у
— которого уже не было ни руки, ни носа. — Прощайте, мои крошки. Вы
— извините меня, что я не привез вам гостинца, потому что, признаюсь,
— не знал даже, живете ли вы на свете, но теперь, как приеду,
— непременно привезу. Тебе привезу саблю; хочешь саблю?

— Хочу, — отвечал Фемистоклюс.

— А тебе барабан; не правда ли, тебе барабан? — продолжал он,
— наклонившись к Алкиду.

— Парапан, — отвечал шепотом и потупив голову Алкид.

— Хорошо, а тебе привезу барабан. Такой славный барабан, этак все
— будет: туррр… ру… тра-та-та, та-та-та… Прощай, душенька! прощай! —
— Тут поцеловал он его в голову и обратился к Манилову и его супруге с
— небольшим смехом, с какие обыкновенно обращаются к родителям, давая
— им знать о невинности желаний их детей.

— Право, останьтесь, Павел Иванович! — сказал Манилов, когда уже все
— вышли на крыльцо. — Посмотрите, какие тучи.

— Это маленькие тучки, — отвечал Чичиков.

— Да знаете ли вы дорогу к Собакевичу?

— Об этом хочу спросить вас.

— Позвольте, я сейчас расскажу вашему кучеру.

Тут Манилов с такою же любезностью рассказал дело кучеру и сказал ему
даже один раз «вы».

Кучер, услышав, что нужно пропустить два поворота и поворотить на
третий, сказал: «Потрафим, ваше благородие», — и Чичиков уехал,
сопровождаемый долго поклонами и маханьями платка приподымавшихся на
цыпочках хозяев.

Манилов долго стоял на крыльце, провожая глазами удалявшуюся бричку, и
когда она уже совершенно стала не видна, он все еще стоял, куря
трубку. Наконец вошел он в комнату, сел на стуле и предался
размышлению, душевно радуясь, что доставил гостю своему небольшое
удовольствие. Потом мысли его перенеслись незаметно к другим предметам
и наконец занеслись бог знает куда. Он думал о благополучии дружеской
жизни, о том, как бы хорошо было жить с другом на берегу какой-нибудь
реки, потом чрез эту реку начал строиться у него мост, потом
огромнейший дом с таким высоким бельведером, что можно оттуда видеть
даже Москву и там пить вечером чай на открытом воздухе и рассуждать о
каких-нибудь приятных предметах. Потом, что они вместе с Чичиковым
приехали в какое-то общество в хороших каретах, где обворожают всех
приятностию обращения, и что будто бы государь, узнавши о такой их
дружбе, пожаловал их генералами, и далее, наконец, бог знает что
такое, чего уже он и сам никак не мог разобрать. Странная просьба
Чичикова прервала вдруг все его мечтания. Мысль о ней как-то особенно
не варилась в его голове: как ни переворачивал он ее, но никак не мог
изъяснить себе, и все время сидел он и курил трубку, что тянулось до
самого ужина.






Глава третья


А Чичиков в довольном расположении духа сидел в своей бричке,
катившейся давно по столбовой дороге. Из предыдущей главы уже видно, в
чем состоял главный предмет его вкуса и склонностей, а потому не диво,
что он скоро погрузился весь в него и телом и душою. Предположения,
сметы и соображения, блуждавшие по лицу его, видно, были очень
приятны, ибо ежеминутно оставляли после себя следы довольной усмешки.
Занятый ими, он не обращал никакого внимания на то, как его кучер,
довольный приемом дворовых людей Манилова, делал весьма дельные
замечания чубарому пристяжному коню, запряженному с правой стороны.
Этот чубарый конь был сильно лукав и показывал только для вида, будто
бы везет, тогда как коренной гнедой и пристяжной каурой масти,
называвшийся Заседателем, потому что был приобретен от какого-то
заседателя, трудилися от всего сердца, так что даже в глазах их было
заметно получаемое ими от того удовольствие. «Хитри, хитри! вот я тебя
перехитрю! — говорил Селифан, приподнявшись и хлыснув кнутом ленивца.
— Ты знай свое дело, панталонник ты немецкий! Гнедой — почтенный конь,
он сполняет свой долг, я ему с охотою дам лишнюю меру, потому что он
почтенный конь, и Заседатель тож хороший конь… Ну, ну! что
потряхиваешь ушами? Ты, дурак, слушай, коли говорят! я тебя, невежа,
не стану дурному учить. Ишь куда ползет!» Здесь он опять хлыснул его
кнутом, примолвив; «У, варвар! Бонапарт ты проклятый!» Потом
прикрикнул на всех: «Эй вы, любезные!» — и стегнул по всем по трем уже
не в виде наказания, но чтобы показать, что был ими доволен. Доставив
такое удовольствие, он опять обратил речь к чубарому: «Ты думаешь, что
скроешь свое поведение. Нет, ты живи по правде, когда хочешь, чтобы
тебе оказывали почтение. Вот у помещика, что мы были, хорошие люди. Я
с удовольствием поговорю, коли хороший человек; с человеком хорошим мы
всегда свои други, тонкие приятели; выпить ли чаю, или закусить — с
охотою, коли хороший человек. Хорошему человеку всякой отдаст
почтение. Вот барина нашего всякой уважает, потому что он, слышь ты,
сполнял службу государскую, он сколеской советник…»

Так рассуждая, Селифан забрался наконец в самые отдаленные
отвлеченности. Если бы Чичиков прислушался, то узнал бы много
подробностей, относившихся лично к нему; но мысли его так были заняты
своим предметом, что один только сильный удар грома заставил его
очнуться и посмотреть вокруг себя; все небо было совершенно обложено
тучами, и пыльная почтовая дорога опрыскалась каплями дождя. Наконец
громовый удар раздался в другой раз громче и ближе, и дождь хлынул
вдруг как из ведра. Сначала, принявши косое направление, хлестал он в
одну сторону кузова кибитки, потом в другую, потом, изменив и образ
нападения и сделавшись совершенно прямым, барабанил прямо в верх его
кузова; брызги наконец стали долетать ему в лицо. Это заставило его
задернуться кожаными занавесками с двумя круглыми окошечками,
определенными на рассматривание дорожных видов, и приказать Селифану
ехать скорее. Селифан, прерванный тоже на самой середине речи,
смекнул, что, точно, не нужно мешкать, вытащил тут же из-под козел
какую-то дрянь из серого сукна, надел ее в рукава, схватил в руки
вожжи и прикрикнул на свою тройку, которая чуть-чуть переступала
ногами, ибо чувствовала приятное расслабление от поучительных речей.
Но Селифан никак не мог припомнить, два или три поворота проехал.
Сообразив и припоминая несколько дорогу, он догадался, что много было
поворотов, которые все пропустил он мимо. Так как русский человек в
решительные минуты найдется, что сделать, не вдаваясь в дальние
рассуждения, то, поворотивши направо, на первую перекрестную дорогу,
прикрикнул он: «Эй вы, други почтенные!» — и пустился вскачь, мало
помышляя о том, куда приведет взятая дорога.

Дождь, однако же, казалось, зарядил надолго. Лежавшая на дороге пыль
быстро замесилась в грязь, и лошадям ежеминутно становилось тяжелее
тащить бричку. Чичиков уже начинал сильно беспокоиться, не видя так
долго деревни Собакевича. По расчету его, давно бы пора было приехать.
Он высматривал по сторонам, но темнота была такая, хоть глаз выколи.

— Селифан! — сказал он наконец, высунувшись из брички.

— Что, барин? — отвечал Селифан.

— Погляди-ка, не видно ли деревни?

— Нет, барин, нигде не видно! — После чего Селифан, помахивая кнутом,
— затянул песню не песню, но что-то такое длинное, чему и конца не
— было. Туда все вошло: все ободрительные и побудительные крики,
— которыми потчевают лошадей по всей России от одного конца до
— другого; прилагательные всех родов без дальнейшего разбора, как что
— первое попалось на язык. Таким образом дошло до того, что он начал
— называть их наконец секретарями.

Между тем Чичиков стал примечать, что бричка качалась на все стороны и
наделяла его пресильными толчками; это дало ему почувствовать, что они
своротили с дороги и, вероятно, тащились по взбороненному полю.
Селифан, казалось, сам смекнул, но не говорил ни слова.

— Что, мошенник, по какой дороге ты едешь? — сказал Чичиков.

— Да что ж, барин, делать, время-то такое; кнута не видишь, такая
— потьма! — Сказавши это, он так покосил бричку, что Чичиков принужден
— был держаться обеими руками. Тут только заметил он, что Селифан
— подгулял.

— Держи, держи, опрокинешь! — кричал он ему.

— Нет, барин, как можно, чтоб я опрокинул, — говорил Селифан. — Это
— нехорошо опрокинуть, я уж сам знаю; уж я никак не опрокину. — Затем
— начал он слегка поворачивать бричку, поворачивал, поворачивал и
— наконец выворотил ее совершенно набок. Чичиков и руками и ногами
— шлепнулся в грязь. Селифан лошадей, однако ж, остановил, впрочем,
— они остановились бы и сами, потому что были сильно изнурены. Такой
— непредвиденный случай совершенно изумил его. Слезши с козел, он стал
— перед бричкою, подперся в бока обеими руками, в то время как барин
— барахтался в грязи, силясь оттуда вылезть, и сказал после некоторого
— размышления: «Вишь ты, и перекинулась!»

— Ты пьян как сапожник! — сказал Чичиков.

— Нет, барин, как можно, чтоб я был пьян! Я знаю, что это нехорошее
— дело быть пьяным. С приятелем поговорил, потому что с хорошим
— человеком можно поговорить, в том нет худого; и закусили вместе.
— Закуска не обидное дело; с хорошим человеком можно закусить.

— А что я тебе сказал последний раз, когда ты напился? а? забыл? —
— сказал Чичиков.

— Нет, ваше благородие, как можно, чтобы я позабыл. Я уже дело свое
— знаю. Я знаю, что нехорошо быть пьяным. С хорошим человеком
— поговорил, потому что…

— Вот я тебя как высеку, так ты у меня будешь знать, как говорить с
— хорошим человеком!

— Как милости вашей будет угодно, — отвечал на все согласный Селифан,
— — коли высечь, то и высечь; я ничуть не прочь от того. Почему ж не
— посечь, коли за дело, на то воля господская. Оно нужно посечь,
— потому что мужик балуется, порядок нужно наблюдать. Коли за дело, то
— и посеки; почему ж не посечь?

На такое рассуждение барин совершенно не нашелся, что отвечать. Но в
это время, казалось, как будто сама судьба решилась над ним сжалиться.
Издали послышался собачий лай. Обрадованный Чичиков дал приказание
погонять лошадей. Русский возница имеет доброе чутье вместо глаз; от
этого случается, что он, зажмуря глаза, качает иногда во весь дух и
всегда куда-нибудь да приезжает. Селифан, не видя ни зги, направил
лошадей так прямо на деревню, что остановился тогда только, когда
бричка ударилася оглоблями в забор и когда решительно уже некуда было
ехать. Чичиков только заметил сквозь густое покрывало лившего дождя
что-то похожее на крышу. Он послал Селифана отыскивать ворота, что,
без сомнения, продолжалось бы долго, если бы на Руси не было вместо
швейцаров лихих собак, которые доложили о нем так звонко, что он
поднес пальцы к ушам своим. Свет мелькнул в одном окошке и досягнул
туманною струею до забора, указавши нашим дорожным ворота. Селифан
принялся стучать, и скоро, отворив калитку, высунулась какая-то
фигура, покрытая армяком, и барин со слугою услышали хриплый бабий
голос:

— Кто стучит? чего расходились?

— Приезжие, матушка, пусти переночевать, — произнес Чичиков.

— Вишь ты, какой востроногий, — сказала старуха, — приехал в какое
— время! Здесь тебе не постоялый двор: помещица живет.

— Что ж делать, матушка: вишь, с дороги сбились. Не ночевать же в
— такое время в степи.

— Да, время темное, нехорошее время, — прибавил Селифан.

— Молчи, дурак, — сказал Чичиков.

— Да кто вы такой? — сказала старуха.

— Дворянин, матушка.

Слово «дворянин» заставило старуху как будто несколько подумать.

— Погодите, я скажу барыне, — произнесла она и минуты через две уже
— возвратилась с фонарем в руке.

Ворота отперлись. Огонек мелькнул и в другом окне. Бричка, въехавши на
двор, остановилась перед небольшим домиком, который за темнотою трудно
было рассмотреть. Только одна половина его была озарена светом,
исходившим из окон; видна была еще лужа перед домом, на которую прямо
ударял тот же свет. Дождь стучал звучно по деревянной крыше и
журчащими ручьями стекал в подставленную бочку. Между тем псы
заливались всеми возможными голосами: один, забросивши вверх голову,
выводил так протяжно и с таким старанием, как будто за это получал бог
знает какое жалованье; другой отхватывал наскоро, как пономарь; промеж
них звенел, как почтовый звонок, неугомонный дискант, вероятно
молодого щенка, и все это, наконец, повершал бас, может быть, старик,
наделенный дюжею собачьей натурой, потому что хрипел, как хрипит
певческий контрабас, когда концерт в полном разливе: тенора
поднимаются на цыпочки от сильного желания вывести высокую ноту, и
все, что ни есть, порывается кверху, закидывая голову, а он один,
засунувши небритый подбородок в галстук, присев и опустившись почти до
земли, пропускает оттуда свою ноту, от которой трясутся и дребезжат
стекла. Уже по одному собачьему лаю, составленному из таких
музыкантов, можно было предположить, что деревушка была порядочная; но
промокший и озябший герой наш ни о чем не думал, как только о постели.
Не успела бричка совершенно остановиться, как он уже соскочил на
крыльцо, пошатнулся и чуть не упал. На крыльцо вышла опять какая-то
женщина, помоложе прежней, но очень на нее похожая. Она проводила его
в комнату. Чичиков кинул вскользь два взгляда: комната была обвешана
старенькими полосатыми обоями; картины с какими-то птицами; между окон
старинные маленькие зеркала с темными рамками в виде свернувшихся
листьев; за всяким зеркалом заложены были или письмо, или старая
колода карт, или чулок; стенные часы с нарисованными цветами на
циферблате… невмочь было ничего более заметить. Он чувствовал, что
глаза его липнули, как будто их кто-нибудь вымазал медом. Минуту
спустя вошла хозяйка женщина пожилых лет, в каком-то спальном чепце,
надетом наскоро, с фланелью на шее, одна из тех матушек, небольших
помещиц, которые плачутся на неурожаи, убытки и держат голову
несколько набок, а между тем набирают понемногу деньжонок в
пестрядевые мешочки, размещенные по ящикам комодом. В один мешочек
отбирают всё целковики, в другой полтиннички, в третий четвертачки,
хотя с виду и кажется, будто бы в комоде ничего нет, кроме белья, да
ночных кофточек, да нитяных моточков, да распоротого салопа, имеющего
потом обратиться в платье, если старое как-нибудь прогорит во время
печения праздничных лепешек со всякими пряженцами или поизотрется само
собою. Но не сгорит платье и не изотрется само собою: бережлива
старушка, и салопу суждено пролежать долго в распоротом виде, а потом
достаться по духовному завещанию племяннице внучатной сестры вместе со
всяким другим хламом.

Чичиков извинился, что побеспокоил неожиданным приездом.

— Ничего, ничего, — сказала хозяйка. — В какое это время вас бог
— принес! Сумятица и вьюга такая… С дороги бы следовало поесть чего-
— нибудь, да пора-то ночная, приготовить нельзя.

Слова хозяйки были прерваны странным шипением, так что гость было
испугался; шум походил на то, как бы вся комната наполнилась змеями;
но, взглянувши вверх, он успокоился, ибо смекнул, что стенным часам
пришла охота бить. За шипеньем тотчас же последовало хрипенье, и
наконец, понатужась всеми силами, они пробили два часа таким звуком,
как бы кто колотил палкой по разбитому горшку, после чего маятник
пошел опять покойно щелкать направо и налево.

Чичиков поблагодарил хозяйку, сказавши, что ему не нужно ничего, чтобы
она не беспокоилась ни о чем, что, кроме постели, он ничего не
требует, и полюбопытствовал только знать, в какие места заехал он и
далеко ли отсюда пути к помещику Собакевичу, на что старуха сказала,
что и не слыхивала такого имени и что такого помещика вовсе нет.

— По крайней мере знаете Манилова? — сказал Чичиков

— А кто таков Манилов?

— Помещик, матушка.

— Нет, не слыхивала, нет такого помещика.

— Какие же есть?

— Бобров, Свиньин, Канапатьев, Харпакин, Трепакин, Плешаков.

— Богатые люди или нет?

— Нет, отец, богатых слишком нет. У кого двадцать душ, у кого
— тридцать, а таких, чтоб по сотне, таких нет.

Чичиков заметил, что он заехал в порядочную глушь.

— Далеко ли по крайней мере до города?

— А верст шестьдесят будет. Как жаль мне, что нечего вам покушать! не
— хотите ли, батюшка, выпить чаю?

— Благодарю, матушка. Ничего не нужно, кроме постели.

— Правда, с такой дороги и очень нужно отдохнуть. Вот здесь и
— расположитесь, батюшка, на этом диване. Эй, Фетинья, принеси перину,
— подушки и простыню. Какое-то время послал бог: гром такой — у меня
— всю ночь горела свеча перед образом. Эх, отец мой, да у тебя-то, как
— у борова, вся спина и бок в грязи! где так изволил засалиться?

— Еще славу богу, что только засалился, нужно благодарить, что не
— отломал совсем боков.

— Святители, какие страсти! Да не нужно ли чем потереть спину?

— Спасибо, спасибо. Не беспокойтесь, а прикажите только вашей девке
— повысушить и вычистить мое платье.

— Слышишь, Фетинья! — сказала хозяйка, обратясь к женщине, выходившей
— на крыльцо со свечою, которая успела уже притащить перину и, взбивши
— ее с обоих боков руками, напустила целый потоп перьев по всей
— комнате. — Ты возьми ихний-то кафтан вместе с исподним и прежде
— просуши их перед огнем, как делывали покойнику барину, а после
— перетри и выколоти хорошенько.

— Слушаю, сударыня! — говорила Фетинья, постилая сверх перины простыню
— и кладя подушки.

— Ну, вот тебе постель готова, — сказала хозяйка. — Прощай, батюшка,
— желаю покойной ночи. Да не нужно ли еще чего? Может, ты привык, отец
— мой, чтобы кто-нибудь почесал на ночь пятки? Покойник мой без этого
— никак не засыпал.

Но гость отказался и от почесывания пяток. Хозяйка вышла, и он тот же
час поспешил раздеться, отдав Фетинье всю снятую с себя сбрую, как
верхнюю, так и нижнюю, и Фетинья, пожелав также с своей стороны
покойной ночи, утащила эти мокрые доспехи. Оставшись один, он не без
удовольствия взглянул на свою постель, которая была почти до потолка.
Фетинья, как видно, была мастерица взбивать перины. Когда, подставивши
стул, взобрался он на постель, она опустилась под ним почти до самого
пола, и перья, вытесненные им из пределов, разлетелись во все углы
комнаты. Погасив свечу, он накрылся ситцевым одеялом и, свернувшись
под ним кренделем, заснул в ту же минуту. Проснулся на другой лень он
уже довольно поздним утром. Солнце сквозь окно блистало ему прямо в
глаза, и мухи, которые вчера спали спокойно на стенах и на потолке,
все обратились к нему: одна села ему на губу, другая на ухо, третья
норовила как бы усесться на самый глаз, ту же, которая имела
неосторожность подсесть близко к носовой ноздре, он потянул впросонках
в самый нос, что заставило его крепко чихнуть, — обстоятельство,
бывшее причиною его пробуждения. Окинувши взглядом комнату, он теперь
заметил, что на картинах не всё были птицы: между ними висел портрет
Кутузова и писанный масляными красками какой-то старик с красными
обшлагами на мундире, как нашивали при Павле Петровиче. Часы опять
испустили шипение и пробили десять; в дверь выглянуло женское лицо и в
ту же минуту спряталось, ибо Чичиков, желая получше заснуть, скинул с
себя совершенно все. Выглянувшее лицо показалось ему как будто
несколько знакомо. Он стал припоминать себе: кто бы это был, и наконец
вспомнил, что это была хозяйка. Он надел рубаху; платье, уже
высушенное и вычищенное, лежало возле него. Одевшись, подошел он к
зеркалу и чихнул опять так громко, что подошедший в это время к окну
индейский петух — окно же было очень близко от земли — заболтал ему
что-то вдруг и весьма скоро на своем странном языке, вероятно «желаю
здравствовать», на что Чичиков сказал ему дурака. Подошедши к окну, он
начал рассматривать бывшие перед ним виды: окно глядело едва ли не в
курятник; по крайней мере, находившийся перед ним узенький дворик весь
был наполнен птицами и всякой домашней тварью. Индейкам и курам не
было числа; промеж них расхаживал петух мерными шагами, потряхивая
гребнем и поворачивая голову набок, как будто к чему-то прислушиваясь;
свинья с семейством очутилась тут же; тут же, разгребая кучу сора,
съела она мимоходом цыпленка и, не замечая этого, продолжала уписывать
арбузные корки своим порядком. Этот небольшой дворик, или курятник,
переграждал дощатый забор, за которым тянулись пространные огороды с
капустой, луком, картофелем, светлой и прочим хозяйственным овощем. По
огороду были разбросаны кое-где яблони и другие фруктовые деревья,
накрытые сетями для защиты от сорок и воробьев, из которых последние
целыми косвенными тучами переносились с одного места на другое. Для
этой же самой причины водружено было несколько чучел на длинных
шестах, с растопыренными руками; на одном из них надет был чепец самой
хозяйки. За огородами следовали крестьянские избы, которые хотя были
выстроены врассыпную и не заключены в правильные улицы, но, по
замечанию, сделанному Чичиковым, показывали довольство обитателей, ибо
были поддерживаемы как следует: изветшавший тес на крышах везде был
заменен новым; ворота нигде не покосились, а в обращенных к нему
крестьянских крытых сараях заметил он где стоявшую запасную почти
новую телегу, а где и две. «Да у ней деревушка не маленька», — сказал
он и положил тут же разговориться и познакомиться с хозяйкой покороче.
Он заглянул в щелочку двери, из которой она было высунула голову, и,
увидев ее, сидящую за чайным столиком, вошел к ней с веселым и
ласковым видом.

— Здравствуйте, батюшка. Каково почивали? — сказала хозяйка,
— приподнимаясь с места. Она была одета лучше, нежели вчера, — в
— темном платье и уже не в спальном чепце, но на шее все так же было
— что-то завязано.

— Хорошо, хорошо, — говорил Чичиков, садясь в кресла. — Вы как,
— матушка?

— Плохо, отец мой.

— Как так?

— Бессонница. Все поясница болит, и нога, что повыше косточки, так вот
— и ломит.

— Пройдет, пройдет, матушка. На это нечего глядеть.

— Дай бог, чтобы прошло. Я-то смазывала свиным салом и скипидаром тоже
— смачивала. А с чем прихлебаете чайку? Во фляжке фруктовая.

— Недурно, матушка, хлебнем и фруктовой.

Читатель, я думаю, уже заметил, что Чичиков, несмотря на ласковый вид,
говорил, однако же, с большею свободою, нежели с Маниловым, и вовсе не
церемонился. Надобно сказать, кто у нас на Руси если не угнались еще
кой в чем другою за иностранцами, то далеко перегнали их в умении
обращаться. Пересчитать нельзя всех оттенков и тонкостей нашего
обращения. Француз или немец век не смекнет и не поймет всех его
особенностей и различий; он почти тем же голосом и тем же языком
станет говорить и с миллионщиком, и с мелким табачным торгашом, хотя,
конечно, в душе поподличает в меру перед первым. У нас не то: у нас
есть такие мудрецы, которые с помещиком, имеющим двести душ, будут
говорить совсем иначе, нежели с тем, у которого их триста, а у
которого их триста, будут говорить опять не так, как с тем, у которого
их пятьсот, а с тем, у которого их пятьсот, опять не так, как с тем, у
которого их восемьсот, — словом, хоть восходи до миллиона, всё найдут
оттенки. Положим, например, существует канцелярия, не здесь, а в
тридевятом государстве, а в канцелярии, положим, существует правитель
канцелярии. Прошу смотреть на него, когда он сидит среди своих
подчиненных, — да просто от страха и слова не выговоришь! гордость и
благородство, и уж чего не выражает лицо его? просто бери кисть, да и
рисуй: Прометей, решительный Прометей! Высматривает орлом, выступает
плавно, мерно. Тот же самый орел, как только вышел из комнаты и
приближается к кабинету своего начальника, куропаткой такой спешит с
бумагами под мышкой, что мочи нет. В обществе и на вечеринке, будь все
небольшого чина, Прометей так и останется Прометеем, а чуть немного
повыше его, с Прометеем сделается такое превращение, какого и Овидий
не выдумает: муха, меньше даже мухи, уничтожился в песчинку! «Да это
не Иван Петрович, — говоришь, глядя на него. — Иван Петрович выше
ростом, а этот и низенький и худенький; тот говорит громко, басит и
никогда не смеется, а этот черт знает что: пищит птицей и все
смеется». Подходишь ближе, глядишь — точно Иван Петрович! «Эхе-хе», —
думаешь себе… Но, однако ж, обратимся к действующим лицам. Чичиков,
как уж мы видели, решился вовсе не церемониться и потому, взявши в
руки чашку с чаем и вливши туда фруктовой, повел такие речи:

— У вас, матушка, хорошая деревенька. Сколько в ней душ?

— Душ-то в ней, отец мой, без малого восемьдесят, — сказала хозяйка, —
— да беда, времена плохи, вот и прошлый год был такой неурожай, что
— боже храни.

— Однако ж мужички на вид дюжие, избенки крепкие. А позвольте узнать
— фамилию вашу. Я так рассеялся… приехал в ночное время…:

— Коробочка, коллежская секретарша.

— Покорнейше благодарю. А имя и отчество?

— Настасья Петровна.

— Настасья Петровна? хорошее имя Настасья Петровна. У меня тетка
— родная, сестра моей матери, Настасья Петровна.

— А ваше имя как? — спросила помещица. — Ведь вы, я чай, заседатель?

— Нет, матушка, — отвечал Чичиков, усмехнувшись, — чай, не заседатель,
— а так ездим по своим делишкам.

— А, так вы покупщик! Как же жаль, право, что я продала мед купцам так
— дешево, а вот ты бы, отец мой, у меня, верно, его купил.

— А вот меду и не купил бы.

— Что ж другое? Разве пеньку? Да вить и пеньки у меня теперь маловато:
— полпуда всего.

— Нет, матушка, другого рода товарец: скажите, у вас умирали
— крестьяне?

— Ох, батюшка, осьмнадцать человека — сказала старуха, вздохнувши. — И
— умер такой всё славный народ, всё работники. После того, правда,
— народилось, да что в них: все такая мелюзга; а заседатель подъехал —
— подать, говорит, уплачивать с души. Народ мертвый, а плати, как за
— живого. На прошлой неделе сгорел у меня кузнец, такой искусный
— кузнец и слесарное мастерство знал.

— Разве у вас был пожар, матушка?

— Бог приберег от такой беды, пожар бы еще хуже; сам сгорел, отец мой.
— Внутри у него как-то загорелось, чересчур выпил, только синий огонек
— пошел от него, весь истлел, истлел и почернел, как уголь, а такой
— был преискусный кузнец! и теперь мне выехать не на чем: некому
— лошадей подковать.

— На все воля божья, матушка! — сказал Чичиков, вздохнувши, — против
— мудрости божией ничего нельзя сказать… Уступите-ка их мне, Настасья
— Петровна?

— Кого, батюшка?

— Да вот этих-то всех, что умерли.

— Да как же уступить их?

— Да так просто. Или, пожалуй, продайте. Я вам за них дам деньги.

— Да как же? Я, право, в толк-то не возьму. Нешто хочешь ты их
— откапывать из земли?

Чичиков увидел, что старуха хватила далеко и что необходимо ей нужно
растолковать, в чем дело. В немногих словах объяснил он ей, что
перевод или покупка будет значиться только на бумаге и души будут
прописаны как бы живые.

— Да на что ж они тебе? — сказала старуха, выпучив на него глаза.

— Это уж мое дело.

— Да ведь они ж мертвые.

— Да кто же говорит, что они живые? Потому-то и в убыток вам, что
— мертвые: вы за них платите, а теперь я вас избавлю от хлопот и
— платежа. Понимаете? Да не только избавлю, да еще сверх того дам вам
— пятнадцать рублей. Ну, теперь ясно?

— Право, не знаю, — произнесла хозяйка с расстановкой. — Ведь я
— мертвых никогда еще не продавала

— Еще бы! Это бы скорей походило на диво, если бы вы их кому нибудь
— продали. Или вы думаете, что в них есть в самом деле какой-нибудь
— прок?

— Нет, этого-то я не думаю. Что ж в них за прок, проку никакого нет.
— Меня только то и затрудняет, что они уже мертвые.

«Ну, баба, кажется, крепколобая!» — подумал про себя Чичиков.

— Послушайте, матушка. Да вы рассудите только хорошенько: — ведь вы
— разоряетесь, платите за него подать, как за живого…

— Ох, отец мой, и не говори об этом! — подхватила помещица. — Еще
— третью неделю взнесла больше полутораста. Да заседателя подмаслила.

— Ну, видите, матушка. А теперь примите в соображение только то, что
— заседателя вам подмасливать больше не нужно, потому что теперь я
— плачу за них; я, а не вы; я принимаю на себя все повинности. Я
— совершу даже крепость на свои деньги, понимаете ли вы это?

Старуха задумалась. Она видела, что дело, точно, как будто выгодно, да
только уж слишком новое и небывалое; а потому начала сильно
побаиваться, чтобы как-нибудь не надул ее этот покупщик; приехал же
бог знает откуда, да еще и в ночное время.

— Так что ж, матушка, по рукам, что ли? — говорил Чичиков.

— Право, отец мой, никогда еще не случалось продавать мне покойников.
— Живых-то я уступила, вот и третьего года протопопу двух девок, по
— сту рублей каждую, и очень благодарил, такие вышли славные
— работницы: сами салфетки ткут.

— Ну, да не о живых дело; бог с ними. Я спрашиваю мертвых.

— Право, я боюсь на первых-то порах, чтобы как-нибудь не понести
— убытку. Может быть, ты, отец мой, меня обманываешь, а они того… они
— больше как-нибудь стоят.

— Послушайте, матушка… эх, какие вы! что ж они могут стоить?
— Рассмотрите: ведь это прах. Понимаете ли? это просто прах. Вы
— возьмите всякую негодную, последнюю вещь, например даже простую
— тряпку, и тряпке есть цена: ее хоть по крайней мере купят на
— бумажную фабрику, а ведь это ни на что не нужно. Ну, скажите сами,
— на что оно нужно?

— Уж это, точно, правда. Уж совсем ни на что не нужно; да ведь меня
— одно только и останавливает, что ведь они уже мертвые.

«Эк ее, дубинноголовая какая! — сказал про себя Чичиков, уже начиная
«выходить из терпения. — Пойди ты сладь с нею! в пот бросила,
«проклятая старуха!» Тут он, вынувши из кармана платок, начал отирать
«пот, в самом деле выступивший на лбу. Впрочем, Чичиков напрасно
«сердился: иной и почтенный, и государственный даже человек, а на деле
«выходит совершенная Коробочка. Как зарубил что себе в голову, то уж
«ничем его не пересилить; сколько ни представляй ему доводов, ясных
«как день, все отскакивает от него, как резинный мяч отскакивает от
«стены. Отерши пот, Чичиков решился попробовать, нельзя ли ее навести
«на путь какою-нибудь иною стороною.

— Вы, матушка, — сказал он, — или не хотите понимать слов моих, или
— так нарочно говорите, лишь бы что-нибудь говорить… Я вам даю деньги:
— пятнадцать рублей ассигнациями. Понимаете ли? Ведь это деньги. Вы их
— не сыщете на улице. Ну, признайтесь, почем продали мед?

— По двенадцати рублей пуд.

— Хватили немножко греха на душу, матушка. По двенадцати не продали.

— Ей-богу, продала.

— Ну видите ль? Так зато это мед. Вы собирали его, может быть, около
— года, с заботами, со старанием, хлопотами; ездили, морили пчел,
— кормили их в погребе целую зиму; а мертвые души дело не от мира
— сего. Тут вы с своей стороны никакого не прилагали старания, на то
— была воля божия, чтоб они оставили мир сей, нанеся ущерб вашему
— хозяйству. Там вы получили за труд, за старание двенадцать рублей, а
— тут вы берете ни за что, даром, да и не двенадцать, а пятнадцать, да
— и не серебром, а все синими ассигнациями. — После таких сильных
— убеждений Чичиков почти уже не сомневался, что старуха наконец
— подастся.

— Право, — отвечала помещица, — мое такое неопытное вдовье дело! лучше
— ж я маненько повременю, авось понаедут купцы, да примерюсь к ценам.

— Страм, страм, матушка! просто страм! Ну что вы это говорите,
— подумайте сами! Кто же станет покупать их? Ну какое употребление он
— может из них сделать ?

— А может, в хозяйстве-то как-нибудь под случай понадобятся… —
— возразила старуха, да и не кончила речи, открыта рот и смотрела на
— него почти со страхом, желая знать, что он на это скажет.

— Мертвые в хозяйстве! Эк куда хватили! Воробьев разве пугать по ночам
— в вашем огороде, что ли?

— С нами крестная сила! Какие ты страсти говоришь! — проговорила
— старуха, крестясь.

— Куда ж еще вы их хотели пристроить? Да, впрочем, ведь кости и могилы
— — все вам остается, перевод только на бумаге. Ну, так что же? Как
— же? отвечайте по крайней мере.

Старуха вновь задумалась.

— О чем же вы думаете, Настасья Петровна?

— Право, я все не приберу, как мне быть; лучше я вам пеньку продам.

— Да что ж пенька? Помилуйте, я вас прошу совсем о другом, а вы мне
— пеньку суете! Пенька пенькою, в другой раз приеду, заберу и пеньку.
— Так как же, Настасья Петровна?

— Ей-богу, товар такой странный, совсем небывалый!

Здесь Чичиков вышел совершенно из границ всякого терпения, хватил в
сердцах стулом об пол и посулил ей черта.

Черта помещица испугалась необыкновенно.

— Ох, не припоминай его, бог с ним! — вскрикнула она, вся побледнев. —
— Еще третьего дня всю ночь мне снился окаянный. Вздумала было на ночь
— загадать на картах после молитвы, да, видно, в наказание-то бог и
— наслал его. Такой гадкий привиделся; а рога-то длиннее бычачьих.

— Я дивлюсь, как они вам десятками не снятся. Из одного христианского
— человеколюбия хотел: вижу, бедная вдова убивается, терпит нужду… да
— пропади и околей со всей вашей деревней!..

— Ах, какие ты забранки пригинаешь! — сказала старуха, глядя на него
— со страхом.

— Да не найдешь слов с вами! Право, словно какая-нибудь, не говоря
— дурного слова, дворняжка, что лежит на сене и сам не ест сена, и
— другим не лает. Я хотел было закупать у вас хозяйственные продукты
— разные, потому что я и казенные подряды тоже веду… — Здесь он
— прилгнул, хоть и вскользь и без всякого дальнейшего размышления, но
— неожиданно удачно. Казенные подряды подействовали сильно на Настасью
— Петровну, по крайней мере, она произнесла уже почти просительным
— голосом:

— Да чего ж ты рассердился так горячо? Знай я прежде, что ты такой
— сердитый, да я бы совсем тебе и не прекословила.

— Есть из чего сердиться! Дело яйца выеденного не стоит, а я стану из-
— за него сердиться!

— Ну, да изволь, я готова отдать за пятнадцать ассигнацией! Только
— смотри, отец мой, а насчет подрядов-то: если случится муки брать
— ржаной, или гречневой, или круп, или скотины битой, так уж,
— пожалуйста, не обидь меня.

— Нет, матушка, не обижу, — говорил он, а между тем отирал рукою пот,
— который в три ручья катился по лицу его. Он расспросил ее, не имеет
— ли она в городе какого-нибудь поверенного или знакомого, которого бы
— могла уполномочить на совершение крепости и всего, что следует.

— Как же, протопопа, отца Кирила, сын служит в палате, — сказала
— Коробочка.

Чичиков попросил ее написать к нему доверенное письмо и, чтобы
избавить от лишних затруднений, сам даже взялся сочинить.

«Хорошо бы было, — подумала между тем про себя Коробочка, — если бы он
«забрал у меня в казну муку и скотину. Нужно его задобрить: теста со
«вчерашнего вечера еще осталось, так пойти сказать Фетинье, чтоб
«спекла блинов; хорошо бы также загнуть пирог пресный с яйцом, у меня
«его славно загибают, да и времени берет немного». Хозяйка вышла с тем
«чтобы привести в исполнение мысль насчет загнутия пирога и, вероятно,
«пополнить ее другими произведениями домашней пекарни и стряпни; а
«Чичиков вышел в гостиную, где провел ночь, с тем чтобы вынуть нужные
«бумаги из своей шкатулки. В гостиной давно уже было все прибрано,
«роскошные перины вынесены вон, перед диваном стоял покрытый стол.
«Поставив на него шкатулку, он несколько отдохнул, ибо чувствовал, что
«был весь в поту, как в реке: все, что ни было на нем, начиная от
«рубашки до чулок, все было мокро. Эк уморила как проклятая старуха» —
«сказал он, немного отдохнувши, и отпер шкатулку. Автор уверен, что
«есть читатели такие любопытные, которые пожелают даже узнать план и
«внутреннее расположение шкатулки. Пожалуй, почему же не
«удовлетворить! Вот оно, внутреннее расположение: в самой средине
«мыльница, за мыльницею шесть-семь узеньких перегородок для бритв;
«потом квадратные закоулки для песочницы и чернильницы с выдолбленною
«между ними лодочкой для перьев, сургучей и всего, что подлиннее;
«потом всякие перегородки с крышечками и без крышечек для того, что
«покороче, наполненные билетами визитными, похоронными, театральными и
«другими, которые складывались на память. Весь верхний ящик со всеми
«перегородками вынимался, и под ним находилось пространство, занятое
«кипами бумаг в лист, потом следовал маленький потаенный ящик для
«денег, выдвигавшийся незаметно сбоку шкатулки. Он всегда так поспешно
«выдвигался и задвигался в ту же минуту хозяином, что наверно нельзя
«сказать, сколько было там денег. Чичиков тут же занялся и, очинив
«перо, начал писать. В это время вошла хозяйка.

— Хорош у тебя ящик, отец мой, — сказала она, подсевши к нему. — Чай,
— в Москве купил его?

— В Москве, — отвечал Чичиков, продолжая писать.

— Я уж знала это: там все хорошая работа. Третьего года сестра моя
— привезла оттуда теплые сапожки для детей: такой прочный товар, до
— сих пор носится. Ахти, сколько у тебя тут гербовой бумаги! —
— продолжала она заглянувши к нему в шкатулку. И в самом деле,
— гербовой бумаги было там немало. — Хоть бы мне листок подарил! а у
— меня такой недостаток; случится в суд просьбу подать, а и не на чем.

Чичиков объяснил ей, что эта бумага не такого рода, что она назначена
для совершения крепостей, а не для просьб. Впрочем, чтобы успокоить
ее, он дал ей какой-то лист в рубль ценою. Написавши письмо, дал он ей
подписаться и попросил маленький списочек мужиков. Оказалось, что
помещица не вела никаких записок, ни списков, а знала почти всех
наизусть; он заставил ее тут же продиктовать их. Некоторые крестьяне
несколько изумили его своими фамилиями, а еще более прозвищами, так
что он всякий раз, слыша их, прежде останавливался, а потом уже
начинал писать. Особенно поразил его какой-то Петр Савельев Неуважай-
Корыто, так что он не мог не сказать: «Экой длинный!» Другой имел
прицепленный к имени «Коровий кирпич», иной оказался просто: Колесо
Иван. Оканчивая писать, он потянул несколько к себе носом воздух и
услышал завлекательный запах чего-то горячего в масле.

— Прошу покорно закусить, — сказала хозяйка.

Чичиков оглянулся и увидел, что на столе стояли уже грибки, пирожки,
скородумки, шанишки, пряглы, блины, лепешки со всякими припеками:
припекой с лучком, припекой с маком, припекой с творогом, припекой со
сняточками, и невесть чего не было.

— Пресный пирог с яйцом! — сказала хозяйка.

Чичиков подвинулся к пресному пирогу с яйцом, и, съевши тут же с
небольшим половину, похвалил его. И в самом деле, пирог сам по себе
был вкусен, а после всей возни и проделок со старухой показался еще
вкуснее.

— А блинков? — сказала хозяйка.

В ответ на это Чичиков свернул три блина вместе и, обмакнувши их в
растопленное масло, отправил в рот, а губы и руки вытер салфеткой.
Повторивши это раза три, он попросил хозяйку приказать заложить его
бричку. Настасья Петровна тут же послала Фетинью, приказавши в то же
время принести еще горячих блинов.

— У вас, матушка, блинцы очень вкусны, — сказал Чичиков, принимаясь за
— принесенные горячие.

— Да у меня-то их хорошо пекут, — сказала хозяйка, — да вот беда:
— урожай плох, мука уж такая неважная… Да что же, батюшка, вы так
— спешите? — проговорила она, увидя, что Чичиков взял в руки картуз, —
— ведь и бричка еще не заложена.

— Заложат, матушка, заложат. У меня скоро закладывают.

— Так уж, пожалуйста, не позабудьте насчет подрядов.

— Не забуду, не забуду, — говорил Чичиков, выходя в сени.

— А свиного сала не покупаете? — сказала хозяйка, следуя за ним.

— Почему не покупать? Покупаю, только после.

— У меня о святках и свиное сало будет.

— Купим, купим, всего купим, и свиного сала купим.

— Может быть, понадобится птичьих перьев. У меня к Филиппову посту
— будут и птичьи перья.

— Хорошо, хорошо, — говорил Чичиков.

— Вот видишь, отец мой, и бричка твоя еще не готова, — сказала
— хозяйка, когда они вышли на крыльцо.

— Будет, будет готова. Расскажите только мне, как добраться до большой
— дороги.

— Как же бы это сделать? — сказала хозяйка. — Рассказать-то мудрено,
— поворотов много; разве я тебе дам девчонку, чтобы проводила. Ведь у
— тебя, чай, место есть на козлах, где бы присесть ей.

— Как не быть.

— Пожалуй, я тебе дам девчонку; она у меня знает дорогу, только ты
— смотри! не завези ее, у меня уже одну завезли купцы.

Чичиков уверил ее, что не завезет, и Коробочка, успокоившись, уже
стала рассматривать все, что было во дворе ее; вперила глаза на
ключницу, выносившую из кладовой деревянную побратиму с медом, на
мужика, показавшегося в воротах, и мало-помалу вся переселилась в
хозяйственную жизнь. Но зачем так долго заниматься Коробочкой?
Коробочка ли, Манилова ли, хозяйственная ли жизнь, или нехозяйственная
— мимо их! Не то на свете дивно устроено: веселое мигом обратится в
печальное, если только долго застоишься перед ним, и тогда бог знает
что взбредет в голову. Может быть, станешь даже думать: да полно,
точно ли Коробочка стоит так низко на бесконечной лестнице
человеческого совершенствования? Точно ли так велика пропасть,
отделяющая ее от сестры ее, недосягаемо огражденной стенами
аристократического дома с благовонными чугунными лестницами, сияющей
медью, красным деревом и коврами, зевающей за недочитанной книгой в
ожидании остроумно-светского визита, где ей предстанет поле блеснуть
умом и высказать вытверженные мысли, мысли, занимающие по законам моды
на целую неделю город, мысли не о том, что делается в ее доме и в ее
поместьях, запутанных и расстроенных благодаря незнанью хозяйственного
дела, а о том, какой политический переворот готовится во Франции,
какое направление принял модный католицизм. Но мимо, мимо! зачем
говорить об этом? Но зачем же среди недумающих, веселых, беспечных
минут сама собою вдруг пронесется иная чудная струя: еще смех не успел
совершенно сбежать с лица, а уже стал другим среди тех же людей, и уже
другим светом осветилось лицо…

— А вот бричка, вот бричка! — вскричал Чичиков, увидя наконец
— подъезжавшую свою бричку. — Что ты, болван, так долго копался?
— Видно, вчерашний хмель у тебя не весь еще выветрило.

Селифан на это ничего не отвечал.

— Прощайте, матушка! А что же, где ваша девчонка?

— Эй, Пелагея! — сказала помещица стоявшей около крыльца девчонке лет
— одиннадцати, в платье из домашней крашенины и с босыми ногами,
— которые издали можно было принять за сапоги, так они были облеплены
— свежею грязью. — Покажи-ка барину дорогу.

Селифан помог взлезть девчонке на козлы, которая, ставши одной ногой
на барскую ступеньку, сначала запачкала ее грязью, а потом уже
взобралась на верхушку и поместилась возле него. Вслед за нею и сам
Чичиков занес ногу на ступеньку и, понагнувши бричку на правую
сторону, потому что был тяжеленек, наконец поместился, сказавши:

— А! теперь хорошо! прощайте, матушка!

Кони тронулись.

Селифан был во всю дорогу суров и с тем вместе очень внимателен к
своему делу, что случалося с ним всегда после того, когда либо в чем
провинился, либо был пьян. Лошади были удивительно как вычищены. Хомут
на одной из них, надевавшийся дотоле почти всегда в разодранном виде,
так что из-под кожи выглядывала пакля, был искусно зашит. Во всю
дорогу был он молчалив, только похлестывал кнутом, и не обращал
никакой поучительной речи к лошадям, хотя чубарому коню, конечно,
хотелось бы выслушать что-нибудь наставительное, ибо в это время вожжи
всегда как-то лениво держались в руках словоохотного возницы и кнут
только для формы гулял поверх спин. Но из угрюмых уст слышны были на
сей раз одни однообразно неприятные восклицания: «Ну же, ну, ворона!
зевай! зевай!» — и больше ничего. Даже сам гнедой и Заседатель были
недовольны, не услышавши ни разу ни «любезные», ни «почтенные».
Чубарый чувствовал пренеприятные удары по своим полным и широким
частям. «Вишь ты, как разнесло его! — думал он сам про себя, несколько
припрядывая ушами. — Небось знает, где бить! Не хлыснет прямо по
спине, а так и выбирает место, где поживее: по ушам зацепит или под
брюхо захлыснет».

— Направо, что ли? — с таким сухим вопросом обратился Селифан к
— сидевшей возле него девчонке, показывая ей кнутом на почерневшую от
— дождя дорогу между яркозелеными, освещенными полями.

— Нет, нет, я уж покажу, — отвечала девчонка.

— Куда ж? — сказал Селифан, когда подъехали поближе.

— Вот куды, — отвечала девчонка, показывая рукою.

— Эх ты! — сказал Селифан. — Да это и есть направо: не знает, где
— право, где лево!

Хотя день был очень хорош, но земля до такой степени загрязнилась, что
колеса брички, захватывая ее, сделались скоро покрытыми ею, как
войлоком, что значительно отяжелило экипаж; к тому же почва была
глиниста и цепка необыкновенно. То и другое было причиною, что они не
могли выбраться из проселков раньше полудня. Без девчонки было бы
трудно сделать и это, потому что дороги расползались во все стороны,
как пойманные раки, когда их высыпают из мешка, и Селифану довелось бы
поколесить уже не по своей вине. Скоро девчонка показала рукою на
черневшее вдали строение, сказавши:

— Вон столбовая дорога!

— А строение? — спросил Селифан.

— Трактир, — сказала девчонка.

— Ну, теперь мы сами доедем, — сказал Селифан, — ступай себе домой.

Он остановился и помог ей сойти, проговорив сквозь зубы: «Эх ты,
черноногая!»

Чичиков дал ей медный грош, и она побрела восвояси, уже довольная тем,
что посидела на козлах.






Глава четвертая


Подъехавши к трактиру, Чичиков велел остановиться по двум причинам. С
одной стороны, чтоб дать отдохнуть лошадям, а с другой стороны, чтоб и
самому несколько закусить и подкрепиться. Автор должен признаться, что
весьма завидует аппетиту и желудку такого рода людей. Для него
решительно ничего не значат все господа большой руки, живущие в
Петербурге и Москве, проводящие время в обдумывании, что бы такое
поесть завтра и какой бы обед сочинить на послезавтра, и принимающиеся
за этот обед не иначе, как отправивши прежде в рот пилюлю; глотающие
устерс, морских пауков и прочих чуд, а потом отправляющиеся в Карлсбад
или на Кавказ. Нет, эти господа никогда не возбуждали в нем зависти.
Но господа средней руки, что на одной станции потребуют ветчины, на
другой поросенка, на третьей ломоть осетра или какую-нибудь запеканную
колбасу с луком и потом как ни в чем не бывало садятся за стол в какое
хочешь время, и стерляжья уха с налимами и молоками шипит и ворчит у
них меж зубами, заедаемая расстегаем или кулебякой с сомовьим плёсом,
так что вчуже пронимает аппетит, — вот эти господа, точно, пользуются
завидным даянием неба! Не один господин большой руки пожертвовал бы
сию же минуту половину душ крестьян и половину имений, заложенных и
только, чтобы иметь такой желудок, какой имеет господин средней руки;
но то беда, что ни за какие деньги, ниже' имения, с улучшениями и без
улучшений, нельзя приобресть такого желудка, какой бывает у господина
средней руки.

Деревянный потемневший трактир принял Чичикова под свой узенький
гостеприимный навес на деревянных выточенных столбиках, похожих на
старинные церковные подсвечники. Трактир был что-то вроде русской
избы, несколько в большем размере. Резные узорочные карнизы из свежего
дерева вокруг окон и под крышей резко и живо пестрели темные его
стены; на ставнях были нарисованы кувшины с цветами.

Взобравшись узенькою деревянною лестницею наверх, в широкие сени, он
встретил отворявшуюся со скрипом дверь и толстую старуху в пестрых
ситцах, проговорившую: «Сюда пожалуйте!» В комнате попались всё старые
приятели, попадающиеся всякому в небольших деревянных трактирах, каких
немало выстроено по дорогам, а именно заиндевелый самовар,
выскобленные гладко сосновые стены, трехугольный шкаф с чайниками и
чашками в углу, фарфоровые вызолоченные яички пред образами, висевшие
на голубых и красных ленточках, окотившаяся недавно кошка, зеркало,
показывавшее вместо двух четыре глаза, а вместо лица какую-то лепешку;
наконец натыканные пучками душистые травы и гвоздики у образов,
высохшие до такой степени, что желавший понюхать их только чихал и
больше ничего.

— Поросенок есть? — с таким вопросом обратился Чичиков к стоявшей
— бабе.

— Есть.

— С хреном и со сметаною?

— С хреном и со сметаною.

— Давай его сюда!

Старуха пошла копаться и принесла тарелку, салфетку, накрахмаленную до
того что дыбилась, как засохшая кора, потом нож с пожелтевшею костяною
колодочкою, тоненький, как перочинный, двузубую вилку и солонку,
которую никак нельзя было поставить прямо на стол.

Герой наш, по обыкновению, сейчас вступил с нею в разговор и
расспросил, сама ли она держит трактир, или есть хозяин, а сколько
дает доходу трактир, и с ними ли живут сыновья, и что старший сын
холостой или женатый человек, и какую взял жену, с большим ли
приданым, или нет, и доволен ли был тесть, и не сердился ли, что мало
подарков получил на свадьбе, — словом, не пропустил ничего. Само собою
разумеется, что полюбопытствовал узнать, какие в окружности находятся
у них помещики, и узнал, что всякие есть помещики: Плотин, Почитаев,
Мыльной, Чепраков-полковник, Собакевич. «А! Собакевича знаешь?» —
спросил он и тут же услышал, что старуха знает не только Собакевича,
но и Манилова, и что Манилов будет поделикатней Собакевича: велит
тотчас сварить курицу, спросит и телятинки; коли есть баранья печенка,
то и бараньей печенки спросит, и всего только что попробует, а
Собакевич одного чего-нибудь спросит, да уж зато всё съест, даже и
подбавки потребует за ту же цену.

Когда он таким образом разговаривал, кушая поросенка, которого
оставался уже последний кусок, послышался стук колес подьехавшего
экипажа. Взглянувши в окно, увидел он остановившуюся перед трактиром
легонькую бричку, запряженную тройкою добрых лошадей. Из брички
вылезали двое какие-то мужчин. Один белокурый, высокого роста; другой
немного пониже, чернявый. Белокурый был в темно-синей венгерке,
чернявый просто в полосатом архалуке. Издали тащилась еще колясчонка,
пустая, влекомая какой-то длинношерстной четверней с изорванными
хомутами и веревочной упряжью. Белокурый тотчас же отправился по
лестнице наверх, между тем как черномазый еще оставался и щупал что-то
в бричке, разговаривая тут же со слугою и махая в то же время ехавшей
за ними коляске. Голос его показался Чичикову как будто несколько
знакомым. Пока он его рассматривал, белокурый успел уже нащупать дверь
и отворить ее. Это был мужчина высокого роста, лицом худощавый, или
что называют издержанный, с рыжими усиками. По загоревшему лицу его
можно было заключить, что он знал, что такое дым, если не пороховой,
то по крайней мере табачный. Он вежливо поклонился Чичикову, на что
последний ответил тем же. В продолжение немногих минут они вероятно бы
разговорились и хорошо познакомились между собою, потому что уже
начало было сделано, и оба почти в одно и то же время изъявили
удовольствие, что пыль по дороге была совершенно прибита вчерашним
дождем и теперь ехать и прохладно и приятно, как вошел чернявый его
товарищ, сбросив с головы на стол картуз свой, молодцевато взъерошив
рукой свои черные густые волосы. Это был среднего роста, очень недурно
сложенный молодец с полными румяными щеками, с белыми, как снег,
зубами и черными, как смоль, бакенбардами. Свеж он был, как кровь с
молоком; здоровье, казалось, так и прыскало с лица его.

— Ба, ба, ба! — вскричал он вдруг, расставив обе руки при виде
— Чичикова. — Какими судьбами?

Чичиков узнал Ноздрева, того самого, с которым он вместе обедал у
прокурора и который с ним в несколько минут сошелся на такую короткую
ногу, что начал уже говорить «ты», хотя, впрочем, он с своей стороны
не подал к тому никакого повода.

— Куда ездил? — говорил Ноздрев и, не дождавшись ответа, продолжал: —
— А я, брат, с ярмарки. Поздравь: продулся в пух! Веришь ли, что
— никогда в жизни так не продувался. Ведь я на обывательских приехал!
— Вот посмотри нарочно в окно! — Здесь он нагнул сам голову Чичикова,
— так что тот чуть не ударился ею об рамку. — Видишь, какая дрянь!
— Насилу дотащили, проклятые, я уже перелез вот в его бричку. — Говоря
— это, Ноздрев показал пальцем на своего товарища. — А вы еще не
— знакомы? Зять мой Мижуев! Мы с ним все утро говорили о тебе. «Ну,
— смотри, говорю, если мы не встретим Чичикова» Ну, брат, если б ты
— знал, как я продулся! Поверишь ли, что не только убухал четырех
— рысаков — всё спустил. Ведь на мне нет ни цепочки, ни часов… —
— Чичиков взглянул и увидел точно, что на нем не было ни цепочки, ни
— часов. Ему даже показалось, что и один бакенбард был у него меньше и
— не так густ, как другой. — А ведь будь только двадцать рублей в
— кармане, — продолжал Ноздрев, — именно не больше как двадцать, я
— отыграл бы все, то есть кроме того, что отыграл бы, вот как честный
— человек, тридцать тысяч сейчас положил бы в бумажник.

— Ты, однако, и тогда так говорил, — отвечал белокурый, — а когда я
— тебе дал пятьдесят рублей, тут же просадил их.

— И не просадил бы! ей-богу, не просадил бы! Не сделай я сам глупость,
— право, не просадил бы. Не загни я после пароле на проклятой семерке
— утку, я бы мог сорвать весь банк.

— Однако ж не сорвал, — сказал белокурый.

— Не сорвал потому, что загнул утку не вовремя. А ты думаешь, майор
— твой хорошо играет?

— Хорошо или не хорошо, однако ж он тебя обыграл.

— Эка важность! — сказал Ноздрев, — этак и я его обыграю. Нет, вот
— попробуй он играть дублетом, так вот тогда я посмотрю, я посмотрю
— тогда, какой он игрок! Зато, брат Чичиков, как покатили мы в первые
— дни! Правда, ярмарка была отличнейшая. Сами купцы говорят, что
— никогда не было такого съезда. У меня все, что ни привезли из
— деревни, продали по самой выгоднейшей цене. Эх, братец, как
— покутили! Теперь даже, как вспомнишь… черт возьми! то есть как жаль,
— что ты не был. Вообрази, что в трех верстах от города стоял
— драгунский полк. Веришь ли, что офицеры, сколько их ни было, сорок
— человек одних офицеров было в городе; как начали мы, братец, пить…
— Штабс-ротмистр Поцелуев… такой славный! усы, братец, такие! Бордо
— называет просто бурдашкой. «Принеси-ка, брат, говорит, бурдашки!»
— Поручик Кувшинников… Ах, братец, какой премилый человек! вот уж,
— можно сказать, во всей форме кутила. Мы все были с ним вместе.
— Какого вина отпустил нам Пономарев! Нужно тебе знать, что он
— мошенник и в его лавке ничего нельзя брать: в вино мешает всякую
— дрянь: сандал, жженую пробку и даже бузиной, подлец, затирает; но
— зато уж если вытащит из дальней комнатки, которая называется у него
— особенной, какую-нибудь бутылочку — ну просто, брат, находишься в
— эмпиреях. Шампанское у нас было такое — что пред ним губернаторское?
— просто квас. Вообрази, не клико, а какое-то клико-матрадура, это
— значит двойное клико. И еще достал одну бутылочку французского под
— названием: бонбон. Запах? — розетка и все что хочешь. Уж так
— покутили!.. После нас приехал какой-то князь, послал в лавку за
— шампанским, нет ни одной бутылки во всем городе, все офицеры выпили.
— Веришь ли, что я один в продолжение обеда выпил семнадцать бутылок
— шампанского!

— Ну, семнадцать бутылок ты не выпьешь, — заметил белокурый.

— Как честный человек говорю, что выпил, — отвечал Ноздрев.

— Ты можешь себе говорить все что хочешь, а я тебе говорю, что и
— десяти не выпьешь.

— Ну хочешь об заклад, что выпью!

— К чему же об заклад?

— Ну, поставь ружье, которое купил в городе.

— Не хочу.

— Ну да поставь, попробуй.

— И пробовать не хочу

— Да, был бы ты без ружья, как без шапки. Эх, брат Чичиков, то есть
— как я жалел, что тебя не было Я знаю, что ты бы не расстался с
— поручиком Кувшинниковым. Уж как бы вы с ним хорошо сошлись! Это не
— то что прокурор и все губернские скряги в нашем городе, которые так
— и трясутся за каждую копейку. Этот, братец, и в гальбик, и в
— банчишку, и во все что хочешь. Эх, Чичиков, ну что бы тебе стоило
— приехать? Право, свинтус ты за это, скотовод эдакой! Поцелуй меня,
— душа, смерть люблю тебя! Мижуев, смотри, вот судьба свела: ну что он
— мне или я ему? Он приехал бог знает откуда, я тоже здесь живу… А
— сколько было, брат, карет, и все это en gros[[1 - В большом
— количестве (франц.)]]. В фортунку крутнул: выиграл две банки помады,
— фарфоровую чашку и гитару; потом опять поставил один раз и
— прокрутил, канальство, еще сверх шесть целковых. А какой, если б ты
— знал, волокита Кувшинников! Мы с ним были на всех почти балах. Одна
— была такая разодетая, рюши на ней, и трюши, и черт знает чего не
— было… я думаю себе только: «черт возьми!» А Кувшинников, то есть это
— такая бестия, подсел к ней и на французском языке подпускает ей
— такие комплименты… Поверишь ли, простых баб не пропустил. Это он
— называет: попользоваться насчет клубнички. Рыб и балыков навезли
— чудных. Я таки привез с собою один; хорошо, что догадался купить,
— когда были еще деньги. Ты куда теперь едешь?

— А я к человечку к одному, — сказал Чичиков.

— Ну, что человечек, брось его! поедем во мне!

— Нет, нельзя, есть дело.

— Ну вот уж и дело! уж и выдумал! Ах ты, Оподелок Иванович!

— Право, дело, да еще и нужное.

— Пари держу, врешь! Ну скажи только, к кому едешь?

— Ну, к Собакевичу.

Здесь Ноздрей захохотал тем звонким смехом, каким заливается только
свежий, здоровый человек, у которого все до последнего выказываются
белые, как сахар, зубы, дрожат и прыгают щеки, а сосед за двумя
дверями, в третьей комнате, вскидывается со сна, вытаращив очи и
произнося: «Эк его разобрало!»

— Что ж тут смешного? — сказал Чичиков, отчасти недовольный таким
— смехом.

Но Ноздрев продолжал хохотать во все горло, приговаривая:

— Ой, пощади, право, тресну со смеху!

— Ничего нет смешного: я дал ему слово, — сказал Чичиков.

— Да ведь ты жизни не будешь рад, когда приедешь к нему, это просто
— жидомор! Ведь я знаю твой характер, ты жестоко опешишься, если
— думаешь найти там банчишку и добрую бутылку какого-нибудь бонбона.
— Послушай, братец: ну к черту Собакевича, поедем во мне! каким
— балыком попотчую! Пономарев, бестия, так раскланивался, говорит:
— «Для вас только, всю ярмарку, говорит, обыщите, не найдете такого».
— Плут, однако ж, ужасный. Я ему в глаза это говорил: «Вы, говорю, с
— нашим откупщиком первые мошенники!» Смеется, бестия, поглаживая
— бороду. Мы с Кувшинниковым каждый день завтракали в его лавке. Ах,
— брат, вот позабыл тебе сказать: знаю, что ты теперь не отстанешь, но
— за десять тысяч не отдам, наперед говорю. Эй, Порфирий! — закричал
— он, подошедши к окну, на своего человека, который держал в одной
— руке ножик, а в другой корку хлеба с куском балыка, который
— посчастливилось ему мимоходом отрезать, вынимая что-то из брички. —
— Эй, Порфирий, — кричал Ноздрев, — принеси-ка щенка! Каков щенок! —
— продолжал он, обращаясь к Чичикову. — Краденый, ни за самого себя не
— отдавал хозяин. Я ему сулил каурую кобылу, которую, помнишь, выменял
— у Хвостырева… — Чичиков, впрочем, отроду не видел ни каурой кобылы,
— ни Хвостырева.

— Барин! ничего не хотите закусить? — сказала в это время, подходя к
— нему, старуха.

— Ничего. Эх, брат, как покутили! Впрочем, давай рюмку водки; какая у
— тебя есть?

— Анисовая, — отвечала старуха.

— Ну, давай анисовой, — сказал Ноздрей.

— Давай уж и мне рюмку! — сказал белокурый.

— В театре одна актриса так, каналья, пела, как канарейка!
— Кувшинников, который сидел возле меня, «Вот, говорит, брат,
— попользоваться бы насчет клубнички!» Одних балаганов, я думаю, было
— пятьдесят. Фенарди четыре часа вертелся мельницею. — Здесь он принял
— рюмку из рук старухи, которая ему за то низко поклонилась. — А,
— давай его сюда! — закричал он увидевши Порфирия, вошедшего с щенком.
— Порфирий был одет, так же как и барин, в каком-то архалуке,
— стеганном на вате, но несколько позамасленней.

— Давай его, клади сюда на пол!

Порфирий положил щенка на пол, который, растянувшись на все четыре
лапы, нюхал землю.

— Вот щенок! — сказал Ноздрев, взявши его за приподнявши рукою. Щенок
— испустил довольно жалобный вой.

— Ты, однако ж, не сделал того, что я тебе говорил, — сказал Ноздрев,
— обратившись к Порфирию и рассматривая брюхо щенка, — и не подумал
— вычесать его?

— Нет, я его вычесывал.

— А отчего же блохи?

— Не могу знать. Статься может, как-нибудь из брички поналезли.

— Врешь, врешь, и не воображал чесать; я думаю, дурак, еще своих
— напустил. Вот посмотри-ка, Чичиков, посмотри, какие уши, на-ка
— пощупай рукою.

— Да зачем, я и так вижу: доброй породы! — отвечал Чичиков.

— Нет, возьми-ка нарочно, пощупай уши!

Чичиков в угодность ему пощупал уши, примолвивши:

— Да, хорошая будет собака.

— А нос, чувствуешь, какой холодный? возьми-на рукою.

Не желая обидеть его, Чичиков взял и за нос, сказавши:

— Хорошее чутье.

— Настоящий мордаш, — продолжал Ноздрев, — а, признаюсь, давно острил
— зубы на мордаша. На, Порфирий, отнеси его!

Порфирий, взявши щенка под брюхо, унес его в бричку.

— Послушай, Чичиков, ты должен непременно теперь ехать ко мне, пять
— верст всего, духом домчимся, а там, пожалуй, можешь и к Собакевичу.

«А что ж, — подумал про себя Чичиков, — заеду я в самом деле к
«Ноздреву. Чем же он хуже других, такой же человек, да еще и
«проигрался. Горазд он, как видно, на все, стало быть у него даром
«можно кое-что выпросить».

— Изволь, едем, — сказал он, — но чур не задержать, мне время дорого.

— Ну, душа, вот это так! Вот это хорошо, постой же, я тебя поцелую за
— это. — Здесь Ноздрев и Чичиков поцеловались. — И славно: втроем и
— покатим!

— Нет, ты уж, пожалуйста, меня-то отпусти, — говорил белокурый, — мне
— нужно домой.

— Пустяки, пустяки, брат, не пущу.

— Право, жена будет сердиться; теперь же ты можешь, пересесть вот в
— ихнюю бричку.

— Ни, ни, ни! И не думай.

Белокурый был один из тех людей, в характере которых на первый взгляд
есть какое-то упорство. Еще не успеешь открыть рта, как они уже готовы
спорить и, кажется, никогда не согласятся на то, что явно
противуположно их образу мыслей, что никогда не назовут глупого умным
и что в особенности не согласятся плясать по чужой дудке; а кончится
всегда тем, что в характере их окажется мягкость, что они согласятся
именно на то, что отвергали, глупое назовут умным и пойдут потом
поплясывать как нельзя лучше под чужую дудку, — словом, начнут гладью,
а кончат гадью.

— Вздор! — сказал Ноздрев в ответ на каков-то ставление белокурого,
— надел ему на голову картуз, и — белокурый отправился вслед за ними.

— За водочку, барин, не заплатили… — сказала старуха

— А, хорошо, хорошо, матушка. Послушай, зятек! заплати, пожалуйста. У
— меня нет ни копейки в кармане.

— Сколько тебе? — сказал зятек.

— Да что, батюшка, двугривенник всего, — сказала старуха.

— Врешь, врешь. Дай ей полтину, предовольно с нее.

— Маловато, барин, — сказала старуха, однако ж взяла деньги с
— благодарностию и еще побежала впопыхах отворять им дверь. Она была
— не в убытке, потому что запросила вчетверо против того, что стоила
— водка.

Приезжие уселись. Бричка Чичикова ехала рядом с бричкой, в которой
сидели Ноздрев и его зять, и потому они все трое могли свободно между
собою разговаривать в продолжение дороги. За ними следовала,
беспрестанно отставая, небольшая колясчонка Ноздрева на тощих
обывательских лошадях. В ней сидел Порфирий с щенком.

Так как разговор, который путешественники вели между собою, был не
очень интересен для читателя, то сделаем лучше, если скажем что-нибудь
о самом Ноздреве, которому, может быть, доведется сыграть не вовсе
последнюю роль в нашей поэме.

Лицо Ноздрева, верно, уже сколько-нибудь знакомо читателю. Таких людей
приходилось всякому встречать немало. Они называются разбитными
малыми, слывут еще в детстве и в школе за хороших товарищей и при всем
том бывают весьма больно поколачиваемы. В их лицах всегда видно что-то
открытое, прямое, удалое. Они скоро знакомятся, и не успеешь
оглянуться, как уже говорят тебе «ты». Дружбу заведут, кажется, навек:
но всегда почти так случается, что подружившийся подерется с ними того
же вечера на дружеской пирушке. Они всегда говоруны, кутилы, лихачи,
народ видный. Ноздрев в тридцать пять лет был таков же совершенно,
каким был в осьмнадцать и двадцать: охотник погулять. Женитьба его
ничуть не переменила, тем более что жена скоро отправилась на тот
свет, оставивши двух ребятишек, которые решительно ему были не нужны.
За детьми, однако ж, присматривала смазливая нянька. Дома он больше
дня никак не мог усидеть. Чуткий нос его слышал за несколько десятков
верст, где была ярмарка со всякими съездами и балами; он уж в одно
мгновенье ока был там, спорил и заводил сумятицу за зеленым столом,
ибо имел, подобно всем таковым, страстишку к картишкам. В картишки,
как мы уже видели из первой главы, играл он не совсем безгрешно и
чисто, зная много разных передержек и других тонкостей, и потому игра
весьма часто оканчивалась другою игрою: или поколачивали его сапогами,
или же задавали передержку его густым и очень хорошим бакенбардам, так
что возвращался домой он иногда с одной только бакенбардой, и то
довольно жидкой. Но здоровые и полные щеки его так хорошо были
сотворены и вмещали в себе столько растительной силы, что бакенбарды
скоро вырастали вновь, еще даже лучше прежних. И что всего страннее,
что может только на одной Руси случиться, он чрез несколько времени
уже встречался опять с теми приятелями, которые его тузили, и
встречался как ни в чем не бывало, и он, как говорится, ничего, и они
ничего.

Ноздрев был в некотором отношении исторический человек. Ни на одном
собрании, где он был, не обходилось без истории. Какая-нибудь история
непременно происходила: или выведут его под руки из зала жандармы, или
принуждены бывают вытолкать свои же приятели. Если же этого не
случится, то все-таки что-нибудь да будет такое, чего с другим никак
не будет: или нарежется в буфете таким образом, что только смеется,
или проврется самым жестоким образом, так что наконец самому сделается
совестно. И наврет совершенно без всякой нужды: вдруг расскажет, что у
него была лошадь какой-нибудь голубой или розовой шерсти, и тому
подобную чепуху, так что слушающие наконец все отходят, произнесши:
«Ну, брат, ты, кажется, уже начал пули лить». Есть люди, имеющие
страстишку нагадить ближнему, иногда вовсе без всякой причины. Иной,
например, даже человек в чинах, с благородною наружностию, со звездой
на груди, будет вам жать руку, разговорится с вами о предметах
глубоких, вызывающих на размышления, а потом, смотришь, тут же, пред
вашими глазами, и нагадит вам. И нагадит так, как простой коллежский
регистратор, а вовсе не так, как человек во звездой на груди,
разговаривающий о предметах, вызывающих на размышление, так что стоишь
только да дивишься, пожимая плечами, да и ничего более. Такую же
странную страсть имел и Ноздрев. Чем кто ближе с ним сходился, тому он
скорее всех насаливал: распускал небылицу, глупее которой трудно
выдумать, расстроивал свадьбу, торговую сделку и вовсе не почитал себя
вашим неприятелем; напротив, если случай приводил его опять
встретиться с вами, он обходился вновь по-дружески и даже говорил:
«Ведь ты такой подлец, никогда ко мне не заедешь». Ноздрев во многих
отношениях был многосторонний человек, то есть человек на все руки. В
ту же минуту он предлагал вам ехать куда угодно, хоть на край света,
войти в какое хотите предприятие, менять все что ни есть на все, что
хотите. Ружье, собака, лошадь — все было предметом мены, но вовсе не с
тем, чтобы выиграть: это происходило просто от какой-то неугомонной
юркости и бойкости характера. Если ему на ярмарке посчастливилось
напасть на простака и обыграть его, он накупал кучу всего, что прежде
попадалось ему на глаза в лавках: хомутов, курительных свечек, платков
для няньки, жеребца, изюму, серебряный рукомойник, голландского
холста, крупичатой муки, табаку, пистолетов, селедок, картин,
точильный инструмент, горшков, сапогов, фаянсовую посуду — насколько
хватало денег. Впрочем, редко случалось, чтобы это было довезено
домой; почти в тот же день спускалось оно все другому, счастливейшему
игроку, иногда даже прибавлялась собственная трубка с кисетом и
мундштуком, а в другой раз и вся четверня со всем: с коляской и
кучером, так что сам хозяин отправлялся в коротеньком сюртучке или
архалуке искать какого-нибудь приятеля, чтобы попользоваться его
экипажем. Вот какой был Ноздрев! Может быть, назовут его характером
избитым, станут говорить, что теперь нет уже Ноздрева. Увы!
несправедливы будут те, которые станут говорить так. Ноздрев долго еще
не выведется из мира. Он везде между нами и, может быть, только ходит
в другом кафтане; но легкомысленно непроницательны люди, и человек в
другом кафтане кажется им другим человеком.

Между тем три экипажа подкатили уже к крыльцу дома Ноздрева. В доме не
было никакого приготовления к их принятию. Посередине столовой стояли
деревянные козлы, и два мужика, стоя на них, белили стены, затягивая
какую-то бесконечную песню; пол весь был обрызган белилами. Ноздрев
приказал тот же час мужиков и козлы вон и выбежал в другую комнату
отдавать повеления. Гости слышали, как он заказывал повару обед;
сообразив это, Чичиков, начинавший уже несколько чувствовать аппетит,
увидел, что раньше пяти часов они не сядут за стол. Ноздрев,
возвратившись, повел гостей осматривать все, что ни было у него на
деревне, и в два часа с небольшим показал решительно все, так что
ничего уж больше не осталось показывать. Прежде всего пошли они
обсматривать конюшню, где видели двух кобыл, одну серую в яблоках,
другую каурую, потом гнедого жеребца, на вид и неказистого, но за
которого Ноздрев божился, что заплатил десять тысяч.

— Десять тысяч ты за него не дал, — заметил зять. — Он и одной не
— стоит.

— Ей-богу, дал десять тысяч, — сказал Ноздрев.

— Ты себе можешь божиться, сколько хочешь, — отвечал зять.

— Ну, хочешь, побьемся об заклад! — сказал Ноздрев.

Об заклад зять не захотел биться.

Потом Ноздрев показал пустые стойла, где были прежде тоже хорошие
лошади. В этой же конюшне видели козла, которого, по старому поверью,
почитали необходимым держать при лошадях, который, как казалось, был с
ними в ладу, гулял под их брюхами, как у себя дома. Потом Ноздрев
повел их глядеть волчонка, бывшего на привязи. «Вот волчонок! — сказал
он. — Я его нарочно кормлю сырым мясом. Мне хочется, чтобы он был
совершенным зверем!» Пошли смотреть пруд, в котором, по словам
Ноздрева, водилась рыба такой величины, что два человека с трудом
вытаскивали штуку, в чем, однако ж, родственник не преминул
усомниться. «Я тебе, Чичиков, — сказал Ноздрев, — покажу отличнейшую
пару собак: крепость черных мясом просто наводит изумление, щиток —
игла!» — и повел их к выстроенному очень красиво маленькому домику,
окруженному большим загороженным со всех сторон двором. Вошедши на
двор, увидели там всяких собак, и густопсовых, и чистопсовых, всех
возможных цветов и мастей: муругих, черных с подпалинами, полво-пегих,
муруго-пегих, красно-пегих, черноухих, сероухих… Тут были все клички,
все повелительные наклонения: стреляй, обругай, порхай, пожар,
скосырь, черкай, допекай, припекай, северга, касатка, награда,
попечительница. Ноздрев был среди их совершенно как отец среди
семейства; все они, тут же пустивши вверх хвосты, зовомые у собачеев
прави'лами, полетели прямо навстречу гостям и стали с ними
здороваться. Штук десять из них положили свои лапы Ноздреву на плеча.
Обругай оказал такую же дружбу Чичикову и, поднявшись на задние ноги,
лизнул его языком в самые губы, так что Чичиков тут же выплюнул.
Осмотрели собак, наводивших изумление крепостью черных мясов, —
хорошие были собаки. Потом пошли осматривать крымскую суку, которая
была уже слепая и, по словам Ноздрева, должна была скоро издохнуть, но
года два тому назад была очень хорошая сука; осмотрели и суку — сука,
точно, была слепая. Потом пошли осматривать водяную мельницу, где
недоставало порхлицы, в которую утверждается верхний камень, быстро
вращающийся на веретене, — «порхающий», по чудному выражению русского
мужика.

— А вот тут скоро будет и кузница! — сказал Ноздрев. Немного прошедши,
— они увидели, точно, кузницу, осмотрели и кузницу.

— Вот на этом поле, — сказал Ноздрев, указывая пальцем на поле, —
— русаков такая гибель, что земли не видно; я сам своими руками поймал
— одного за задние ноги.

— Ну, русака ты не поймаешь рукою! — заметил зять.

— А вот же поймал, нарочно поймал! — отвечал Ноздрев — Теперь я поведу
— тебя посмотреть, — продолжал он, обращаясь к Чичикову, — границу,
— где оканчивается моя земля.

Ноздрев повел своих гостей полем, которое во многих местах состояло из
кочек. Гости должны были пробираться между перелогами и взбороненными
нивами. Чичиков начинал чувствовать усталость. Во многих местах ноги
их выдавливали под собою воду, до такой степени место было низко.
Сначала они было береглись и переступали осторожно, но потом, увидя,
что это ни к чему не служит, брели прямо, не разбирая, где бо'льшая, а
где меньшая грязь. Прошедши порядочное расстояние, увидели, точно,
границу, состоявшую из деревянного столбика и узенького рва.

— Вот граница! — сказал Ноздрев. — Все, что ни видишь по эту сторону,
— все это мое, и даже по ту сторону, весь этот лес, которым вон
— синеет, и все, что за лесом, все мое.

— Да когда же этот лес сделался твоим? — спросил зять. — Разве ты
— недавно купил его? Ведь он не был твой.

— Да, я купил его недавно, — отвечал Ноздрев.

— Когда же ты успел его так скоро купить?

— Как же, я еще третьего дня купил, и дорого, черт возьми, дал.

— Да ведь ты был в то время на ярмарке.

— Эх ты, Софрон! Разве нельзя быть в одно время и на ярмарке и купить
— землю? Ну, я был на ярмарке, а приказчик мой тут без меня и купил.

— Да, ну разве приказчик! — сказал зять, но и тут усумнился и покачал
— головою.

Гости воротились тою же гадкою дорогою к дому. Ноздрев повел их в свой
кабинет, в котором, впрочем, не было заметно следов того, что бывает в
кабинетах, то есть книг или бумаги; висели только сабли и два ружья —
одно в триста, а другое в восемьсот рублей. Зять, осмотревши, покачал
только головою. Потом были показаны турецкие кинжалы, на одном из
которых по ошибке было вырезано: «Мастер Савелий Сибиряков». Вслед за
тем показалась гостям шарманка. Ноздрев тут же провертел пред ними
кое-что. Шарманка играла не без приятности, но в средине ее, кажется,
что-то случилось, ибо мазурка оканчивалась песнею: «Мальбруг в поход
поехал», а «Мальбруг в поход поехал» неожиданно завершался каким-то
давно знакомым вальсом. Уже Ноздрев давно перестал вертеть, но в
шарманке была одна дудка очень бойкая, никак не хотевшая угомониться,
и долго еще потому свистела она одна. Потом показались трубки —
деревянные, глиняные, пенковые, обкуренные и необкуренные, обтянутые
замшею и необтянутые, чубук с янтарным мундштуком, недавно выигранный,
кисет, вышитый какою-то графинею, где-то на почтовой станции
влюбившеюся в него по уши, у которой ручки, по словам его, были самой
субдительной сюперфлю, — слово, вероятно означавшее у него высочайшую
точку совершенства. Закусивши балыком, они сели за стол близ пяти
часов. Обед, как видно, не составлял у Ноздрева главного в жизни;
блюда не играли большой роли: кое-что и пригорело, кое-что и вовсе не
сварилось. Видно, что повар руководствовался более каким-то
вдохновеньем и клал первое, что попадалось под руку: стоял ли возле
него перец — он сыпал перец, капуста ли попалась — совал капусту,
пичкал молоко, ветчину, горох — словом, катай-валяй, было бы горячо, а
вкус какой-нибудь, верно, выдет. Зато Ноздрев налег на вина: еще не
подавали супа, он уже налил гостям по большому стакану портвейна и по
другому госотерна, потому что в губернских и уездных городах не бывает
простого сотерна. Потому Ноздрев велел принести бутылку мадеры, лучше
которой не пивал сам фельдмаршал. Мадера, точно, даже горела во рту,
ибо купцы, зная уже вкус помещиков, любивших добрую мадеру, заправляли
ее беспощадно ромом, а иной раз вливали туда и царской водки, в
надежде, что всё вынесут русские желудки. Потом Ноздрев велел еще
принесть какую-то особенную бутылку, которая, по словам его, была и
бургоньон и шампаньон вместе. Он наливал очень усердно в оба стакана,
и направо и налево, и зятю и Чичикову; Чичиков заметил, однако же,
как-то вскользь, что самому себе он не много прибавлял. Это заставило
его быть осторожным, и как только Ноздрев как-нибудь заговаривался или
наливал зятю, он опрокидывал в ту же минуту свой стакан в тарелку. В
непродолжительном времени была принесена на стол рябиновка, имевшая,
по словам Ноздрева, совершенный вкус сливок, но в которой, к
изумлению, слышна была сивушища во всей своей силе. Потом пили какой-
то бальзам, носивший такое имя, которое даже трудно было припомнить,
да и сам хозяин в другой раз назвал его уже другим именем. Обед давно
уже кончился, и вина были перепробованы, но гости всё еще сидели за
столом. Чичиков никак не хотел заговорить с Ноздревым при зяте насчет
главного предмета. Все-таки зять был человек посторонний, а предмет
требовал уединенного и дружеского разговора. Впрочем, зять вряд ли мог
быть человеком опасным, потому что нагрузился, кажется, вдоволь и,
сидя на стуле, ежеминутно клевался носом. Заметив и сам, что находился
не в надежном состоянии, он стал наконец отпрашиваться домой, но таким
ленивым и вялым голосом, как будто бы, по русскому выражению,
натаскивал клещами на лошадь хомут.

— И ни-ни! не пущу! — сказал Ноздрев

— Нет, не обижай меня, друг мой, право, поеду, — говорил зять, — ты
— меня очень обидишь.

— Пустяки, пустяки! мы соорудим сию минуту банчишку.

— Нет, сооружай, брат, сам, а я не могу, жена будет в большой
— претензии, право, я должен ей рассказать о ярмарке. Нужно, брат,
— право, нужно доставить ей удовольствие. Нет, ты не держи меня!

— Ну ее, жену, к..! важное в самом деле дело станете делать вместе!

— Нет, брат! она такая почтенная и верная! Услуги оказывает такие…
— поверишь, у меня слезы на глазах. Нет, ты не держи меня; как честный
— человек, поеду. Я тебя в этом уверяю по истинной совести.

— Пусть его едет, что в нем проку! — сказал тихо Чичиков Ноздреву.

— А и вправду! — сказал Ноздрев. — Смерть не люблю таких растепелей! —
— и прибавил вслух: — Ну, черт с тобою, поезжай бабиться с женою,
— фетюк![[2 - Фетюк — слово, обидное для мужчины, происхоит от Фиты —
— буквы, почитаемой некоторыми неприличною буквою. (Прим. Н. В.
— Гоголя.)]]

— Нет, брат, ты не ругай меня фетюком, — отвечал зять, — я ей жизнью
— обязан. Такая, право, добрая, милая, такие ласки оказывает… до слез
— разбирает; спросит, что видел на ярмарке — нужно все рассказать,
— такая, право, милая.

— Ну поезжай, ври ей чепуху! Вот картуз твой.

— Нет, брат, тебе совсем не следует о ней так отзываться; этим ты,
— можно сказать, меня самого обижаешь, она такая милая.

— Ну, так и убирайся к ней скорее!

— Да, брат, поеду, извини, что не могу остаться. Душой рад бы был, но
— не могу.

Зять еще долго повторял свои извинения, не замечая, что сам уже давно
сидел в бричке, давно выехал за ворота и перед ним давно были одни
пустые поля. Должно думать, что жена не много слышала подробностей о
ярмарке.

— Такая дрянь! — говорил Ноздрев, стоя перед окном и глядя на
— уезжавший экипаж. — Вон как потащился! конек пристяжной недурен, я
— давно хотел подцепить его. Да ведь с ним нельзя никак сойтиться.
— Фетюк, просто фетюк!

Засим вошли они в комнату. Порфирий подал свечи, и Чичиков заметил в
руках хозяина неизвестно откуда взявшуюся колоду карт.

— А что брат, — говорил Ноздрев, прижавши бока колоды пальцами и
— несколько погнувши ее, так что треснула и отскочила бумажка. — Ну,
— для препровождения времени, держу триста рублей банку!

Но Чичиков прикинулся, как будто и не слышал, о чем речь, и сказал,
как бы вдруг припомнив:

— А! чтоб не позабыть: у меня к тебе просьба.

— Какая?

— Дай прежде слово, что исполнишь.

— Да какая просьба?

— Ну, да уж дай слово!

— Изволь

— Честное слово?

— Честное слово.

— Вот какая просьба: у тебя есть, чай, много умерших крестьян, которые
— еще не вычеркнуть из ревизии?

— Ну есть, а что?

— Переведи их на меня, на мое имя.

— А на что тебе?

— Ну да мне нужно.

— Да на что?

— Ну да уж нужно… уж это мое дело, — словом, нужно.

— Ну уж, верно, что-нибудь затеял. Признайся, что?

— Да что ж затеял? из этакого пустяка и затеять ничего нельзя.

— Да зачем же они тебе?

— Ох, какой любопытный! ему всякую дрянь хотелось бы пощупать рукой,
— да еще и понюхать!

— Да к чему ж ты не хочешь сказать?

— Да что же тебе за прибыль знать? ну, просто так, пришла фантазия.

— Так вот же: до тех пор, пока не скажешь, не сделаю!

— Ну вот видишь, вот уж и нечестно с твоей стороны: слово дал, да и на
— попятный двор.

— Ну, как ты себе хочешь, а не сделаю, пока не скажешь, на что.

«Что бы такое сказать ему?» — подумал Чичиков в после минутного
«размышления объявил, что мертвые души нужны ему для приобретения весу
«в обществе, что он поместьев больших не имеет, так до того времени
«хоть бы какие-нибудь душонки.

— Врешь, врешь! — сказал Ноздрев, не давши окончить. — Врешь, брат!

Чичиков и сам заметил, что придумал не очень ловко и предлог довольно
слаб.

— Ну, так я ж тебе скажу прямее, — сказал он, поправившись, — только,
— пожалуйста, не проговорись никому. Я задумал жениться; но нужно тебе
— знать, что отец и мать невесты преамбициозные люди. Такая, право,
— комиссия: не рад, что связался, хотят непременно, чтоб у жениха было
— никак не меньше трехсот душ, а так как у меня целых почти
— полутораста крестьян недостает…

— Ну врешь! врешь! — закричал опять Ноздрев.

— Ну вот уж здесь, — сказал Чичиков, — ни вот на столько не солгал, —
— и показал большим пальцем на своем мизинце самую маленькую часть.

— Голову ставлю, что врешь!

— Однако ж это обидно! что же я такое в самом деле! почему я
— непременно лгу?

— Ну да ведь я знаю тебя: ведь ты большой мошенник, позволь мне это
— сказать тебе по дружбе! Ежели бы я был твоим начальником, я бы тебя
— повесил на первом дереве.

Чичиков оскорбился таким замечанием. Уже всякое выражение, сколько-
нибудь грубое или оскорбляющее благопристойность, было ему неприятно.
Он даже не любил допускать с собой ни в каком случае фамильярного
обращения, разве только если особа была слишком высокого звания. И
потому теперь он совершенно обиделся.

— Ей-богу, повесил бы, — повторил Ноздрев, — я тебе говорю это
— откровенно, не с тем чтобы тебя обидеть, а просто по-дружески
— говорю.

— Всему есть границы, — сказал Чичиков с чувством достоинства. — Если
— хочешь пощеголять подобными речами, так ступай в казармы, — и потом
— присовокупил: — Не хочешь подарить, так продай.

— Продать! Да ведь я знаю тебя, ведь ты подлец, ведь ты дорого не дашь
— за них?

— Эх, да ты ведь тоже хорош! смотри ты! что они у тебя бриллиантовые,
— что ли?

— Ну, так и есть. Я уж тебя знал.

— Помилуй, брат, что ж у тебя за жидовское побуждение. Ты бы должен
— просто отдать мне их.

— Ну, послушай, чтоб доказать тебе, что я вовсе не какой-нибудь
— скалдырник, я не возьму за них ничего. Купи у меня жеребца, я тебе
— дам их в придачу.

— Помилуй, на что ж мне жеребец? — сказал Чичиков, изумленный в самом
— деле таким предложением.

— Как на что? да ведь я за него заплатил десять тысяч, а тебе отдаю за
— четыре.

— Да на что мне жеребец? завода я не держу.

— Да послушай, ты не понимаешь: ведь я с тебя возьму теперь всего
— только три тысячи, а остальную тысячу ты можешь заплатить мне после.

— Да не нужен мне жеребец, бог с ним!

— Ну, купи каурую кобылу.

— И кобылы не нужно.

— За кобылу и за серого коня, которого ты у меня видел, возьму я с
— тебя только две тысячи.

— Да не нужны мне лошади.

— Ты их продашь, тебе на первой ярмарке дадут за них втрое больше.

— Так лучше ж ты их сам продай, когда уверен, что выиграешь втрое.

— Я знаю, что выиграю, да мне хочется, чтобы и ты получил выгоду.

Чичиков поблагодарил за расположение и напрямик отказался и от серого
коня, и от каурой кобылы.

— Ну так купи собак. Я тебе продам такую пару, просто мороз по коже
— подирает! брудастая, с усами, шерсть стоит вверх, как щетина.
— Бочковатость ребр уму непостижимая, лапа вся в комке, земли не
— заденет.

— Да зачем мне собаки? я не охотник.

— Да мне хочется, чтобы у тебя были собаки. Послушай, если уж не
— хочешь собак, так купи у меня шарманку, чудная шарманка; самому, как
— честный человек, обошлась в полторы тысячи. тебе отдаю за девятьсот
— рублей.

— Да зачем же мне шарманка? Ведь я не немец, чтобы, тащася с ней по
— дорогам, выпрашивать деньги.

— Да ведь это не такая шарманка, как носят немцы. Это орган; посмотри
— нарочно: вся из красного дерева. Вот я тебе покажу ее еще! — Здесь
— Ноздрев, схвативши за руку Чичикова, стал тащить его в другую
— комнату, и как тот ни упирался ногами в пол и ни уверял, что он
— знает уже, какая шарманка, но должен был услышать еще раз, каким
— образом поехал в поход Мальбруг. — Когда ты не хочешь на деньги, так
— вот что, слушай: я тебе дам шарманку и все, сколько ни есть у меня,
— мертвые души, а ты мне дай свою бричку и триста рублей придачи.

— Ну вот еще, а я-то в чем поеду?

— Я тебе дам другую бричку. Вот пойдем в сарай, я тебе покажу ее! Ты
— ее только перекрасишь, и будет чудо бричка.

«Эк его неугомонный бес как обуял!» — подумал про себя Чичиков и
«решился во что бы то ни стало отделаться от всяких бричек, шарманок и
«всех возможных собак, несмотря на непостижимую уму бочковатость ребр
«и комкость лап.

— Да ведь бричка, шарманка и мертвые души, все вместе!

— Не хочу, — сказал еще раз Чичиков.

— Отчего ж ты не хочешь?

— Оттого, что просто не хочу, да и полно.

— Экой ты, право, такой! с тобой, как я вижу, нельзя, как водится
— между хорошими друзьями и товарищами, такой, право!.. Сейчас видно,
— что двуличный человек!

— Да что же я, дурак, что ли? ты посуди сам: зачем же приобретать
— вещь, решительно для меня ненужную?

— Ну уж, пожалуйста, не говори. Теперь я очень хорошо тебя знаю.
— Такая, право, ракалия! Ну, послушай, хочешь метнем банчик? Я
— поставлю всех умерших на карту, шарманку тоже.

— Ну, решаться в банк, значит подвергаться неизвестности, — говорил
— Чичиков и между тем взглянул искоса на бывшие в руках у него карты.
— Обе талии ему показались очень похожими на искусственные, и самый
— крап глядел весьма подозрительно.

— Отчего ж неизвестности? — сказал Ноздрев. — Никакой неизвестности!
— будь только на твоей стороне счастие, ты можешь выиграть чертову
— пропасть. Вон она! экое счастье! — говорил он, начиная метать для
— возбуждения задору. — Экое счастье! экое счастье! вон: так и
— колотит! вот та проклятая девятка, на которой я все просадил!
— Чувствовал, что продаст, да уже, зажмурив глаза, думаю себе: «Черт
— тебя побери, продавай, проклятая!»

Когда Ноздрев это говорил, Порфирий принес бутылку. Но Чичиков
отказался решительно как играть, так и пить.

— Отчего ж ты не хочешь играть? — сказал Ноздрев.

— Ну оттого, что не расположен. Да, признаться сказать, я вовсе не
— охотник играть.

— Отчего ж не охотник?

Чичиков пожал плечами и прибавил:

— Потому что не охотник.

— Дрянь же ты!

— Что ж делать? так бог создал.

— Фетюк просто! Я думал было прежде, что ты хоть сколько-нибудь
— порядочный человек, а ты никакого не понимаешь обращения. С тобой
— никак нельзя говорить, как с человеком близким… никакого прямодушия,
— ни искренности! совершенный Собакевич, такой подлец!

— Да за что же ты бранишь меня? Виноват разве я, что не играю? Продай
— мне душ одних, если уж ты такой человек, что дрожишь из-за этого
— вздору.

— Черта лысого получишь! хотел было, даром хотел отдать, но теперь вот
— не получишь же! Хоть три царства давай, не отдам. Такой шильник,
— печник гадкий! С этих пор с тобой никакого дела не хочу иметь.
— Порфирий, ступай скажи конюху, чтобы не давал овса лошадям его,
— пусть их едят одно сено.

Последнего заключения Чичиков никак не ожидал.

— Лучше б ты мне просто на глаза не показывался! — сказал Ноздрев.

Несмотря, однако ж, на такую размолвку, гость и хозяин поужинали
вместе, хотя на этот раз не стояло на столе никаких вин с затейливыми
именами. Торчала одна только бутылка с какие-то кипрским, которое было
то, что называют кислятина во всех отношениях. После ужина Ноздрев
сказал Чичикову, отведя его в боковую комнату, где была приготовлена
для него постель:

— Вот тебе постель! Не хочу и доброй ночи желать тебе!

Чичиков остался по уходе Ноздрева в самом неприятном расположении
духа. Он внутренно досадовал на себя, бранил себя за то, что к нему
заехал и потерял даром время. Но еще более бранил себя за то, что
заговорил с ним о деле, поступил неосторожно, как ребенок, как дурак:
ибо дело совсем не такого роду, чтобы быть вверену Ноздреву… Ноздрев
человек-дрянь, Ноздрев может наврать, прибавить, распустить черт знает
что, выйдут еще какие-нибудь сплетни — нехорошо, нехорошо. «Просто
дурак я». — говорил он сам себе. Ночь спал он очень дурно. Какие-то
маленькие пребойкие насекомые кусали его нестерпимо больно, так что он
всей горстью скреб по уязвленному месту, приговаривая: «А, чтоб вас
черт побрал вместе с Ноздревым!» Проснулся он ранним утром. Первым
делом его было, надевши халат и сапоги, отправиться через двор в
конюшню приказать Селифану сей же час закладывать бричку. Возвращаясь
через двор, он встретился с Ноздревым, который был также в халате, с
трубкою в зубах.

Ноздрев приветствовал его по-дружески и спросил, каково ему спалось.

— Так себе, — отвечал Чичиков весьма сухо.

— А я, брат, — говорил Ноздрев, — такая мерзость лезла всю ночь, что
— гнусно рассказывать, и во рту после вчерашнего точно эскадрон
— переночевал. Представь: снилось, что меня высекли, ей-ей! и,
— вообрази, кто? Вот ни за что не угадаешь: штабс-ротмистр Поцелуев
— вместе с Кувшинниковым.

«Да, — подумал про себя Чичиков, — хорошо бы, если б тебя отодрали
«наяву».

— Ей-богу! да пребольно! Проснулся: черт возьми, в самом деле что-то
— почесывается, — верно, ведьмы блохи. Ну, ты ступай теперь одевайся,
— я к тебе сейчас приду. Нужно только ругнуть подлеца приказчика.

Чичиков ушел в комнату одеться и умыться. Когда после того вышел он в
столовую, там уже стоял на столе чайный прибор с бутылкою рома. В
комнате были следы вчерашнего обеда и ужина; кажется, половая щетка не
притрогивалась вовсе. На полу валялись хлебные крохи, а табачная зола
видна даже была на скатерти. Сам хозяин, не замедливший скоро войти,
ничего не имел у себя под халатом, кроме открытой груди, на которой
росла какая-то борода. Держа в руке чубук и прихлебывая из чашки, он
был очень хорош для живописца, не любящего страх господ прилизанных и
завитых, подобно цирюльным вывескам, или выстриженных под гребенку.

— Ну, так как же думаешь? — сказал Ноздрев, немного помолчавши. — Не
— хочешь играть на души?

— Я уже сказал тебе, брат, что не играю; купить — изволь, куплю.

— Продать я не хочу, это будет не по-приятельски. Я не стану снимать
— плевы с черт знает чего. В бантик — другое дело. Прокинем хоть
— талию!

— Я уж сказал, что нет.

— А меняться не хочешь?

— Не хочу.

— Ну, послушай, сыграем в шашки, выиграешь — твои все. Ведь у меня
— много таких, которых нужно вычеркнуть из ревизии. Эй, Порфирий,
— принеси-ка сюда шашечницу.

— Напрасен труд, я не буду играть.

— Да ведь это не в банк; тут никакого не может быть счастия или
— фальши: все ведь от искусства; я даже тебя предваряю, что я совсем
— не умею играть, разве что-нибудь мне дашь вперед.

«Сем-ка я, — подумал про себя Чичиков, — сыграю с ним в шашки! В шашки
«игрывал я недурно, а на штуки ему здесь трудно подняться».

— Изволь, так и быть, в шашки сыграю.

— Души идут в ста рублях!

— Зачем же? довольно, если пойдут в пятидесяти.

— Нет, что ж за куш пятьдесят? Лучше ж в эту сумму я включу тебе
— какого-нибудь щенка средней руки или золотую печатку к часам.

— Ну, изволь! — сказал Чичиков.

— Сколько же ты мне дашь вперед? — сказал Ноздрев.

— Это с какой стати? Конечно, ничего.

— По крайней мере пусть будут мои два хода.

— Не хочу, я сам плохо играю.

— Знаем мы вас, как вы плохо играете! — сказал Ноздрев, выступая
— шашкой.

— Давненько не брал я в руки шашек! — говорил Чичиков, подвигая тоже
— шашку.

— Знаем мы вас, как вы плохо играете! — сказал Ноздрев, выступая
— шашкой.

— Давненько не брал я в руки шашек! — говорил Чичиков, подвигая шашку.

— Знаем мы вас, как вы плохо играете! — сказал Ноздрев, подвигая
— шашку, да в то же самое время подвинул обшлагом рукава и другую
— шашку.

— Давненько не брал я в руки!.. Э, э! это, брат, что? отсади-ка ее
— назад! — говорил Чичиков.

— Кого?

— Да шашку-то, — сказал Чичиков и в то же время увидел перед самым
— носом своим другую, которая, как казалось, пробиралась в дамки;
— откуда она взялась это один только бог знал. — Нет, — сказал
— Чичиков, вставши из-за стола, — с тобой нет никакой возможности
— играть! Этак не ходят, по три шашки вдруг!

— Отчего ж по три? Это по ошибке. Одна подвинулась нечаянно, я ее
— отодвину, изволь.

— А другая-то откуда взялась?

— Какая другая?

— А вот эта, что пробирается в дамки?

— Вот тебе на, будто не помнишь!

— Нет, брат, я все ходы считал и все помню; ты ее только теперь
— пристроил. Ей место вон где!

— Как, где место? — сказал Ноздрев, покрасневши. — Да, ты, брат, как я
— вижу, сочинитель!

— Нет, брат, это, кажется, ты сочинитель, да только неудачно.

— За кого ж ты меня почитаешь? — говорил Ноздрев. — Стану я разве
— плутоватать?

— Я тебя ни за кого не почитаю, но только играть с этих пор никогда не
— буду.

— Нет, ты не можешь отказаться, — говорил Ноздрев, горячась, — игра
— начата!

— Я имею право отказаться, потому что ты не так играешь, как прилично
— честному человеку.

— Нет, врешь, ты этого не можешь сказать!

— Нет, брат, сам ты врешь!

— Я не плутовал, а ты отказаться не можешь, ты должен кончить партию!

— Этого ты меня не заставишь сделать, — сказал Чичиков хладнокровно и,
— подошедши к доске, смешал шашки.

Ноздрев вспыхнул и подошел к Чичикову так близко, что тот отступил
шага два назад.

— Я тебя заставлю играть! Это ничего, что ты смешал шашки, я помню все
— ходы. Мы их поставим опять так, как были.

— Нет, брат, дело кончено, я с тобою не стану играть.

— Так ты не хочешь играть?

— Ты сам видишь, что с тобою нет возможности играть.

— Нет, скажи напрямик, ты не хочешь играть? — говорил Ноздрев,
— подступая еще ближе.

— Не хочу! — сказал Чичиков и поднес, однако ж, обе руки на всякий
— случай поближе к лицу, ибо дело становилось в самом деле жарко.

Эта предосторожность была весьма у места, потому что Ноздрев
размахнулся рукой… и очень бы могло статься, что одна из приятных и
полных щек нашего героя покрылась бы несмываемым бесчестием; но,
счастливо отведши удар, он схватил Ноздрева за обе задорные его руки и
держал его крепко.

— Порфирий, Павлушка! — кричал Ноздрев в бешенстве, порываясь
— вырваться.

Услыша эти слова, Чичиков, чтобы не сделать дворовых людей свидетелями
соблазнительной сцены и вместе с тем чувствуя, что держать Ноздрева
было бесполезно, выпустил его руки. В это самое время вошел Порфирий и
с ним Павлушка, парень дюжий, с которым иметь дело было совсем
невыгодно.

— Так ты не хочешь оканчивать партии? — говорил Ноздрев. — Отвечай мне
— напрямик!

— Партии нет возможности оканчивать, — говорил Чичиков и заглянул в
— окно. Он увидел свою бричку, которая стояла совсем готовая, а
— Селифан ожидал, казалось, мановения, чтобы подкатить под крыльцо, но
— из комнаты не было никакой возможности выбраться: в дверях стояли
— два дюжих крепостных дурака.

— Так ты не хочешь доканчивать партии? — повторил Ноздрев с лицом,
— горевшим, как в огне.

— Если бы ты играл, как прилично честному человеку. Но теперь не могу.

— А! так ты не можешь, подлец! когда увидел, что не твоя берет, так и
— не можешь! Бейте его! — кричал он исступленно, обратившись к
— Порфирию и Павлушке, а сам схватил в руку черешневый чубук. Чичиков
— стал бледен как полотно. Он хотел что-то сказать, но чувствовал, что
— губы его шевелились без звука.

— Бейте его! — кричал Ноздрев, порываясь вперед с черешневым чубуком,
— весь в жару, в поту, как будто подступал под неприступную крепость.
— — Бейте его! — кричал он таким же голосом, как во время великого
— приступа кричит своему взводу: «Ребята, вперед!» какой-нибудь
— отчаянный поручик, которого взбалмошная храбрость уже приобрела
— такую известность, что дается нарочный приказ держать его за руки во
— время горячих дел. Но поручик уже почувствовал бранный задор, все
— пошло кругом в голове его; перед ним носится Суворов, он лезет на
— великое дело. «Ребята, вперед!» — кричит он, порываясь, не помышляя,
— что вредит уже обдуманному плану общего приступа, что миллионы
— ружейных дул выставились в амбразуры неприступных, уходящих за-
— облака крепостных стен, что взлетит, как пух, на воздух его
— бессильный взвод и что уже свищет роковая пуля, готовясь захлопнуть
— его крикливую глотку. Но если Ноздрев выразил собою подступившего
— под крепость отчаянного, потерявшегося поручика, то крепость, на
— которую он шел, никак не была похожа на неприступную. Напротив,
— крепость чувствовала такой страх, что душа ее спряталась в самые
— пятки. Уже стул, которым он вздумал было защищаться, был вырван
— крепостными людьми из рук его, уже, зажмурив глаза, ни жив ни мертв,
— он готовился отведать черкесского чубука своего хозяина, и бог знает
— чего бы ни случилось с ним; но судьбам угодно было спасти бока,
— плеча и все благовоспитанные части нашего героя. Неожиданным образом
— звякнули вдруг, как с облаков, задребезжавшие звуки колокольчика,
— раздался ясно стук колес подлетевшей к крыльцу телеги, и отозвались
— даже в самой комнате тяжелый храп и тяжкая одышка разгоряченных
— коней остановившейся тройки. Все невольно глянули в окно: кто-то, с
— усами, в полувоенном сюртуке, вылезал из телеги. Осведомившись в
— передней, вошел он в ту самую минуту, когда Чичиков не успел еще
— опомниться от своего страха и был в самом жалком положении, в каком
— когда-либо находился смертный.

— Позвольте узнать, кто здесь господин Ноздрев? — сказал незнакомец,
— посмотревши в некотором недоумении на Ноздрева, который стоял с
— чубуком в руке, и на Чичикова, который едва начинал оправляться от
— своего невыгодного положения.

— Позвольте прежде узнать, с кем имею честь говорить? — сказал
— Ноздрев, подходя к нему ближе.

— Капитан-исправник.

— А что вам угодно?

— Я приехал вам объявить сообщенное мне извещение, что вы находитесь
— под судом до времени окончания решения по вашему делу.

— Что за вздор, по какому делу? — сказал Ноздрев.

— Вы были замешаны в историю, по случаю нанесения помещику Максимову
— личной обиды розгами в пьяном виде.

— Вы врете! я и в глаза не видал помещика Максимова!

— Милостивый государь! позвольте вам доложить, что я офицер. Вы можете
— это сказать вашему слуге, а не мне!

Здесь Чичиков, не дожидаясь, что будет отвечать на это Ноздрев, скорее
за шапку да по-за спиною капитана-исправника выскользнул на крыльцо,
сел в бричку и велел Селифану погонять лошадей во весь дух.






Глава пятая


Герой наш трухнул, однако ж, порядком. Хотя бричка мчалась во всю
пропащую и деревня Ноздрева давно унеслась из вида, закрывшись полями,
отлогостями и пригорками, но он все еще поглядывал назад со страхом,
как бы ожидая, что вот-вот налетит погоня. Дыхание его переводилось с
трудом, и когда он попробовал приложить руку к сердцу, то
почувствовал, что оно билось, как перепелка в клетке. «Эк какую баню
задал! смотри ты какой!» Тут много было посулено Ноздреву всяких
нелегких и сильных желаний; попались даже и нехорошие слова. Что ж
делать? Русский человек, да еще и в сердцах. К тому ж дело было совсем
нешуточное. «Что ни говори, — сказал он сам в себе, — а не подоспей
капитан-исправник, мне бы, может быть, не далось бы более и на свет
божий взглянуть! Пропал бы, как волдырь на воде, без всякого следа, не
оставивши потомков, не доставив будущим детям ни состояния, ни
честного имени!» Герой наш очень заботился о своих потомках.

«Экой скверный барин! — думал про себя Селифан. — Я еще не видал
«такого барина. То есть плюнуть бы ему за это! Ты лучше человеку не
«дай есть, а коня ты должен кормить, потому что конь любит овес. Это
«его продовольство: что, примером, нам кошт, то для него овес, он его
«продовольство».

Кони тоже, казалось, думали невыгодно об Ноздреве: не только гнедой и
Заседатель, но и сам чубарый был не в духе. Хотя ему на часть и
доставался всегда овес потуже и Селифан не иначе всыпал ему в корыто,
как сказавши прежде: «Эх ты, подлец!» — но, однако ж, это все-таки был
овес, а не простое сено, он жевал его с удовольствием и часто
засовывал длинную морду свою в корытца к товарищам поотведать, какое у
них было продовольствие, особливо когда Селифана не было в конюшне, но
теперь одно сено… нехорошо; все были недовольны.

Но скоро все недовольные были прерваны среди излияний своих внезапным
и совсем неожиданным образом. Все, не исключая и самого кучера,
опомнились и очнулись только тогда, когда на них наскакала коляска с
шестериком коней и почти над головами их раздалися крик сидевших в
коляске дам, брань и угрозы чужого кучера: «Ах ты мошенник эдакой;
ведь я тебе кричал в голос: сворачивай, ворона, направо! Пьян ты, что
ли?» Селифан почувствовал свою оплошность, но так как русский человек
не любит сознаться перед другим, что он виноват, то тут же вымолвил
он, приосанясь: «А ты что так расскакался? глаза-то свои в кабаке
заложил, что ли?» Вслед за сим он принялся отсаживать назад бричку,
чтобы высвободиться таким образом из чужой упряжи, но не тут-то было,
все перепуталось. Чубарый с любопытством обнюхивал новых своих
приятелей, которые очутились по обеим сторонам его. Между тем сидевшие
в коляске дамы глядели на все это с выражением страха в лицах. Одна
была старуха, другая молоденькая, шестнадцатилетняя, с золотистыми
волосами весьма ловко и мило приглаженными на небольшой головке.
Хорошенький овал лица ее круглился, как свеженькое яичко, и, подобно
ему, белел какою-то прозрачною белизною, когда свежее, только что
снесенное, оно держится против света в смуглых руках испытующей его
ключницы и пропускает сквозь себя лучи сияющего солнца; ее тоненькие
ушки также сквозили, рдея проникавшим их теплым светом. При этом испуг
в открытых, остановившихся устах, на глазах слезы — все это в ней было
так мило, что герой наш глядел на нее несколько минут, не обращая
никакого внимания на происшедшую кутерьму между лошадьми и кучерами.
«Отсаживай, что ли, нижегородская ворона!» — кричал чужой кучер.
Селифан потянул поводья назад, чужой кучер сделал то же, лошади
несколько попятились назад и потом опять сшиблись, переступивши
постромки. При этом обстоятельстве чубарому коню так понравилось новое
знакомство, что он никак не хотел выходить из колеи, в которую попал
непредвиденными судьбами, и, положивши свою морду на шею своего нового
приятеля, казалось, что-то нашептывал ему в самое ухо, вероятно,
чепуху страшную, потому что приезжий беспрестанно встряхивал ушами.

На такую сумятицу успели, однако ж, собраться мужики из деревни,
которая была, к счастию, неподалеку. Так как подобное зрелище для
мужика сущая благодать, все равно что для немца газеты или клуб, то
скоро около экипажа накопилась их бездна, и в деревне остались только
старые бабы да малые ребята. Постромки отвязали; несколько тычков
чубарому коню в морду заставали его попятиться; словом, их разрознили
и развели. Но досада ли, которую почувствовали приезжие кони за то,
что разлучили их с приятелями, или просто дурь, только, сколько ни
хлестал их кучер, они не двигались и стояли как вкопанные. Участие
мужиков возросло до невероятной степени. Каждый наперерыв совался с
советом: «Ступай, Андрюшка, проведи-ка ты пристяжного, что с правой
стороны, а дядя Митяй пусть сядет верхом на коренного! Садись, дядя
Митяй!» Сухощавый и длинный дядя Митяй с рыжей бородой взобрался на
коренного коня и сделался похожим на деревенскую колокольню, или,
лучше, на крючок, которым достают воду в колодцах. Кучер ударил по
лошадям, но не тут-то было, ничего не пособил дядя Митяй. «Стой, стой!
— кричали мужики. — Садись-ка ты, дядя Митяй, на пристяжную, а на
коренную пусть сядет дядя Миняй!» Дядя Миняй, широкоплечий мужик с
черною, как уголь, бородою и брюхом, похожим на тот исполинский
самовар, в котором варится сбитень для всего прозябнувшего рынка, с
охотою сел на коренного, который чуть не пригнулся под ним до земли.
«Теперь дело пойдет! — кричали мужики. — Накаливай, накаливай его!
пришпандорь кнутом вон того, того, солового, что он горячится, как
корамора!»[[3 - Корамора — большой, длинный, вялый комар; иногда
залетает в комнату и торчит где-нибудь одиночкой на стене. К нему
спокойно можно подойти и ухватить его за ногу, в ответ на что он
только топырится или горячится, как говорит народ. (Прим. Н. В.
Гоголя.)]] Но, увидевши, что дело не шло и не помогло никакое
накаливанье, дядя Митяй и дядя Миняй сели оба на коренного, а на
пристяжного посадили Андрюшку. Наконец, кучер, потерявши терпение,
прогнал и дядю Митяя и дядю Миняя, и хорошо сделал, потому что от
лошадей пошел такой пар, как будто бы они отхватали не переводя духа
станцию. Он дал им минуту отдохнуть, после чего они пошли сами собою.
Во все продолжение этой проделки Чичиков глядел очень внимательно на
молоденькую незнакомку. Он пытался несколько раз с нею заговорить, но
как-то не пришлось так. А между тем дамы уехали, хорошенькая головка с
тоненькими чертами лица и тоненьким станом скрылась, как что-то
похожее на виденье, и опять осталась дорога, бричка, тройка знакомых
читателю лошадей, Селифан, Чичиков, гладь и пустота окрестных полей.
Везде, где бы ни было в жизни, среди ли черствых, шероховато-бедных и
неопрятно-плесневеющих низменных рядов ее, или среди однообразно-
хладных и скучно-опрятных сословий высших, везде хоть раз встретится
на пути человеку явленье, не похожее на все то, что случалось ему
видеть дотоле, которое хоть раз пробудит в нем чувство, не похожее на
те, которые суждено ему чувствовать всю жизнь. Везде поперек каким бы
ни было печалям, из которых плетется жизнь наша, весело промчится
блистающая радость, как иногда блестящий экипаж с золотой упряжью,
картинными конями и сверкающим блеском стекол вдруг неожиданно
пронесется мимо какой-нибудь заглохнувшей бедной деревушки, не
видавшей ничего, кроме сельской телеги, и долго мужики стоят, зевая, с
открытыми ртами, не надевая шапок, хотя давно уже унесся и пропал из
виду дивный экипаж. Так и блондинка тоже вдруг совершенно неожиданным
образом показалась в нашей повести и так же скрылась. Попадись на ту
пору вместо Чичикова какой-нибудь двадцатилетний юноша, гусар ли он,
студент ли он, или просто только что начавший жизненное поприще, — и
боже! чего бы не проснулось, не зашевелилось, не заговорило в нем!
Долго бы стоял он бесчувственно на одном месте, вперивши бессмысленно
очи в даль, позабыв и дорогу, и все ожидающие впереди выговоры, и
распеканья за промедление, позабыв и себя, и службу, и мир, и все, что
ни есть в мире.

Но герой наш уже был средних лет и осмотрительно-охлажденного
характера. Он тоже задумался и думал, но положительнее, не так
безотчетны и даже отчасти очень основательны были его мысли. «Славная
бабешка! — сказал он, открывши табакерку и понюхавши табаку. — Но ведь
что, главное, в ней хорошо? Хорошо то, что она сейчас только, как
видно, выпущена из какого-нибудь пансиона или института, что в ней,
как говорится, нет еще ничего бабьего, то есть именно того, что у них
есть самого неприятного. Она теперь как дитя, все в ней просто, она
скажет, что ей вздумается, засмеется, где захочет засмеяться. Из нее
все можно сделать, она может быть чудо, а может выйти и дрянь, и выдет
дрянь! Вот пусть-на только за нее примутся теперь маменьки и тетушки.
В один год так ее наполнят всяким бабьем, что сам родной отец не
узнает. Откуда возьмется и надутость, и чопорность, станет ворочаться
по вытверженным наставлениям, станет ломать голову и придумывать, с
кем, и как, и сколько нужно говорить, как на кого смотреть, всякую
минуту будет бояться, чтобы не сказать больше, чем нужно, запутается
наконец сама, и кончится тем, что станет наконец врать всю жизнь, и
выдет просто черт знает что!» Здесь он несколько времени помолчал и
потом прибавил: «А любопытно бы знать, чьих она? что, как ее отец?
богатый ли помещик почтенного нрава, или просто благомыслящий человек
с капиталом, приобретенным на службе? Ведь если, положим, этой девушке
да придать тысячонок двести приданого, из нее бы мог выйти очень,
очень лакомый кусочек. Это бы могло составить, так сказать, счастье
порядочного человека». Двести тысячонок так привлекательно стали
рисоваться в голове его, что он внутренно начал досадовать на самого
себя, зачем в продолжение хлопотни около экипажей не разведал от
форейтора или кучера, кто такие были проезжающие. Скоро, однако ж,
показавшаяся деревня Собакевича рассеяла его мысли и заставила их
обратиться к своему постоянному предмету.

Деревня показалась ему довольно велика; два леса, березовый и
сосновый, как два крыла, одно темнее, другое светлее, были у ней
справа и слева; посреди виднелся деревянный дом с мезонином, красной
крышей и темными или, лучше, дикими стенами, — дом вроде тех, как у
нас строят для военных поселений и немецких колонистов. Было заметно,
что при постройке его зодчий беспрестанно боролся со вкусом хозяина.
Зодчий был педант и хотел симметрии, хозяин — удобства и, как видно,
вследствие того заколотил на одной стороне все отвечающие окна и
провертел на место их одно маленькое, вероятно понадобившееся для
темного чулана. Фронтон тоже никак не пришелся посреди дома, как ни
бился архитектор, потому что хозяин приказал одну колонну сбоку
выкинуть, и оттого очутилось не четыре колонны, как было назначено, а
только три. Двор окружен был крепкою и непомерно толстою деревянною
решеткой. Помещик, казалось, хлопотал много о прочности. На конюшни,
сараи и кухни были употреблены полновесные и толстые бревна,
определенные на вековое стояние. Деревенские избы мужиков тож срублены
были на диво: не было кирчёных стен, резных узоров и прочих затей, но
все было пригнано плотно и как следует. Даже колодец был обделан в
такой крепкий дуб, какой идет только на мельницы да на корабли.
Словом, все, на что ни глядел он, было упористо, без пошатки, в каком-
то крепком и неуклюжем порядке. Подъезжая к крыльцу, заметил он
выглянувшие из окна почти в одно время два лица: женское, в венце,
узкое, длинное, как огурец, и мужское, круглое, широкое, как
молдаванские тыквы, называемые горлянками, изо которых делают на Руси
балалайки, двухструнные легкие балалайки, красу и потеху ухватливого
двадцатилетнего парня, мигача и щеголя, и подмигивающего и
посвистывающего на белогрудых и белошейных девиц, собравшихся
послушать его тихострунного треньканья. Выглянувши, оба лица в ту же
минуту спрятались. На крыльцо вышел лакей в серой куртке с голубым
стоячим воротником и ввел Чичикова в сени, куда вышел уже сам хозяин.
Увидев гостя, он сказал отрывисто: «Прошу» — и повел его во внутренние
жилья.

Когда Чичиков взглянул искоса на Собакевича, он ему на этот раз
показался весьма похожим на средней величины медведя. Для довершение
сходства фрак на нем был совершенно медвежьего цвета, рукава длинны,
панталоны длинны, ступнями ступал он и вкривь и вкось и наступал
беспрестанно на чужие ноги. Цвет лица имел каленый, горячий, какой
бывает на медном пятаке. Известно, что есть много на свете таких лиц,
над отделкою которых натура недолго мудрила, не употребляла никаких
мелких инструментов, как-то: напильников, буравчиков и прочего, но
просто рубила со своего плеча: хватила топором раз — вышел нос,
хватила в другой — вышли губы, большим сверлом ковырнула глаза и, не
обскобливши, пустила на свет, сказавши: «Живет!» Такой же самый
крепкий и на диво стаченный образ был у Собакевича: держал он его
более вниз, чем вверх, шеей не ворочал вовсе и в силу такого
неповорота редко глядел на того, с которым говорил, но всегда или на
угол печки, или на дверь. Чичиков еще раз взглянул на него искоса,
когда проходили они столовую: медведь! совершенный медведь! Нужно же
такое странное сближение: его даже звали Михайлом Семеновичем. Зная
привычку его наступать на ноги, он очень осторожно передвигал своими и
давал ему дорогу вперед. Хозяин, казалось, сам чувствовал за собою
этот грех и тот же час спросил: «Не побеспокоил ли я вас?» Но Чичиков
поблагодарил, сказав, что еще не произошло никакого беспокойства.

Вошел в гостиную, Собакевич показал на кресла, сказавши опять:
«Прошу!» Садясь, Чичиков взглянул на стены и на висевшие на них
картины. На картинах все были молодцы, всё греческие полководцы,
гравированные во весь рост: Маврокордато в красных панталонах и
мундире, с очками на носу, Миаули, Канами. Все эти герои были с такими
толстыми ляжками и неслыханными усами, что дрожь проходила по телу.
Между крепкими греками, неизвестно каким образом и для чего,
поместился Багратион, тощий, худенький, с маленькими знаменами и
пушками внизу и в самых узеньких рамках. Потом опять следовала героиня
греческая Бобелина, которой одна нога казалась больше всего туловища
тех щеголей, которые наполняют нынешние гостиные. Хозяин, будучи сам
человек здоровый и крепкий, казалось, хотел, чтобы и комнату его
украшали тоже люди крепкие и здоровые. Возле Бобелины, у самого окна,
висела клетка, из которой глядел дрозд темного цвета с белыми
крапинками, очень похожий тоже на Собакевича. Гость и хозяин не успели
помолчать двух минут, как дверь в гостиной отворилась и вошла хозяйка,
дама весьма высокая, в чепце с лентами, перекрашенными домашнею
краскою. Вошла она степенно, держа голову прямо, как пальма.

— Это моя Феодулия Ивановна! — сказал Собакевич.

Чичиков подошел к ручке Феодулии Ивановны, которую она почти впихнула
ему в губы, причем он имел случай заметить, что руки были вымыты
огуречным рассолом.

— Душенька, рекомендую тебе, — продолжал Собакевич, — Павел Иванович
— Чичиков! У губернатора и почтмейстера имел честь познакомиться.

Феодулия Ивановна попросила садиться, сказавши тоже: «Прошу!» — и
сделав движение головою, подобно актрисам, представляющим королев.
Затем она уселась на диване, накрылась своим мериносовым платком и уже
не двигнула более ни глазом, ни бровью.

Чичиков опять поднял глаза вверх и опять увидел Канари с толстыми
ляжками и нескончаемыми усами, Бобелину и дрозда в клетке.

Почти в течение целых пяти минут все хранили молчание; раздавался
только стук, производимый носом дрозда о дерево деревянной клетки, на
дне которой удил он хлебные зернышки. Чичиков еще раз окинул комнату,
и все, что в ней ни было, — все было прочно, неуклюже в высочайшей
степени и имело какое-то странное сходство с самим хозяином дома; в
углу гостиной стояло пузатое ореховое бюро на пренелепых четырех
ногах, совершенный медведь. Стол, кресла, стулья — все было самого
тяжелого и беспокойного свойства, — словом, каждый предмет, каждый
стул, казалось, говорил: «И я тоже Собакевич!» или: «И я тоже очень
похож на Собакевича!»

— Мы об вас вспоминали у председателя палаты, у Ивана Григорьевича, —
— сказал наконец Чичиков, видя, что никто не располагается начинать
— разговора, — в прошедший четверг. Очень приятно провели там время.

— Да, я не был тогда у председателя, — отвечал Собакевич.

— А прекрасный человек!

— Кто такой? — сказал Собакевич, глядя на угол печи.

— Председатель.

— Ну, может быть, это вам так показалось: он только что масон, а такой
— дурак, какого свет не производил.

Чичиков немного озадачился таким отчасти резким определением, но
потом, поправившись, продолжал:

— Конечно, всякий человек не без слабостей, но зато губернатор какой
— превосходный человек!

— Губернатор превосходный человек?

— Да, не правда ли?

— Первый разбойник в мире!

— Как, губернатор разбойник? — сказал Чичиков и совершенно не мог
— понять, как губернатор мог попасть в разбойники. — Признаюсь, этого
— я бы никак не подумал, — продолжал он. — Но позвольте, однако же,
— заметить: поступки его совершенно не такие, напротив, скорее даже
— мягкости в нем много. — Тут он привел в доказательство даже
— кошельки, вышитые его собственными руками, и отозвался с похвалою об
— ласковом выражении лица его.

— И лицо разбойничье! — сказал Собакевич. — Дайте ему только нож да
— выпустите его на большую дорогу — зарежет, за копейку зарежет! Он да
— еще вице-губернатор — это Гога и Магога!

«Нет, он с ними не в ладах, — подумал про себя Чичиков. — А вот
«заговорю я с ним о полицеймейстере: он, кажется, друг его».

— Впрочем, что до меня, — сказал он, — мне, признаюсь, более всех
— нравится полицеймейстер. Какой-то этакой характер прямой, открытый;
— в лице видно что-то простосердечное.

— Мошенник! — сказал Собакевич очень хладнокровно, — продаст, обманет,
— еще и пообедает с вами! Я их знаю всех: это всё мошенники, весь
— город там такой: мошенник на мошеннике сидит и мошенником погоняет.
— Все христопродавцы. Один там только и есть порядочный человек:
— прокурор; да и тот, если сказать правду, свинья.

После таких похвальных, хотя несколько кратких биографий Чичиков
увидел, что о других чиновниках нечего упоминать и вспомнил, что
Собакевич не любил ни о ком хорошо отзываться.

— Что ж, душенька, пойдем обедать, — сказала Собакевичу его супруга.

— Прошу! — сказал Собакевич.

Засим, подошевши к столу, где была закуска, гость и хозяин выпили как
следует по рюмке водки, закусили, как закусывает вся пространная
Россия по городам и деревням, то есть всякими соленостями и иными
возбуждающими благодатями, и потекли все в столовую; впереди их, как
плавный гусь, понеслась хозяйка. Небольшой стол был накрыт на четыре
прибора. На четвертое место явилась очень скоро, трудно сказать
утвердительно, кто такая, дама или девица, родственница, домоводка или
просто проживающая в доме: что-то без чепца, около тридцати лет, в
пестром платке. Есть лица, которые существуют на свете не как предмет,
а как посторонние крапинки или пятнышки на предмете. Сидят они на том
же месте, одинаково держат голову, их почти готов принять за мебель и
думаешь, что отроду еще не выходило слово из таких уст; а где-нибудь в
девичьей или в кладовой окажется просто: ого-го!

— Щи, моя душа, сегодня очень хороши! — сказал Собакевич, хлебнувши
— щей и отваливши себе с блюда огромный кусок няни, известного блюда,
— которое подается к щам и состоит из бараньего желудка, начиненного
— гречневой кашей, мозгом и ножками. — Эдакой няни, — продолжал он,
— обратившись к Чичикову, — вы не будете есть в городе, там вам черт
— знает что подадут!

— У губернатора, однако ж, недурен стол, — сказал Чичиков.

— Да знаете ли, из чего это все готовится? вы есть не станете, когда
— узнаете.

— Не знаю, как приготовляется, об этом я не могу судить, но свиные
— котлеты и разварная рыба были превосходны.

— Это вам так показалось. Ведь я знаю, что они на рынке покупают.
— Купит вон тот каналья повар, что выучился у француза, кота, обдерет
— его, да и подает на стол вместо зайца.

— Фу! какую ты неприятность говоришь, — сказала супруга Собакевича.

— А что ж, душенька, так у них делается, я не виноват, так у них у
— всех делается. Все что ни есть ненужного, что Акулька у нас бросает,
— с позволения сказать, в помойную лохань, они его в суп! да в суп!
— туда его!

— Ты за столом всегда эдакое расскажешь! — возразила опять супруга
— Собакевича.

— Что ж, душа моя, — сказал Собакевич, — если б я сам это делал, но я
— тебе прямо в глаза скажу, что я гадостей не стану есть. Мне лягушку
— хоть сахаром облепи, не возьму ее в рот, и устрицы тоже не возьму: я
— знаю, на что устрица похожа. Возьмите барана, — продолжал он,
— обращаясь к Чичикову, — это бараний бок с кашей! Это не те фрикасе,
— что делаются на барских кухнях из баранины, какая суток по четыре на
— рынке валяется! Это все выдумали доктора немцы да французы, я бы их
— перевешал за это! Выдумали диету, лечить голодом! Что у них немецкая
— жидкостная натура, так они воображают, что и с русским желудком
— сладят! Нет, это все не то, это всё выдумки, это всё… — Здесь
— Собакевич даже сердито покачал головою. — Толкуют: просвещенье,
— просвещенье, а это просвещенье — фук! Сказал бы и другое слово, да
— вот только что за столом неприлично. У меня не так. У меня когда
— свинина — всю свинью давай на стол, баранина — всего барана тащи,
— гусь — всего гуся! Лучше я съем двух блюд, да съем в меру, как душа
— требует. — Собакевич подтвердил это делом: он опрокинул половину
— бараньего бока к себе на тарелку, съел все, обгрыз, обсосал до
— последней косточки.

«Да, — подумал Чичиков, — у этого губа не дура».

— У меня не так, — говорил Собакевич, вытирая салфеткою руки, — у меня
— не так, как у какого-нибудь Плюшкина: восемьсот душ имеет, а живет и
— обедает хуже моего пастуха!

— Кто такой этот Плюшкин? — спросил Чичиков.

— Мошенник, — отвечал Собакевич. — Такой скряга, какого вообразитъ
— трудно. В тюрьме колодники лучше живут, чем он: всех людей переморил
— голодом.

— Вправду! — подхватил с участием Чичиков. — И вы говорите, что у
— него, точно, люди умирают в большом количестве?

— Как мухи мрут.

— Неужели как мухи! А позвольте спросить, как далеко живет он от вас?

— В пяти верстах.

— В пяти верстах! — воскликнул Чичиков и даже почувствовал небольшое
— сердечное биение. — Но если выехать из ваших ворот, это будет
— направо или налево?

— Я вам даже не советую дороги знать к этой собаке! — сказал
— Собакевич. — Извинительней сходить в какое-нибудь непристойное
— место, чем к нему.

— Нет, я спросил не для каких-либо, а потому только, что интересуюсь
— познанием всякого рода мест, — отвечал на это Чичиков.

За бараньим боком последовали ватрушки, из которых каждая была гораздо
больше тарелки, потом индюк ростом в теленка, набитый всяким добром:
яйцами, рисом, печенками и невесть чем, что все ложилось комом в
желудке. Этим обед и кончился; но когда встали из-за стола, Чичиков
почувствовал в себе тяжести на целый пуд больше. Пошли в гостиную, где
уже очутилось на блюдечке варенье — ни груша, ни слива, ни иная ягода,
до которого, впрочем, не дотронулись ни гость, ни хозяин. Хозяйка
вышла, с тем чтобы накласть его и на другие блюдечки. Воспользовавшись
ее отсутствием, Чичиков обратился к Собакевичу, который, лежа в
креслах, только покряхтывал после такого сытного обеда и издавал ртом
какие-то невнятные звуки, крестясь и закрывая поминутно его рукою.
Чичиков обратился к нему с такими словами:

— Я хотел было поговорить с вами об одном дельце.

— Вот еще варенье, — сказала хозяйка, возвращаясь с блюдечком, —
— редька, варенная в меду!

— А вот мы его после! — сказал Собакевич. — Ты ступай теперь в свою
— комнату, мы с Павлом Ивановичем скинем фраки, маленько приотдохнем!

Хозяйка уже изъявила было готовность послать за пуховиками и
подушками, но хозяин сказал: «Ничего, мы отдохнем в креслах», — и
хозяйка ушла.

Собакевич слегка принагнул голову, приготовляясь слышать, в чем было
дельце.

Чичиков начал как-то очень отдаленно, коснулся вообще всего русского
государства и отозвался с большою похвалою об его пространстве,
сказал, что даже самая древняя римская монархия не была так велика, и
иностранцы справедливо удивляются… Собакевич все слушал, наклонивши
голову. И что по существующим положениям этого государства, в славе
которому нет равного, ревизские души, окончивши жизненное поприще,
числятся, однако ж, до подачи новой ревизской сказки наравне с живыми,
чтоб таким образом не обременить присутственные места множеством
мелочных и бесполезных справок и не увеличить сложность и без того уже
весьма сложного государственного механизма… Собакевич все слушал,
наклонивши голову, — и что, однако же, при всей справедливости этой
меры она бывает отчасти тягостна для многих владельцев, обязывая их
взносить подати так, как бы за живой предмет, и что он, чувствуя
уважение личное к нему, готов бы даже отчасти принять на себя эту
действительно тяжелую обязанность. Насчет главного предмета Чичиков
выразился очень осторожно: никак не назвал души умершими, а только
несуществующими.

Собакевич слушал все по-прежнему, нагнувши голову, и хоть бы что-
нибудь похожее на выражение показалось на лице его. Казалось, в этом
теле совсем не было души, или она у него была, но вовсе не там, где
следует, а, как у бессмертного кощея, где-то за горами и закрыта такою
толстою скорлупою, что все, что ни ворочалось на дне ее, не
производило решительно никакого потрясения на поверхности

— Итак?.. — сказал Чичиков, ожидая не без некоторого волнения ответа.

— Вам нужно мертвых душ? — спросил Собакевич очень просто, без
— малейшего удивления, как бы речь шла о хлебе.

— Да, — отвечал Чичиков и опять смягчил выражение, прибавивши: —
— несуществующих.

— Найдутся, почему не быть… — сказал Собакевич.

— А если найдутся, то вам, без сомнения… будет приятно от них
— избавиться?

— Извольте, я готов продать, — сказал Собакевич, уже несколько
— приподнявши голову и смекнувши, что покупщик, верно, должен иметь
— здесь какую-нибудь выгоду.

«Черт возьми, — подумал Чичиков про себя, — этот уж продает прежде,
«чем я заикнулся!» — и проговорил вслух:

— А, например, как же цена? хотя, впрочем, это такой предмет… что о
— цене даже странно…

— Да чтобы не запрашивать с вас лишнего, по сту рублей за штуку! —
— сказал Собакевич.

— По сту! — вскричал Чичиков, разинув рот и поглядевши ему в самые
— глаза, не зная, сам ли он ослышался, или язык Собакевича по своей
— тяжелой натуре, не так поворотившись, брякнул вместо одного другое
— слово.

— Что ж, разве это для вас дорого? — произнес Собакевич и потом
— прибавил: — А какая бы, однако ж, ваша цена?

— Моя цена! Мы, верно, как-нибудь ошиблись или не понимаем друг друга,
— позабыли, в чем состоит предмет. Я полагаю с своей стороны, положа
— на руку на сердце: по восьми гривен за душу, это самая красная ценз!

— Эк куда хватили — по восьми гривенок!

— Что ж, по моему суждению, как я думаю, больше нельзя.

— Ведь я продаю не лапти.

— Однако ж согласитесь сами: ведь это тоже и не люди.

— Так вы думаете, сыщете такого дурака, который бы вам продал по
— двугривенному ревизскую душу?

— Но позвольте: зачем вы их называете ревизскими, ведь души-то самые
— давно уже умерли, остался один неосязаемый чувствами звук. Впрочем,
— чтобы не входить в дальнейшие разговоры по этой части, по полтора
— рубли, извольте, дам, а больше не могу.

— Стыдно вам и говорить такую сумму! вы торгуйтесь, говорите настоящую
— цену!

— Не могу, Михаил Семенович, поверьте моей совести, не могу: чего уж
— невозможно сделать, того невозможно сделать, — говорил Чичиков,
— однако ж по полтинке еще прибавил.

— Да чего вы скупитесь? — сказал Собакевич. — Право, недорого! Другой
— мошенник обманет вас, продаст вам дрянь, а не души; а у меня что
— ядреный орех, все на отбор: не мастеровой, так иной какой-нибудь
— здоровый мужик. Вы рассмотрите: вот, например, каретник Михеев! ведь
— больше никаких экипажей и не делал, как только рессорные. И не то,
— как бывает московская работа, что на один час, — прочность такая,
— сам и обобьет, и лаком покроет!

Чичиков открыл рот, с тем чтобы заметить, что Михеева, однако же,
давно нет на свете; но Собакевич вошел, как говорится, в самую силу
речи, откуда взялась рысь и дар слова:

— А Пробка Степан, плотник? я голову прозакладую, если вы где сыщете
— такого мужика. Ведь что за силища была! Служи он в гвардии, ему бы
— бог знает что дали, трех аршин с вершком ростом!

Чичиков опять хотел заметить, что и Пробки нет на свете; но
Собакевича, как видно, пронесло: полились такие потоки речей, что
только нужно было слушать:

— Милушкин, кирпичник! мог поставить печь в каком угодно доме. Максим
— Телятников, сапожник: что шилом кольнет, то и сапоги, что сапоги, то
— и спасибо, и хоть бы в рот хмельного. А Еремей Сорокоплёхин! да этот
— мужик один станет за всех, в Москве торговал, одного оброку приносил
— по пятисот рублей. Ведь вот какой народ! Это не то, что вам продаст
— какой-нибудь Плюшкин.

— Но позвольте, — сказал наконец Чичиков, изумленный таким обильным
— наводнением речей, которым, казалось, и конца не было, — зачем вы
— исчисляете все их качества, ведь в них толку теперь нет никакого,
— ведь это все народ мертвый. Мертвым телом хоть забор подпирай,
— говорит пословица.

— Да, конечно, мертвые, — сказал Собакевич, как бы одумавшись и
— припомнив, что они в самом деле были уже мертвые, а потом прибавил:
— — Впрочем, и то сказать что из этих людей, которые числятся теперь
— живущими? Что это за люди? мухи, а не люди.

— Да все же они существуют, а это ведь мечта.

— Ну нет, не мечта! Я вам доложу, каков был Михеев, так вы таких людей
— не сыщете: машинища такая, что в эту комнату не войдет; нет, это не
— мечта! А в плечищах у него была такая силища, какой нет у лошади;
— хотел бы а знать, где бы вы в другом месте нашли такую мечту!

Последние слова он уже сказал, обратившись к висевшим на стене
портретам Багратиона и Колокотрони, как обыкновенно случается с
разговаривающими, когда один из них вдруг, неизвестно почему,
обратится не к тому лицу, к которому относятся слова, а к какому-
нибудь нечаянно пришедшему третьему, даже вовсе незнакомому, от
которого знает, что не услышит ни ответа, ни мнения, ни подтверждения,
но на которого, однако ж, так устремит взгляд, как будто призывает его
в посредники; и несколько смешавшийся в первую минуту незнакомец не
знает, отвечать ли ему на то дело, о котором ничего не слышал, или так
постоять, соблюдши надлежащее приличие, и потом уже уйти прочь.

— Нет, больше двух рублей я не могу дать, — сказал Чичиков.

— Извольте, чтоб не претендовали на меня, что дорого запрашиваю и не
— хочу сделать вам никакого одолжения, извольте — по семидесяти пяти
— рублей за душу, только ассигнациями, право только для знакомства!

«Что он в самом деле, — подумал про себя Чичиков, — за дурака, что ли,
«принимает меня?» — и прибавил потом вслух:

— Мне странно, право: кажется, между нами происходит какое-то
— театральное представление или комедия, иначе я не могу себе
— объяснить… Вы, кажется, человек довольно умный, владеете сведениями
— образованности. Ведь предмет просто фу-фу. Что ж он стоит? кому
— нужен?

— Да вот вы же покупаете, стало быть нужен.

Здесь Чичиков закусил губу и не нашелся, что отвечать. Он стал было
говорить про какие-то обстоятельства фамильные и семейственные, но
Собакевич отвечал просто:

— Мне не нужно знать, какие у вас отношения; я в дела фамильные не
— мешаюсь, это ваше дело. Вам понадобились души, я и продаю вам, и
— будете раскаиваться, что не купили.

— Два рублика, — сказал Чичиков.

— Эк, право, затвердила сорока Якова одно про всякого, как говорит
— пословица; как наладили на два, так не хотите с них и съехать. Вы
— давайте настоящую цену!

«Ну, уж черт его побери, — подумал про себя Чичиков, — по полтине ему
«прибавлю, собаке, на орехи!»

— Извольте, по полтине прибавлю.

— Ну, извольте, и я вам скажу тоже мое последнее слово: пятьдесят
— рублей! Право, убыток себе, дешевле нигде не купите такого хорошего
— народа!

«Экой кулак!» — сказал про себя Чичиков и потом продолжал вслух с
«некоторою досадою:

— Да что в самом деле… как будто точно сурьезное дело; да я в другом
— месте нипочем возьму. Еще мне всякий с охотой сбудет их, чтобы
— только поскорей избавиться. Дурак разве станет держать их при себе и
— платить за них подати!

— Но знаете ли, что такого рода покупки, я это говорю между нами, по
— дружбе, не всегда позволительны, и расскажи я или кто иной — такому
— человеку не будет никакой доверенности относительно контрактов или
— вступления в какие-нибудь выгодные обязательства.

«Вишь, куды метит, подлец!» — подумал Чичиков и тут же произнес с
«самым хладнокровным видом:

— Как вы себе хотите, я покупаю не для какой-либо надобности, как вы
— думаете, а так, по наклонности собственных мыслей. Два с полтиною не
— хотите — прощайте!

«Его не собьешь, неподатлив!» — подумал Собакевич.

— Ну, бог с вами, давайте по тридцати и берите их себе!

— Нет, я вижу, вы не хотите продать, прощайте!

— Позвольте, позвольте! — сказал Собакевич, не выпуская его руки и
— наступив ему на ногу, ибо герой наш позабыл поберечься, в наказанье
— за что должен был зашипеть и подскочить на одной ноге.

— Прошу прощенья! я, кажется, вас побеспокоил. Пожалуйте, садитесь
— сюда! Прошу! — Здесь он усадил его в кресла с некоторою даже
— ловкостию, как такой медведь, который уже побывал в руках, умеет и
— перевертываться, и делать разные штуки на вопросы: «А покажи, Миша,
— как бабы парятся» или: «А как, Миша, малые ребята горох крадут?»

— Право, я напрасно время трачу, мне нужно спешить.

— Посидите одну минуточку, я вам сейчас скажу одно приятное для вас
— слово. — Тут Собакевич подсел поближе и сказал ему тихо на ухо, как
— будто секрет: — Хотите угол?

— То есть двадцать пять рублей? Ни, ни, ни, даже четверти угла не дам,
— копейки не прибавлю.

Собакевич замолчал. Чичиков тоже замолчал. Минуты две длилось
молчание. Багратион с орлиным носом глядел со стены чрезвычайно
внимательно на эту покупку.

— Какая ж ваша будет последняя цена? — сказал наконец Собакевич.

— Два с полтиною.

— Право у вас душа человеческая все равно что пареная репа. Уж хоть по
— три рубли дайте!

— Не могу.

— Ну, нечего с вами делать, извольте! Убыток, да нрав такой собачий:
— не могу не доставить удовольствия ближнему. Ведь, я чай, нужно и
— купчую совершить, чтоб все было в порядке.

— Разумеется.

— Ну вот то-то же, нужно будет ехать в город.

Так совершилось дело. Оба решили, что завтра же быть в городе и
управиться с купчей крепостью. Чичиков попросил списочка крестьян.
Собакевич согласился охотно и тут же, подошед к бюро, собственноручно
принялся выписывать всех не только поименно, но даже с означением
похвальных качеств.

А Чичиков от нечего делать занялся, находясь позади рассматриваньем
всего просторного его оклада. Как взглянул он на его спину, широкую,
как у вятских приземистых лошадей, и на ноги его, походившие на
чугунные тумбы, которые ставят на тротуарах, не мог не воскликнуть
внутренно: «Эк наградил-то тебя бог! вот уж точно, как говорят,
неладно скроен, да крепко сшит!.. Родился ли ты уж так медведем, или
омедведила тебя захолустная жизнь, хлебные посевы, возня с мужиками, и
ты чрез них сделался то, что называют человек-кулак? Но нет: я думаю,
ты все был бы тот же, хотя бы даже воспитали тебя по моде, пустили бы
в ход и жил бы ты в Петербурге, а не в захолустье. Вся разница в том,
что теперь ты упишешь полбараньего бока с кашей, закусивши ватрушкою в
тарелку, а тогда бы ты ел какие-нибудь котлетки с трюфелями. Да вот
теперь у тебя под властью мужики: ты с ними в ладу и, конечно, их не
обидишь, потому что они твои, тебе же будет хуже; а тогда бы у тебя
были чиновники, которых бы ты сильно пощелкивал, смекнувши, что они не
твои же крепостные, или грабил бы ты казну! Нет, кто уж кулак, тому не
разогнуться в ладонь! А разогни кулаку один или два пальца, выдет еще
хуже. Попробуй он слегка верхушек какой-нибудь науки, даст он знать
потом, занявши место повиднее всем тем, которые в самом деле узнали
какую-нибудь науку. Да еще, пожалуй, скажет потом: „Дай-ка себя
покажу!“ Да такое выдумает мудрое постановление, что многим придется
солоно… Эх, если бы все кулаки!..»

— Готова записка, — сказал Собакевич, оборотившись.

— Готова? Пожалуйте ее сюда! — Он пробежал ее глазами и подивился
— аккуратности и точности: не только было обстоятельно прописано
— ремесло, звание, лета и семейное состояние, но даже на полях
— находились особенные отметки насчет поведения, трезвости, — словом,
— любо было глядеть.

— Теперь пожалуйте же задаточек, — сказал Собакевич.

— К чему же вам задаточек? Вы получите в городе за одним разом все
— деньги.

— Все, знаете, так уж водится, — возразил Собакевич.

— Не знаю, как вам дать, я не взял с собою денег. Да, вот десять
— рублей есть.

— Что же десять! Дайте по крайней мере хоть пятьдесят!

Чичиков стал было отговариваться, что нет; но Собакевич так сказал
утвердительно, что у него есть деньги, что он вынул еще бумажку,
сказавши:

— Пожалуй, вот вам еще пятнадцать, итого двадцать. Пожалуйте только
— расписку.

— Да на что ж вам расписка?

— Все, знаете, лучше расписку. Не ровен час, все может случиться.

— Хорошо, дайте же сюда деньги!

— На что ж деньги? У меня вот они в руке! как только напишете
— расписку, в ту же минуту

— Да позвольте, как же мне писать расписку? прежде нужно видеть
— деньги.

Чичиков выпустил из рук бумажки Собакевичу, который, приблизившись к
столу и накрывши их пальцами левой руки, другою написал на лоскутке
бумаги, что задаток двадцать пять рублей государственными ассигнациями
за проданные души получил сполна. Написавши записку, он пересмотрел
еще раз ассигнации.

— Бумажка-то старенькая! — произнес он, рассматривая одну из них на
— свете, — немножко разорвана, ну да между приятелями нечего на это
— глядеть.

«Кулак, кулак! — подумал про себя Чичиков, — да еще и бестия в
«придачу!»

— А женского пола не хотите?

— Нет, благодарю.

— Я бы недорого и взял. Для знакомства по рублику за штуку.

— Нет, в женском поле не нуждаюсь.

— Ну, когда не нуждаетесь, так нечего и говорить. На вкусы нет закона:
— кто любит попа, а кто попадью, говорит пословица.

— Еще я хотел вас попросить, чтобы эта сделка осталась между нами, —
— говорил Чичиков, прощаясь.

— Да уж само собою разумеется. Третьего сюда нечего мешать; что по
— искренности происходит между короткими друзьями, то должно остаться
— во взаимной их дружбе. Прощайте! Благодарю, что посетили; прошу и
— впредь не забывать: коли выберется свободный часик, приезжайте
— пообедать, время провести. Может быть, опять случится услужить чем-
— нибудь друг другу.

«Да, как бы не так! — думал про себя Чичиков, садясь. в бричку. — По
«два с полтиною содрал за мертвую душу, чертов кулак!»

Он был недоволен поведением Собакевича. Все-таки, как бы то ни было,
человек знакомый, и у губернатора, и у полицеймейстера видались, а
поступил как бы совершенно чужой, за дрянь взял деньги! Когда бричка
выехала со двора, он оглянулся назад и увидел, что Собакевич все еще
стоял на крыльце и, как казалось, приглядывался, желая знать, куда
гость поедет.

— Подлец, до сих пор еще стоит! — проговорил он сквозь зубы и велел
— Селифану, поворотивши к крестьянским избам, отъехать таким образом,
— чтобы нельзя было видеть экипажа со стороны господского двора. Ему
— хотелось заехать к Плюшкину, у которого, по словам Собакевича, люди
— умирали, как мухи, но не хотелось, чтобы Собакевич знал про это.
— Когда бричка была уже на конце деревни, он подозвал к себе первого
— мужика, который, попавши где-то на дороге претолстое бревно, тащил
— его на плече, подобно неутомимому муравью, к себе в избу.

— Эй, борода! а как проехать отсюда к Плюшкину, так чтоб не мимо
— господского дома?

Мужик, казалось, затруднился сим вопросом.

— Что ж, не знаешь?

— Нет, барин, не знаю.

— Эх, ты! А и седым волосом еще подернуло! скрягу Плюшкина не знаешь,
— того, что плохо кормит людей?

— А! заплатанной, заплатанной! — вскрикнул мужик.

Было им прибавлено и существительное к слову «заплатанной», очень
удачное, но неупотребительное в светском разговоре, а потому мы его
пропустим. Впрочем, можно догадываться, что оно выражено было очень
метко, потому что Чичиков, хотя мужик давно уже пропал из виду и много
уехали вперед, однако ж все еще усмехался, сидя в бричке. Выражается
сильно российский народ! и если наградит кого словцом, то пойдет оно
ему в род и потомство, утащит он его с собою и на службу, и в
отставку, и в Петербург, и на край света. И как уж потом ни хитри и ни
облагораживай свое прозвище, хоть заставь пишущих людишек выводить его
за наемную плату от древнекняжеского рода, ничто не поможет: каркнет
само за себя прозвище во все свое воронье горло и скажет ясно, откуда
вылетела птица. Произнесенное метко, все равно что писанное, не
вырубливается топором. А уж куды бывает метко все то, что вышло из
глубины Руси, где нет ни немецких, ни чухонских, ни всяких иных
племен, а всё сам-самородок, живой и бойкий русский ум, что не лезет
за словом в карман, не высиживает его, как наседка цыплят, а
влепливает сразу, как пашпорт на вечную носку, и нечего прибавлять уже
потом, какой у тебя нос или губы, — одной чертой обрисован ты с ног до
головы!

Как несметное множество церквей, монастырей с куполами, главами,
крестами, рассыпано на святой, благочестивой Руси, так несметное
множество племен, поколений, народов толпится, пестреет и мечется по
лицу земли. И всякий народ, носящий в себе залог сил, полный творящих
способностей души, своей яркой особенности и других даров нога,
своеобразно отличился каждый своим собственным словом, которым,
выражая какой ни есть предмет, отражает в выраженье его часть
собственного своего характера. Сердцеведением и мудрым познаньем жизни
отзовется слово британца; легким щеголем блеснет и разлетится
недолговечное слово француза; затейливо придумает свое, не всякому
доступное, умно-худощавое слово немец; но нет слова, которое было бы
так замашисто, бойко так вырвалось бы из-под самого сердца, так бы
кипело и животрепетало, как метко сказанное русское слово.

EOT;

    /*
    *** START: FULL LICENSE ***

    Creative Commons Legal Code

    Attribution-ShareAlike 3.0 Unported


    CREATIVE COMMONS CORPORATION IS NOT A LAW FIRM AND DOES NOT PROVIDE
    LEGAL SERVICES. DISTRIBUTION OF THIS LICENSE DOES NOT CREATE AN
    ATTORNEY-CLIENT RELATIONSHIP. CREATIVE COMMONS PROVIDES THIS
    INFORMATION ON AN "AS-IS" BASIS. CREATIVE COMMONS MAKES NO WARRANTIES
    REGARDING THE INFORMATION PROVIDED, AND DISCLAIMS LIABILITY FOR
    DAMAGES RESULTING FROM ITS USE. License

    THE WORK (AS DEFINED BELOW) IS PROVIDED UNDER THE TERMS OF THIS
    CREATIVE COMMONS PUBLIC LICENSE ("CCPL" OR "LICENSE"). THE WORK IS
    PROTECTED BY COPYRIGHT AND/OR OTHER APPLICABLE LAW. ANY USE OF THE
    WORK OTHER THAN AS AUTHORIZED UNDER THIS LICENSE OR COPYRIGHT LAW IS
    PROHIBITED.

    BY EXERCISING ANY RIGHTS TO THE WORK PROVIDED HERE, YOU ACCEPT AND
    AGREE TO BE BOUND BY THE TERMS OF THIS LICENSE. TO THE EXTENT THIS
    LICENSE MAY BE CONSIDERED TO BE A CONTRACT, THE LICENSOR GRANTS YOU
    THE RIGHTS CONTAINED HERE IN CONSIDERATION OF YOUR ACCEPTANCE OF SUCH
    TERMS AND CONDITIONS.

    1. Definitions

    "Adaptation" means a work based upon the Work, or upon the Work and
    other pre-existing works, such as a translation, adaptation,
    derivative work, arrangement of music or other alterations of a
    literary or artistic work, or phonogram or performance and includes
    cinematographic adaptations or any other form in which the Work may be
    recast, transformed, or adapted including in any form recognizably
    derived from the original, except that a work that constitutes a
    Collection will not be considered an Adaptation for the purpose of
    this License. For the avoidance of doubt, where the Work is a musical
    work, performance or phonogram, the synchronization of the Work in
    timed-relation with a moving image ("synching") will be considered an
    Adaptation for the purpose of this License. "Collection" means a
    collection of literary or artistic works, such as encyclopedias and
    anthologies, or performances, phonograms or broadcasts, or other works
    or subject matter other than works listed in Section 1(f) below,
    which, by reason of the selection and arrangement of their contents,
    constitute intellectual creations, in which the Work is included in
    its entirety in unmodified form along with one or more other
    contributions, each constituting separate and independent works in
    themselves, which together are assembled into a collective whole. A
    work that constitutes a Collection will not be considered an
    Adaptation (as defined below) for the purposes of this License.
    "Creative Commons Compatible License" means a license that is listed
    at http://creativecommons.org/compatiblelicenses that has been
    approved by Creative Commons as being essentially equivalent to this
    License, including, at a minimum, because that license: (i) contains
    terms that have the same purpose, meaning and effect as the License
    Elements of this License; and, (ii) explicitly permits the relicensing
    of adaptations of works made available under that license under this
    License or a Creative Commons jurisdiction license with the same
    License Elements as this License. "Distribute" means to make available
    to the public the original and copies of the Work or Adaptation, as
    appropriate, through sale or other transfer of ownership. "License
    Elements" means the following high-level license attributes as
    selected by Licensor and indicated in the title of this License:
    Attribution, ShareAlike. "Licensor" means the individual, individuals,
    entity or entities that offer(s) the Work under the terms of this
    License. "Original Author" means, in the case of a literary or
    artistic work, the individual, individuals, entity or entities who
    created the Work or if no individual or entity can be identified, the
    publisher; and in addition (i) in the case of a performance the
    actors, singers, musicians, dancers, and other persons who act, sing,
    deliver, declaim, play in, interpret or otherwise perform literary or
    artistic works or expressions of folklore; (ii) in the case of a
    phonogram the producer being the person or legal entity who first
    fixes the sounds of a performance or other sounds; and, (iii) in the
    case of broadcasts, the organization that transmits the broadcast.
    "Work" means the literary and/or artistic work offered under the terms
    of this License including without limitation any production in the
    literary, scientific and artistic domain, whatever may be the mode or
    form of its expression including digital form, such as a book,
    pamphlet and other writing; a lecture, address, sermon or other work
    of the same nature; a dramatic or dramatico-musical work; a
    choreographic work or entertainment in dumb show; a musical
    composition with or without words; a cinematographic work to which are
    assimilated works expressed by a process analogous to cinematography;
    a work of drawing, painting, architecture, sculpture, engraving or
    lithography; a photographic work to which are assimilated works
    expressed by a process analogous to photography; a work of applied
    art; an illustration, map, plan, sketch or three-dimensional work
    relative to geography, topography, architecture or science; a
    performance; a broadcast; a phonogram; a compilation of data to the
    extent it is protected as a copyrightable work; or a work performed by
    a variety or circus performer to the extent it is not otherwise
    considered a literary or artistic work. "You" means an individual or
    entity exercising rights under this License who has not previously
    violated the terms of this License with respect to the Work, or who
    has received express permission from the Licensor to exercise rights
    under this License despite a previous violation. "Publicly Perform"
    means to perform public recitations of the Work and to communicate to
    the public those public recitations, by any means or process,
    including by wire or wireless means or public digital performances; to
    make available to the public Works in such a way that members of the
    public may access these Works from a place and at a place individually
    chosen by them; to perform the Work to the public by any means or
    process and the communication to the public of the performances of the
    Work, including by public digital performance; to broadcast and
    rebroadcast the Work by any means including signs, sounds or images.
    "Reproduce" means to make copies of the Work by any means including
    without limitation by sound or visual recordings and the right of
    fixation and reproducing fixations of the Work, including storage of a
    protected performance or phonogram in digital form or other electronic
    medium. 2. Fair Dealing Rights. Nothing in this License is intended to
    reduce, limit, or restrict any uses free from copyright or rights
    arising from limitations or exceptions that are provided for in
    connection with the copyright protection under copyright law or other
    applicable laws.

    3. License Grant. Subject to the terms and conditions of this License,
    Licensor hereby grants You a worldwide, royalty-free, non-exclusive,
    perpetual (for the duration of the applicable copyright) license to
    exercise the rights in the Work as stated below:

    to Reproduce the Work, to incorporate the Work into one or more
    Collections, and to Reproduce the Work as incorporated in the
    Collections; to create and Reproduce Adaptations provided that any
    such Adaptation, including any translation in any medium, takes
    reasonable steps to clearly label, demarcate or otherwise identify
    that changes were made to the original Work. For example, a
    translation could be marked "The original work was translated from
    English to Spanish," or a modification could indicate "The original
    work has been modified."; to Distribute and Publicly Perform the Work
    including as incorporated in Collections; and, to Distribute and
    Publicly Perform Adaptations. For the avoidance of doubt:

    Non-waivable Compulsory License Schemes. In those jurisdictions in
    which the right to collect royalties through any statutory or
    compulsory licensing scheme cannot be waived, the Licensor reserves
    the exclusive right to collect such royalties for any exercise by You
    of the rights granted under this License; Waivable Compulsory License
    Schemes. In those jurisdictions in which the right to collect
    royalties through any statutory or compulsory licensing scheme can be
    waived, the Licensor waives the exclusive right to collect such
    royalties for any exercise by You of the rights granted under this
    License; and, Voluntary License Schemes. The Licensor waives the right
    to collect royalties, whether individually or, in the event that the
    Licensor is a member of a collecting society that administers
    voluntary licensing schemes, via that society, from any exercise by
    You of the rights granted under this License. The above rights may be
    exercised in all media and formats whether now known or hereafter
    devised. The above rights include the right to make such modifications
    as are technically necessary to exercise the rights in other media and
    formats. Subject to Section 8(f), all rights not expressly granted by
    Licensor are hereby reserved.

    4. Restrictions. The license granted in Section 3 above is expressly
    made subject to and limited by the following restrictions:

    You may Distribute or Publicly Perform the Work only under the terms
    of this License. You must include a copy of, or the Uniform Resource
    Identifier (URI) for, this License with every copy of the Work You
    Distribute or Publicly Perform. You may not offer or impose any terms
    on the Work that restrict the terms of this License or the ability of
    the recipient of the Work to exercise the rights granted to that
    recipient under the terms of the License. You may not sublicense the
    Work. You must keep intact all notices that refer to this License and
    to the disclaimer of warranties with every copy of the Work You
    Distribute or Publicly Perform. When You Distribute or Publicly
    Perform the Work, You may not impose any effective technological
    measures on the Work that restrict the ability of a recipient of the
    Work from You to exercise the rights granted to that recipient under
    the terms of the License. This Section 4(a) applies to the Work as
    incorporated in a Collection, but this does not require the Collection
    apart from the Work itself to be made subject to the terms of this
    License. If You create a Collection, upon notice from any Licensor You
    must, to the extent practicable, remove from the Collection any credit
    as required by Section 4(c), as requested. If You create an
    Adaptation, upon notice from any Licensor You must, to the extent
    practicable, remove from the Adaptation any credit as required by
    Section 4(c), as requested. You may Distribute or Publicly Perform an
    Adaptation only under the terms of: (i) this License; (ii) a later
    version of this License with the same License Elements as this
    License; (iii) a Creative Commons jurisdiction license (either this or
    a later license version) that contains the same License Elements as
    this License (e.g., Attribution-ShareAlike 3.0 US)); (iv) a Creative
    Commons Compatible License. If you license the Adaptation under one of
    the licenses mentioned in (iv), you must comply with the terms of that
    license. If you license the Adaptation under the terms of any of the
    licenses mentioned in (i), (ii) or (iii) (the "Applicable License"),
    you must comply with the terms of the Applicable License generally and
    the following provisions: (I) You must include a copy of, or the URI
    for, the Applicable License with every copy of each Adaptation You
    Distribute or Publicly Perform; (II) You may not offer or impose any
    terms on the Adaptation that restrict the terms of the Applicable
    License or the ability of the recipient of the Adaptation to exercise
    the rights granted to that recipient under the terms of the Applicable
    License; (III) You must keep intact all notices that refer to the
    Applicable License and to the disclaimer of warranties with every copy
    of the Work as included in the Adaptation You Distribute or Publicly
    Perform; (IV) when You Distribute or Publicly Perform the Adaptation,
    You may not impose any effective technological measures on the
    Adaptation that restrict the ability of a recipient of the Adaptation
    from You to exercise the rights granted to that recipient under the
    terms of the Applicable License. This Section 4(b) applies to the
    Adaptation as incorporated in a Collection, but this does not require
    the Collection apart from the Adaptation itself to be made subject to
    the terms of the Applicable License. If You Distribute, or Publicly
    Perform the Work or any Adaptations or Collections, You must, unless a
    request has been made pursuant to Section 4(a), keep intact all
    copyright notices for the Work and provide, reasonable to the medium
    or means You are utilizing: (i) the name of the Original Author (or
    pseudonym, if applicable) if supplied, and/or if the Original Author
    and/or Licensor designate another party or parties (e.g., a sponsor
    institute, publishing entity, journal) for attribution ("Attribution
    Parties") in Licensor's copyright notice, terms of service or by other
    reasonable means, the name of such party or parties; (ii) the title of
    the Work if supplied; (iii) to the extent reasonably practicable, the
    URI, if any, that Licensor specifies to be associated with the Work,
    unless such URI does not refer to the copyright notice or licensing
    information for the Work; and (iv) , consistent with Ssection 3(b), in
    the case of an Adaptation, a credit identifying the use of the Work in
    the Adaptation (e.g., "French translation of the Work by Original
    Author," or "Screenplay based on original Work by Original Author").
    The credit required by this Section 4(c) may be implemented in any
    reasonable manner; provided, however, that in the case of a Adaptation
    or Collection, at a minimum such credit will appear, if a credit for
    all contributing authors of the Adaptation or Collection appears, then
    as part of these credits and in a manner at least as prominent as the
    credits for the other contributing authors. For the avoidance of
    doubt, You may only use the credit required by this Section for the
    purpose of attribution in the manner set out above and, by exercising
    Your rights under this License, You may not implicitly or explicitly
    assert or imply any connection with, sponsorship or endorsement by the
    Original Author, Licensor and/or Attribution Parties, as appropriate,
    of You or Your use of the Work, without the separate, express prior
    written permission of the Original Author, Licensor and/or Attribution
    Parties. Except as otherwise agreed in writing by the Licensor or as
    may be otherwise permitted by applicable law, if You Reproduce,
    Distribute or Publicly Perform the Work either by itself or as part of
    any Adaptations or Collections, You must not distort, mutilate, modify
    or take other derogatory action in relation to the Work which would be
    prejudicial to the Original Author's honor or reputation. Licensor
    agrees that in those jurisdictions (e.g. Japan), in which any exercise
    of the right granted in Section 3(b) of this License (the right to
    make Adaptations) would be deemed to be a distortion, mutilation,
    modification or other derogatory action prejudicial to the Original
    Author's honor and reputation, the Licensor will waive or not assert,
    as appropriate, this Section, to the fullest extent permitted by the
    applicable national law, to enable You to reasonably exercise Your
    right under Section 3(b) of this License (right to make Adaptations)
    but not otherwise. 5. Representations, Warranties and Disclaimer

    UNLESS OTHERWISE MUTUALLY AGREED TO BY THE PARTIES IN WRITING,
    LICENSOR OFFERS THE WORK AS-IS AND MAKES NO REPRESENTATIONS OR
    WARRANTIES OF ANY KIND CONCERNING THE WORK, EXPRESS, IMPLIED,
    STATUTORY OR OTHERWISE, INCLUDING, WITHOUT LIMITATION, WARRANTIES OF
    TITLE, MERCHANTIBILITY, FITNESS FOR A PARTICULAR PURPOSE,
    NONINFRINGEMENT, OR THE ABSENCE OF LATENT OR OTHER DEFECTS, ACCURACY,
    OR THE PRESENCE OF ABSENCE OF ERRORS, WHETHER OR NOT DISCOVERABLE.
    SOME JURISDICTIONS DO NOT ALLOW THE EXCLUSION OF IMPLIED WARRANTIES,
    SO SUCH EXCLUSION MAY NOT APPLY TO YOU.

    6. Limitation on Liability. EXCEPT TO THE EXTENT REQUIRED BY
    APPLICABLE LAW, IN NO EVENT WILL LICENSOR BE LIABLE TO YOU ON ANY
    LEGAL THEORY FOR ANY SPECIAL, INCIDENTAL, CONSEQUENTIAL, PUNITIVE OR
    EXEMPLARY DAMAGES ARISING OUT OF THIS LICENSE OR THE USE OF THE WORK,
    EVEN IF LICENSOR HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.

    7. Termination

    This License and the rights granted hereunder will terminate
    automatically upon any breach by You of the terms of this License.
    Individuals or entities who have received Adaptations or Collections
    from You under this License, however, will not have their licenses
    terminated provided such individuals or entities remain in full
    compliance with those licenses. Sections 1, 2, 5, 6, 7, and 8 will
    survive any termination of this License. Subject to the above terms
    and conditions, the license granted here is perpetual (for the
    duration of the applicable copyright in the Work). Notwithstanding the
    above, Licensor reserves the right to release the Work under different
    license terms or to stop distributing the Work at any time; provided,
    however that any such election will not serve to withdraw this License
    (or any other license that has been, or is required to be, granted
    under the terms of this License), and this License will continue in
    full force and effect unless terminated as stated above. 8.
    Miscellaneous

    Each time You Distribute or Publicly Perform the Work or a Collection,
    the Licensor offers to the recipient a license to the Work on the same
    terms and conditions as the license granted to You under this License.
    Each time You Distribute or Publicly Perform an Adaptation, Licensor
    offers to the recipient a license to the original Work on the same
    terms and conditions as the license granted to You under this License.
    If any provision of this License is invalid or unenforceable under
    applicable law, it shall not affect the validity or enforceability of
    the remainder of the terms of this License, and without further action
    by the parties to this agreement, such provision shall be reformed to
    the minimum extent necessary to make such provision valid and
    enforceable. No term or provision of this License shall be deemed
    waived and no breach consented to unless such waiver or consent shall
    be in writing and signed by the party to be charged with such waiver
    or consent. This License constitutes the entire agreement between the
    parties with respect to the Work licensed here. There are no
    understandings, agreements or representations with respect to the Work
    not specified here. Licensor shall not be bound by any additional
    provisions that may appear in any communication from You. This License
    may not be modified without the mutual written agreement of the
    Licensor and You. The rights granted under, and the subject matter
    referenced, in this License were drafted utilizing the terminology of
    the Berne Convention for the Protection of Literary and Artistic Works
    (as amended on September 28, 1979), the Rome Convention of 1961, the
    WIPO Copyright Treaty of 1996, the WIPO Performances and Phonograms
    Treaty of 1996 and the Universal Copyright Convention (as revised on
    July 24, 1971). These rights and subject matter take effect in the
    relevant jurisdiction in which the License terms are sought to be
    enforced according to the corresponding provisions of the
    implementation of those treaty provisions in the applicable national
    law. If the standard suite of rights granted under applicable
    copyright law includes additional rights not granted under this
    License, such additional rights are deemed to be included in the
    License; this License is not intended to restrict the license of any
    rights under applicable law. Creative Commons Notice

    Creative Commons is not a party to this License, and makes no warranty
    whatsoever in connection with the Work. Creative Commons will not be
    liable to You or any party on any legal theory for any damages
    whatsoever, including without limitation any general, special,
    incidental or consequential damages arising in connection to this
    license. Notwithstanding the foregoing two (2) sentences, if Creative
    Commons has expressly identified itself as the Licensor hereunder, it
    shall have all rights and obligations of Licensor.

    Except for the limited purpose of indicating to the public that the
    Work is licensed under the CCPL, Creative Commons does not authorize
    the use by either party of the trademark "Creative Commons" or any
    related trademark or logo of Creative Commons without the prior
    written consent of Creative Commons. Any permitted use will be in
    compliance with Creative Commons' then-current trademark usage
    guidelines, as may be published on its website or otherwise made
    available upon request from time to time. For the avoidance of doubt,
    this trademark restriction does not form part of the License.

    Creative Commons may be contacted at http://creativecommons.org/.

    */
}
