<?php
/*
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * This software consists of voluntary contributions made by many individuals
 * and is licensed under the MIT license. For more information, see
 * <http://www.doctrine-project.org>.
 */

namespace Doctrine\ODM\MongoDB\Types;

/**
 * The Increment type.
 *
 * @since       1.0
 * @deprecated This type will be removed in ODM 2.0. Please use int or float instead
 */
class IncrementType extends Type
{
    public function convertToDatabaseValue($value)
    {
        @trigger_error(
            'Increment type was deprecated in version doctrine/mongodb-odm 1.1 - use int or float with increment storage strategy instead.',
            E_USER_DEPRECATED
        );
        return $value !== null ? (is_float($value) ? (float) $value : (int) $value) : null;
    }

    public function convertToPHPValue($value)
    {
        @trigger_error(
            'Increment type was deprecated in version doctrine/mongodb-odm 1.1 - use int or float with increment storage strategy instead.',
            E_USER_DEPRECATED
        );
        return $value !== null ? (is_float($value) ? (float) $value : (int) $value) : null;
    }

    public function closureToMongo()
    {
        return '$return = is_float($value) ? (float) $value : (int) $value;';
    }

    public function closureToPHP()
    {
        return '$return = is_float($value) ? (float) $value : (int) $value;';
    }
}
