<?php

declare(strict_types=1);

namespace Doctrine\ODM\MongoDB\Types;

use DateTime;
use DateTimeImmutable;
use DateTimeInterface;
use RuntimeException;

use function get_class;
use function sprintf;

class DateImmutableType extends DateType
{
    /**
     * @return DateTimeImmutable
     */
    public static function getDateTime($value): DateTimeInterface
    {
        $datetime = parent::getDateTime($value);

        if ($datetime instanceof DateTimeImmutable) {
            return $datetime;
        }

        if ($datetime instanceof DateTime) {
            return DateTimeImmutable::createFromMutable($datetime);
        }

        // @phpstan-ignore-next-line
        throw new RuntimeException(sprintf(
            '%s::getDateTime has returned an unsupported implementation of DateTimeInterface: %s',
            parent::class,
            get_class($datetime)
        ));
    }

    public function getNextVersion($current)
    {
        return new DateTimeImmutable();
    }
}
