<?php

namespace Documents;

use Doctrine\ODM\MongoDB\Mapping\Annotations as ODM;

/**
 * @ODM\Document(collection="servers")
 * @ODM\InheritanceType("SINGLE_COLLECTION")
 * @ODM\DiscriminatorField(fieldName="stype")
 * @ODM\DiscriminatorMap({
 * "server"="Server",
 * "server_guest"="GuestServer"
 * })
 */
class Server
{
    /** @ODM\Id */
    public $id;

    /** @ODM\String */
    public $name;
}