<?php
/*
 * This file is part of Pomm's Cli package.
 *
 * (c) 2014 Grégoire HUBERT <hubert.greg@gmail.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */
namespace PommProject\Cli\Test\Unit\Command;

use PommProject\Foundation\Session\Session;
use PommProject\Foundation\Tester\FoundationSessionAtoum;

use PommProject\Cli\Test\Fixture\StructureFixtureClient;

use Symfony\Component\Console\Application;
use Symfony\Component\Console\Tester\CommandTester;

class InspectDatabase extends FoundationSessionAtoum
{
    protected function initializeSession(Session $session)
    {
        $session
            ->registerClient(new StructureFixtureClient())
            ;
    }

    public function testExecute()
    {
        $application = new Application();
        $application->add($this->newTestedInstance()->setSession($this->buildSession()));
        $command = $application->find('pomm:inspect:database');
        $tester = new CommandTester($command);
        $tester->execute(
            [
                'command'          => $command->getName(),
                'config-name'      => 'pomm_test',
            ]
        );
        $this
            ->string($tester->getDisplay())
            ->contains("| pomm_test")
            ->contains("This is a test schema.")
            ->contains(" 4 ")
            ;
    }
}


