<?php
/*
 * This file is part of Pomm's Cli package.
 *
 * (c) 2014 - 2015 Grégoire HUBERT <hubert.greg@gmail.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */
namespace PommProject\Cli\Test\Unit\Command;

use PommProject\Cli\Test\Fixture\StructureFixtureClient;
use PommProject\Foundation\Session\Session;
use PommProject\ModelManager\Tester\ModelSessionAtoum;
use Symfony\Component\Console\Application;
use Symfony\Component\Console\Tester\CommandTester;

class InspectDatabase extends ModelSessionAtoum
{
    protected function initializeSession(Session $session): void
    {
        $session
            ->registerClient(new StructureFixtureClient())
            ;
    }

    public function testExecute(): void
    {
        $application = new Application();
        $application->addCommand($this->newTestedInstance()->setSession($this->buildSession()));
        $command = $application->find('pomm:inspect:database');
        $tester = new CommandTester($command);
        $tester->execute(
            [
                'command'          => $command->getName(),
                'config-name'      => 'pomm_test',
            ],
            [
                'decorated'        => false
            ]
        );
        $this
            ->string($tester->getDisplay())
            ->contains("| pomm_test")
            ->contains("This is a test schema.")
            ->contains(" 4 ")
            ;
    }
}
