<?php

/***********************************************************************
 *
 * Ting - PHP Datamapper
 * ==========================================
 *
 * Copyright (C) 2014 CCM Benchmark Group. (http://www.ccmbenchmark.com)
 *
 ***********************************************************************
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you
 * may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * permissions and limitations under the License.
 *
 **********************************************************************/

namespace CCMBenchmark\Ting;

use CCMBenchmark\Ting\Util\PropertyAccessor;
use Pimple\Container;

class Services implements ContainerInterface
{
    protected $container = null;

    protected $serviceOptions = null;

    public function __construct()
    {
        $this->container = new Container();
        $this->container->offsetSet(
            'ConnectionPool',
            fn () => new ConnectionPool()
        );

        $this->container->offsetSet(
            'MetadataRepository',
            fn () => new MetadataRepository($this->get('SerializerFactory'))
        );

        $this->container->offsetSet(
            'UnitOfWork',
            fn () => new UnitOfWork(
                $this->get('ConnectionPool'),
                $this->get('MetadataRepository'),
                $this->get('QueryFactory')
            )
        );

        $this->container->offsetSet(
            'CollectionFactory',
            $this->container->factory(fn () => new Repository\CollectionFactory(
                $this->get('MetadataRepository'),
                $this->get('UnitOfWork'),
                $this->get('Hydrator')
            ))
        );

        $this->container->offsetSet(
            'QueryFactory',
            fn () => new Query\QueryFactory()
        );

        $this->container->offsetSet(
            'SerializerFactory',
            fn () => new Serializer\SerializerFactory()
        );

        $this->container->offsetSet(
            'Hydrator',
            $this->container->factory(function () {
                $hydrator = new Repository\Hydrator();
                $hydrator->setMetadataRepository($this->get('MetadataRepository'));
                $hydrator->setUnitOfWork($this->get('UnitOfWork'));
                return $hydrator;
            })
        );

        $this->container->offsetSet(
            'HydratorSingleObject',
            $this->container->factory(function () {
                $hydrator = new Repository\HydratorSingleObject();
                $hydrator->setMetadataRepository($this->get('MetadataRepository'));
                $hydrator->setUnitOfWork($this->get('UnitOfWork'));
                return $hydrator;
            })
        );

        $this->container->offsetSet(
            'HydratorAggregator',
            $this->container->factory(function () {
                $hydrator = new Repository\HydratorAggregator();
                $hydrator->setMetadataRepository($this->get('MetadataRepository'));
                $hydrator->setUnitOfWork($this->get('UnitOfWork'));
                return $hydrator;
            })
        );

        $this->container->offsetSet(
            'HydratorRelational',
            $this->container->factory(function () {
                $hydrator = new Repository\HydratorRelational();
                $hydrator->setMetadataRepository($this->get('MetadataRepository'));
                $hydrator->setUnitOfWork($this->get('UnitOfWork'));
                return $hydrator;
            })
        );

        $this->container->offsetSet(
            'RepositoryFactory',
            fn () => new Repository\RepositoryFactory(
                $this->get('ConnectionPool'),
                $this->get('MetadataRepository'),
                $this->get('QueryFactory'),
                $this->get('CollectionFactory'),
                $this->get('UnitOfWork'),
                $this->get('Cache'),
                $this->get('SerializerFactory')
            )
        );

        $this->container->offsetSet(
            'Cache',
            fn () => new Cache\Cache()
        );

        $this->container->offsetSet(
            'PropertyAccessor',
            function () {
                return new PropertyAccessor();
            }
        );
    }

    public function set($id, \Closure $callable, $factory = false)
    {
        if ($factory === true) {
            $callable = $this->container->factory($callable);
        }

        $this->container->offsetSet($id, $callable);
        return $this;
    }

    public function get($id, array $options = null)
    {
        if ($options !== null) {
            if (isset($this->serviceOptions[$id]) && $this->serviceOptions[$id] !== $options) {
                throw new \RuntimeException(sprintf('Cannot call service %s with another configuration', $id));
            }
            $this->serviceOptions[$id] = $options;
        }

        return $this->container->offsetGet($id);
    }

    public function has($id)
    {
        return $this->container->offsetExists($id);
    }
}
