<?php

/***********************************************************************
 *
 * Ting - PHP Datamapper
 * ==========================================
 *
 * Copyright (C) 2014 CCM Benchmark Group. (http://www.ccmbenchmark.com)
 *
 ***********************************************************************
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you
 * may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * permissions and limitations under the License.
 *
 **********************************************************************/

namespace tests\fixtures\FakeDriver;

use CCMBenchmark\Ting\Driver\DriverInterface;
use CCMBenchmark\Ting\Driver\Exception;
use CCMBenchmark\Ting\Driver\StatementInterface;
use CCMBenchmark\Ting\Logger\DriverLoggerInterface;
use CCMBenchmark\Ting\Repository\CollectionInterface;

class Driver implements DriverInterface
{
    private $name;

    public static function forConnectionKey($connectionConfig, $database, \Closure $callback)
    {
        $callback(
            $connectionConfig['host'] . '|' .
            $connectionConfig['port'] . '|' .
            $connectionConfig['user'] . '|' .
            $connectionConfig['password']
        );
    }

    public function connect(string $hostname, string $username, string $password, int $port): static
    {
        return $this;
    }

    public function close(): static
    {
        return $this;
    }

    public function setName(string $name): static
    {
        $this->name = $name;
        return $this;
    }

    public function getName()
    {
        return $this->name;
    }

    public function setCharset(string $charset): void
    {

    }

    public function setLogger(DriverLoggerInterface $logger = null): static
    {
        return $this;
    }


    /**
     * @param string $sql
     * @param array $params
     * @param CollectionInterface $collection
     * @return mixed
     */
    public function execute(string $sql, array $params = [], ?CollectionInterface $collection = null): mixed
    {

    }

    /**
     * @param string $sql
     * @return StatementInterface
     */
    public function prepare($sql): StatementInterface
    {

    }

    public function escapeField(mixed $field = null): string
    {
        return (string) $field;
    }

    public function getInsertedId(): int
    {

    }

    /**
     * @return int
     */
    public function getAffectedRows(): int
    {

    }

    public static function getConnectionKey(array $connectionConfig, string $database): string
    {
        return md5(var_export($connectionConfig, true) . $database);
    }

    public function setDatabase(string $database): static
    {
        return $this;
    }

    /**
     * @param callable $callback
     */
    public function ifIsError(callable $callback): static
    {
        return $this;
    }

    /**
     * @param callable $callback
     */
    public function ifIsNotConnected(callable $callback): static
    {
        return $this;
    }

    public function startTransaction(): void
    {

    }

    public function rollback(): void
    {

    }

    public function commit(): void
    {
    }

    /**
     * @param $statement
     * @throws Exception
     */
    public function closeStatement(string $statement): void
    {

    }

    public function setTimezone(?string $timezone = null): void
    {
    }

    public function ping(): bool
    {
    }
}
