<?php

/***********************************************************************
 *
 * Ting - PHP Datamapper
 * ==========================================
 *
 * Copyright (C) 2014 CCM Benchmark Group. (http://www.ccmbenchmark.com)
 *
 ***********************************************************************
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you
 * may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * permissions and limitations under the License.
 *
 **********************************************************************/

namespace CCMBenchmark\Ting\Driver;

use CCMBenchmark\Ting\Logger\DriverLoggerInterface;
use CCMBenchmark\Ting\Repository\CollectionInterface;

interface StatementInterface
{
    /**
     * @param \mysqli_stmt|Object $driverStatement
     * @param array               $paramsOrder
     * @param string              $connectionName
     * @param string              $database
     */
    public function __construct($driverStatement, array $paramsOrder, $connectionName, $database);

    /**
     * @param array $params
     * @param CollectionInterface $collection
     * @return mixed
     * @throws QueryException
     */
    public function execute(array $params, ?CollectionInterface $collection = null);

    /**
     * @param DriverLoggerInterface $logger
     * @return void
     */
    public function setLogger(?DriverLoggerInterface $logger = null);
}
