<?php

namespace Behat\Behat\Context;

use Behat\Behat\Context\ContextInterface;

/*
 * This file is part of the Behat.
 * (c) Konstantin Kudryashov <ever.zet@gmail.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

/**
 * Context initializer interface.
 *
 * @author Konstantin Kudryashov <ever.zet@gmail.com>
 */
interface ContextInitializerInterface
{
    /**
     * Checks if initializer supports provided context.
     *
     * @param ContextInterface $context
     *
     * @return Boolean
     */
    function supports(ContextInterface $context);

    /**
     * Initializes provided context.
     *
     * @param ContextInterface $context
     */
    function initialize(ContextInterface $context);
}
