<?php
// This file was auto-generated from sdk-root/src/data/socialmessaging/2024-01-01/api-2.json
return [ 'version' => '2.0', 'metadata' => [ 'apiVersion' => '2024-01-01', 'auth' => [ 'aws.auth#sigv4', ], 'endpointPrefix' => 'social-messaging', 'protocol' => 'rest-json', 'protocols' => [ 'rest-json', ], 'serviceFullName' => 'AWS End User Messaging Social', 'serviceId' => 'SocialMessaging', 'signatureVersion' => 'v4', 'signingName' => 'social-messaging', 'uid' => 'socialmessaging-2024-01-01', ], 'operations' => [ 'AssociateWhatsAppBusinessAccount' => [ 'name' => 'AssociateWhatsAppBusinessAccount', 'http' => [ 'method' => 'POST', 'requestUri' => '/v1/whatsapp/signup', 'responseCode' => 200, ], 'input' => [ 'shape' => 'AssociateWhatsAppBusinessAccountInput', ], 'output' => [ 'shape' => 'AssociateWhatsAppBusinessAccountOutput', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'LimitExceededException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InvalidParametersException', ], [ 'shape' => 'ThrottledRequestException', ], [ 'shape' => 'DependencyException', ], ], ], 'CreateWhatsAppMessageTemplate' => [ 'name' => 'CreateWhatsAppMessageTemplate', 'http' => [ 'method' => 'POST', 'requestUri' => '/v1/whatsapp/template/put', 'responseCode' => 200, ], 'input' => [ 'shape' => 'CreateWhatsAppMessageTemplateInput', ], 'output' => [ 'shape' => 'CreateWhatsAppMessageTemplateOutput', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InvalidParametersException', ], [ 'shape' => 'ThrottledRequestException', ], [ 'shape' => 'InternalServiceException', ], [ 'shape' => 'DependencyException', ], ], ], 'CreateWhatsAppMessageTemplateFromLibrary' => [ 'name' => 'CreateWhatsAppMessageTemplateFromLibrary', 'http' => [ 'method' => 'POST', 'requestUri' => '/v1/whatsapp/template/create', 'responseCode' => 200, ], 'input' => [ 'shape' => 'CreateWhatsAppMessageTemplateFromLibraryInput', ], 'output' => [ 'shape' => 'CreateWhatsAppMessageTemplateFromLibraryOutput', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InvalidParametersException', ], [ 'shape' => 'ThrottledRequestException', ], [ 'shape' => 'InternalServiceException', ], [ 'shape' => 'DependencyException', ], ], ], 'CreateWhatsAppMessageTemplateMedia' => [ 'name' => 'CreateWhatsAppMessageTemplateMedia', 'http' => [ 'method' => 'POST', 'requestUri' => '/v1/whatsapp/template/media', 'responseCode' => 200, ], 'input' => [ 'shape' => 'CreateWhatsAppMessageTemplateMediaInput', ], 'output' => [ 'shape' => 'CreateWhatsAppMessageTemplateMediaOutput', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InvalidParametersException', ], [ 'shape' => 'ThrottledRequestException', ], [ 'shape' => 'InternalServiceException', ], [ 'shape' => 'DependencyException', ], ], ], 'DeleteWhatsAppMessageMedia' => [ 'name' => 'DeleteWhatsAppMessageMedia', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/v1/whatsapp/media', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DeleteWhatsAppMessageMediaInput', ], 'output' => [ 'shape' => 'DeleteWhatsAppMessageMediaOutput', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InvalidParametersException', ], [ 'shape' => 'AccessDeniedByMetaException', ], [ 'shape' => 'ThrottledRequestException', ], [ 'shape' => 'InternalServiceException', ], [ 'shape' => 'DependencyException', ], ], 'idempotent' => true, ], 'DeleteWhatsAppMessageTemplate' => [ 'name' => 'DeleteWhatsAppMessageTemplate', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/v1/whatsapp/template', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DeleteWhatsAppMessageTemplateInput', ], 'output' => [ 'shape' => 'DeleteWhatsAppMessageTemplateOutput', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InvalidParametersException', ], [ 'shape' => 'ThrottledRequestException', ], [ 'shape' => 'InternalServiceException', ], [ 'shape' => 'DependencyException', ], ], 'idempotent' => true, ], 'DisassociateWhatsAppBusinessAccount' => [ 'name' => 'DisassociateWhatsAppBusinessAccount', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/v1/whatsapp/waba/disassociate', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DisassociateWhatsAppBusinessAccountInput', ], 'output' => [ 'shape' => 'DisassociateWhatsAppBusinessAccountOutput', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InvalidParametersException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottledRequestException', ], [ 'shape' => 'DependencyException', ], ], 'idempotent' => true, ], 'GetLinkedWhatsAppBusinessAccount' => [ 'name' => 'GetLinkedWhatsAppBusinessAccount', 'http' => [ 'method' => 'GET', 'requestUri' => '/v1/whatsapp/waba/details', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetLinkedWhatsAppBusinessAccountInput', ], 'output' => [ 'shape' => 'GetLinkedWhatsAppBusinessAccountOutput', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InvalidParametersException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottledRequestException', ], [ 'shape' => 'InternalServiceException', ], [ 'shape' => 'DependencyException', ], ], 'readonly' => true, ], 'GetLinkedWhatsAppBusinessAccountPhoneNumber' => [ 'name' => 'GetLinkedWhatsAppBusinessAccountPhoneNumber', 'http' => [ 'method' => 'GET', 'requestUri' => '/v1/whatsapp/waba/phone/details', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetLinkedWhatsAppBusinessAccountPhoneNumberInput', ], 'output' => [ 'shape' => 'GetLinkedWhatsAppBusinessAccountPhoneNumberOutput', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InvalidParametersException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottledRequestException', ], [ 'shape' => 'InternalServiceException', ], [ 'shape' => 'DependencyException', ], ], 'readonly' => true, ], 'GetWhatsAppMessageMedia' => [ 'name' => 'GetWhatsAppMessageMedia', 'http' => [ 'method' => 'POST', 'requestUri' => '/v1/whatsapp/media/get', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetWhatsAppMessageMediaInput', ], 'output' => [ 'shape' => 'GetWhatsAppMessageMediaOutput', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InvalidParametersException', ], [ 'shape' => 'AccessDeniedByMetaException', ], [ 'shape' => 'ThrottledRequestException', ], [ 'shape' => 'InternalServiceException', ], [ 'shape' => 'DependencyException', ], ], ], 'GetWhatsAppMessageTemplate' => [ 'name' => 'GetWhatsAppMessageTemplate', 'http' => [ 'method' => 'GET', 'requestUri' => '/v1/whatsapp/template', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetWhatsAppMessageTemplateInput', ], 'output' => [ 'shape' => 'GetWhatsAppMessageTemplateOutput', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InvalidParametersException', ], [ 'shape' => 'ThrottledRequestException', ], [ 'shape' => 'InternalServiceException', ], [ 'shape' => 'DependencyException', ], ], 'readonly' => true, ], 'ListLinkedWhatsAppBusinessAccounts' => [ 'name' => 'ListLinkedWhatsAppBusinessAccounts', 'http' => [ 'method' => 'GET', 'requestUri' => '/v1/whatsapp/waba/list', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListLinkedWhatsAppBusinessAccountsInput', ], 'output' => [ 'shape' => 'ListLinkedWhatsAppBusinessAccountsOutput', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InvalidParametersException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottledRequestException', ], [ 'shape' => 'InternalServiceException', ], ], 'readonly' => true, ], 'ListTagsForResource' => [ 'name' => 'ListTagsForResource', 'http' => [ 'method' => 'GET', 'requestUri' => '/v1/tags/list', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListTagsForResourceInput', ], 'output' => [ 'shape' => 'ListTagsForResourceOutput', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InvalidParametersException', ], [ 'shape' => 'ThrottledRequestException', ], [ 'shape' => 'InternalServiceException', ], ], 'readonly' => true, ], 'ListWhatsAppMessageTemplates' => [ 'name' => 'ListWhatsAppMessageTemplates', 'http' => [ 'method' => 'GET', 'requestUri' => '/v1/whatsapp/template/list', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListWhatsAppMessageTemplatesInput', ], 'output' => [ 'shape' => 'ListWhatsAppMessageTemplatesOutput', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InvalidParametersException', ], [ 'shape' => 'ThrottledRequestException', ], [ 'shape' => 'InternalServiceException', ], [ 'shape' => 'DependencyException', ], ], 'readonly' => true, ], 'ListWhatsAppTemplateLibrary' => [ 'name' => 'ListWhatsAppTemplateLibrary', 'http' => [ 'method' => 'POST', 'requestUri' => '/v1/whatsapp/template/library', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListWhatsAppTemplateLibraryInput', ], 'output' => [ 'shape' => 'ListWhatsAppTemplateLibraryOutput', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InvalidParametersException', ], [ 'shape' => 'ThrottledRequestException', ], [ 'shape' => 'InternalServiceException', ], [ 'shape' => 'DependencyException', ], ], 'readonly' => true, ], 'PostWhatsAppMessageMedia' => [ 'name' => 'PostWhatsAppMessageMedia', 'http' => [ 'method' => 'POST', 'requestUri' => '/v1/whatsapp/media', 'responseCode' => 200, ], 'input' => [ 'shape' => 'PostWhatsAppMessageMediaInput', ], 'output' => [ 'shape' => 'PostWhatsAppMessageMediaOutput', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InvalidParametersException', ], [ 'shape' => 'AccessDeniedByMetaException', ], [ 'shape' => 'ThrottledRequestException', ], [ 'shape' => 'InternalServiceException', ], [ 'shape' => 'DependencyException', ], ], ], 'PutWhatsAppBusinessAccountEventDestinations' => [ 'name' => 'PutWhatsAppBusinessAccountEventDestinations', 'http' => [ 'method' => 'PUT', 'requestUri' => '/v1/whatsapp/waba/eventdestinations', 'responseCode' => 200, ], 'input' => [ 'shape' => 'PutWhatsAppBusinessAccountEventDestinationsInput', ], 'output' => [ 'shape' => 'PutWhatsAppBusinessAccountEventDestinationsOutput', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InvalidParametersException', ], [ 'shape' => 'ThrottledRequestException', ], [ 'shape' => 'InternalServiceException', ], ], 'idempotent' => true, ], 'SendWhatsAppMessage' => [ 'name' => 'SendWhatsAppMessage', 'http' => [ 'method' => 'POST', 'requestUri' => '/v1/whatsapp/send', 'responseCode' => 200, ], 'input' => [ 'shape' => 'SendWhatsAppMessageInput', ], 'output' => [ 'shape' => 'SendWhatsAppMessageOutput', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InvalidParametersException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottledRequestException', ], [ 'shape' => 'InternalServiceException', ], [ 'shape' => 'DependencyException', ], ], ], 'TagResource' => [ 'name' => 'TagResource', 'http' => [ 'method' => 'POST', 'requestUri' => '/v1/tags/tag-resource', 'responseCode' => 200, ], 'input' => [ 'shape' => 'TagResourceInput', ], 'output' => [ 'shape' => 'TagResourceOutput', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InvalidParametersException', ], [ 'shape' => 'ThrottledRequestException', ], [ 'shape' => 'InternalServiceException', ], ], ], 'UntagResource' => [ 'name' => 'UntagResource', 'http' => [ 'method' => 'POST', 'requestUri' => '/v1/tags/untag-resource', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UntagResourceInput', ], 'output' => [ 'shape' => 'UntagResourceOutput', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InvalidParametersException', ], [ 'shape' => 'ThrottledRequestException', ], [ 'shape' => 'InternalServiceException', ], ], ], 'UpdateWhatsAppMessageTemplate' => [ 'name' => 'UpdateWhatsAppMessageTemplate', 'http' => [ 'method' => 'POST', 'requestUri' => '/v1/whatsapp/template', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateWhatsAppMessageTemplateInput', ], 'output' => [ 'shape' => 'UpdateWhatsAppMessageTemplateOutput', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InvalidParametersException', ], [ 'shape' => 'ThrottledRequestException', ], [ 'shape' => 'InternalServiceException', ], [ 'shape' => 'DependencyException', ], ], ], ], 'shapes' => [ 'AccessDeniedByMetaException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'ErrorMessage', ], ], 'error' => [ 'httpStatusCode' => 403, 'senderFault' => true, ], 'exception' => true, ], 'AccessDeniedException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'ErrorMessage', ], ], 'error' => [ 'httpStatusCode' => 403, 'senderFault' => true, ], 'exception' => true, ], 'AddContactNumber' => [ 'type' => 'boolean', 'box' => true, ], 'AddLearnMoreLink' => [ 'type' => 'boolean', 'box' => true, ], 'AddSecurityRecommendation' => [ 'type' => 'boolean', 'box' => true, ], 'AddTrackPackageLink' => [ 'type' => 'boolean', 'box' => true, ], 'Arn' => [ 'type' => 'string', 'max' => 2048, 'min' => 0, 'pattern' => 'arn:.*', ], 'AssociateInProgressToken' => [ 'type' => 'string', 'max' => 50, 'min' => 0, 'sensitive' => true, ], 'AssociateWhatsAppBusinessAccountInput' => [ 'type' => 'structure', 'members' => [ 'signupCallback' => [ 'shape' => 'WhatsAppSignupCallback', ], 'setupFinalization' => [ 'shape' => 'WhatsAppSetupFinalization', ], ], ], 'AssociateWhatsAppBusinessAccountOutput' => [ 'type' => 'structure', 'members' => [ 'signupCallbackResult' => [ 'shape' => 'WhatsAppSignupCallbackResult', ], 'statusCode' => [ 'shape' => 'Integer', ], ], ], 'Boolean' => [ 'type' => 'boolean', 'box' => true, ], 'ButtonType' => [ 'type' => 'string', 'max' => 25, 'min' => 1, ], 'CodeExpirationMinutes' => [ 'type' => 'integer', 'box' => true, ], 'CreateWhatsAppMessageTemplateFromLibraryInput' => [ 'type' => 'structure', 'required' => [ 'metaLibraryTemplate', 'id', ], 'members' => [ 'metaLibraryTemplate' => [ 'shape' => 'MetaLibraryTemplate', ], 'id' => [ 'shape' => 'LinkedWhatsAppBusinessAccountId', ], ], ], 'CreateWhatsAppMessageTemplateFromLibraryOutput' => [ 'type' => 'structure', 'members' => [ 'metaTemplateId' => [ 'shape' => 'MetaTemplateId', ], 'templateStatus' => [ 'shape' => 'String', ], 'category' => [ 'shape' => 'MetaTemplateCategory', ], ], ], 'CreateWhatsAppMessageTemplateInput' => [ 'type' => 'structure', 'required' => [ 'templateDefinition', 'id', ], 'members' => [ 'templateDefinition' => [ 'shape' => 'MetaTemplateDefinition', ], 'id' => [ 'shape' => 'LinkedWhatsAppBusinessAccountId', ], ], ], 'CreateWhatsAppMessageTemplateMediaInput' => [ 'type' => 'structure', 'required' => [ 'id', ], 'members' => [ 'id' => [ 'shape' => 'LinkedWhatsAppBusinessAccountId', ], 'sourceS3File' => [ 'shape' => 'S3File', ], ], ], 'CreateWhatsAppMessageTemplateMediaOutput' => [ 'type' => 'structure', 'members' => [ 'metaHeaderHandle' => [ 'shape' => 'String', ], ], ], 'CreateWhatsAppMessageTemplateOutput' => [ 'type' => 'structure', 'members' => [ 'metaTemplateId' => [ 'shape' => 'MetaTemplateId', ], 'templateStatus' => [ 'shape' => 'String', ], 'category' => [ 'shape' => 'MetaTemplateCategory', ], ], ], 'DeleteAllLanguages' => [ 'type' => 'boolean', 'box' => true, ], 'DeleteWhatsAppMessageMediaInput' => [ 'type' => 'structure', 'required' => [ 'mediaId', 'originationPhoneNumberId', ], 'members' => [ 'mediaId' => [ 'shape' => 'WhatsAppMediaId', 'location' => 'querystring', 'locationName' => 'mediaId', ], 'originationPhoneNumberId' => [ 'shape' => 'WhatsAppPhoneNumberId', 'location' => 'querystring', 'locationName' => 'originationPhoneNumberId', ], ], ], 'DeleteWhatsAppMessageMediaOutput' => [ 'type' => 'structure', 'members' => [ 'success' => [ 'shape' => 'Boolean', ], ], ], 'DeleteWhatsAppMessageTemplateInput' => [ 'type' => 'structure', 'required' => [ 'id', 'templateName', ], 'members' => [ 'metaTemplateId' => [ 'shape' => 'MetaTemplateId', 'location' => 'querystring', 'locationName' => 'metaTemplateId', ], 'deleteAllLanguages' => [ 'shape' => 'DeleteAllLanguages', 'location' => 'querystring', 'locationName' => 'deleteAllTemplates', ], 'id' => [ 'shape' => 'LinkedWhatsAppBusinessAccountId', 'location' => 'querystring', 'locationName' => 'id', ], 'templateName' => [ 'shape' => 'MetaTemplateName', 'location' => 'querystring', 'locationName' => 'templateName', ], ], ], 'DeleteWhatsAppMessageTemplateOutput' => [ 'type' => 'structure', 'members' => [], ], 'DependencyException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'ErrorMessage', ], ], 'error' => [ 'httpStatusCode' => 502, ], 'exception' => true, 'fault' => true, 'retryable' => [ 'throttling' => false, ], ], 'DisassociateWhatsAppBusinessAccountInput' => [ 'type' => 'structure', 'required' => [ 'id', ], 'members' => [ 'id' => [ 'shape' => 'LinkedWhatsAppBusinessAccountId', 'location' => 'querystring', 'locationName' => 'id', ], ], ], 'DisassociateWhatsAppBusinessAccountOutput' => [ 'type' => 'structure', 'members' => [], ], 'ErrorMessage' => [ 'type' => 'string', ], 'EventDestinationArn' => [ 'type' => 'string', 'max' => 2048, 'min' => 0, 'pattern' => 'arn:.*:[a-z-]+([/:](.*))?', ], 'Filter' => [ 'type' => 'map', 'key' => [ 'shape' => 'FilterKeyString', ], 'value' => [ 'shape' => 'FilterValueString', ], 'max' => 10, 'min' => 0, ], 'FilterKeyString' => [ 'type' => 'string', 'max' => 100, 'min' => 1, ], 'FilterValueString' => [ 'type' => 'string', 'max' => 100, 'min' => 1, ], 'GetLinkedWhatsAppBusinessAccountInput' => [ 'type' => 'structure', 'required' => [ 'id', ], 'members' => [ 'id' => [ 'shape' => 'LinkedWhatsAppBusinessAccountId', 'location' => 'querystring', 'locationName' => 'id', ], ], ], 'GetLinkedWhatsAppBusinessAccountOutput' => [ 'type' => 'structure', 'members' => [ 'account' => [ 'shape' => 'LinkedWhatsAppBusinessAccount', ], ], ], 'GetLinkedWhatsAppBusinessAccountPhoneNumberInput' => [ 'type' => 'structure', 'required' => [ 'id', ], 'members' => [ 'id' => [ 'shape' => 'WhatsAppPhoneNumberId', 'location' => 'querystring', 'locationName' => 'id', ], ], ], 'GetLinkedWhatsAppBusinessAccountPhoneNumberOutput' => [ 'type' => 'structure', 'members' => [ 'phoneNumber' => [ 'shape' => 'WhatsAppPhoneNumberDetail', ], 'linkedWhatsAppBusinessAccountId' => [ 'shape' => 'LinkedWhatsAppBusinessAccountId', ], ], ], 'GetWhatsAppMessageMediaInput' => [ 'type' => 'structure', 'required' => [ 'mediaId', 'originationPhoneNumberId', ], 'members' => [ 'mediaId' => [ 'shape' => 'WhatsAppMediaId', ], 'originationPhoneNumberId' => [ 'shape' => 'WhatsAppPhoneNumberId', ], 'metadataOnly' => [ 'shape' => 'Boolean', ], 'destinationS3PresignedUrl' => [ 'shape' => 'S3PresignedUrl', ], 'destinationS3File' => [ 'shape' => 'S3File', ], ], ], 'GetWhatsAppMessageMediaOutput' => [ 'type' => 'structure', 'members' => [ 'mimeType' => [ 'shape' => 'String', ], 'fileSize' => [ 'shape' => 'Long', ], ], ], 'GetWhatsAppMessageTemplateInput' => [ 'type' => 'structure', 'required' => [ 'metaTemplateId', 'id', ], 'members' => [ 'metaTemplateId' => [ 'shape' => 'MetaTemplateId', 'location' => 'querystring', 'locationName' => 'metaTemplateId', ], 'id' => [ 'shape' => 'LinkedWhatsAppBusinessAccountId', 'location' => 'querystring', 'locationName' => 'id', ], ], ], 'GetWhatsAppMessageTemplateOutput' => [ 'type' => 'structure', 'members' => [ 'template' => [ 'shape' => 'MetaTemplate', ], ], ], 'Headers' => [ 'type' => 'map', 'key' => [ 'shape' => 'String', ], 'value' => [ 'shape' => 'String', ], ], 'Integer' => [ 'type' => 'integer', 'box' => true, ], 'InternalServiceException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'ErrorMessage', ], ], 'error' => [ 'httpStatusCode' => 500, ], 'exception' => true, 'fault' => true, 'retryable' => [ 'throttling' => false, ], ], 'InvalidParametersException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'ErrorMessage', ], ], 'error' => [ 'httpStatusCode' => 400, 'senderFault' => true, ], 'exception' => true, ], 'IsoCountryCode' => [ 'type' => 'string', 'pattern' => '[A-Z]{2}', ], 'LibraryTemplateBodyInputs' => [ 'type' => 'structure', 'members' => [ 'addContactNumber' => [ 'shape' => 'AddContactNumber', ], 'addLearnMoreLink' => [ 'shape' => 'AddLearnMoreLink', ], 'addSecurityRecommendation' => [ 'shape' => 'AddSecurityRecommendation', ], 'addTrackPackageLink' => [ 'shape' => 'AddTrackPackageLink', ], 'codeExpirationMinutes' => [ 'shape' => 'CodeExpirationMinutes', ], ], ], 'LibraryTemplateButtonInput' => [ 'type' => 'structure', 'members' => [ 'type' => [ 'shape' => 'ButtonType', ], 'phoneNumber' => [ 'shape' => 'PhoneNumber', ], 'url' => [ 'shape' => 'MetaUrlWithSuffixExample', ], 'otpType' => [ 'shape' => 'OtpType', ], 'zeroTapTermsAccepted' => [ 'shape' => 'ZeroTapTermsAccepted', ], 'supportedApps' => [ 'shape' => 'SupportedApps', ], ], ], 'LibraryTemplateButtonList' => [ 'type' => 'structure', 'members' => [ 'type' => [ 'shape' => 'ButtonType', ], 'text' => [ 'shape' => 'MetaText', ], 'phoneNumber' => [ 'shape' => 'PhoneNumber', ], 'url' => [ 'shape' => 'MetaUrl', ], 'otpType' => [ 'shape' => 'OtpType', ], 'zeroTapTermsAccepted' => [ 'shape' => 'ZeroTapTermsAccepted', ], 'supportedApps' => [ 'shape' => 'SupportedApps', ], ], ], 'LimitExceededException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'ErrorMessage', ], ], 'error' => [ 'httpStatusCode' => 400, 'senderFault' => true, ], 'exception' => true, ], 'LinkedAccountWithIncompleteSetup' => [ 'type' => 'map', 'key' => [ 'shape' => 'WhatsAppBusinessAccountId', ], 'value' => [ 'shape' => 'LinkedWhatsAppBusinessAccountIdMetaData', ], ], 'LinkedWhatsAppBusinessAccount' => [ 'type' => 'structure', 'required' => [ 'arn', 'id', 'wabaId', 'registrationStatus', 'linkDate', 'wabaName', 'eventDestinations', 'phoneNumbers', ], 'members' => [ 'arn' => [ 'shape' => 'LinkedWhatsAppBusinessAccountArn', ], 'id' => [ 'shape' => 'LinkedWhatsAppBusinessAccountId', ], 'wabaId' => [ 'shape' => 'WhatsAppBusinessAccountId', ], 'registrationStatus' => [ 'shape' => 'RegistrationStatus', ], 'linkDate' => [ 'shape' => 'WhatsAppBusinessAccountLinkDate', ], 'wabaName' => [ 'shape' => 'WhatsAppBusinessAccountName', ], 'eventDestinations' => [ 'shape' => 'WhatsAppBusinessAccountEventDestinations', ], 'phoneNumbers' => [ 'shape' => 'WhatsAppPhoneNumberSummaryList', ], ], ], 'LinkedWhatsAppBusinessAccountArn' => [ 'type' => 'string', 'max' => 2048, 'min' => 0, 'pattern' => 'arn:.*:waba/[0-9a-zA-Z]+', ], 'LinkedWhatsAppBusinessAccountId' => [ 'type' => 'string', 'max' => 115, 'min' => 1, 'pattern' => '.*(^waba-.*$)|(^arn:.*:waba/[0-9a-zA-Z]+$).*', ], 'LinkedWhatsAppBusinessAccountIdMetaData' => [ 'type' => 'structure', 'members' => [ 'accountName' => [ 'shape' => 'WhatsAppBusinessAccountName', ], 'registrationStatus' => [ 'shape' => 'RegistrationStatus', ], 'unregisteredWhatsAppPhoneNumbers' => [ 'shape' => 'WhatsAppPhoneNumberDetailList', ], 'wabaId' => [ 'shape' => 'LinkedWhatsAppBusinessAccountId', ], ], ], 'LinkedWhatsAppBusinessAccountSummary' => [ 'type' => 'structure', 'required' => [ 'arn', 'id', 'wabaId', 'registrationStatus', 'linkDate', 'wabaName', 'eventDestinations', ], 'members' => [ 'arn' => [ 'shape' => 'LinkedWhatsAppBusinessAccountArn', ], 'id' => [ 'shape' => 'LinkedWhatsAppBusinessAccountId', ], 'wabaId' => [ 'shape' => 'WhatsAppBusinessAccountId', ], 'registrationStatus' => [ 'shape' => 'RegistrationStatus', ], 'linkDate' => [ 'shape' => 'WhatsAppBusinessAccountLinkDate', ], 'wabaName' => [ 'shape' => 'WhatsAppBusinessAccountName', ], 'eventDestinations' => [ 'shape' => 'WhatsAppBusinessAccountEventDestinations', ], ], ], 'LinkedWhatsAppBusinessAccountSummaryList' => [ 'type' => 'list', 'member' => [ 'shape' => 'LinkedWhatsAppBusinessAccountSummary', ], ], 'LinkedWhatsAppPhoneNumberArn' => [ 'type' => 'string', 'max' => 2048, 'min' => 0, 'pattern' => 'arn:.*:phone-number-id/[0-9a-zA-Z]+', ], 'ListLinkedWhatsAppBusinessAccountsInput' => [ 'type' => 'structure', 'members' => [ 'nextToken' => [ 'shape' => 'NextToken', 'location' => 'querystring', 'locationName' => 'nextToken', ], 'maxResults' => [ 'shape' => 'MaxResults', 'location' => 'querystring', 'locationName' => 'maxResults', ], ], ], 'ListLinkedWhatsAppBusinessAccountsOutput' => [ 'type' => 'structure', 'members' => [ 'linkedAccounts' => [ 'shape' => 'LinkedWhatsAppBusinessAccountSummaryList', ], 'nextToken' => [ 'shape' => 'NextToken', ], ], ], 'ListTagsForResourceInput' => [ 'type' => 'structure', 'required' => [ 'resourceArn', ], 'members' => [ 'resourceArn' => [ 'shape' => 'Arn', 'location' => 'querystring', 'locationName' => 'resourceArn', ], ], ], 'ListTagsForResourceOutput' => [ 'type' => 'structure', 'members' => [ 'statusCode' => [ 'shape' => 'Integer', ], 'tags' => [ 'shape' => 'TagList', ], ], ], 'ListWhatsAppMessageTemplatesInput' => [ 'type' => 'structure', 'required' => [ 'id', ], 'members' => [ 'id' => [ 'shape' => 'LinkedWhatsAppBusinessAccountId', 'location' => 'querystring', 'locationName' => 'id', ], 'nextToken' => [ 'shape' => 'NextToken', 'location' => 'querystring', 'locationName' => 'nextToken', ], 'maxResults' => [ 'shape' => 'MaxResults', 'location' => 'querystring', 'locationName' => 'maxResults', ], ], ], 'ListWhatsAppMessageTemplatesOutput' => [ 'type' => 'structure', 'members' => [ 'templates' => [ 'shape' => 'TemplateSummaryList', ], 'nextToken' => [ 'shape' => 'NextToken', ], ], ], 'ListWhatsAppTemplateLibraryInput' => [ 'type' => 'structure', 'required' => [ 'id', ], 'members' => [ 'nextToken' => [ 'shape' => 'NextToken', ], 'maxResults' => [ 'shape' => 'MaxResults', ], 'id' => [ 'shape' => 'LinkedWhatsAppBusinessAccountId', 'location' => 'querystring', 'locationName' => 'id', ], 'filters' => [ 'shape' => 'Filter', ], ], ], 'ListWhatsAppTemplateLibraryOutput' => [ 'type' => 'structure', 'members' => [ 'metaLibraryTemplates' => [ 'shape' => 'MetaLibraryTemplatesList', ], 'nextToken' => [ 'shape' => 'NextToken', ], ], ], 'Long' => [ 'type' => 'long', 'box' => true, ], 'MaxResults' => [ 'type' => 'integer', 'box' => true, 'max' => 100, 'min' => 1, ], 'MetaIndustries' => [ 'type' => 'list', 'member' => [ 'shape' => 'MetaIndustry', ], ], 'MetaIndustry' => [ 'type' => 'string', 'max' => 25, 'min' => 1, ], 'MetaLibraryTemplate' => [ 'type' => 'structure', 'required' => [ 'templateName', 'libraryTemplateName', 'templateCategory', 'templateLanguage', ], 'members' => [ 'templateName' => [ 'shape' => 'MetaTemplateName', ], 'libraryTemplateName' => [ 'shape' => 'MetaTemplateName', ], 'templateCategory' => [ 'shape' => 'MetaTemplateCategory', ], 'templateLanguage' => [ 'shape' => 'MetaTemplateLanguage', ], 'libraryTemplateButtonInputs' => [ 'shape' => 'MetaLibraryTemplateButtonInputs', ], 'libraryTemplateBodyInputs' => [ 'shape' => 'LibraryTemplateBodyInputs', ], ], ], 'MetaLibraryTemplateButtonInputs' => [ 'type' => 'list', 'member' => [ 'shape' => 'LibraryTemplateButtonInput', ], ], 'MetaLibraryTemplateButtonList' => [ 'type' => 'list', 'member' => [ 'shape' => 'LibraryTemplateButtonList', ], ], 'MetaLibraryTemplateDefinition' => [ 'type' => 'structure', 'members' => [ 'templateName' => [ 'shape' => 'MetaTemplateName', ], 'templateLanguage' => [ 'shape' => 'MetaTemplateLanguage', ], 'templateCategory' => [ 'shape' => 'MetaTemplateCategory', ], 'templateTopic' => [ 'shape' => 'MetaTemplateTopic', ], 'templateUseCase' => [ 'shape' => 'MetaTemplateUseCase', ], 'templateIndustry' => [ 'shape' => 'MetaIndustries', ], 'templateHeader' => [ 'shape' => 'MetaTemplateHeader', ], 'templateBody' => [ 'shape' => 'MetaTemplateBody', ], 'templateButtons' => [ 'shape' => 'MetaLibraryTemplateButtonList', ], 'templateId' => [ 'shape' => 'MetaTemplateId', ], 'templateBodyExampleParams' => [ 'shape' => 'MetaTemplateBodyExampleParams', ], ], ], 'MetaLibraryTemplatesList' => [ 'type' => 'list', 'member' => [ 'shape' => 'MetaLibraryTemplateDefinition', ], ], 'MetaParameterFormat' => [ 'type' => 'string', 'max' => 15, 'min' => 1, ], 'MetaTemplate' => [ 'type' => 'string', 'max' => 6000, 'min' => 1, ], 'MetaTemplateBody' => [ 'type' => 'string', 'max' => 2000, 'min' => 1, ], 'MetaTemplateBodyExampleParams' => [ 'type' => 'list', 'member' => [ 'shape' => 'String', ], ], 'MetaTemplateCategory' => [ 'type' => 'string', 'max' => 100, 'min' => 1, ], 'MetaTemplateComponents' => [ 'type' => 'blob', 'max' => 3000, 'min' => 1, ], 'MetaTemplateCtaLinkTrackingOptedOut' => [ 'type' => 'boolean', 'box' => true, ], 'MetaTemplateDefinition' => [ 'type' => 'blob', 'max' => 6000, 'min' => 1, ], 'MetaTemplateHeader' => [ 'type' => 'string', 'max' => 200, 'min' => 1, ], 'MetaTemplateId' => [ 'type' => 'string', 'max' => 100, 'min' => 1, 'pattern' => '[0-9]+', ], 'MetaTemplateLanguage' => [ 'type' => 'string', 'max' => 6, 'min' => 1, ], 'MetaTemplateName' => [ 'type' => 'string', 'max' => 512, 'min' => 1, ], 'MetaTemplateQualityScore' => [ 'type' => 'string', 'max' => 20, 'min' => 1, ], 'MetaTemplateStatus' => [ 'type' => 'string', 'max' => 20, 'min' => 1, ], 'MetaTemplateTopic' => [ 'type' => 'string', 'max' => 20, 'min' => 1, ], 'MetaTemplateUseCase' => [ 'type' => 'string', 'max' => 30, 'min' => 1, ], 'MetaText' => [ 'type' => 'string', 'max' => 40, 'min' => 1, ], 'MetaUrl' => [ 'type' => 'string', 'max' => 400, 'min' => 1, ], 'MetaUrlWithSuffixExample' => [ 'type' => 'map', 'key' => [ 'shape' => 'MetaUrlWithSuffixExampleKeyString', ], 'value' => [ 'shape' => 'MetaUrlWithSuffixExampleValueString', ], 'max' => 10, 'min' => 0, ], 'MetaUrlWithSuffixExampleKeyString' => [ 'type' => 'string', 'max' => 30, 'min' => 1, ], 'MetaUrlWithSuffixExampleValueString' => [ 'type' => 'string', 'max' => 400, 'min' => 1, ], 'NextToken' => [ 'type' => 'string', 'max' => 600, 'min' => 1, ], 'OtpType' => [ 'type' => 'string', 'max' => 25, 'min' => 1, ], 'PhoneNumber' => [ 'type' => 'string', 'max' => 20, 'min' => 1, ], 'PostWhatsAppMessageMediaInput' => [ 'type' => 'structure', 'required' => [ 'originationPhoneNumberId', ], 'members' => [ 'originationPhoneNumberId' => [ 'shape' => 'WhatsAppPhoneNumberId', ], 'sourceS3PresignedUrl' => [ 'shape' => 'S3PresignedUrl', ], 'sourceS3File' => [ 'shape' => 'S3File', ], ], ], 'PostWhatsAppMessageMediaOutput' => [ 'type' => 'structure', 'members' => [ 'mediaId' => [ 'shape' => 'WhatsAppMediaId', ], ], ], 'PutWhatsAppBusinessAccountEventDestinationsInput' => [ 'type' => 'structure', 'required' => [ 'id', 'eventDestinations', ], 'members' => [ 'id' => [ 'shape' => 'LinkedWhatsAppBusinessAccountId', ], 'eventDestinations' => [ 'shape' => 'WhatsAppBusinessAccountEventDestinations', ], ], ], 'PutWhatsAppBusinessAccountEventDestinationsOutput' => [ 'type' => 'structure', 'members' => [], ], 'RegistrationStatus' => [ 'type' => 'string', 'enum' => [ 'COMPLETE', 'INCOMPLETE', ], ], 'ResourceNotFoundException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'ErrorMessage', ], ], 'error' => [ 'httpStatusCode' => 404, 'senderFault' => true, ], 'exception' => true, ], 'RoleArn' => [ 'type' => 'string', 'pattern' => 'arn:.*:iam::\\d{12}:role\\/[a-zA-Z0-9+=,.@\\-_]+', ], 'S3File' => [ 'type' => 'structure', 'required' => [ 'bucketName', 'key', ], 'members' => [ 'bucketName' => [ 'shape' => 'S3FileBucketNameString', ], 'key' => [ 'shape' => 'S3FileKeyString', ], ], 'sensitive' => true, ], 'S3FileBucketNameString' => [ 'type' => 'string', 'max' => 63, 'min' => 3, 'pattern' => '[a-z0-9][a-z0-9.-]*[a-z0-9]', ], 'S3FileKeyString' => [ 'type' => 'string', 'max' => 1024, 'min' => 0, ], 'S3PresignedUrl' => [ 'type' => 'structure', 'required' => [ 'url', 'headers', ], 'members' => [ 'url' => [ 'shape' => 'S3PresignedUrlUrlString', ], 'headers' => [ 'shape' => 'Headers', ], ], 'sensitive' => true, ], 'S3PresignedUrlUrlString' => [ 'type' => 'string', 'max' => 2000, 'min' => 1, 'pattern' => 'https://(.*)s3(.*).amazonaws.com/(.*)', ], 'SendWhatsAppMessageInput' => [ 'type' => 'structure', 'required' => [ 'originationPhoneNumberId', 'message', 'metaApiVersion', ], 'members' => [ 'originationPhoneNumberId' => [ 'shape' => 'WhatsAppPhoneNumberId', ], 'message' => [ 'shape' => 'WhatsAppMessageBlob', ], 'metaApiVersion' => [ 'shape' => 'String', ], ], ], 'SendWhatsAppMessageOutput' => [ 'type' => 'structure', 'members' => [ 'messageId' => [ 'shape' => 'String', ], ], ], 'String' => [ 'type' => 'string', ], 'StringList' => [ 'type' => 'list', 'member' => [ 'shape' => 'String', ], ], 'SupportedApp' => [ 'type' => 'map', 'key' => [ 'shape' => 'SupportedAppKeyString', ], 'value' => [ 'shape' => 'SupportedAppValueString', ], 'max' => 10, 'min' => 0, ], 'SupportedAppKeyString' => [ 'type' => 'string', 'max' => 30, 'min' => 1, ], 'SupportedAppValueString' => [ 'type' => 'string', 'max' => 100, 'min' => 1, ], 'SupportedApps' => [ 'type' => 'list', 'member' => [ 'shape' => 'SupportedApp', ], ], 'Tag' => [ 'type' => 'structure', 'required' => [ 'key', ], 'members' => [ 'key' => [ 'shape' => 'TagKeyString', ], 'value' => [ 'shape' => 'TagValueString', ], ], ], 'TagKeyString' => [ 'type' => 'string', 'max' => 128, 'min' => 1, ], 'TagList' => [ 'type' => 'list', 'member' => [ 'shape' => 'Tag', ], ], 'TagResourceInput' => [ 'type' => 'structure', 'required' => [ 'resourceArn', 'tags', ], 'members' => [ 'resourceArn' => [ 'shape' => 'Arn', ], 'tags' => [ 'shape' => 'TagList', ], ], ], 'TagResourceOutput' => [ 'type' => 'structure', 'members' => [ 'statusCode' => [ 'shape' => 'Integer', ], ], ], 'TagValueString' => [ 'type' => 'string', 'max' => 256, 'min' => 0, ], 'TemplateSummary' => [ 'type' => 'structure', 'members' => [ 'templateName' => [ 'shape' => 'MetaTemplateName', ], 'metaTemplateId' => [ 'shape' => 'MetaTemplateId', ], 'templateStatus' => [ 'shape' => 'MetaTemplateStatus', ], 'templateQualityScore' => [ 'shape' => 'MetaTemplateQualityScore', ], 'templateLanguage' => [ 'shape' => 'MetaTemplateLanguage', ], 'templateCategory' => [ 'shape' => 'MetaTemplateCategory', ], ], ], 'TemplateSummaryList' => [ 'type' => 'list', 'member' => [ 'shape' => 'TemplateSummary', ], ], 'ThrottledRequestException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'ErrorMessage', ], ], 'error' => [ 'httpStatusCode' => 429, 'senderFault' => true, ], 'exception' => true, 'retryable' => [ 'throttling' => false, ], ], 'TwoFactorPin' => [ 'type' => 'string', 'max' => 6, 'min' => 1, 'sensitive' => true, ], 'UntagResourceInput' => [ 'type' => 'structure', 'required' => [ 'resourceArn', 'tagKeys', ], 'members' => [ 'resourceArn' => [ 'shape' => 'Arn', ], 'tagKeys' => [ 'shape' => 'StringList', ], ], ], 'UntagResourceOutput' => [ 'type' => 'structure', 'members' => [ 'statusCode' => [ 'shape' => 'Integer', ], ], ], 'UpdateWhatsAppMessageTemplateInput' => [ 'type' => 'structure', 'required' => [ 'id', 'metaTemplateId', ], 'members' => [ 'id' => [ 'shape' => 'LinkedWhatsAppBusinessAccountId', ], 'metaTemplateId' => [ 'shape' => 'MetaTemplateId', ], 'parameterFormat' => [ 'shape' => 'MetaParameterFormat', ], 'templateCategory' => [ 'shape' => 'MetaTemplateCategory', ], 'templateComponents' => [ 'shape' => 'MetaTemplateComponents', ], 'ctaUrlLinkTrackingOptedOut' => [ 'shape' => 'MetaTemplateCtaLinkTrackingOptedOut', ], ], ], 'UpdateWhatsAppMessageTemplateOutput' => [ 'type' => 'structure', 'members' => [], ], 'ValidationException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'ErrorMessage', ], ], 'error' => [ 'httpStatusCode' => 400, 'senderFault' => true, ], 'exception' => true, ], 'WabaPhoneNumberSetupFinalization' => [ 'type' => 'structure', 'required' => [ 'id', 'twoFactorPin', ], 'members' => [ 'id' => [ 'shape' => 'WhatsAppPhoneNumber', ], 'twoFactorPin' => [ 'shape' => 'TwoFactorPin', ], 'dataLocalizationRegion' => [ 'shape' => 'IsoCountryCode', ], 'tags' => [ 'shape' => 'TagList', ], ], ], 'WabaPhoneNumberSetupFinalizationList' => [ 'type' => 'list', 'member' => [ 'shape' => 'WabaPhoneNumberSetupFinalization', ], ], 'WabaSetupFinalization' => [ 'type' => 'structure', 'members' => [ 'id' => [ 'shape' => 'WhatsAppBusinessAccountId', ], 'eventDestinations' => [ 'shape' => 'WhatsAppBusinessAccountEventDestinations', ], 'tags' => [ 'shape' => 'TagList', ], ], ], 'WhatsAppBusinessAccountEventDestination' => [ 'type' => 'structure', 'required' => [ 'eventDestinationArn', ], 'members' => [ 'eventDestinationArn' => [ 'shape' => 'EventDestinationArn', ], 'roleArn' => [ 'shape' => 'RoleArn', ], ], ], 'WhatsAppBusinessAccountEventDestinations' => [ 'type' => 'list', 'member' => [ 'shape' => 'WhatsAppBusinessAccountEventDestination', ], 'max' => 1, 'min' => 0, ], 'WhatsAppBusinessAccountId' => [ 'type' => 'string', 'max' => 100, 'min' => 1, ], 'WhatsAppBusinessAccountLinkDate' => [ 'type' => 'timestamp', ], 'WhatsAppBusinessAccountName' => [ 'type' => 'string', 'max' => 200, 'min' => 0, ], 'WhatsAppDisplayPhoneNumber' => [ 'type' => 'string', 'max' => 20, 'min' => 0, ], 'WhatsAppMediaId' => [ 'type' => 'string', 'max' => 100, 'min' => 1, 'pattern' => '[A-Za-z0-9]+', ], 'WhatsAppMessageBlob' => [ 'type' => 'blob', 'max' => 2048000, 'min' => 1, 'sensitive' => true, ], 'WhatsAppPhoneNumber' => [ 'type' => 'string', 'max' => 100, 'min' => 1, ], 'WhatsAppPhoneNumberDetail' => [ 'type' => 'structure', 'required' => [ 'arn', 'phoneNumber', 'phoneNumberId', 'metaPhoneNumberId', 'displayPhoneNumberName', 'displayPhoneNumber', 'qualityRating', ], 'members' => [ 'arn' => [ 'shape' => 'LinkedWhatsAppPhoneNumberArn', ], 'phoneNumber' => [ 'shape' => 'PhoneNumber', ], 'phoneNumberId' => [ 'shape' => 'WhatsAppPhoneNumberId', ], 'metaPhoneNumberId' => [ 'shape' => 'WhatsAppPhoneNumber', ], 'displayPhoneNumberName' => [ 'shape' => 'WhatsAppPhoneNumberName', ], 'displayPhoneNumber' => [ 'shape' => 'WhatsAppDisplayPhoneNumber', ], 'qualityRating' => [ 'shape' => 'WhatsAppPhoneNumberQualityRating', ], 'dataLocalizationRegion' => [ 'shape' => 'IsoCountryCode', ], ], ], 'WhatsAppPhoneNumberDetailList' => [ 'type' => 'list', 'member' => [ 'shape' => 'WhatsAppPhoneNumberDetail', ], ], 'WhatsAppPhoneNumberId' => [ 'type' => 'string', 'max' => 115, 'min' => 1, 'pattern' => '.*(^phone-number-id-.*$)|(^arn:.*:phone-number-id/[0-9a-zA-Z]+$).*', ], 'WhatsAppPhoneNumberName' => [ 'type' => 'string', 'max' => 200, 'min' => 0, ], 'WhatsAppPhoneNumberQualityRating' => [ 'type' => 'string', 'max' => 10, 'min' => 0, ], 'WhatsAppPhoneNumberSummary' => [ 'type' => 'structure', 'required' => [ 'arn', 'phoneNumber', 'phoneNumberId', 'metaPhoneNumberId', 'displayPhoneNumberName', 'displayPhoneNumber', 'qualityRating', ], 'members' => [ 'arn' => [ 'shape' => 'LinkedWhatsAppPhoneNumberArn', ], 'phoneNumber' => [ 'shape' => 'PhoneNumber', ], 'phoneNumberId' => [ 'shape' => 'WhatsAppPhoneNumberId', ], 'metaPhoneNumberId' => [ 'shape' => 'WhatsAppPhoneNumber', ], 'displayPhoneNumberName' => [ 'shape' => 'WhatsAppPhoneNumberName', ], 'displayPhoneNumber' => [ 'shape' => 'WhatsAppDisplayPhoneNumber', ], 'qualityRating' => [ 'shape' => 'WhatsAppPhoneNumberQualityRating', ], 'dataLocalizationRegion' => [ 'shape' => 'IsoCountryCode', ], ], ], 'WhatsAppPhoneNumberSummaryList' => [ 'type' => 'list', 'member' => [ 'shape' => 'WhatsAppPhoneNumberSummary', ], ], 'WhatsAppSetupFinalization' => [ 'type' => 'structure', 'required' => [ 'associateInProgressToken', 'phoneNumbers', ], 'members' => [ 'associateInProgressToken' => [ 'shape' => 'AssociateInProgressToken', ], 'phoneNumbers' => [ 'shape' => 'WabaPhoneNumberSetupFinalizationList', ], 'phoneNumberParent' => [ 'shape' => 'LinkedWhatsAppBusinessAccountId', ], 'waba' => [ 'shape' => 'WabaSetupFinalization', ], ], ], 'WhatsAppSignupCallback' => [ 'type' => 'structure', 'required' => [ 'accessToken', ], 'members' => [ 'accessToken' => [ 'shape' => 'WhatsAppSignupCallbackAccessTokenString', ], 'callbackUrl' => [ 'shape' => 'WhatsAppSignupCallbackCallbackUrlString', ], ], ], 'WhatsAppSignupCallbackAccessTokenString' => [ 'type' => 'string', 'max' => 1000, 'min' => 0, ], 'WhatsAppSignupCallbackCallbackUrlString' => [ 'type' => 'string', 'max' => 100, 'min' => 0, ], 'WhatsAppSignupCallbackResult' => [ 'type' => 'structure', 'members' => [ 'associateInProgressToken' => [ 'shape' => 'AssociateInProgressToken', ], 'linkedAccountsWithIncompleteSetup' => [ 'shape' => 'LinkedAccountWithIncompleteSetup', ], ], ], 'ZeroTapTermsAccepted' => [ 'type' => 'boolean', 'box' => true, ], ],];
