<?php
// This file was auto-generated from sdk-root/src/data/appmesh/2019-01-25/api-2.json
return [ 'version' => '2.0', 'metadata' => [ 'apiVersion' => '2019-01-25', 'endpointPrefix' => 'appmesh', 'jsonVersion' => '1.1', 'protocol' => 'rest-json', 'serviceFullName' => 'AWS App Mesh', 'serviceId' => 'App Mesh', 'signatureVersion' => 'v4', 'signingName' => 'appmesh', 'uid' => 'appmesh-2019-01-25', ], 'operations' => [ 'CreateMesh' => [ 'name' => 'CreateMesh', 'http' => [ 'method' => 'PUT', 'requestUri' => '/v20190125/meshes', 'responseCode' => 200, ], 'input' => [ 'shape' => 'CreateMeshInput', ], 'output' => [ 'shape' => 'CreateMeshOutput', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'LimitExceededException', ], [ 'shape' => 'NotFoundException', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'TooManyRequestsException', ], ], 'idempotent' => true, ], 'CreateRoute' => [ 'name' => 'CreateRoute', 'http' => [ 'method' => 'PUT', 'requestUri' => '/v20190125/meshes/{meshName}/virtualRouter/{virtualRouterName}/routes', 'responseCode' => 200, ], 'input' => [ 'shape' => 'CreateRouteInput', ], 'output' => [ 'shape' => 'CreateRouteOutput', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'LimitExceededException', ], [ 'shape' => 'NotFoundException', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'TooManyRequestsException', ], ], 'idempotent' => true, ], 'CreateVirtualNode' => [ 'name' => 'CreateVirtualNode', 'http' => [ 'method' => 'PUT', 'requestUri' => '/v20190125/meshes/{meshName}/virtualNodes', 'responseCode' => 200, ], 'input' => [ 'shape' => 'CreateVirtualNodeInput', ], 'output' => [ 'shape' => 'CreateVirtualNodeOutput', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'LimitExceededException', ], [ 'shape' => 'NotFoundException', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'TooManyRequestsException', ], ], 'idempotent' => true, ], 'CreateVirtualRouter' => [ 'name' => 'CreateVirtualRouter', 'http' => [ 'method' => 'PUT', 'requestUri' => '/v20190125/meshes/{meshName}/virtualRouters', 'responseCode' => 200, ], 'input' => [ 'shape' => 'CreateVirtualRouterInput', ], 'output' => [ 'shape' => 'CreateVirtualRouterOutput', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'LimitExceededException', ], [ 'shape' => 'NotFoundException', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'TooManyRequestsException', ], ], 'idempotent' => true, ], 'CreateVirtualService' => [ 'name' => 'CreateVirtualService', 'http' => [ 'method' => 'PUT', 'requestUri' => '/v20190125/meshes/{meshName}/virtualServices', 'responseCode' => 200, ], 'input' => [ 'shape' => 'CreateVirtualServiceInput', ], 'output' => [ 'shape' => 'CreateVirtualServiceOutput', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'LimitExceededException', ], [ 'shape' => 'NotFoundException', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'TooManyRequestsException', ], ], 'idempotent' => true, ], 'DeleteMesh' => [ 'name' => 'DeleteMesh', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/v20190125/meshes/{meshName}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DeleteMeshInput', ], 'output' => [ 'shape' => 'DeleteMeshOutput', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'NotFoundException', ], [ 'shape' => 'ResourceInUseException', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'TooManyRequestsException', ], ], 'idempotent' => true, ], 'DeleteRoute' => [ 'name' => 'DeleteRoute', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/v20190125/meshes/{meshName}/virtualRouter/{virtualRouterName}/routes/{routeName}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DeleteRouteInput', ], 'output' => [ 'shape' => 'DeleteRouteOutput', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'NotFoundException', ], [ 'shape' => 'ResourceInUseException', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'TooManyRequestsException', ], ], 'idempotent' => true, ], 'DeleteVirtualNode' => [ 'name' => 'DeleteVirtualNode', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/v20190125/meshes/{meshName}/virtualNodes/{virtualNodeName}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DeleteVirtualNodeInput', ], 'output' => [ 'shape' => 'DeleteVirtualNodeOutput', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'NotFoundException', ], [ 'shape' => 'ResourceInUseException', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'TooManyRequestsException', ], ], 'idempotent' => true, ], 'DeleteVirtualRouter' => [ 'name' => 'DeleteVirtualRouter', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/v20190125/meshes/{meshName}/virtualRouters/{virtualRouterName}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DeleteVirtualRouterInput', ], 'output' => [ 'shape' => 'DeleteVirtualRouterOutput', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'NotFoundException', ], [ 'shape' => 'ResourceInUseException', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'TooManyRequestsException', ], ], 'idempotent' => true, ], 'DeleteVirtualService' => [ 'name' => 'DeleteVirtualService', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/v20190125/meshes/{meshName}/virtualServices/{virtualServiceName}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DeleteVirtualServiceInput', ], 'output' => [ 'shape' => 'DeleteVirtualServiceOutput', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'NotFoundException', ], [ 'shape' => 'ResourceInUseException', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'TooManyRequestsException', ], ], 'idempotent' => true, ], 'DescribeMesh' => [ 'name' => 'DescribeMesh', 'http' => [ 'method' => 'GET', 'requestUri' => '/v20190125/meshes/{meshName}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DescribeMeshInput', ], 'output' => [ 'shape' => 'DescribeMeshOutput', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'NotFoundException', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'TooManyRequestsException', ], ], ], 'DescribeRoute' => [ 'name' => 'DescribeRoute', 'http' => [ 'method' => 'GET', 'requestUri' => '/v20190125/meshes/{meshName}/virtualRouter/{virtualRouterName}/routes/{routeName}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DescribeRouteInput', ], 'output' => [ 'shape' => 'DescribeRouteOutput', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'NotFoundException', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'TooManyRequestsException', ], ], ], 'DescribeVirtualNode' => [ 'name' => 'DescribeVirtualNode', 'http' => [ 'method' => 'GET', 'requestUri' => '/v20190125/meshes/{meshName}/virtualNodes/{virtualNodeName}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DescribeVirtualNodeInput', ], 'output' => [ 'shape' => 'DescribeVirtualNodeOutput', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'NotFoundException', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'TooManyRequestsException', ], ], ], 'DescribeVirtualRouter' => [ 'name' => 'DescribeVirtualRouter', 'http' => [ 'method' => 'GET', 'requestUri' => '/v20190125/meshes/{meshName}/virtualRouters/{virtualRouterName}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DescribeVirtualRouterInput', ], 'output' => [ 'shape' => 'DescribeVirtualRouterOutput', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'NotFoundException', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'TooManyRequestsException', ], ], ], 'DescribeVirtualService' => [ 'name' => 'DescribeVirtualService', 'http' => [ 'method' => 'GET', 'requestUri' => '/v20190125/meshes/{meshName}/virtualServices/{virtualServiceName}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DescribeVirtualServiceInput', ], 'output' => [ 'shape' => 'DescribeVirtualServiceOutput', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'NotFoundException', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'TooManyRequestsException', ], ], ], 'ListMeshes' => [ 'name' => 'ListMeshes', 'http' => [ 'method' => 'GET', 'requestUri' => '/v20190125/meshes', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListMeshesInput', ], 'output' => [ 'shape' => 'ListMeshesOutput', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'NotFoundException', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'TooManyRequestsException', ], ], ], 'ListRoutes' => [ 'name' => 'ListRoutes', 'http' => [ 'method' => 'GET', 'requestUri' => '/v20190125/meshes/{meshName}/virtualRouter/{virtualRouterName}/routes', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListRoutesInput', ], 'output' => [ 'shape' => 'ListRoutesOutput', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'NotFoundException', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'TooManyRequestsException', ], ], ], 'ListTagsForResource' => [ 'name' => 'ListTagsForResource', 'http' => [ 'method' => 'GET', 'requestUri' => '/v20190125/tags', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListTagsForResourceInput', ], 'output' => [ 'shape' => 'ListTagsForResourceOutput', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'NotFoundException', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'TooManyRequestsException', ], ], ], 'ListVirtualNodes' => [ 'name' => 'ListVirtualNodes', 'http' => [ 'method' => 'GET', 'requestUri' => '/v20190125/meshes/{meshName}/virtualNodes', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListVirtualNodesInput', ], 'output' => [ 'shape' => 'ListVirtualNodesOutput', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'NotFoundException', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'TooManyRequestsException', ], ], ], 'ListVirtualRouters' => [ 'name' => 'ListVirtualRouters', 'http' => [ 'method' => 'GET', 'requestUri' => '/v20190125/meshes/{meshName}/virtualRouters', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListVirtualRoutersInput', ], 'output' => [ 'shape' => 'ListVirtualRoutersOutput', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'NotFoundException', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'TooManyRequestsException', ], ], ], 'ListVirtualServices' => [ 'name' => 'ListVirtualServices', 'http' => [ 'method' => 'GET', 'requestUri' => '/v20190125/meshes/{meshName}/virtualServices', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListVirtualServicesInput', ], 'output' => [ 'shape' => 'ListVirtualServicesOutput', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'NotFoundException', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'TooManyRequestsException', ], ], ], 'TagResource' => [ 'name' => 'TagResource', 'http' => [ 'method' => 'PUT', 'requestUri' => '/v20190125/tag', 'responseCode' => 200, ], 'input' => [ 'shape' => 'TagResourceInput', ], 'output' => [ 'shape' => 'TagResourceOutput', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'NotFoundException', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'TooManyRequestsException', ], [ 'shape' => 'TooManyTagsException', ], ], 'idempotent' => true, ], 'UntagResource' => [ 'name' => 'UntagResource', 'http' => [ 'method' => 'PUT', 'requestUri' => '/v20190125/untag', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UntagResourceInput', ], 'output' => [ 'shape' => 'UntagResourceOutput', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'NotFoundException', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'TooManyRequestsException', ], ], 'idempotent' => true, ], 'UpdateMesh' => [ 'name' => 'UpdateMesh', 'http' => [ 'method' => 'PUT', 'requestUri' => '/v20190125/meshes/{meshName}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateMeshInput', ], 'output' => [ 'shape' => 'UpdateMeshOutput', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'NotFoundException', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'TooManyRequestsException', ], ], 'idempotent' => true, ], 'UpdateRoute' => [ 'name' => 'UpdateRoute', 'http' => [ 'method' => 'PUT', 'requestUri' => '/v20190125/meshes/{meshName}/virtualRouter/{virtualRouterName}/routes/{routeName}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateRouteInput', ], 'output' => [ 'shape' => 'UpdateRouteOutput', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'LimitExceededException', ], [ 'shape' => 'NotFoundException', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'TooManyRequestsException', ], ], 'idempotent' => true, ], 'UpdateVirtualNode' => [ 'name' => 'UpdateVirtualNode', 'http' => [ 'method' => 'PUT', 'requestUri' => '/v20190125/meshes/{meshName}/virtualNodes/{virtualNodeName}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateVirtualNodeInput', ], 'output' => [ 'shape' => 'UpdateVirtualNodeOutput', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'LimitExceededException', ], [ 'shape' => 'NotFoundException', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'TooManyRequestsException', ], ], 'idempotent' => true, ], 'UpdateVirtualRouter' => [ 'name' => 'UpdateVirtualRouter', 'http' => [ 'method' => 'PUT', 'requestUri' => '/v20190125/meshes/{meshName}/virtualRouters/{virtualRouterName}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateVirtualRouterInput', ], 'output' => [ 'shape' => 'UpdateVirtualRouterOutput', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'LimitExceededException', ], [ 'shape' => 'NotFoundException', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'TooManyRequestsException', ], ], 'idempotent' => true, ], 'UpdateVirtualService' => [ 'name' => 'UpdateVirtualService', 'http' => [ 'method' => 'PUT', 'requestUri' => '/v20190125/meshes/{meshName}/virtualServices/{virtualServiceName}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateVirtualServiceInput', ], 'output' => [ 'shape' => 'UpdateVirtualServiceOutput', ], 'errors' => [ [ 'shape' => 'BadRequestException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ForbiddenException', ], [ 'shape' => 'InternalServerErrorException', ], [ 'shape' => 'LimitExceededException', ], [ 'shape' => 'NotFoundException', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'TooManyRequestsException', ], ], 'idempotent' => true, ], ], 'shapes' => [ 'VirtualRouterListener' => [ 'type' => 'structure', 'required' => [ 'portMapping', ], 'members' => [ 'portMapping' => [ 'shape' => 'PortMapping', ], ], ], 'VirtualRouterStatusCode' => [ 'type' => 'string', 'enum' => [ 'ACTIVE', 'DELETED', 'INACTIVE', ], ], 'TagKeyList' => [ 'type' => 'list', 'member' => [ 'shape' => 'TagKey', ], 'min' => 0, 'max' => 50, ], 'GrpcRetryPolicy' => [ 'type' => 'structure', 'required' => [ 'maxRetries', 'perRetryTimeout', ], 'members' => [ 'grpcRetryEvents' => [ 'shape' => 'GrpcRetryPolicyEvents', ], 'httpRetryEvents' => [ 'shape' => 'HttpRetryPolicyEvents', ], 'maxRetries' => [ 'shape' => 'MaxRetries', ], 'perRetryTimeout' => [ 'shape' => 'Duration', ], 'tcpRetryEvents' => [ 'shape' => 'TcpRetryPolicyEvents', ], ], ], 'CreateVirtualNodeOutput' => [ 'type' => 'structure', 'required' => [ 'virtualNode', ], 'members' => [ 'virtualNode' => [ 'shape' => 'VirtualNodeData', ], ], 'payload' => 'virtualNode', ], 'Logging' => [ 'type' => 'structure', 'members' => [ 'accessLog' => [ 'shape' => 'AccessLog', ], ], ], 'Long' => [ 'type' => 'long', 'box' => true, ], 'UpdateVirtualRouterOutput' => [ 'type' => 'structure', 'required' => [ 'virtualRouter', ], 'members' => [ 'virtualRouter' => [ 'shape' => 'VirtualRouterData', ], ], 'payload' => 'virtualRouter', ], 'ListVirtualRoutersOutput' => [ 'type' => 'structure', 'required' => [ 'virtualRouters', ], 'members' => [ 'nextToken' => [ 'shape' => 'String', ], 'virtualRouters' => [ 'shape' => 'VirtualRouterList', ], ], ], 'ResourceMetadata' => [ 'type' => 'structure', 'required' => [ 'arn', 'createdAt', 'lastUpdatedAt', 'meshOwner', 'resourceOwner', 'uid', 'version', ], 'members' => [ 'arn' => [ 'shape' => 'Arn', ], 'createdAt' => [ 'shape' => 'Timestamp', ], 'lastUpdatedAt' => [ 'shape' => 'Timestamp', ], 'meshOwner' => [ 'shape' => 'AccountId', ], 'resourceOwner' => [ 'shape' => 'AccountId', ], 'uid' => [ 'shape' => 'String', ], 'version' => [ 'shape' => 'Long', ], ], ], 'ResourceInUseException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'String', ], ], 'exception' => true, 'error' => [ 'code' => 'ResourceInUseException', 'httpStatusCode' => 409, 'senderFault' => true, ], ], 'UpdateVirtualNodeOutput' => [ 'type' => 'structure', 'required' => [ 'virtualNode', ], 'members' => [ 'virtualNode' => [ 'shape' => 'VirtualNodeData', ], ], 'payload' => 'virtualNode', ], 'ListRoutesOutput' => [ 'type' => 'structure', 'required' => [ 'routes', ], 'members' => [ 'nextToken' => [ 'shape' => 'String', ], 'routes' => [ 'shape' => 'RouteList', ], ], ], 'VirtualServiceBackend' => [ 'type' => 'structure', 'required' => [ 'virtualServiceName', ], 'members' => [ 'clientPolicy' => [ 'shape' => 'ClientPolicy', ], 'virtualServiceName' => [ 'shape' => 'ServiceName', ], ], ], 'BadRequestException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'String', ], ], 'exception' => true, 'error' => [ 'code' => 'BadRequestException', 'httpStatusCode' => 400, 'senderFault' => true, ], ], 'GrpcRouteMetadataList' => [ 'type' => 'list', 'member' => [ 'shape' => 'GrpcRouteMetadata', ], 'min' => 1, 'max' => 10, ], 'ListenerTlsMode' => [ 'type' => 'string', 'enum' => [ 'DISABLED', 'PERMISSIVE', 'STRICT', ], ], 'HealthCheckPolicy' => [ 'type' => 'structure', 'required' => [ 'healthyThreshold', 'intervalMillis', 'protocol', 'timeoutMillis', 'unhealthyThreshold', ], 'members' => [ 'healthyThreshold' => [ 'shape' => 'HealthCheckThreshold', ], 'intervalMillis' => [ 'shape' => 'HealthCheckIntervalMillis', ], 'path' => [ 'shape' => 'String', ], 'port' => [ 'shape' => 'PortNumber', ], 'protocol' => [ 'shape' => 'PortProtocol', ], 'timeoutMillis' => [ 'shape' => 'HealthCheckTimeoutMillis', ], 'unhealthyThreshold' => [ 'shape' => 'HealthCheckThreshold', ], ], ], 'EgressFilter' => [ 'type' => 'structure', 'required' => [ 'type', ], 'members' => [ 'type' => [ 'shape' => 'EgressFilterType', ], ], ], 'VirtualServiceList' => [ 'type' => 'list', 'member' => [ 'shape' => 'VirtualServiceRef', ], ], 'ClientPolicy' => [ 'type' => 'structure', 'members' => [ 'tls' => [ 'shape' => 'ClientPolicyTls', ], ], ], 'Boolean' => [ 'type' => 'boolean', 'box' => true, ], 'HttpRetryPolicyEvent' => [ 'type' => 'string', 'min' => 1, 'max' => 25, ], 'DescribeVirtualServiceOutput' => [ 'type' => 'structure', 'required' => [ 'virtualService', ], 'members' => [ 'virtualService' => [ 'shape' => 'VirtualServiceData', ], ], 'payload' => 'virtualService', ], 'CertificateAuthorityArns' => [ 'type' => 'list', 'member' => [ 'shape' => 'Arn', ], 'min' => 1, 'max' => 3, ], 'DescribeVirtualNodeOutput' => [ 'type' => 'structure', 'required' => [ 'virtualNode', ], 'members' => [ 'virtualNode' => [ 'shape' => 'VirtualNodeData', ], ], 'payload' => 'virtualNode', ], 'AwsCloudMapName' => [ 'type' => 'string', 'min' => 1, 'max' => 1024, 'pattern' => '((?=^.{1,127}$)^([a-zA-Z0-9_][a-zA-Z0-9-_]{0,61}[a-zA-Z0-9_]|[a-zA-Z0-9])(.([a-zA-Z0-9_][a-zA-Z0-9-_]{0,61}[a-zA-Z0-9_]|[a-zA-Z0-9]))*$)|(^.$)', ], 'CreateRouteOutput' => [ 'type' => 'structure', 'required' => [ 'route', ], 'members' => [ 'route' => [ 'shape' => 'RouteData', ], ], 'payload' => 'route', ], 'DnsServiceDiscovery' => [ 'type' => 'structure', 'required' => [ 'hostname', ], 'members' => [ 'hostname' => [ 'shape' => 'Hostname', ], ], ], 'DeleteRouteInput' => [ 'type' => 'structure', 'required' => [ 'meshName', 'routeName', 'virtualRouterName', ], 'members' => [ 'meshName' => [ 'shape' => 'ResourceName', 'location' => 'uri', 'locationName' => 'meshName', ], 'meshOwner' => [ 'shape' => 'AccountId', 'location' => 'querystring', 'locationName' => 'meshOwner', ], 'routeName' => [ 'shape' => 'ResourceName', 'location' => 'uri', 'locationName' => 'routeName', ], 'virtualRouterName' => [ 'shape' => 'ResourceName', 'location' => 'uri', 'locationName' => 'virtualRouterName', ], ], ], 'VirtualNodeData' => [ 'type' => 'structure', 'required' => [ 'meshName', 'metadata', 'spec', 'status', 'virtualNodeName', ], 'members' => [ 'meshName' => [ 'shape' => 'ResourceName', ], 'metadata' => [ 'shape' => 'ResourceMetadata', ], 'spec' => [ 'shape' => 'VirtualNodeSpec', ], 'status' => [ 'shape' => 'VirtualNodeStatus', ], 'virtualNodeName' => [ 'shape' => 'ResourceName', ], ], ], 'UntagResourceOutput' => [ 'type' => 'structure', 'members' => [], ], 'TcpRetryPolicyEvent' => [ 'type' => 'string', 'enum' => [ 'connection-error', ], ], 'Backend' => [ 'type' => 'structure', 'members' => [ 'virtualService' => [ 'shape' => 'VirtualServiceBackend', ], ], ], 'ListMeshesInput' => [ 'type' => 'structure', 'members' => [ 'limit' => [ 'shape' => 'ListMeshesLimit', 'location' => 'querystring', 'locationName' => 'limit', ], 'nextToken' => [ 'shape' => 'String', 'location' => 'querystring', 'locationName' => 'nextToken', ], ], ], 'VirtualRouterData' => [ 'type' => 'structure', 'required' => [ 'meshName', 'metadata', 'spec', 'status', 'virtualRouterName', ], 'members' => [ 'meshName' => [ 'shape' => 'ResourceName', ], 'metadata' => [ 'shape' => 'ResourceMetadata', ], 'spec' => [ 'shape' => 'VirtualRouterSpec', ], 'status' => [ 'shape' => 'VirtualRouterStatus', ], 'virtualRouterName' => [ 'shape' => 'ResourceName', ], ], ], 'UpdateMeshInput' => [ 'type' => 'structure', 'required' => [ 'meshName', ], 'members' => [ 'clientToken' => [ 'shape' => 'String', 'idempotencyToken' => true, ], 'meshName' => [ 'shape' => 'ResourceName', 'location' => 'uri', 'locationName' => 'meshName', ], 'spec' => [ 'shape' => 'MeshSpec', ], ], ], 'CreateVirtualRouterInput' => [ 'type' => 'structure', 'required' => [ 'meshName', 'spec', 'virtualRouterName', ], 'members' => [ 'clientToken' => [ 'shape' => 'String', 'idempotencyToken' => true, ], 'meshName' => [ 'shape' => 'ResourceName', 'location' => 'uri', 'locationName' => 'meshName', ], 'meshOwner' => [ 'shape' => 'AccountId', 'location' => 'querystring', 'locationName' => 'meshOwner', ], 'spec' => [ 'shape' => 'VirtualRouterSpec', ], 'tags' => [ 'shape' => 'TagList', 'tags' => [ 'not-preview', ], ], 'virtualRouterName' => [ 'shape' => 'ResourceName', ], ], ], 'DescribeVirtualRouterOutput' => [ 'type' => 'structure', 'required' => [ 'virtualRouter', ], 'members' => [ 'virtualRouter' => [ 'shape' => 'VirtualRouterData', ], ], 'payload' => 'virtualRouter', ], 'CreateMeshOutput' => [ 'type' => 'structure', 'required' => [ 'mesh', ], 'members' => [ 'mesh' => [ 'shape' => 'MeshData', ], ], 'payload' => 'mesh', ], 'CreateVirtualRouterOutput' => [ 'type' => 'structure', 'required' => [ 'virtualRouter', ], 'members' => [ 'virtualRouter' => [ 'shape' => 'VirtualRouterData', ], ], 'payload' => 'virtualRouter', ], 'VirtualServiceStatus' => [ 'type' => 'structure', 'required' => [ 'status', ], 'members' => [ 'status' => [ 'shape' => 'VirtualServiceStatusCode', ], ], ], 'HttpRetryPolicyEvents' => [ 'type' => 'list', 'member' => [ 'shape' => 'HttpRetryPolicyEvent', ], 'min' => 1, 'max' => 25, ], 'ListenerTlsCertificate' => [ 'type' => 'structure', 'members' => [ 'acm' => [ 'shape' => 'ListenerTlsAcmCertificate', ], 'file' => [ 'shape' => 'ListenerTlsFileCertificate', ], ], ], 'ListMeshesLimit' => [ 'type' => 'integer', 'box' => true, 'min' => 1, 'max' => 100, ], 'AwsCloudMapInstanceAttributeKey' => [ 'type' => 'string', 'min' => 1, 'max' => 255, 'pattern' => '^[a-zA-Z0-9!-~]+$', ], 'VirtualRouterSpec' => [ 'type' => 'structure', 'members' => [ 'listeners' => [ 'shape' => 'VirtualRouterListeners', ], ], ], 'VirtualNodeSpec' => [ 'type' => 'structure', 'members' => [ 'backendDefaults' => [ 'shape' => 'BackendDefaults', ], 'backends' => [ 'shape' => 'Backends', ], 'listeners' => [ 'shape' => 'Listeners', ], 'logging' => [ 'shape' => 'Logging', ], 'serviceDiscovery' => [ 'shape' => 'ServiceDiscovery', ], ], ], 'ListMeshesOutput' => [ 'type' => 'structure', 'required' => [ 'meshes', ], 'members' => [ 'meshes' => [ 'shape' => 'MeshList', ], 'nextToken' => [ 'shape' => 'String', ], ], ], 'VirtualRouterListeners' => [ 'type' => 'list', 'member' => [ 'shape' => 'VirtualRouterListener', ], 'min' => 1, 'max' => 1, ], 'PortSet' => [ 'type' => 'list', 'member' => [ 'shape' => 'PortNumber', ], ], 'HttpMethod' => [ 'type' => 'string', 'enum' => [ 'CONNECT', 'DELETE', 'GET', 'HEAD', 'OPTIONS', 'PATCH', 'POST', 'PUT', 'TRACE', ], ], 'ConflictException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'String', ], ], 'exception' => true, 'error' => [ 'code' => 'ConflictException', 'httpStatusCode' => 409, 'senderFault' => true, ], ], 'MeshList' => [ 'type' => 'list', 'member' => [ 'shape' => 'MeshRef', ], ], 'MaxRetries' => [ 'type' => 'long', 'box' => true, 'min' => 0, ], 'TlsValidationContextTrust' => [ 'type' => 'structure', 'members' => [ 'acm' => [ 'shape' => 'TlsValidationContextAcmTrust', ], 'file' => [ 'shape' => 'TlsValidationContextFileTrust', ], ], ], 'PortMapping' => [ 'type' => 'structure', 'required' => [ 'port', 'protocol', ], 'members' => [ 'port' => [ 'shape' => 'PortNumber', ], 'protocol' => [ 'shape' => 'PortProtocol', ], ], ], 'ListVirtualServicesOutput' => [ 'type' => 'structure', 'required' => [ 'virtualServices', ], 'members' => [ 'nextToken' => [ 'shape' => 'String', ], 'virtualServices' => [ 'shape' => 'VirtualServiceList', ], ], ], 'AwsCloudMapInstanceAttributeValue' => [ 'type' => 'string', 'min' => 1, 'max' => 1024, 'pattern' => '^([a-zA-Z0-9!-~][ ta-zA-Z0-9!-~]*){0,1}[a-zA-Z0-9!-~]{0,1}$', ], 'WeightedTarget' => [ 'type' => 'structure', 'required' => [ 'virtualNode', 'weight', ], 'members' => [ 'virtualNode' => [ 'shape' => 'ResourceName', ], 'weight' => [ 'shape' => 'PercentInt', ], ], ], 'RouteRef' => [ 'type' => 'structure', 'required' => [ 'arn', 'createdAt', 'lastUpdatedAt', 'meshName', 'meshOwner', 'resourceOwner', 'routeName', 'version', 'virtualRouterName', ], 'members' => [ 'arn' => [ 'shape' => 'Arn', ], 'createdAt' => [ 'shape' => 'Timestamp', ], 'lastUpdatedAt' => [ 'shape' => 'Timestamp', ], 'meshName' => [ 'shape' => 'ResourceName', ], 'meshOwner' => [ 'shape' => 'AccountId', ], 'resourceOwner' => [ 'shape' => 'AccountId', ], 'routeName' => [ 'shape' => 'ResourceName', ], 'version' => [ 'shape' => 'Long', ], 'virtualRouterName' => [ 'shape' => 'ResourceName', ], ], ], 'DeleteVirtualNodeInput' => [ 'type' => 'structure', 'required' => [ 'meshName', 'virtualNodeName', ], 'members' => [ 'meshName' => [ 'shape' => 'ResourceName', 'location' => 'uri', 'locationName' => 'meshName', ], 'meshOwner' => [ 'shape' => 'AccountId', 'location' => 'querystring', 'locationName' => 'meshOwner', ], 'virtualNodeName' => [ 'shape' => 'ResourceName', 'location' => 'uri', 'locationName' => 'virtualNodeName', ], ], ], 'RouteData' => [ 'type' => 'structure', 'required' => [ 'meshName', 'metadata', 'routeName', 'spec', 'status', 'virtualRouterName', ], 'members' => [ 'meshName' => [ 'shape' => 'ResourceName', ], 'metadata' => [ 'shape' => 'ResourceMetadata', ], 'routeName' => [ 'shape' => 'ResourceName', ], 'spec' => [ 'shape' => 'RouteSpec', ], 'status' => [ 'shape' => 'RouteStatus', ], 'virtualRouterName' => [ 'shape' => 'ResourceName', ], ], ], 'RouteStatusCode' => [ 'type' => 'string', 'enum' => [ 'ACTIVE', 'DELETED', 'INACTIVE', ], ], 'InternalServerErrorException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'String', ], ], 'exception' => true, 'error' => [ 'code' => 'InternalServerErrorException', 'httpStatusCode' => 500, 'fault' => true, ], ], 'HeaderName' => [ 'type' => 'string', 'min' => 1, 'max' => 50, ], 'TagList' => [ 'type' => 'list', 'member' => [ 'shape' => 'TagRef', ], 'min' => 0, 'max' => 50, ], 'GrpcRetryPolicyEvent' => [ 'type' => 'string', 'enum' => [ 'cancelled', 'deadline-exceeded', 'internal', 'resource-exhausted', 'unavailable', ], ], 'TlsValidationContextAcmTrust' => [ 'type' => 'structure', 'required' => [ 'certificateAuthorityArns', ], 'members' => [ 'certificateAuthorityArns' => [ 'shape' => 'CertificateAuthorityArns', ], ], ], 'ForbiddenException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'String', ], ], 'exception' => true, 'error' => [ 'code' => 'ForbiddenException', 'httpStatusCode' => 403, 'senderFault' => true, ], ], 'HeaderMatchMethod' => [ 'type' => 'structure', 'members' => [ 'exact' => [ 'shape' => 'HeaderMatch', ], 'prefix' => [ 'shape' => 'HeaderMatch', ], 'range' => [ 'shape' => 'MatchRange', ], 'regex' => [ 'shape' => 'HeaderMatch', ], 'suffix' => [ 'shape' => 'HeaderMatch', ], ], ], 'DeleteMeshOutput' => [ 'type' => 'structure', 'required' => [ 'mesh', ], 'members' => [ 'mesh' => [ 'shape' => 'MeshData', ], ], 'payload' => 'mesh', ], 'EgressFilterType' => [ 'type' => 'string', 'enum' => [ 'ALLOW_ALL', 'DROP_ALL', ], ], 'DurationValue' => [ 'type' => 'long', 'box' => true, 'min' => 0, ], 'Hostname' => [ 'type' => 'string', ], 'TagResourceInput' => [ 'type' => 'structure', 'required' => [ 'resourceArn', 'tags', ], 'members' => [ 'resourceArn' => [ 'shape' => 'Arn', 'location' => 'querystring', 'locationName' => 'resourceArn', ], 'tags' => [ 'shape' => 'TagList', ], ], ], 'VirtualServiceProvider' => [ 'type' => 'structure', 'members' => [ 'virtualNode' => [ 'shape' => 'VirtualNodeServiceProvider', ], 'virtualRouter' => [ 'shape' => 'VirtualRouterServiceProvider', ], ], ], 'GrpcRouteMatch' => [ 'type' => 'structure', 'members' => [ 'metadata' => [ 'shape' => 'GrpcRouteMetadataList', ], 'methodName' => [ 'shape' => 'MethodName', ], 'serviceName' => [ 'shape' => 'ServiceName', ], ], ], 'AwsCloudMapServiceDiscovery' => [ 'type' => 'structure', 'required' => [ 'namespaceName', 'serviceName', ], 'members' => [ 'attributes' => [ 'shape' => 'AwsCloudMapInstanceAttributes', ], 'namespaceName' => [ 'shape' => 'AwsCloudMapName', ], 'serviceName' => [ 'shape' => 'AwsCloudMapName', ], ], ], 'UpdateVirtualServiceOutput' => [ 'type' => 'structure', 'required' => [ 'virtualService', ], 'members' => [ 'virtualService' => [ 'shape' => 'VirtualServiceData', ], ], 'payload' => 'virtualService', ], 'MeshStatus' => [ 'type' => 'structure', 'members' => [ 'status' => [ 'shape' => 'MeshStatusCode', ], ], ], 'CreateVirtualNodeInput' => [ 'type' => 'structure', 'required' => [ 'meshName', 'spec', 'virtualNodeName', ], 'members' => [ 'clientToken' => [ 'shape' => 'String', 'idempotencyToken' => true, ], 'meshName' => [ 'shape' => 'ResourceName', 'location' => 'uri', 'locationName' => 'meshName', ], 'meshOwner' => [ 'shape' => 'AccountId', 'location' => 'querystring', 'locationName' => 'meshOwner', ], 'spec' => [ 'shape' => 'VirtualNodeSpec', ], 'tags' => [ 'shape' => 'TagList', 'tags' => [ 'not-preview', ], ], 'virtualNodeName' => [ 'shape' => 'ResourceName', ], ], ], 'NotFoundException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'String', ], ], 'exception' => true, 'error' => [ 'code' => 'NotFoundException', 'httpStatusCode' => 404, 'senderFault' => true, ], ], 'RouteSpec' => [ 'type' => 'structure', 'members' => [ 'grpcRoute' => [ 'shape' => 'GrpcRoute', ], 'http2Route' => [ 'shape' => 'HttpRoute', ], 'httpRoute' => [ 'shape' => 'HttpRoute', ], 'priority' => [ 'shape' => 'RoutePriority', ], 'tcpRoute' => [ 'shape' => 'TcpRoute', ], ], ], 'CreateVirtualServiceOutput' => [ 'type' => 'structure', 'required' => [ 'virtualService', ], 'members' => [ 'virtualService' => [ 'shape' => 'VirtualServiceData', ], ], 'payload' => 'virtualService', ], 'FileAccessLog' => [ 'type' => 'structure', 'required' => [ 'path', ], 'members' => [ 'path' => [ 'shape' => 'FilePath', ], ], ], 'VirtualRouterServiceProvider' => [ 'type' => 'structure', 'required' => [ 'virtualRouterName', ], 'members' => [ 'virtualRouterName' => [ 'shape' => 'ResourceName', ], ], ], 'DeleteVirtualServiceInput' => [ 'type' => 'structure', 'required' => [ 'meshName', 'virtualServiceName', ], 'members' => [ 'meshName' => [ 'shape' => 'ResourceName', 'location' => 'uri', 'locationName' => 'meshName', ], 'meshOwner' => [ 'shape' => 'AccountId', 'location' => 'querystring', 'locationName' => 'meshOwner', ], 'virtualServiceName' => [ 'shape' => 'ServiceName', 'location' => 'uri', 'locationName' => 'virtualServiceName', ], ], ], 'TlsValidationContext' => [ 'type' => 'structure', 'required' => [ 'trust', ], 'members' => [ 'trust' => [ 'shape' => 'TlsValidationContextTrust', ], ], ], 'DeleteVirtualRouterOutput' => [ 'type' => 'structure', 'required' => [ 'virtualRouter', ], 'members' => [ 'virtualRouter' => [ 'shape' => 'VirtualRouterData', ], ], 'payload' => 'virtualRouter', ], 'TagsLimit' => [ 'type' => 'integer', 'box' => true, 'min' => 1, 'max' => 50, ], 'DeleteVirtualNodeOutput' => [ 'type' => 'structure', 'required' => [ 'virtualNode', ], 'members' => [ 'virtualNode' => [ 'shape' => 'VirtualNodeData', ], ], 'payload' => 'virtualNode', ], 'UpdateVirtualNodeInput' => [ 'type' => 'structure', 'required' => [ 'meshName', 'spec', 'virtualNodeName', ], 'members' => [ 'clientToken' => [ 'shape' => 'String', 'idempotencyToken' => true, ], 'meshName' => [ 'shape' => 'ResourceName', 'location' => 'uri', 'locationName' => 'meshName', ], 'meshOwner' => [ 'shape' => 'AccountId', 'location' => 'querystring', 'locationName' => 'meshOwner', ], 'spec' => [ 'shape' => 'VirtualNodeSpec', ], 'virtualNodeName' => [ 'shape' => 'ResourceName', 'location' => 'uri', 'locationName' => 'virtualNodeName', ], ], ], 'ListenerTls' => [ 'type' => 'structure', 'required' => [ 'certificate', 'mode', ], 'members' => [ 'certificate' => [ 'shape' => 'ListenerTlsCertificate', ], 'mode' => [ 'shape' => 'ListenerTlsMode', ], ], ], 'DeleteMeshInput' => [ 'type' => 'structure', 'required' => [ 'meshName', ], 'members' => [ 'meshName' => [ 'shape' => 'ResourceName', 'location' => 'uri', 'locationName' => 'meshName', ], ], ], 'TcpRetryPolicyEvents' => [ 'type' => 'list', 'member' => [ 'shape' => 'TcpRetryPolicyEvent', ], 'min' => 1, 'max' => 1, ], 'CreateVirtualServiceInput' => [ 'type' => 'structure', 'required' => [ 'meshName', 'spec', 'virtualServiceName', ], 'members' => [ 'clientToken' => [ 'shape' => 'String', 'idempotencyToken' => true, ], 'meshName' => [ 'shape' => 'ResourceName', 'location' => 'uri', 'locationName' => 'meshName', ], 'meshOwner' => [ 'shape' => 'AccountId', 'location' => 'querystring', 'locationName' => 'meshOwner', ], 'spec' => [ 'shape' => 'VirtualServiceSpec', ], 'tags' => [ 'shape' => 'TagList', 'tags' => [ 'not-preview', ], ], 'virtualServiceName' => [ 'shape' => 'ServiceName', ], ], ], 'UpdateVirtualRouterInput' => [ 'type' => 'structure', 'required' => [ 'meshName', 'spec', 'virtualRouterName', ], 'members' => [ 'clientToken' => [ 'shape' => 'String', 'idempotencyToken' => true, ], 'meshName' => [ 'shape' => 'ResourceName', 'location' => 'uri', 'locationName' => 'meshName', ], 'meshOwner' => [ 'shape' => 'AccountId', 'location' => 'querystring', 'locationName' => 'meshOwner', ], 'spec' => [ 'shape' => 'VirtualRouterSpec', ], 'virtualRouterName' => [ 'shape' => 'ResourceName', 'location' => 'uri', 'locationName' => 'virtualRouterName', ], ], ], 'ListTagsForResourceInput' => [ 'type' => 'structure', 'required' => [ 'resourceArn', ], 'members' => [ 'limit' => [ 'shape' => 'TagsLimit', 'location' => 'querystring', 'locationName' => 'limit', ], 'nextToken' => [ 'shape' => 'String', 'location' => 'querystring', 'locationName' => 'nextToken', ], 'resourceArn' => [ 'shape' => 'Arn', 'location' => 'querystring', 'locationName' => 'resourceArn', ], ], ], 'GrpcRetryPolicyEvents' => [ 'type' => 'list', 'member' => [ 'shape' => 'GrpcRetryPolicyEvent', ], 'min' => 1, 'max' => 5, ], 'ServiceUnavailableException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'String', ], ], 'exception' => true, 'error' => [ 'code' => 'ServiceUnavailableException', 'httpStatusCode' => 503, 'fault' => true, ], ], 'DescribeMeshOutput' => [ 'type' => 'structure', 'required' => [ 'mesh', ], 'members' => [ 'mesh' => [ 'shape' => 'MeshData', ], ], 'payload' => 'mesh', ], 'DeleteVirtualRouterInput' => [ 'type' => 'structure', 'required' => [ 'meshName', 'virtualRouterName', ], 'members' => [ 'meshName' => [ 'shape' => 'ResourceName', 'location' => 'uri', 'locationName' => 'meshName', ], 'meshOwner' => [ 'shape' => 'AccountId', 'location' => 'querystring', 'locationName' => 'meshOwner', ], 'virtualRouterName' => [ 'shape' => 'ResourceName', 'location' => 'uri', 'locationName' => 'virtualRouterName', ], ], ], 'DescribeRouteInput' => [ 'type' => 'structure', 'required' => [ 'meshName', 'routeName', 'virtualRouterName', ], 'members' => [ 'meshName' => [ 'shape' => 'ResourceName', 'location' => 'uri', 'locationName' => 'meshName', ], 'meshOwner' => [ 'shape' => 'AccountId', 'location' => 'querystring', 'locationName' => 'meshOwner', ], 'routeName' => [ 'shape' => 'ResourceName', 'location' => 'uri', 'locationName' => 'routeName', ], 'virtualRouterName' => [ 'shape' => 'ResourceName', 'location' => 'uri', 'locationName' => 'virtualRouterName', ], ], ], 'DeleteRouteOutput' => [ 'type' => 'structure', 'required' => [ 'route', ], 'members' => [ 'route' => [ 'shape' => 'RouteData', ], ], 'payload' => 'route', ], 'Listeners' => [ 'type' => 'list', 'member' => [ 'shape' => 'Listener', ], 'min' => 0, 'max' => 1, ], 'Backends' => [ 'type' => 'list', 'member' => [ 'shape' => 'Backend', ], ], 'PortProtocol' => [ 'type' => 'string', 'enum' => [ 'grpc', 'http', 'http2', 'tcp', ], ], 'VirtualNodeStatusCode' => [ 'type' => 'string', 'enum' => [ 'ACTIVE', 'DELETED', 'INACTIVE', ], ], 'ServiceName' => [ 'type' => 'string', ], 'UpdateVirtualServiceInput' => [ 'type' => 'structure', 'required' => [ 'meshName', 'spec', 'virtualServiceName', ], 'members' => [ 'clientToken' => [ 'shape' => 'String', 'idempotencyToken' => true, ], 'meshName' => [ 'shape' => 'ResourceName', 'location' => 'uri', 'locationName' => 'meshName', ], 'meshOwner' => [ 'shape' => 'AccountId', 'location' => 'querystring', 'locationName' => 'meshOwner', ], 'spec' => [ 'shape' => 'VirtualServiceSpec', ], 'virtualServiceName' => [ 'shape' => 'ServiceName', 'location' => 'uri', 'locationName' => 'virtualServiceName', ], ], ], 'HealthCheckThreshold' => [ 'type' => 'integer', 'min' => 2, 'max' => 10, ], 'UpdateRouteOutput' => [ 'type' => 'structure', 'required' => [ 'route', ], 'members' => [ 'route' => [ 'shape' => 'RouteData', ], ], 'payload' => 'route', ], 'PercentInt' => [ 'type' => 'integer', 'min' => 0, 'max' => 100, ], 'MethodName' => [ 'type' => 'string', 'min' => 1, 'max' => 50, ], 'TagValue' => [ 'type' => 'string', 'min' => 0, 'max' => 256, ], 'HttpRouteAction' => [ 'type' => 'structure', 'required' => [ 'weightedTargets', ], 'members' => [ 'weightedTargets' => [ 'shape' => 'WeightedTargets', ], ], ], 'ListRoutesInput' => [ 'type' => 'structure', 'required' => [ 'meshName', 'virtualRouterName', ], 'members' => [ 'limit' => [ 'shape' => 'ListRoutesLimit', 'location' => 'querystring', 'locationName' => 'limit', ], 'meshName' => [ 'shape' => 'ResourceName', 'location' => 'uri', 'locationName' => 'meshName', ], 'meshOwner' => [ 'shape' => 'AccountId', 'location' => 'querystring', 'locationName' => 'meshOwner', ], 'nextToken' => [ 'shape' => 'String', 'location' => 'querystring', 'locationName' => 'nextToken', ], 'virtualRouterName' => [ 'shape' => 'ResourceName', 'location' => 'uri', 'locationName' => 'virtualRouterName', ], ], ], 'VirtualServiceRef' => [ 'type' => 'structure', 'required' => [ 'arn', 'createdAt', 'lastUpdatedAt', 'meshName', 'meshOwner', 'resourceOwner', 'version', 'virtualServiceName', ], 'members' => [ 'arn' => [ 'shape' => 'Arn', ], 'createdAt' => [ 'shape' => 'Timestamp', ], 'lastUpdatedAt' => [ 'shape' => 'Timestamp', ], 'meshName' => [ 'shape' => 'ResourceName', ], 'meshOwner' => [ 'shape' => 'AccountId', ], 'resourceOwner' => [ 'shape' => 'AccountId', ], 'version' => [ 'shape' => 'Long', ], 'virtualServiceName' => [ 'shape' => 'ServiceName', ], ], ], 'VirtualNodeStatus' => [ 'type' => 'structure', 'required' => [ 'status', ], 'members' => [ 'status' => [ 'shape' => 'VirtualNodeStatusCode', ], ], ], 'VirtualRouterRef' => [ 'type' => 'structure', 'required' => [ 'arn', 'createdAt', 'lastUpdatedAt', 'meshName', 'meshOwner', 'resourceOwner', 'version', 'virtualRouterName', ], 'members' => [ 'arn' => [ 'shape' => 'Arn', ], 'createdAt' => [ 'shape' => 'Timestamp', ], 'lastUpdatedAt' => [ 'shape' => 'Timestamp', ], 'meshName' => [ 'shape' => 'ResourceName', ], 'meshOwner' => [ 'shape' => 'AccountId', ], 'resourceOwner' => [ 'shape' => 'AccountId', ], 'version' => [ 'shape' => 'Long', ], 'virtualRouterName' => [ 'shape' => 'ResourceName', ], ], ], 'VirtualServiceData' => [ 'type' => 'structure', 'required' => [ 'meshName', 'metadata', 'spec', 'status', 'virtualServiceName', ], 'members' => [ 'meshName' => [ 'shape' => 'ResourceName', ], 'metadata' => [ 'shape' => 'ResourceMetadata', ], 'spec' => [ 'shape' => 'VirtualServiceSpec', ], 'status' => [ 'shape' => 'VirtualServiceStatus', ], 'virtualServiceName' => [ 'shape' => 'ServiceName', ], ], ], 'HttpRouteHeader' => [ 'type' => 'structure', 'required' => [ 'name', ], 'members' => [ 'invert' => [ 'shape' => 'Boolean', ], 'match' => [ 'shape' => 'HeaderMatchMethod', ], 'name' => [ 'shape' => 'HeaderName', ], ], ], 'FilePath' => [ 'type' => 'string', 'min' => 1, 'max' => 255, ], 'AwsCloudMapInstanceAttributes' => [ 'type' => 'list', 'member' => [ 'shape' => 'AwsCloudMapInstanceAttribute', ], ], 'VirtualNodeRef' => [ 'type' => 'structure', 'required' => [ 'arn', 'createdAt', 'lastUpdatedAt', 'meshName', 'meshOwner', 'resourceOwner', 'version', 'virtualNodeName', ], 'members' => [ 'arn' => [ 'shape' => 'Arn', ], 'createdAt' => [ 'shape' => 'Timestamp', ], 'lastUpdatedAt' => [ 'shape' => 'Timestamp', ], 'meshName' => [ 'shape' => 'ResourceName', ], 'meshOwner' => [ 'shape' => 'AccountId', ], 'resourceOwner' => [ 'shape' => 'AccountId', ], 'version' => [ 'shape' => 'Long', ], 'virtualNodeName' => [ 'shape' => 'ResourceName', ], ], ], 'CreateMeshInput' => [ 'type' => 'structure', 'required' => [ 'meshName', ], 'members' => [ 'clientToken' => [ 'shape' => 'String', 'idempotencyToken' => true, ], 'meshName' => [ 'shape' => 'ResourceName', ], 'spec' => [ 'shape' => 'MeshSpec', ], 'tags' => [ 'shape' => 'TagList', 'tags' => [ 'not-preview', ], ], ], ], 'GrpcRouteAction' => [ 'type' => 'structure', 'required' => [ 'weightedTargets', ], 'members' => [ 'weightedTargets' => [ 'shape' => 'WeightedTargets', ], ], ], 'LimitExceededException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'String', ], ], 'exception' => true, 'error' => [ 'code' => 'LimitExceededException', 'httpStatusCode' => 400, 'senderFault' => true, ], ], 'UpdateMeshOutput' => [ 'type' => 'structure', 'required' => [ 'mesh', ], 'members' => [ 'mesh' => [ 'shape' => 'MeshData', ], ], 'payload' => 'mesh', ], 'GrpcRouteMetadataMatchMethod' => [ 'type' => 'structure', 'members' => [ 'exact' => [ 'shape' => 'HeaderMatch', ], 'prefix' => [ 'shape' => 'HeaderMatch', ], 'range' => [ 'shape' => 'MatchRange', ], 'regex' => [ 'shape' => 'HeaderMatch', ], 'suffix' => [ 'shape' => 'HeaderMatch', ], ], ], 'DescribeVirtualServiceInput' => [ 'type' => 'structure', 'required' => [ 'meshName', 'virtualServiceName', ], 'members' => [ 'meshName' => [ 'shape' => 'ResourceName', 'location' => 'uri', 'locationName' => 'meshName', ], 'meshOwner' => [ 'shape' => 'AccountId', 'location' => 'querystring', 'locationName' => 'meshOwner', ], 'virtualServiceName' => [ 'shape' => 'ServiceName', 'location' => 'uri', 'locationName' => 'virtualServiceName', ], ], ], 'ListVirtualServicesLimit' => [ 'type' => 'integer', 'box' => true, 'min' => 1, 'max' => 100, ], 'AwsCloudMapInstanceAttribute' => [ 'type' => 'structure', 'required' => [ 'key', 'value', ], 'members' => [ 'key' => [ 'shape' => 'AwsCloudMapInstanceAttributeKey', ], 'value' => [ 'shape' => 'AwsCloudMapInstanceAttributeValue', ], ], ], 'VirtualServiceSpec' => [ 'type' => 'structure', 'members' => [ 'provider' => [ 'shape' => 'VirtualServiceProvider', ], ], ], 'MatchRange' => [ 'type' => 'structure', 'required' => [ 'end', 'start', ], 'members' => [ 'end' => [ 'shape' => 'Long', ], 'start' => [ 'shape' => 'Long', ], ], ], 'ListVirtualRoutersLimit' => [ 'type' => 'integer', 'box' => true, 'min' => 1, 'max' => 100, ], 'HealthCheckIntervalMillis' => [ 'type' => 'long', 'box' => true, 'min' => 5000, 'max' => 300000, ], 'VirtualRouterList' => [ 'type' => 'list', 'member' => [ 'shape' => 'VirtualRouterRef', ], ], 'Arn' => [ 'type' => 'string', ], 'TcpRoute' => [ 'type' => 'structure', 'required' => [ 'action', ], 'members' => [ 'action' => [ 'shape' => 'TcpRouteAction', ], ], ], 'VirtualNodeList' => [ 'type' => 'list', 'member' => [ 'shape' => 'VirtualNodeRef', ], ], 'ListVirtualRoutersInput' => [ 'type' => 'structure', 'required' => [ 'meshName', ], 'members' => [ 'limit' => [ 'shape' => 'ListVirtualRoutersLimit', 'location' => 'querystring', 'locationName' => 'limit', ], 'meshName' => [ 'shape' => 'ResourceName', 'location' => 'uri', 'locationName' => 'meshName', ], 'meshOwner' => [ 'shape' => 'AccountId', 'location' => 'querystring', 'locationName' => 'meshOwner', ], 'nextToken' => [ 'shape' => 'String', 'location' => 'querystring', 'locationName' => 'nextToken', ], ], ], 'DurationUnit' => [ 'type' => 'string', 'enum' => [ 'ms', 's', ], ], 'RoutePriority' => [ 'type' => 'integer', 'box' => true, 'min' => 0, 'max' => 1000, ], 'ListVirtualServicesInput' => [ 'type' => 'structure', 'required' => [ 'meshName', ], 'members' => [ 'limit' => [ 'shape' => 'ListVirtualServicesLimit', 'location' => 'querystring', 'locationName' => 'limit', ], 'meshName' => [ 'shape' => 'ResourceName', 'location' => 'uri', 'locationName' => 'meshName', ], 'meshOwner' => [ 'shape' => 'AccountId', 'location' => 'querystring', 'locationName' => 'meshOwner', ], 'nextToken' => [ 'shape' => 'String', 'location' => 'querystring', 'locationName' => 'nextToken', ], ], ], 'AccessLog' => [ 'type' => 'structure', 'members' => [ 'file' => [ 'shape' => 'FileAccessLog', ], ], ], 'ListVirtualNodesInput' => [ 'type' => 'structure', 'required' => [ 'meshName', ], 'members' => [ 'limit' => [ 'shape' => 'ListVirtualNodesLimit', 'location' => 'querystring', 'locationName' => 'limit', ], 'meshName' => [ 'shape' => 'ResourceName', 'location' => 'uri', 'locationName' => 'meshName', ], 'meshOwner' => [ 'shape' => 'AccountId', 'location' => 'querystring', 'locationName' => 'meshOwner', ], 'nextToken' => [ 'shape' => 'String', 'location' => 'querystring', 'locationName' => 'nextToken', ], ], ], 'ListVirtualNodesLimit' => [ 'type' => 'integer', 'box' => true, 'min' => 1, 'max' => 100, ], 'HealthCheckTimeoutMillis' => [ 'type' => 'long', 'box' => true, 'min' => 2000, 'max' => 60000, ], 'ResourceName' => [ 'type' => 'string', 'min' => 1, 'max' => 255, ], 'TooManyRequestsException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'String', ], ], 'exception' => true, 'error' => [ 'code' => 'TooManyRequestsException', 'httpStatusCode' => 429, 'senderFault' => true, ], ], 'Timestamp' => [ 'type' => 'timestamp', ], 'HeaderMatch' => [ 'type' => 'string', 'min' => 1, 'max' => 255, ], 'AccountId' => [ 'type' => 'string', 'min' => 12, 'max' => 12, ], 'Duration' => [ 'type' => 'structure', 'members' => [ 'unit' => [ 'shape' => 'DurationUnit', ], 'value' => [ 'shape' => 'DurationValue', ], ], ], 'DescribeRouteOutput' => [ 'type' => 'structure', 'required' => [ 'route', ], 'members' => [ 'route' => [ 'shape' => 'RouteData', ], ], 'payload' => 'route', ], 'HttpRouteMatch' => [ 'type' => 'structure', 'required' => [ 'prefix', ], 'members' => [ 'headers' => [ 'shape' => 'HttpRouteHeaders', ], 'method' => [ 'shape' => 'HttpMethod', ], 'prefix' => [ 'shape' => 'String', ], 'scheme' => [ 'shape' => 'HttpScheme', ], ], ], 'TagRef' => [ 'type' => 'structure', 'required' => [ 'key', ], 'members' => [ 'key' => [ 'shape' => 'TagKey', ], 'value' => [ 'shape' => 'TagValue', ], ], ], 'MeshRef' => [ 'type' => 'structure', 'required' => [ 'arn', 'createdAt', 'lastUpdatedAt', 'meshName', 'meshOwner', 'resourceOwner', 'version', ], 'members' => [ 'arn' => [ 'shape' => 'Arn', ], 'createdAt' => [ 'shape' => 'Timestamp', ], 'lastUpdatedAt' => [ 'shape' => 'Timestamp', ], 'meshName' => [ 'shape' => 'ResourceName', ], 'meshOwner' => [ 'shape' => 'AccountId', ], 'resourceOwner' => [ 'shape' => 'AccountId', ], 'version' => [ 'shape' => 'Long', ], ], ], 'MeshStatusCode' => [ 'type' => 'string', 'enum' => [ 'ACTIVE', 'DELETED', 'INACTIVE', ], ], 'MeshData' => [ 'type' => 'structure', 'required' => [ 'meshName', 'metadata', 'spec', 'status', ], 'members' => [ 'meshName' => [ 'shape' => 'ResourceName', ], 'metadata' => [ 'shape' => 'ResourceMetadata', ], 'spec' => [ 'shape' => 'MeshSpec', ], 'status' => [ 'shape' => 'MeshStatus', ], ], ], 'VirtualRouterStatus' => [ 'type' => 'structure', 'required' => [ 'status', ], 'members' => [ 'status' => [ 'shape' => 'VirtualRouterStatusCode', ], ], ], 'TcpRouteAction' => [ 'type' => 'structure', 'required' => [ 'weightedTargets', ], 'members' => [ 'weightedTargets' => [ 'shape' => 'WeightedTargets', ], ], ], 'DescribeVirtualNodeInput' => [ 'type' => 'structure', 'required' => [ 'meshName', 'virtualNodeName', ], 'members' => [ 'meshName' => [ 'shape' => 'ResourceName', 'location' => 'uri', 'locationName' => 'meshName', ], 'meshOwner' => [ 'shape' => 'AccountId', 'location' => 'querystring', 'locationName' => 'meshOwner', ], 'virtualNodeName' => [ 'shape' => 'ResourceName', 'location' => 'uri', 'locationName' => 'virtualNodeName', ], ], ], 'RouteStatus' => [ 'type' => 'structure', 'required' => [ 'status', ], 'members' => [ 'status' => [ 'shape' => 'RouteStatusCode', ], ], ], 'Listener' => [ 'type' => 'structure', 'required' => [ 'portMapping', ], 'members' => [ 'healthCheck' => [ 'shape' => 'HealthCheckPolicy', ], 'portMapping' => [ 'shape' => 'PortMapping', ], 'tls' => [ 'shape' => 'ListenerTls', ], ], ], 'GrpcRoute' => [ 'type' => 'structure', 'required' => [ 'action', 'match', ], 'members' => [ 'action' => [ 'shape' => 'GrpcRouteAction', ], 'match' => [ 'shape' => 'GrpcRouteMatch', ], 'retryPolicy' => [ 'shape' => 'GrpcRetryPolicy', ], ], ], 'ListRoutesLimit' => [ 'type' => 'integer', 'box' => true, 'min' => 1, 'max' => 100, ], 'ClientPolicyTls' => [ 'type' => 'structure', 'required' => [ 'validation', ], 'members' => [ 'enforce' => [ 'shape' => 'Boolean', 'box' => true, ], 'ports' => [ 'shape' => 'PortSet', ], 'validation' => [ 'shape' => 'TlsValidationContext', ], ], ], 'DeleteVirtualServiceOutput' => [ 'type' => 'structure', 'required' => [ 'virtualService', ], 'members' => [ 'virtualService' => [ 'shape' => 'VirtualServiceData', ], ], 'payload' => 'virtualService', ], 'VirtualNodeServiceProvider' => [ 'type' => 'structure', 'required' => [ 'virtualNodeName', ], 'members' => [ 'virtualNodeName' => [ 'shape' => 'ResourceName', ], ], ], 'BackendDefaults' => [ 'type' => 'structure', 'members' => [ 'clientPolicy' => [ 'shape' => 'ClientPolicy', ], ], ], 'ListenerTlsFileCertificate' => [ 'type' => 'structure', 'required' => [ 'certificateChain', 'privateKey', ], 'members' => [ 'certificateChain' => [ 'shape' => 'FilePath', ], 'privateKey' => [ 'shape' => 'FilePath', ], ], ], 'HttpRetryPolicy' => [ 'type' => 'structure', 'required' => [ 'maxRetries', 'perRetryTimeout', ], 'members' => [ 'httpRetryEvents' => [ 'shape' => 'HttpRetryPolicyEvents', ], 'maxRetries' => [ 'shape' => 'MaxRetries', ], 'perRetryTimeout' => [ 'shape' => 'Duration', ], 'tcpRetryEvents' => [ 'shape' => 'TcpRetryPolicyEvents', ], ], ], 'DescribeVirtualRouterInput' => [ 'type' => 'structure', 'required' => [ 'meshName', 'virtualRouterName', ], 'members' => [ 'meshName' => [ 'shape' => 'ResourceName', 'location' => 'uri', 'locationName' => 'meshName', ], 'meshOwner' => [ 'shape' => 'AccountId', 'location' => 'querystring', 'locationName' => 'meshOwner', ], 'virtualRouterName' => [ 'shape' => 'ResourceName', 'location' => 'uri', 'locationName' => 'virtualRouterName', ], ], ], 'TagResourceOutput' => [ 'type' => 'structure', 'members' => [], ], 'RouteList' => [ 'type' => 'list', 'member' => [ 'shape' => 'RouteRef', ], ], 'TooManyTagsException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'String', ], ], 'exception' => true, 'error' => [ 'code' => 'TooManyTagsException', 'httpStatusCode' => 400, 'senderFault' => true, ], ], 'PortNumber' => [ 'type' => 'integer', 'min' => 1, 'max' => 65535, ], 'TlsValidationContextFileTrust' => [ 'type' => 'structure', 'required' => [ 'certificateChain', ], 'members' => [ 'certificateChain' => [ 'shape' => 'FilePath', ], ], ], 'GrpcRouteMetadata' => [ 'type' => 'structure', 'required' => [ 'name', ], 'members' => [ 'invert' => [ 'shape' => 'Boolean', ], 'match' => [ 'shape' => 'GrpcRouteMetadataMatchMethod', ], 'name' => [ 'shape' => 'HeaderName', ], ], ], 'CreateRouteInput' => [ 'type' => 'structure', 'required' => [ 'meshName', 'routeName', 'spec', 'virtualRouterName', ], 'members' => [ 'clientToken' => [ 'shape' => 'String', 'idempotencyToken' => true, ], 'meshName' => [ 'shape' => 'ResourceName', 'location' => 'uri', 'locationName' => 'meshName', ], 'meshOwner' => [ 'shape' => 'AccountId', 'location' => 'querystring', 'locationName' => 'meshOwner', ], 'routeName' => [ 'shape' => 'ResourceName', ], 'spec' => [ 'shape' => 'RouteSpec', ], 'tags' => [ 'shape' => 'TagList', 'tags' => [ 'not-preview', ], ], 'virtualRouterName' => [ 'shape' => 'ResourceName', 'location' => 'uri', 'locationName' => 'virtualRouterName', ], ], ], 'WeightedTargets' => [ 'type' => 'list', 'member' => [ 'shape' => 'WeightedTarget', ], 'min' => 1, 'max' => 10, ], 'HttpRouteHeaders' => [ 'type' => 'list', 'member' => [ 'shape' => 'HttpRouteHeader', ], 'min' => 1, 'max' => 10, ], 'String' => [ 'type' => 'string', ], 'HttpScheme' => [ 'type' => 'string', 'enum' => [ 'http', 'https', ], ], 'UpdateRouteInput' => [ 'type' => 'structure', 'required' => [ 'meshName', 'routeName', 'spec', 'virtualRouterName', ], 'members' => [ 'clientToken' => [ 'shape' => 'String', 'idempotencyToken' => true, ], 'meshName' => [ 'shape' => 'ResourceName', 'location' => 'uri', 'locationName' => 'meshName', ], 'meshOwner' => [ 'shape' => 'AccountId', 'location' => 'querystring', 'locationName' => 'meshOwner', ], 'routeName' => [ 'shape' => 'ResourceName', 'location' => 'uri', 'locationName' => 'routeName', ], 'spec' => [ 'shape' => 'RouteSpec', ], 'virtualRouterName' => [ 'shape' => 'ResourceName', 'location' => 'uri', 'locationName' => 'virtualRouterName', ], ], ], 'HttpRoute' => [ 'type' => 'structure', 'required' => [ 'action', 'match', ], 'members' => [ 'action' => [ 'shape' => 'HttpRouteAction', ], 'match' => [ 'shape' => 'HttpRouteMatch', ], 'retryPolicy' => [ 'shape' => 'HttpRetryPolicy', ], ], ], 'DescribeMeshInput' => [ 'type' => 'structure', 'required' => [ 'meshName', ], 'members' => [ 'meshName' => [ 'shape' => 'ResourceName', 'location' => 'uri', 'locationName' => 'meshName', ], 'meshOwner' => [ 'shape' => 'AccountId', 'location' => 'querystring', 'locationName' => 'meshOwner', ], ], ], 'MeshSpec' => [ 'type' => 'structure', 'members' => [ 'egressFilter' => [ 'shape' => 'EgressFilter', ], ], ], 'ListTagsForResourceOutput' => [ 'type' => 'structure', 'required' => [ 'tags', ], 'members' => [ 'nextToken' => [ 'shape' => 'String', ], 'tags' => [ 'shape' => 'TagList', ], ], ], 'ServiceDiscovery' => [ 'type' => 'structure', 'members' => [ 'awsCloudMap' => [ 'shape' => 'AwsCloudMapServiceDiscovery', ], 'dns' => [ 'shape' => 'DnsServiceDiscovery', ], ], ], 'ListVirtualNodesOutput' => [ 'type' => 'structure', 'required' => [ 'virtualNodes', ], 'members' => [ 'nextToken' => [ 'shape' => 'String', ], 'virtualNodes' => [ 'shape' => 'VirtualNodeList', ], ], ], 'UntagResourceInput' => [ 'type' => 'structure', 'required' => [ 'resourceArn', 'tagKeys', ], 'members' => [ 'resourceArn' => [ 'shape' => 'Arn', 'location' => 'querystring', 'locationName' => 'resourceArn', ], 'tagKeys' => [ 'shape' => 'TagKeyList', ], ], ], 'ListenerTlsAcmCertificate' => [ 'type' => 'structure', 'required' => [ 'certificateArn', ], 'members' => [ 'certificateArn' => [ 'shape' => 'Arn', ], ], ], 'TagKey' => [ 'type' => 'string', 'min' => 1, 'max' => 128, ], 'VirtualServiceStatusCode' => [ 'type' => 'string', 'enum' => [ 'ACTIVE', 'DELETED', 'INACTIVE', ], ], ],];
