<?php
// This file was auto-generated from sdk-root/src/data/bedrock/2023-04-20/api-2.json
return [ 'version' => '2.0', 'metadata' => [ 'apiVersion' => '2023-04-20', 'endpointPrefix' => 'bedrock', 'jsonVersion' => '1.1', 'protocol' => 'rest-json', 'serviceFullName' => 'Amazon Bedrock', 'serviceId' => 'Bedrock', 'signatureVersion' => 'v4', 'signingName' => 'bedrock', 'uid' => 'bedrock-2023-04-20', ], 'operations' => [ 'CreateModelCustomizationJob' => [ 'name' => 'CreateModelCustomizationJob', 'http' => [ 'method' => 'POST', 'requestUri' => '/model-customization-jobs', 'responseCode' => 201, ], 'input' => [ 'shape' => 'CreateModelCustomizationJobRequest', ], 'output' => [ 'shape' => 'CreateModelCustomizationJobResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'TooManyTagsException', ], [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'ThrottlingException', ], ], 'idempotent' => true, ], 'DeleteCustomModel' => [ 'name' => 'DeleteCustomModel', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/custom-models/{modelIdentifier}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DeleteCustomModelRequest', ], 'output' => [ 'shape' => 'DeleteCustomModelResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ThrottlingException', ], ], 'idempotent' => true, ], 'DeleteModelInvocationLoggingConfiguration' => [ 'name' => 'DeleteModelInvocationLoggingConfiguration', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/logging/modelinvocations', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DeleteModelInvocationLoggingConfigurationRequest', ], 'output' => [ 'shape' => 'DeleteModelInvocationLoggingConfigurationResponse', ], 'errors' => [ [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ThrottlingException', ], ], 'idempotent' => true, ], 'GetCustomModel' => [ 'name' => 'GetCustomModel', 'http' => [ 'method' => 'GET', 'requestUri' => '/custom-models/{modelIdentifier}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetCustomModelRequest', ], 'output' => [ 'shape' => 'GetCustomModelResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'GetFoundationModel' => [ 'name' => 'GetFoundationModel', 'http' => [ 'method' => 'GET', 'requestUri' => '/foundation-models/{modelIdentifier}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetFoundationModelRequest', ], 'output' => [ 'shape' => 'GetFoundationModelResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'GetModelCustomizationJob' => [ 'name' => 'GetModelCustomizationJob', 'http' => [ 'method' => 'GET', 'requestUri' => '/model-customization-jobs/{jobIdentifier}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetModelCustomizationJobRequest', ], 'output' => [ 'shape' => 'GetModelCustomizationJobResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'GetModelInvocationLoggingConfiguration' => [ 'name' => 'GetModelInvocationLoggingConfiguration', 'http' => [ 'method' => 'GET', 'requestUri' => '/logging/modelinvocations', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetModelInvocationLoggingConfigurationRequest', ], 'output' => [ 'shape' => 'GetModelInvocationLoggingConfigurationResponse', ], 'errors' => [ [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'ListCustomModels' => [ 'name' => 'ListCustomModels', 'http' => [ 'method' => 'GET', 'requestUri' => '/custom-models', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListCustomModelsRequest', ], 'output' => [ 'shape' => 'ListCustomModelsResponse', ], 'errors' => [ [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'ListFoundationModels' => [ 'name' => 'ListFoundationModels', 'http' => [ 'method' => 'GET', 'requestUri' => '/foundation-models', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListFoundationModelsRequest', ], 'output' => [ 'shape' => 'ListFoundationModelsResponse', ], 'errors' => [ [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'ListModelCustomizationJobs' => [ 'name' => 'ListModelCustomizationJobs', 'http' => [ 'method' => 'GET', 'requestUri' => '/model-customization-jobs', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListModelCustomizationJobsRequest', ], 'output' => [ 'shape' => 'ListModelCustomizationJobsResponse', ], 'errors' => [ [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'ListTagsForResource' => [ 'name' => 'ListTagsForResource', 'http' => [ 'method' => 'POST', 'requestUri' => '/listTagsForResource', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListTagsForResourceRequest', ], 'output' => [ 'shape' => 'ListTagsForResourceResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'PutModelInvocationLoggingConfiguration' => [ 'name' => 'PutModelInvocationLoggingConfiguration', 'http' => [ 'method' => 'PUT', 'requestUri' => '/logging/modelinvocations', 'responseCode' => 200, ], 'input' => [ 'shape' => 'PutModelInvocationLoggingConfigurationRequest', ], 'output' => [ 'shape' => 'PutModelInvocationLoggingConfigurationResponse', ], 'errors' => [ [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ThrottlingException', ], ], 'idempotent' => true, ], 'StopModelCustomizationJob' => [ 'name' => 'StopModelCustomizationJob', 'http' => [ 'method' => 'POST', 'requestUri' => '/model-customization-jobs/{jobIdentifier}/stop', 'responseCode' => 200, ], 'input' => [ 'shape' => 'StopModelCustomizationJobRequest', ], 'output' => [ 'shape' => 'StopModelCustomizationJobResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ThrottlingException', ], ], 'idempotent' => true, ], 'TagResource' => [ 'name' => 'TagResource', 'http' => [ 'method' => 'POST', 'requestUri' => '/tagResource', 'responseCode' => 200, ], 'input' => [ 'shape' => 'TagResourceRequest', ], 'output' => [ 'shape' => 'TagResourceResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'TooManyTagsException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'UntagResource' => [ 'name' => 'UntagResource', 'http' => [ 'method' => 'POST', 'requestUri' => '/untagResource', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UntagResourceRequest', ], 'output' => [ 'shape' => 'UntagResourceResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ThrottlingException', ], ], ], ], 'shapes' => [ 'AccessDeniedException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'NonBlankString', ], ], 'error' => [ 'httpStatusCode' => 403, 'senderFault' => true, ], 'exception' => true, ], 'BaseModelIdentifier' => [ 'type' => 'string', 'max' => 2048, 'min' => 1, 'pattern' => '^(arn:aws(-[^:]+)?:bedrock:[a-z0-9-]{1,20}:(([0-9]{12}:custom-model/[a-z0-9-]{1,63}[.]{1}[a-z0-9-]{1,63}/[a-z0-9]{12})|(:foundation-model/[a-z0-9-]{1,63}[.]{1}[a-z0-9-]{1,63}([a-z0-9-]{1,63}[.]){0,2}[a-z0-9-]{1,63}([:][a-z0-9-]{1,63}){0,2})))|([a-z0-9-]{1,63}[.]{1}[a-z0-9-]{1,63}([.]?[a-z0-9-]{1,63})([:][a-z0-9-]{1,63}){0,2})|(([0-9a-zA-Z][_-]?)+)$', ], 'BedrockModelId' => [ 'type' => 'string', 'max' => 140, 'min' => 0, 'pattern' => '^[a-z0-9-]{1,63}[.]{1}[a-z0-9-]{1,63}([a-z0-9-]{1,63}[.]){0,2}[a-z0-9-]{1,63}([:][a-z0-9-]{1,63}){0,2}(/[a-z0-9]{12}|)$', ], 'Boolean' => [ 'type' => 'boolean', 'box' => true, ], 'BrandedName' => [ 'type' => 'string', 'max' => 20, 'min' => 1, 'pattern' => '^.*$', ], 'BucketName' => [ 'type' => 'string', 'max' => 63, 'min' => 3, ], 'CloudWatchConfig' => [ 'type' => 'structure', 'required' => [ 'logGroupName', 'roleArn', ], 'members' => [ 'largeDataDeliveryS3Config' => [ 'shape' => 'S3Config', ], 'logGroupName' => [ 'shape' => 'LogGroupName', ], 'roleArn' => [ 'shape' => 'RoleArn', ], ], ], 'ConflictException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'NonBlankString', ], ], 'error' => [ 'httpStatusCode' => 400, 'senderFault' => true, ], 'exception' => true, ], 'CreateModelCustomizationJobRequest' => [ 'type' => 'structure', 'required' => [ 'baseModelIdentifier', 'customModelName', 'hyperParameters', 'jobName', 'outputDataConfig', 'roleArn', 'trainingDataConfig', ], 'members' => [ 'baseModelIdentifier' => [ 'shape' => 'BaseModelIdentifier', ], 'clientRequestToken' => [ 'shape' => 'IdempotencyToken', 'idempotencyToken' => true, ], 'customModelKmsKeyId' => [ 'shape' => 'KmsKeyId', ], 'customModelName' => [ 'shape' => 'CustomModelName', ], 'customModelTags' => [ 'shape' => 'TagList', ], 'hyperParameters' => [ 'shape' => 'ModelCustomizationHyperParameters', ], 'jobName' => [ 'shape' => 'JobName', ], 'jobTags' => [ 'shape' => 'TagList', ], 'outputDataConfig' => [ 'shape' => 'OutputDataConfig', ], 'roleArn' => [ 'shape' => 'RoleArn', ], 'trainingDataConfig' => [ 'shape' => 'TrainingDataConfig', ], 'validationDataConfig' => [ 'shape' => 'ValidationDataConfig', ], 'vpcConfig' => [ 'shape' => 'VpcConfig', ], ], ], 'CreateModelCustomizationJobResponse' => [ 'type' => 'structure', 'required' => [ 'jobArn', ], 'members' => [ 'jobArn' => [ 'shape' => 'ModelCustomizationJobArn', ], ], ], 'CustomModelArn' => [ 'type' => 'string', 'max' => 1011, 'min' => 20, 'pattern' => '^arn:aws(-[^:]+)?:bedrock:[a-z0-9-]{1,20}:[0-9]{12}:custom-model/[a-z0-9-]{1,63}[.]{1}[a-z0-9-]{1,63}([a-z0-9-]{1,63}[.]){0,2}[a-z0-9-]{1,63}([:][a-z0-9-]{1,63}){0,2}/[a-z0-9]{12}$', ], 'CustomModelName' => [ 'type' => 'string', 'max' => 63, 'min' => 1, 'pattern' => '^([0-9a-zA-Z][_-]?)+$', ], 'CustomModelSummary' => [ 'type' => 'structure', 'required' => [ 'baseModelArn', 'baseModelName', 'creationTime', 'modelArn', 'modelName', ], 'members' => [ 'baseModelArn' => [ 'shape' => 'ModelArn', ], 'baseModelName' => [ 'shape' => 'ModelName', ], 'creationTime' => [ 'shape' => 'Timestamp', ], 'modelArn' => [ 'shape' => 'CustomModelArn', ], 'modelName' => [ 'shape' => 'CustomModelName', ], ], ], 'CustomModelSummaryList' => [ 'type' => 'list', 'member' => [ 'shape' => 'CustomModelSummary', ], ], 'DeleteCustomModelRequest' => [ 'type' => 'structure', 'required' => [ 'modelIdentifier', ], 'members' => [ 'modelIdentifier' => [ 'shape' => 'ModelIdentifier', 'location' => 'uri', 'locationName' => 'modelIdentifier', ], ], ], 'DeleteCustomModelResponse' => [ 'type' => 'structure', 'members' => [], ], 'DeleteModelInvocationLoggingConfigurationRequest' => [ 'type' => 'structure', 'members' => [], ], 'DeleteModelInvocationLoggingConfigurationResponse' => [ 'type' => 'structure', 'members' => [], ], 'ErrorMessage' => [ 'type' => 'string', 'max' => 2048, 'min' => 0, ], 'FineTuningJobStatus' => [ 'type' => 'string', 'enum' => [ 'InProgress', 'Completed', 'Failed', 'Stopping', 'Stopped', ], ], 'FoundationModelArn' => [ 'type' => 'string', 'pattern' => '^arn:aws(-[^:]+)?:bedrock:[a-z0-9-]{1,20}::foundation-model/[a-z0-9-]{1,63}[.]{1}([a-z0-9-]{1,63}[.]){0,2}[a-z0-9-]{1,63}([:][a-z0-9-]{1,63}){0,2}$', ], 'FoundationModelDetails' => [ 'type' => 'structure', 'required' => [ 'modelArn', 'modelId', ], 'members' => [ 'customizationsSupported' => [ 'shape' => 'ModelCustomizationList', ], 'inferenceTypesSupported' => [ 'shape' => 'InferenceTypeList', ], 'inputModalities' => [ 'shape' => 'ModelModalityList', ], 'modelArn' => [ 'shape' => 'FoundationModelArn', ], 'modelId' => [ 'shape' => 'BedrockModelId', ], 'modelName' => [ 'shape' => 'BrandedName', ], 'outputModalities' => [ 'shape' => 'ModelModalityList', ], 'providerName' => [ 'shape' => 'BrandedName', ], 'responseStreamingSupported' => [ 'shape' => 'Boolean', ], ], ], 'FoundationModelSummary' => [ 'type' => 'structure', 'required' => [ 'modelArn', 'modelId', ], 'members' => [ 'customizationsSupported' => [ 'shape' => 'ModelCustomizationList', ], 'inferenceTypesSupported' => [ 'shape' => 'InferenceTypeList', ], 'inputModalities' => [ 'shape' => 'ModelModalityList', ], 'modelArn' => [ 'shape' => 'FoundationModelArn', ], 'modelId' => [ 'shape' => 'BedrockModelId', ], 'modelName' => [ 'shape' => 'BrandedName', ], 'outputModalities' => [ 'shape' => 'ModelModalityList', ], 'providerName' => [ 'shape' => 'BrandedName', ], 'responseStreamingSupported' => [ 'shape' => 'Boolean', ], ], ], 'FoundationModelSummaryList' => [ 'type' => 'list', 'member' => [ 'shape' => 'FoundationModelSummary', ], ], 'GetCustomModelRequest' => [ 'type' => 'structure', 'required' => [ 'modelIdentifier', ], 'members' => [ 'modelIdentifier' => [ 'shape' => 'ModelIdentifier', 'location' => 'uri', 'locationName' => 'modelIdentifier', ], ], ], 'GetCustomModelResponse' => [ 'type' => 'structure', 'required' => [ 'baseModelArn', 'creationTime', 'jobArn', 'modelArn', 'modelName', 'outputDataConfig', 'trainingDataConfig', ], 'members' => [ 'baseModelArn' => [ 'shape' => 'ModelArn', ], 'creationTime' => [ 'shape' => 'Timestamp', ], 'hyperParameters' => [ 'shape' => 'ModelCustomizationHyperParameters', ], 'jobArn' => [ 'shape' => 'ModelCustomizationJobArn', ], 'jobName' => [ 'shape' => 'JobName', ], 'modelArn' => [ 'shape' => 'ModelArn', ], 'modelKmsKeyArn' => [ 'shape' => 'KmsKeyArn', ], 'modelName' => [ 'shape' => 'CustomModelName', ], 'outputDataConfig' => [ 'shape' => 'OutputDataConfig', ], 'trainingDataConfig' => [ 'shape' => 'TrainingDataConfig', ], 'trainingMetrics' => [ 'shape' => 'TrainingMetrics', ], 'validationDataConfig' => [ 'shape' => 'ValidationDataConfig', ], 'validationMetrics' => [ 'shape' => 'ValidationMetrics', ], ], ], 'GetFoundationModelRequest' => [ 'type' => 'structure', 'required' => [ 'modelIdentifier', ], 'members' => [ 'modelIdentifier' => [ 'shape' => 'ModelIdentifier', 'location' => 'uri', 'locationName' => 'modelIdentifier', ], ], ], 'GetFoundationModelResponse' => [ 'type' => 'structure', 'members' => [ 'modelDetails' => [ 'shape' => 'FoundationModelDetails', ], ], ], 'GetModelCustomizationJobRequest' => [ 'type' => 'structure', 'required' => [ 'jobIdentifier', ], 'members' => [ 'jobIdentifier' => [ 'shape' => 'ModelCustomizationJobIdentifier', 'location' => 'uri', 'locationName' => 'jobIdentifier', ], ], ], 'GetModelCustomizationJobResponse' => [ 'type' => 'structure', 'required' => [ 'baseModelArn', 'creationTime', 'hyperParameters', 'jobArn', 'jobName', 'outputDataConfig', 'outputModelName', 'roleArn', 'trainingDataConfig', 'validationDataConfig', ], 'members' => [ 'baseModelArn' => [ 'shape' => 'FoundationModelArn', ], 'clientRequestToken' => [ 'shape' => 'IdempotencyToken', ], 'creationTime' => [ 'shape' => 'Timestamp', ], 'endTime' => [ 'shape' => 'Timestamp', ], 'failureMessage' => [ 'shape' => 'ErrorMessage', ], 'hyperParameters' => [ 'shape' => 'ModelCustomizationHyperParameters', ], 'jobArn' => [ 'shape' => 'ModelCustomizationJobArn', ], 'jobName' => [ 'shape' => 'JobName', ], 'lastModifiedTime' => [ 'shape' => 'Timestamp', ], 'outputDataConfig' => [ 'shape' => 'OutputDataConfig', ], 'outputModelArn' => [ 'shape' => 'CustomModelArn', ], 'outputModelKmsKeyArn' => [ 'shape' => 'KmsKeyArn', ], 'outputModelName' => [ 'shape' => 'CustomModelName', ], 'roleArn' => [ 'shape' => 'RoleArn', ], 'status' => [ 'shape' => 'ModelCustomizationJobStatus', ], 'trainingDataConfig' => [ 'shape' => 'TrainingDataConfig', ], 'trainingMetrics' => [ 'shape' => 'TrainingMetrics', ], 'validationDataConfig' => [ 'shape' => 'ValidationDataConfig', ], 'validationMetrics' => [ 'shape' => 'ValidationMetrics', ], 'vpcConfig' => [ 'shape' => 'VpcConfig', ], ], ], 'GetModelInvocationLoggingConfigurationRequest' => [ 'type' => 'structure', 'members' => [], ], 'GetModelInvocationLoggingConfigurationResponse' => [ 'type' => 'structure', 'members' => [ 'loggingConfig' => [ 'shape' => 'LoggingConfig', ], ], ], 'IdempotencyToken' => [ 'type' => 'string', 'max' => 256, 'min' => 1, 'pattern' => '^[a-zA-Z0-9](-*[a-zA-Z0-9])*$', ], 'InferenceType' => [ 'type' => 'string', 'enum' => [ 'ON_DEMAND', 'PROVISIONED', ], ], 'InferenceTypeList' => [ 'type' => 'list', 'member' => [ 'shape' => 'InferenceType', ], ], 'InternalServerException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'NonBlankString', ], ], 'error' => [ 'httpStatusCode' => 500, ], 'exception' => true, 'fault' => true, ], 'JobName' => [ 'type' => 'string', 'max' => 63, 'min' => 1, 'pattern' => '^[a-zA-Z0-9](-*[a-zA-Z0-9\\+\\-\\.])*$', ], 'KeyPrefix' => [ 'type' => 'string', 'max' => 1024, 'min' => 0, ], 'KmsKeyArn' => [ 'type' => 'string', 'max' => 2048, 'min' => 1, 'pattern' => '^arn:aws(-[^:]+)?:kms:[a-zA-Z0-9-]*:[0-9]{12}:key/[a-zA-Z0-9-]{36}$', ], 'KmsKeyId' => [ 'type' => 'string', 'max' => 2048, 'min' => 1, 'pattern' => '^arn:aws(-[^:]+)?:kms:[a-zA-Z0-9-]*:[0-9]{12}:((key/[a-zA-Z0-9-]{36})|(alias/[a-zA-Z0-9-_/]+))$', ], 'ListCustomModelsRequest' => [ 'type' => 'structure', 'members' => [ 'baseModelArnEquals' => [ 'shape' => 'ModelArn', 'location' => 'querystring', 'locationName' => 'baseModelArnEquals', ], 'creationTimeAfter' => [ 'shape' => 'Timestamp', 'location' => 'querystring', 'locationName' => 'creationTimeAfter', ], 'creationTimeBefore' => [ 'shape' => 'Timestamp', 'location' => 'querystring', 'locationName' => 'creationTimeBefore', ], 'foundationModelArnEquals' => [ 'shape' => 'FoundationModelArn', 'location' => 'querystring', 'locationName' => 'foundationModelArnEquals', ], 'maxResults' => [ 'shape' => 'MaxResults', 'location' => 'querystring', 'locationName' => 'maxResults', ], 'nameContains' => [ 'shape' => 'CustomModelName', 'location' => 'querystring', 'locationName' => 'nameContains', ], 'nextToken' => [ 'shape' => 'PaginationToken', 'location' => 'querystring', 'locationName' => 'nextToken', ], 'sortBy' => [ 'shape' => 'SortModelsBy', 'location' => 'querystring', 'locationName' => 'sortBy', ], 'sortOrder' => [ 'shape' => 'SortOrder', 'location' => 'querystring', 'locationName' => 'sortOrder', ], ], ], 'ListCustomModelsResponse' => [ 'type' => 'structure', 'members' => [ 'modelSummaries' => [ 'shape' => 'CustomModelSummaryList', ], 'nextToken' => [ 'shape' => 'PaginationToken', ], ], ], 'ListFoundationModelsRequest' => [ 'type' => 'structure', 'members' => [ 'byCustomizationType' => [ 'shape' => 'ModelCustomization', 'location' => 'querystring', 'locationName' => 'byCustomizationType', ], 'byInferenceType' => [ 'shape' => 'InferenceType', 'location' => 'querystring', 'locationName' => 'byInferenceType', ], 'byOutputModality' => [ 'shape' => 'ModelModality', 'location' => 'querystring', 'locationName' => 'byOutputModality', ], 'byProvider' => [ 'shape' => 'Provider', 'location' => 'querystring', 'locationName' => 'byProvider', ], ], ], 'ListFoundationModelsResponse' => [ 'type' => 'structure', 'members' => [ 'modelSummaries' => [ 'shape' => 'FoundationModelSummaryList', ], ], ], 'ListModelCustomizationJobsRequest' => [ 'type' => 'structure', 'members' => [ 'creationTimeAfter' => [ 'shape' => 'Timestamp', 'location' => 'querystring', 'locationName' => 'creationTimeAfter', ], 'creationTimeBefore' => [ 'shape' => 'Timestamp', 'location' => 'querystring', 'locationName' => 'creationTimeBefore', ], 'maxResults' => [ 'shape' => 'MaxResults', 'location' => 'querystring', 'locationName' => 'maxResults', ], 'nameContains' => [ 'shape' => 'JobName', 'location' => 'querystring', 'locationName' => 'nameContains', ], 'nextToken' => [ 'shape' => 'PaginationToken', 'location' => 'querystring', 'locationName' => 'nextToken', ], 'sortBy' => [ 'shape' => 'SortJobsBy', 'location' => 'querystring', 'locationName' => 'sortBy', ], 'sortOrder' => [ 'shape' => 'SortOrder', 'location' => 'querystring', 'locationName' => 'sortOrder', ], 'statusEquals' => [ 'shape' => 'FineTuningJobStatus', 'location' => 'querystring', 'locationName' => 'statusEquals', ], ], ], 'ListModelCustomizationJobsResponse' => [ 'type' => 'structure', 'members' => [ 'modelCustomizationJobSummaries' => [ 'shape' => 'ModelCustomizationJobSummaries', ], 'nextToken' => [ 'shape' => 'PaginationToken', ], ], ], 'ListTagsForResourceRequest' => [ 'type' => 'structure', 'required' => [ 'resourceARN', ], 'members' => [ 'resourceARN' => [ 'shape' => 'TaggableResourcesArn', ], ], ], 'ListTagsForResourceResponse' => [ 'type' => 'structure', 'members' => [ 'tags' => [ 'shape' => 'TagList', ], ], ], 'LogGroupName' => [ 'type' => 'string', 'max' => 512, 'min' => 1, ], 'LoggingConfig' => [ 'type' => 'structure', 'members' => [ 'cloudWatchConfig' => [ 'shape' => 'CloudWatchConfig', ], 'embeddingDataDeliveryEnabled' => [ 'shape' => 'Boolean', ], 'imageDataDeliveryEnabled' => [ 'shape' => 'Boolean', ], 's3Config' => [ 'shape' => 'S3Config', ], 'textDataDeliveryEnabled' => [ 'shape' => 'Boolean', ], ], ], 'MaxResults' => [ 'type' => 'integer', 'box' => true, 'max' => 1000, 'min' => 1, ], 'MetricFloat' => [ 'type' => 'float', 'box' => true, ], 'ModelArn' => [ 'type' => 'string', 'max' => 1011, 'min' => 20, 'pattern' => '^arn:aws(-[^:]+)?:bedrock:[a-z0-9-]{1,20}:(([0-9]{12}:custom-model/[a-z0-9-]{1,63}[.]{1}[a-z0-9-]{1,63}/[a-z0-9]{12})|(:foundation-model/[a-z0-9-]{1,63}[.]{1}([a-z0-9-]{1,63}[.]){0,2}[a-z0-9-]{1,63}([:][a-z0-9-]{1,63}){0,2}))$', ], 'ModelCustomization' => [ 'type' => 'string', 'enum' => [ 'FINE_TUNING', ], ], 'ModelCustomizationHyperParameters' => [ 'type' => 'map', 'key' => [ 'shape' => 'String', ], 'value' => [ 'shape' => 'String', ], ], 'ModelCustomizationJobArn' => [ 'type' => 'string', 'max' => 1011, 'min' => 0, 'pattern' => '^arn:aws(-[^:]+)?:bedrock:[a-z0-9-]{1,20}:[0-9]{12}:model-customization-job/[a-z0-9-]{1,63}[.]{1}[a-z0-9-]{1,63}([a-z0-9-]{1,63}[.]){0,2}[a-z0-9-]{1,63}([:][a-z0-9-]{1,63}){0,2}/[a-z0-9]{12}$', ], 'ModelCustomizationJobIdentifier' => [ 'type' => 'string', 'max' => 1011, 'min' => 0, 'pattern' => '^(arn:aws(-[^:]+)?:bedrock:[a-z0-9-]{1,20}:[0-9]{12}:model-customization-job/[a-z0-9-]{1,63}[.]{1}[a-z0-9-]{1,63}([a-z0-9-]{1,63}[.]){0,2}[a-z0-9-]{1,63}([:][a-z0-9-]{1,63}){0,2}/[a-z0-9]{12})|([a-zA-Z0-9](-*[a-zA-Z0-9\\+\\-\\.])*)$', ], 'ModelCustomizationJobStatus' => [ 'type' => 'string', 'enum' => [ 'InProgress', 'Completed', 'Failed', 'Stopping', 'Stopped', ], ], 'ModelCustomizationJobSummaries' => [ 'type' => 'list', 'member' => [ 'shape' => 'ModelCustomizationJobSummary', ], ], 'ModelCustomizationJobSummary' => [ 'type' => 'structure', 'required' => [ 'baseModelArn', 'creationTime', 'jobArn', 'jobName', 'status', ], 'members' => [ 'baseModelArn' => [ 'shape' => 'ModelArn', ], 'creationTime' => [ 'shape' => 'Timestamp', ], 'customModelArn' => [ 'shape' => 'CustomModelArn', ], 'customModelName' => [ 'shape' => 'CustomModelName', ], 'endTime' => [ 'shape' => 'Timestamp', ], 'jobArn' => [ 'shape' => 'ModelCustomizationJobArn', ], 'jobName' => [ 'shape' => 'JobName', ], 'lastModifiedTime' => [ 'shape' => 'Timestamp', ], 'status' => [ 'shape' => 'ModelCustomizationJobStatus', ], ], ], 'ModelCustomizationList' => [ 'type' => 'list', 'member' => [ 'shape' => 'ModelCustomization', ], ], 'ModelIdentifier' => [ 'type' => 'string', 'max' => 2048, 'min' => 1, 'pattern' => '^(arn:aws(-[^:]+)?:amazon-bedrock:[a-zA-Z0-9-]*:(([0-9]{12})|(aws))?:(custom|built-in)-model/.+)|(arn:aws(-[^:]+)?:bedrock:[a-z0-9-]{1,20}:(([0-9]{12}:custom-model/[a-z0-9-]{1,63}[.]{1}[a-z0-9-]{1,63}/[a-z0-9]{12})|(:foundation-model/([a-z0-9-]{1,63}[.]{1}[a-z0-9-]{1,63}([.]?[a-z0-9-]{1,63})([:][a-z0-9-]{1,63}){0,2}))))|(([a-z0-9-]{1,63}[.]{1}[a-z0-9-]{1,63}([.]?[a-z0-9-]{1,63})([:][a-z0-9-]{1,63}){0,2}))|(([0-9a-zA-Z][_-]?)+)$', ], 'ModelModality' => [ 'type' => 'string', 'enum' => [ 'TEXT', 'IMAGE', 'EMBEDDING', ], ], 'ModelModalityList' => [ 'type' => 'list', 'member' => [ 'shape' => 'ModelModality', ], ], 'ModelName' => [ 'type' => 'string', 'max' => 63, 'min' => 1, 'pattern' => '^([a-z0-9-]{1,63}[.]{1}[a-z0-9-]{1,63})$', ], 'NonBlankString' => [ 'type' => 'string', 'pattern' => '^[\\s\\S]*$', ], 'OutputDataConfig' => [ 'type' => 'structure', 'required' => [ 's3Uri', ], 'members' => [ 's3Uri' => [ 'shape' => 'S3Uri', ], ], ], 'PaginationToken' => [ 'type' => 'string', 'max' => 2048, 'min' => 1, 'pattern' => '^\\S*$', ], 'Provider' => [ 'type' => 'string', 'pattern' => '^[a-z0-9-]{1,63}$', ], 'PutModelInvocationLoggingConfigurationRequest' => [ 'type' => 'structure', 'required' => [ 'loggingConfig', ], 'members' => [ 'loggingConfig' => [ 'shape' => 'LoggingConfig', ], ], ], 'PutModelInvocationLoggingConfigurationResponse' => [ 'type' => 'structure', 'members' => [], ], 'ResourceNotFoundException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'NonBlankString', ], ], 'error' => [ 'httpStatusCode' => 404, 'senderFault' => true, ], 'exception' => true, ], 'RoleArn' => [ 'type' => 'string', 'max' => 2048, 'min' => 0, 'pattern' => '^arn:aws(-[^:]+)?:iam::([0-9]{12})?:role/.+$', ], 'S3Config' => [ 'type' => 'structure', 'required' => [ 'bucketName', ], 'members' => [ 'bucketName' => [ 'shape' => 'BucketName', ], 'keyPrefix' => [ 'shape' => 'KeyPrefix', ], ], ], 'S3Uri' => [ 'type' => 'string', 'max' => 1024, 'min' => 1, 'pattern' => '^s3://[a-z0-9][\\.\\-a-z0-9]{1,61}[a-z0-9](/.*)?$', ], 'SecurityGroupId' => [ 'type' => 'string', 'max' => 32, 'min' => 0, 'pattern' => '^[-0-9a-zA-Z]+$', ], 'SecurityGroupIds' => [ 'type' => 'list', 'member' => [ 'shape' => 'SecurityGroupId', ], 'max' => 5, 'min' => 1, ], 'ServiceQuotaExceededException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'NonBlankString', ], ], 'error' => [ 'httpStatusCode' => 400, 'senderFault' => true, ], 'exception' => true, ], 'SortJobsBy' => [ 'type' => 'string', 'enum' => [ 'CreationTime', ], ], 'SortModelsBy' => [ 'type' => 'string', 'enum' => [ 'CreationTime', ], ], 'SortOrder' => [ 'type' => 'string', 'enum' => [ 'Ascending', 'Descending', ], ], 'StopModelCustomizationJobRequest' => [ 'type' => 'structure', 'required' => [ 'jobIdentifier', ], 'members' => [ 'jobIdentifier' => [ 'shape' => 'ModelCustomizationJobIdentifier', 'location' => 'uri', 'locationName' => 'jobIdentifier', ], ], ], 'StopModelCustomizationJobResponse' => [ 'type' => 'structure', 'members' => [], ], 'String' => [ 'type' => 'string', ], 'SubnetId' => [ 'type' => 'string', 'max' => 32, 'min' => 0, 'pattern' => '^[-0-9a-zA-Z]+$', ], 'SubnetIds' => [ 'type' => 'list', 'member' => [ 'shape' => 'SubnetId', ], 'max' => 16, 'min' => 1, ], 'Tag' => [ 'type' => 'structure', 'required' => [ 'key', 'value', ], 'members' => [ 'key' => [ 'shape' => 'TagKey', ], 'value' => [ 'shape' => 'TagValue', ], ], ], 'TagKey' => [ 'type' => 'string', 'max' => 128, 'min' => 1, 'pattern' => '^[a-zA-Z0-9\\s._:/=+@-]*$', ], 'TagKeyList' => [ 'type' => 'list', 'member' => [ 'shape' => 'TagKey', ], 'max' => 200, 'min' => 0, ], 'TagList' => [ 'type' => 'list', 'member' => [ 'shape' => 'Tag', ], 'max' => 200, 'min' => 0, ], 'TagResourceRequest' => [ 'type' => 'structure', 'required' => [ 'resourceARN', 'tags', ], 'members' => [ 'resourceARN' => [ 'shape' => 'TaggableResourcesArn', ], 'tags' => [ 'shape' => 'TagList', ], ], ], 'TagResourceResponse' => [ 'type' => 'structure', 'members' => [], ], 'TagValue' => [ 'type' => 'string', 'max' => 256, 'min' => 0, 'pattern' => '^[a-zA-Z0-9\\s._:/=+@-]*$', ], 'TaggableResourcesArn' => [ 'type' => 'string', 'max' => 1011, 'min' => 20, 'pattern' => '(^arn:aws(-[^:]+)?:amazon-bedrock:[a-zA-Z0-9-]*:[0-9]{12}:(fine-tuning-job|custom-model)/.+$)|([a-zA-Z0-9][a-zA-Z0-9\\-]*$)|(^arn:aws(|-cn|-us-gov):bedrock:[a-z0-9-]{1,20}:([0-9]{12}|):(fine-tuning-job|model-customization-job|custom-model)/[a-z0-9-]{1,63}[.]{1}[a-z0-9-]{1,63}(/[a-z0-9]{12})$)|(^arn:aws(-[^:]+)?:bedrock:[a-z0-9-]{1,20}:[0-9]{12}:provisioned-model/[a-z0-9]{12}$)', ], 'ThrottlingException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'NonBlankString', ], ], 'error' => [ 'httpStatusCode' => 429, 'senderFault' => true, ], 'exception' => true, ], 'Timestamp' => [ 'type' => 'timestamp', 'timestampFormat' => 'iso8601', ], 'TooManyTagsException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'NonBlankString', ], 'resourceName' => [ 'shape' => 'TaggableResourcesArn', ], ], 'error' => [ 'httpStatusCode' => 400, 'senderFault' => true, ], 'exception' => true, ], 'TrainingDataConfig' => [ 'type' => 'structure', 'required' => [ 's3Uri', ], 'members' => [ 's3Uri' => [ 'shape' => 'S3Uri', ], ], ], 'TrainingMetrics' => [ 'type' => 'structure', 'members' => [ 'trainingLoss' => [ 'shape' => 'MetricFloat', ], ], ], 'UntagResourceRequest' => [ 'type' => 'structure', 'required' => [ 'resourceARN', 'tagKeys', ], 'members' => [ 'resourceARN' => [ 'shape' => 'TaggableResourcesArn', ], 'tagKeys' => [ 'shape' => 'TagKeyList', ], ], ], 'UntagResourceResponse' => [ 'type' => 'structure', 'members' => [], ], 'ValidationDataConfig' => [ 'type' => 'structure', 'required' => [ 'validators', ], 'members' => [ 'validators' => [ 'shape' => 'Validators', ], ], ], 'ValidationException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'NonBlankString', ], ], 'error' => [ 'httpStatusCode' => 400, 'senderFault' => true, ], 'exception' => true, ], 'ValidationMetrics' => [ 'type' => 'list', 'member' => [ 'shape' => 'ValidatorMetric', ], ], 'Validator' => [ 'type' => 'structure', 'required' => [ 's3Uri', ], 'members' => [ 's3Uri' => [ 'shape' => 'S3Uri', ], ], ], 'ValidatorMetric' => [ 'type' => 'structure', 'members' => [ 'validationLoss' => [ 'shape' => 'MetricFloat', ], ], ], 'Validators' => [ 'type' => 'list', 'member' => [ 'shape' => 'Validator', ], 'max' => 10, 'min' => 0, ], 'VpcConfig' => [ 'type' => 'structure', 'required' => [ 'securityGroupIds', 'subnetIds', ], 'members' => [ 'securityGroupIds' => [ 'shape' => 'SecurityGroupIds', ], 'subnetIds' => [ 'shape' => 'SubnetIds', ], ], ], ],];
