<?php
/**
 *
 * This file is part of Aura for PHP.
 *
 * @license http://opensource.org/licenses/bsd-license.php BSD
 *
 */
namespace Aura\SqlQuery\Common;

use Aura\SqlQuery\QueryInterface;

/**
 *
 * An interface for UPDATE queries.
 *
 * @package Aura.SqlQuery
 *
 */
interface UpdateInterface extends QueryInterface, WhereInterface, ValuesInterface
{
    /**
     *
     * Sets the table to update.
     *
     * @param string $table The table to update.
     *
     * @return self
     *
     */
    public function table($table);
}
