<?php declare(strict_types=1);

namespace Amp\Parallel\Ipc;

use Amp\Cancellation;
use Amp\Closable;
use Amp\Socket\Socket;

interface IpcHub extends Closable
{
    /**
     * @param non-empty-string $key A key generated by {@see generateKey()}.
     */
    public function accept(string $key, ?Cancellation $cancellation = null): Socket;

    /**
     * @return non-empty-string URI to use with {@see connect()}.
     */
    public function getUri(): string;

    /**
     * @return non-empty-string Pass the key returned from this method to the connecting context and {@see accept()}.
     */
    public function generateKey(): string;
}
