<?php

use AlloCine\I18NBundle\Translation\Loco;
use AlloCine\UnifiedTag\Bundle\Worker\TranslationWorker;
use Symfony\Component\HttpFoundation\File\File;

define('API_KEY', 'fpFDW6ddnVQEonn79jEK2C06rpG5Iqss');
require './vendor/autoload.php';

$client = new Loco(API_KEY);

$tags = $client->getTags();
$locales = $client->getLocales();
$path = TranslationWorker::OUTPUT_PATH;

foreach ($locales as $locale => $realLocale) {
    foreach ($tags as $tag) {
        $export = $client->export($realLocale, $tag);

        try {
            $filename = sprintf('%s/%s.%s.xlf', $path, $tag, $locale);
            $file = new File($filename);
        } catch (\Exception $e) {
            $filename = sprintf('%s/%s.%s.xlf', $path, $tag, $realLocale);
            $file = new File($filename);
        }

        $file->openFile('w')->fwrite($export);
    }
}

